/*
 * Decompiled with CFR 0.152.
 */
package PETER_Remoter.remoter_GUI;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ECGParser {
    public static final String FILES_ECG_PATH = "data/ecg/";
    public static final String FILES_ECG_EXT = ".csv";
    public static final String NORMAL_SIN = "data/ecg/meta_NormalSinRhythm.csv";
    public static final String STEMI = "data/ecg/meta_STEMI.csv";
    public static final String AV_BLOCK_1 = "data/ecg/meta_1AVBlock.csv";
    public static final String AV_BLOCK_2_TYPE1 = "data/ecg/meta_2AVBlockT1.csv";
    public static final String AV_BLOCK_2_TYPE2 = "data/ecg/meta_2AVBlockT2.csv";
    public static final String AV_BLOCK_3 = "data/ecg/c_3AVBlock.csv";
    public static final String VF = "data/ecg/meta_fibrilation.csv";
    public static final String VT = "data/ecg/c_VT.csv";

    private ECGParser() {
    }

    public static List<float[][]> loadECGData(String sourceName) {
        ArrayList<float[][]> listCurves = new ArrayList<float[][]>();
        File file = new File(sourceName);
        if (!file.exists() || file.isDirectory()) {
            return null;
        }
        try (BufferedReader br = new BufferedReader(new FileReader(sourceName));){
            String line;
            while ((line = br.readLine()) != null) {
                String[] parseLine = line.split(",");
                int lineNumber = Integer.valueOf(parseLine[0]);
                String pathCurve = parseLine[1];
                listCurves.add(ECGParser.loadECGCurve(lineNumber, pathCurve));
            }
        }
        catch (IOException ex) {
            Logger.getLogger(ECGParser.class.getName()).log(Level.SEVERE, null, ex);
            listCurves = null;
        }
        return listCurves;
    }

    private static float[][] loadECGCurve(int lineNumber, String pathCurve) throws IOException {
        String line;
        System.out.println("Loading data from " + pathCurve);
        BufferedReader br = new BufferedReader(new FileReader(pathCurve));
        float[][] ecgData = new float[lineNumber - 2][3];
        int numberOfLine = 0;
        br.readLine();
        br.readLine();
        while ((line = br.readLine()) != null) {
            String[] parser = line.split(",");
            ecgData[numberOfLine][0] = Float.valueOf(parser[0]).floatValue();
            ecgData[numberOfLine][1] = Float.valueOf(parser[1]).floatValue();
            ecgData[numberOfLine][2] = Float.valueOf(parser[2]).floatValue();
            ++numberOfLine;
        }
        br.close();
        return ecgData;
    }
}

