/*
 * Decompiled with CFR 0.152.
 */
package PETER_Monitor.vital_monitor;

import Language.LoadFXMLWithResourceBundle;
import PETER_Communications.com_protocol.VitalData;
import PETER_Monitor.BonusPanel;
import PETER_Monitor.vital_ecg.ECGData;
import PETER_Monitor.vital_ecg.ECGLineChart;
import PETER_Monitor.vital_ecg.ECGPoint;
import PETER_Monitor.vital_monitor.DefibrilatorHandle;
import PETER_Monitor.vital_monitor.NIBPHandler;
import PETER_Monitor.vital_monitor.SidePanel;
import PETER_Monitor.vital_monitor.settings_monitor.Settings;
import PETER_Monitor.vital_monitor.settings_monitor.SettingsValues;
import PETER_Monitor.vital_monitor.settings_monitor.ValuesAboutStateOfAplication;
import PETER_Monitor.vital_values.ChangingValuesAnimation;
import PETER_Monitor.vital_values.NIBPVitalFunction;
import PETER_Monitor.vital_values.SimpleVitalFunction;
import PETER_Monitor.vital_values.TempVitalFunction;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.chart.Chart;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ProgressBar;
import javafx.scene.image.Image;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundImage;
import javafx.scene.layout.BackgroundPosition;
import javafx.scene.layout.BackgroundRepeat;
import javafx.scene.layout.BackgroundSize;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.RowConstraints;
import javafx.scene.text.Font;
import javafx.stage.Stage;
import javafx.util.Duration;

public class Controller
implements Initializable {
    @FXML
    Button aed;
    @FXML
    Button shock;
    @FXML
    Button changeMode;
    @FXML
    Button closeNIBP;
    @FXML
    Button start;
    @FXML
    Button closeDefibrilator;
    @FXML
    Button lowImpedanceButton;
    @FXML
    Button mediumImpedanceButton;
    @FXML
    Button highImpedanceButton;
    @FXML
    Button NIBPButton;
    @FXML
    ProgressBar reload;
    @FXML
    ProgressBar NIBPprogress;
    @FXML
    ProgressBar analysaProgress;
    @FXML
    ProgressBar poweringOnProgress;
    @FXML
    Label powerinOnLabel;
    @FXML
    Button energy50;
    @FXML
    Button energy100;
    @FXML
    Button energy150;
    @FXML
    Button energy200;
    @FXML
    Label NIBPmodeLabel;
    @FXML
    Label NIBPmodeValueLabel;
    @FXML
    Label NIBPpressureLabel;
    @FXML
    Label NIBPpressure2Label;
    @FXML
    Label power;
    @FXML
    Label timeTotalLabel;
    @FXML
    Label timeLastLabel;
    @FXML
    Label numberOfShocksLabel;
    @FXML
    Label typeOfDefibrilator;
    @FXML
    Label NIBPtime;
    @FXML
    GridPane defibrilator;
    @FXML
    GridPane firstGraph;
    @FXML
    GridPane secondGraph;
    @FXML
    GridPane thirdGraph;
    @FXML
    GridPane fourthGraph;
    @FXML
    GridPane fifthGraph;
    @FXML
    GridPane valuesFromRemoter;
    @FXML
    GridPane powerOn;
    @FXML
    GridPane NIBPGridPane;
    @FXML
    GridPane NIBPOverview;
    @FXML
    GridPane AEDfunction;
    @FXML
    GridPane SideMenu;
    @FXML
    GridPane MenuDefibrilator;
    @FXML
    GridPane manualSetting;
    @FXML
    Label infoDefibrilatorLabel;
    @FXML
    Button metronomButton;
    @FXML
    Label metronomLabel;
    @FXML
    MenuItem pauseAplication;
    @FXML
    MenuItem resumeAplication;
    @FXML
    MenuItem shutDownMonitor;
    @FXML
    MenuItem boundariesMenu;
    @FXML
    MenuItem aboutMenu;
    @FXML
    MenuItem settingsMenu;
    @FXML
    CheckMenuItem graph1;
    @FXML
    CheckMenuItem graph2;
    @FXML
    CheckMenuItem graph3;
    @FXML
    Button soundDefibrilator;
    @FXML
    Button soundNIBP;
    @FXML
    Button overViewButton;
    @FXML
    Button powerOnButton;
    @FXML
    Button manualButton;
    @FXML
    CheckBox connectEcgElectrods;
    @FXML
    CheckBox connectTherapyElectrods;
    private ECGData ecgData;
    private ECGLineChart ecgGraph;
    private VitalData vitalData;
    private NIBPHandler NIBPhandler;
    private DefibrilatorHandle defibrilatorHandle;
    private boolean isMetronomOn = false;
    private ArrayList<SimpleVitalFunction> vitalFunctions;
    private int hearthRateIndex;
    private int SpO2Index;
    private int PPIndex;
    private int NIBPIndex;
    private int CO2Index;
    private int TempIndex;
    private ChangingValuesAnimation changingValuesAnimation;
    private ArrayList newValues;
    private Settings settings;
    private SidePanel sp;
    private Timeline poweringOnAnimation;
    private boolean ecgSound;

    public void initialize(URL uRL, ResourceBundle resourceBundle) {
        this.sp = new SidePanel();
        this.SideMenu.add((Node)this.sp.createAEDMenu(), 0, 0, 2, 2);
        this.SideMenu.add((Node)this.sp.createTopMenu(), 0, 2, 2, 2);
        this.aed = this.sp.getBottomButton(0);
        this.manualButton = this.sp.getBottomButton(1);
        this.shock = this.sp.getBottomButton(4);
        this.NIBPButton = this.sp.getTopButton(0);
        this.defibrilatorHandle = new DefibrilatorHandle(this.defibrilator, this.typeOfDefibrilator, this.power, this.numberOfShocksLabel, this.timeLastLabel, this.timeTotalLabel, this.reload, this.shock, this.infoDefibrilatorLabel, this.analysaProgress, this.closeDefibrilator);
        this.NIBPhandler = new NIBPHandler(this.NIBPprogress, this.NIBPmodeLabel, this.NIBPmodeValueLabel, this.NIBPpressureLabel, this.NIBPpressure2Label, this.changeMode, this.start, this.NIBPGridPane, this.NIBPtime, this.NIBPOverview, this.closeNIBP);
        this.setVisibilityAllComponents(false);
        this.defibrilatorHandle.setImpedanceFromRemoter(1, this.lowImpedanceButton, this.mediumImpedanceButton, this.highImpedanceButton);
        this.defibrilatorHandle.setActivePowerButton(this.energy200, this.energy50, this.energy100, this.energy150, this.energy200);
        this.reload.minWidthProperty().bind((ObservableValue)((GridPane)this.reload.getParent()).heightProperty().subtract(100));
        this.analysaProgress.minWidthProperty().bind((ObservableValue)((GridPane)this.analysaProgress.getParent()).widthProperty().subtract(70));
        this.setElectrodsCheckboxes();
        this.changingValuesAnimation = new ChangingValuesAnimation();
        this.setSoundButtonDefibrilator();
        this.setSoundNIBPButton();
        this.ecgSound = true;
        this.setVisibilityAllComponents(false);
        this.settings = new Settings(this.soundDefibrilator, this.soundNIBP);
        this.setupVitalFunctionsPanels();
        this.aed.setOnAction(actionEvent -> this.normalMonitorStart(this.aed));
        this.manualButton.setOnAction(actionEvent -> this.normalMonitorStart(this.manualButton));
        this.sp.getBottomButton(2).setOnAction(actionEvent -> this.runAnalyza());
        this.sp.getBottomButton(3).setOnAction(actionEvent -> this.reloadDefibrilator());
        this.shock.setOnAction(actionEvent -> this.startShock());
        this.shock.setDisable(true);
        this.NIBPButton.setOnAction(actionEvent -> this.showPressure());
        this.sp.getTopButton(4).setOnAction(actionEvent -> this.setBoundaries());
    }

    public ECGData getECGData() {
        return this.ecgData;
    }

    public void addFirstGraph(String string, ECGLineChart eCGLineChart) {
        this.ecgGraph = eCGLineChart;
        this.ecgGraph.setPadding(new Insets(0.0, 0.0, 20.0, 0.0));
        this.firstGraph.add((Node)this.createPanelWithButton(new Label(string), new Button()), 0, 0);
        this.firstGraph.add((Node)this.ecgGraph, 1, 0);
    }

    private GridPane createPanelWithButton(Label label, Button button) {
        GridPane gridPane = new GridPane();
        label.setFont(Font.font((String)"System", (double)20.0));
        label.setPadding(new Insets(3.0, 0.0, 0.0, 0.0));
        ColumnConstraints columnConstraints = new ColumnConstraints();
        columnConstraints.setMinWidth(79.0);
        RowConstraints rowConstraints = new RowConstraints(50.0);
        rowConstraints.setValignment(VPos.TOP);
        RowConstraints rowConstraints2 = new RowConstraints();
        rowConstraints2.minHeightProperty().bind((ObservableValue)this.firstGraph.heightProperty().subtract(50));
        gridPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{columnConstraints});
        gridPane.getRowConstraints().addAll((Object[])new RowConstraints[]{rowConstraints, rowConstraints2});
        gridPane.add((Node)label, 0, 0);
        gridPane.add((Node)button, 0, 1);
        gridPane.minHeightProperty().bind((ObservableValue)this.firstGraph.heightProperty());
        ((ColumnConstraints)gridPane.getColumnConstraints().get(0)).setHalignment(HPos.CENTER);
        button.setMinWidth(50.0);
        button.setMinHeight(40.0);
        GridPane.setMargin((Node)button, (Insets)new Insets(0.0, 0.0, 35.0, 12.0));
        GridPane.setMargin((Node)label, (Insets)new Insets(0.0, 0.0, 0.0, 10.0));
        button.setStyle("-fx-cursor: hand;");
        this.setBackgroundImageOnSoundButton(button, false);
        button.setOnAction(actionEvent -> {
            this.setBackgroundImageOnSoundButton(button, this.ecgSound);
            this.ecgSound = !this.ecgSound;
            this.ecgData.setBeep(this.ecgSound);
        });
        return gridPane;
    }

    private void setBackgroundImageOnSoundButton(Button button, boolean bl) {
        String string = bl ? "images/disabledSound.jpg" : "images/activeSound.jpg";
        BackgroundImage backgroundImage = new BackgroundImage(new Image(this.getClass().getResource(string).toExternalForm()), BackgroundRepeat.NO_REPEAT, BackgroundRepeat.NO_REPEAT, BackgroundPosition.CENTER, BackgroundSize.DEFAULT);
        Background background = new Background(new BackgroundImage[]{backgroundImage});
        button.setBackground(background);
    }

    private void createNormalGraphPane(GridPane gridPane, String string, Chart chart) {
        chart.setPadding(new Insets(0.0, 0.0, 20.0, 0.0));
        Label label = new Label(string);
        label.setFont(Font.font((String)"System", (double)20.0));
        label.setPadding(new Insets(3.0, 0.0, 0.0, 0.0));
        ((ColumnConstraints)gridPane.getColumnConstraints().get(0)).setHalignment(HPos.CENTER);
        ((RowConstraints)gridPane.getRowConstraints().get(0)).setValignment(VPos.TOP);
        gridPane.add((Node)label, 0, 0);
        gridPane.add((Node)chart, 1, 0);
        GridPane.setMargin((Node)label, (Insets)new Insets(0.0, 0.0, 0.0, 10.0));
    }

    public void removeGraph(int n) {
        switch (n) {
            case 1: {
                this.firstGraph.getChildren().clear();
                break;
            }
            case 2: {
                this.secondGraph.getChildren().clear();
                break;
            }
            case 3: {
                this.thirdGraph.getChildren().clear();
                break;
            }
            case 4: {
                this.fourthGraph.getChildren().clear();
                break;
            }
            case 5: {
                this.fifthGraph.getChildren().clear();
            }
        }
    }

    @FXML
    public void exitApplication() {
        Platform.exit();
    }

    @FXML
    public void fullscreen() {
        Stage stage = (Stage)this.valuesFromRemoter.getScene().getWindow();
        stage.setFullScreen(true);
    }

    @FXML
    public void settings() {
        this.settings.showSettings(0);
    }

    @FXML
    public void setBoundaries() {
        this.settings.showSettings(1);
    }

    @FXML
    public void getAbout() {
        this.settings.showSettings(3);
    }

    @FXML
    public void hideGraph(ActionEvent actionEvent) {
        String string = ((CheckMenuItem)actionEvent.getSource()).getId();
        boolean bl = ((CheckMenuItem)actionEvent.getSource()).isSelected();
        switch (string) {
            case "graph1": {
                this.firstGraph.setVisible(!bl);
                break;
            }
            case "graph2": {
                this.secondGraph.setVisible(!bl);
                break;
            }
            case "graph3": {
                this.thirdGraph.setVisible(!bl);
            }
        }
    }

    @FXML
    public void pauseAplication() {
        this.changingValuesAnimation.pauseAnimation();
        this.defibrilatorHandle.pauseAnimations();
        this.NIBPhandler.pauseAnimation();
        this.pauseAplication.setDisable(true);
        this.resumeAplication.setDisable(false);
    }

    @FXML
    public void resumeAplication() {
        this.changingValuesAnimation.resumeAnimation();
        this.defibrilatorHandle.resumeAnimation();
        this.NIBPhandler.resumeAnimation();
        this.pauseAplication.setDisable(false);
        this.resumeAplication.setDisable(true);
    }

    @FXML
    public void shutDownMonitor() {
        this.setVisibilityAllComponents(false);
        this.firstGraph.getParent().setStyle("-fx-background-color: black;");
        this.changingValuesAnimation.stopAnimation();
        this.ecgData.clear();
        this.ecgData = null;
        this.removeGraph(1);
        this.removeGraph(2);
        this.removeGraph(3);
        this.vitalFunctions.forEach(simpleVitalFunction -> simpleVitalFunction.clear());
        this.vitalFunctions.clear();
        this.vitalFunctions = null;
        this.vitalData = null;
        ValuesAboutStateOfAplication.clear();
    }

    public void defibStart(ActionEvent actionEvent) {
        Button button = (Button)actionEvent.getSource();
        if (button.getText().equals(LoadFXMLWithResourceBundle.getLangResource().getString("monitor.userPanel.aed")) && this.powerOn.isVisible()) {
            this.startPoweringOnAnimation(0.4, true);
            return;
        }
        if (this.powerOn.isVisible()) {
            return;
        }
    }

    public void normalMonitorStart(Button button) {
        if (button.getText().equals(LoadFXMLWithResourceBundle.getLangResource().getString("monitor.userPanel.aed")) && this.powerOn.isVisible()) {
            this.startPoweringOnAnimation(0.4, true);
            return;
        }
        if (this.powerOn.isVisible() || this.defibrilator.isVisible()) {
            return;
        }
        if (this.NIBPGridPane.isVisible() && !this.NIBPhandler.isNIBPRunning()) {
            this.hidePressure();
        }
        this.defibrilatorHandle.defibStart(button.getText(), this.manualSetting, this.AEDfunction);
    }

    public void setPowerValue(ActionEvent actionEvent) {
        this.defibrilatorHandle.setActivePowerButton((Button)actionEvent.getSource(), this.energy50, this.energy100, this.energy150, this.energy200);
    }

    public void changeElectrods() {
        this.defibrilatorHandle.changeElectrods();
    }

    public void runAnalyza() {
        if (this.vitalData != null && this.defibrilator.isVisible()) {
            this.defibrilatorHandle.runAnalyza(this.vitalData.getSuccessOfAnalyse());
        }
    }

    public void reloadDefibrilator() {
        if (!this.defibrilatorHandle.isAED() && this.defibrilator.isVisible()) {
            this.defibrilatorHandle.reloadDefibrilator(true);
        }
    }

    @FXML
    public void setMetronom() {
        if (this.isMetronomOn) {
            this.isMetronomOn = false;
            this.metronomButton.setStyle("");
            this.metronomLabel.setText(LoadFXMLWithResourceBundle.getLangResource().getString("monitor.metronom.off"));
        } else {
            this.isMetronomOn = true;
            this.metronomButton.setStyle("-fx-background-color:white; -fx-text-fill:black;");
            this.metronomLabel.setText(LoadFXMLWithResourceBundle.getLangResource().getString("monitor.metronom.on"));
        }
    }

    public void setSoundButtonDefibrilator() {
        this.soundDefibrilator.setOnAction(actionEvent -> {
            if (this.defibrilatorHandle.isActiveSound()) {
                this.defibrilatorHandle.setActiveSounds(false);
                this.soundDefibrilator.setStyle("-fx-background-color:white; -fx-text-fill:black;");
                this.soundDefibrilator.setText(LoadFXMLWithResourceBundle.getLangResource().getString("monitor.global.sound"));
            } else {
                this.defibrilatorHandle.setActiveSounds(true);
                this.soundDefibrilator.setStyle("");
                this.soundDefibrilator.setText(LoadFXMLWithResourceBundle.getLangResource().getString("monitor.defibrilator.mute"));
            }
        });
        if (SettingsValues.DEFIBRILATORSound) {
            this.soundDefibrilator.fire();
        }
    }

    public void setElectrodsCheckboxes() {
        this.connectTherapyElectrods.setDisable(true);
        this.connectEcgElectrods.selectedProperty().addListener((observableValue, bl, bl2) -> {
            this.connectTherapyElectrods.setDisable(!this.connectEcgElectrods.isSelected());
            this.connectTherapyElectrods.setSelected(false);
        });
        this.connectEcgElectrods.setOnAction(actionEvent -> this.defibrilatorHandle.setElectrods(this.connectEcgElectrods.isSelected(), this.connectTherapyElectrods.isSelected()));
        this.connectTherapyElectrods.setOnAction(actionEvent -> this.defibrilatorHandle.setElectrods(this.connectEcgElectrods.isSelected(), this.connectTherapyElectrods.isSelected()));
    }

    public void startShock() {
        this.defibrilatorHandle.startShock();
        if (this.vitalData != null && this.vitalData.getResurectionEcg() != null) {
            this.ecgData.sendCurve(Controller.setEcgData(this.vitalData.getResurectionEcg()));
            this.vitalFunctions.get(this.hearthRateIndex).setActualValue(80.0);
            this.vitalFunctions.get(this.PPIndex).setActualValue(35.0);
            this.vitalFunctions.get(this.CO2Index).setActualValue(58.0);
            this.vitalFunctions.get(this.SpO2Index).setActualValue(32.0);
            this.newValues.set(this.hearthRateIndex, 80.0);
            this.newValues.set(this.PPIndex, 72.0);
            this.newValues.set(this.CO2Index, 42.0);
            this.newValues.set(this.SpO2Index, 85.0);
        }
    }

    public void hideDefibrilator() {
        ValuesAboutStateOfAplication.isDefibrilatorManualOn = false;
        ValuesAboutStateOfAplication.isDefibrilatorAEDOn = false;
        this.defibrilatorHandle.hideDefibrilator();
    }

    public void showPressure() {
        ValuesAboutStateOfAplication.isNIBPON = true;
        this.NIBPhandler.showPressure();
    }

    public void hidePressure() {
        ValuesAboutStateOfAplication.isNIBPON = false;
        this.NIBPhandler.hidePressure();
    }

    public void runPressure() {
        if (this.vitalData != null) {
            this.NIBPhandler.runPressure(this.vitalData.getSysPressure(), this.vitalData.getDiaPressure());
        }
    }

    public void setNIBPmode() {
        this.NIBPhandler.setMode();
    }

    public void showOverview() {
        if (this.NIBPOverview.isVisible()) {
            this.NIBPOverview.setVisible(false);
            this.overViewButton.setStyle("");
        } else {
            this.NIBPOverview.setVisible(true);
            this.NIBPhandler.showOverview();
            this.overViewButton.setStyle("-fx-background-color:white; -fx-text-fill:black;");
        }
    }

    public void setSoundNIBPButton() {
        this.soundNIBP.setOnAction(actionEvent -> {
            if (this.NIBPhandler.getVolumeActive()) {
                this.NIBPhandler.setVolume(0);
                this.soundNIBP.setText(LoadFXMLWithResourceBundle.getLangResource().getString("monitor.global.sound"));
                this.soundNIBP.setStyle("-fx-background-color:white; -fx-text-fill:black;");
            } else {
                this.NIBPhandler.setVolume(5);
                this.soundNIBP.setText(LoadFXMLWithResourceBundle.getLangResource().getString("monitor.nibp.mute"));
                this.soundNIBP.setStyle("");
            }
        });
        if (SettingsValues.NIBPSound) {
            this.soundNIBP.fire();
        }
    }

    private void startPoweringOnAnimation(double d, boolean bl) {
        this.poweringOnProgress.setVisible(true);
        this.powerinOnLabel.setVisible(true);
        if (ValuesAboutStateOfAplication.isMonitorTurnON) {
            this.setVisibilityAllComponents(true);
            return;
        }
        if (this.poweringOnAnimation == null) {
            this.poweringOnProgress.setProgress(ValuesAboutStateOfAplication.valuesLoadingMonitor);
            this.poweringOnAnimation = new Timeline(new KeyFrame[]{new KeyFrame(Duration.seconds((double)d), actionEvent -> this.poweringOnAnimation(bl), new KeyValue[0])});
            this.poweringOnAnimation.setCycleCount(-1);
            this.poweringOnAnimation.playFromStart();
        }
    }

    private void poweringOnAnimation(boolean bl) {
        this.poweringOnProgress.setProgress(this.poweringOnProgress.getProgress() + 0.05);
        ValuesAboutStateOfAplication.valuesLoadingMonitor = this.poweringOnProgress.getProgress();
        if (this.poweringOnProgress.getProgress() >= 1.0) {
            this.poweringOnAnimation.stop();
            this.poweringOnAnimation = null;
            this.poweringOnProgress.setVisible(false);
            this.powerinOnLabel.setVisible(false);
            this.poweringOnProgress.setProgress(0.0);
            this.setVisibilityAllComponents(true);
            ValuesAboutStateOfAplication.isMonitorTurnON = true;
            if (bl) {
                this.defibrilatorHandle.defibStart(LoadFXMLWithResourceBundle.getLangResource().getString("monitor.userPanel.aed"), this.manualSetting, this.AEDfunction);
            }
        }
    }

    public void showAppComponents() {
        this.startPoweringOnAnimation(0.6, false);
    }

    private void setVisibilityAllComponents(boolean bl) {
        if (bl) {
            this.setECGData();
            this.firstGraph.getParent().setStyle("-fx-background-color:whitesmoke");
            this.setupVitalFunctionsPanels();
            this.setBindingFromVitalFunctionsToGraph();
            BonusPanel bonusPanel = new BonusPanel();
            this.fifthGraph.add((Node)bonusPanel.createBonusPanel(), 0, 0);
        }
        this.firstGraph.setVisible(bl);
        this.secondGraph.setVisible(bl);
        this.thirdGraph.setVisible(bl);
        this.fourthGraph.setVisible(bl);
        this.fifthGraph.setVisible(bl);
        this.valuesFromRemoter.setVisible(bl);
        this.NIBPGridPane.setVisible(false);
        this.defibrilator.setVisible(false);
        this.pauseAplication.setDisable(!bl);
        this.resumeAplication.setDisable(true);
        this.shutDownMonitor.setDisable(!bl);
        this.graph1.setDisable(!bl);
        this.graph2.setDisable(!bl);
        this.powerOn.setVisible(!bl);
        this.NIBPButton.setVisible(bl);
    }

    private void setupVitalFunctionsPanels() {
        if (this.vitalFunctions == null) {
            this.vitalFunctions = new ArrayList();
            this.vitalFunctions.add(new SimpleVitalFunction("HR", "l/min", SettingsValues.HRmin, SettingsValues.HRmax, SettingsValues.getColorToVitalFunctionByIndex(0), 1, 300));
            this.hearthRateIndex = this.vitalFunctions.size() - 1;
            this.vitalFunctions.add(new SimpleVitalFunction("SPO2", "%", SettingsValues.SPO2min, SettingsValues.SPO2max, SettingsValues.getColorToVitalFunctionByIndex(1), 1, 100));
            this.SpO2Index = this.vitalFunctions.size() - 1;
            this.vitalFunctions.add(new SimpleVitalFunction("PP", "l/min", SettingsValues.PPmin, SettingsValues.PPmax, SettingsValues.getColorToVitalFunctionByIndex(2), 1, 300));
            this.PPIndex = this.vitalFunctions.size() - 1;
            this.vitalFunctions.add(new NIBPVitalFunction("M\u011b\u0159en\u00ed tlaku", "mmHg", SettingsValues.getColorToVitalFunctionByIndex(3)));
            this.NIBPIndex = this.vitalFunctions.size() - 1;
            this.vitalFunctions.add(new SimpleVitalFunction("ETCO2", "mmHg", SettingsValues.ETCO2min, SettingsValues.ETCO2max, SettingsValues.getColorToVitalFunctionByIndex(4), 1, 60));
            this.CO2Index = this.vitalFunctions.size() - 1;
            this.vitalFunctions.add(new TempVitalFunction("TEMP", "\u00b0C", SettingsValues.TEMPmin, SettingsValues.TEMPmax, SettingsValues.getColorToVitalFunctionByIndex(5), 15, 45));
            this.TempIndex = this.vitalFunctions.size() - 1;
            for (int i = 0; i < this.vitalFunctions.size(); ++i) {
                this.valuesFromRemoter.add((Node)this.vitalFunctions.get(i).getPanel(), i, 0);
            }
            this.NIBPhandler.setNibpVitalFunction((NIBPVitalFunction)this.vitalFunctions.get(this.NIBPIndex));
            this.settings.setVitalFunctions(this.vitalFunctions);
            ValuesAboutStateOfAplication.vitalFunctions = this.vitalFunctions;
        }
    }

    private void setBindingFromVitalFunctionsToGraph() {
        this.vitalFunctions.get(this.hearthRateIndex).getActualValueProperty().addListener((observableValue, number, number2) -> {
            if (!this.vitalFunctions.get(this.hearthRateIndex).getChangeComplete()) {
                this.ecgData.setHR(number2.intValue());
            }
        });
        this.vitalFunctions.get(this.CO2Index).getActualValueProperty().addListener((observableValue, number, number2) -> {
            if (!this.vitalFunctions.get(this.CO2Index).getChangeComplete()) {
                this.ecgData.getGraphCO2().setCO2(number2.intValue());
            }
        });
    }

    public void setData(VitalData vitalData) {
        if (this.ecgData == null) {
            return;
        }
        Timeline timeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.seconds((double)0.1), actionEvent -> {
            if (vitalData.isFibrilation()) {
                this.ecgData.setHR(vitalData.getHeartRate());
                this.vitalFunctions.get(this.hearthRateIndex).setActualValue(vitalData.getHeartRate());
                this.ecgData.sendCurve(Controller.setEcgData(vitalData.getEcg()));
            } else {
                this.handleECGCurveData(vitalData.getAsystolia(), vitalData.getEcg());
                this.handleDataForGraphAfterReceive(vitalData.getHeartRate(), vitalData.getCO2());
            }
            this.defibrilatorHandle.setImpedanceFromRemoter(vitalData.getImpedance(), this.lowImpedanceButton, this.mediumImpedanceButton, this.highImpedanceButton);
            this.setElectrodes(vitalData);
            this.vitalData = vitalData;
            this.changingValuesAnimation.changeValues(this.vitalFunctions, this.createListWithNewValuesFromVitalData(this.vitalData));
            ValuesAboutStateOfAplication.changingValuesAnimation = this.changingValuesAnimation;
            ValuesAboutStateOfAplication.actualVitalData = this.vitalData;
        }, new KeyValue[0])});
        timeline.setCycleCount(1);
        timeline.play();
    }

    private void setElectrodes(VitalData vitalData) {
        if (!vitalData.getElectrodesWasChange()) {
            return;
        }
        if (this.connectEcgElectrods.isSelected() != vitalData.getConnectECG() || this.connectTherapyElectrods.isSelected() != vitalData.getConnectTerapy()) {
            this.connectEcgElectrods.setSelected(vitalData.getConnectECG());
            this.connectTherapyElectrods.setSelected(vitalData.getConnectTerapy());
            this.defibrilatorHandle.setElectrods(vitalData.getConnectECG(), vitalData.getConnectTerapy());
        }
    }

    private void handleECGCurveData(boolean bl, List<float[][]> list) {
        if (!bl && list == null) {
            return;
        }
        if (this.vitalData != null) {
            if (bl && !this.vitalData.getAsystolia()) {
                this.ecgData.plotAsystolie();
                this.ecgData.setHR(1);
                return;
            }
            if (!bl && !list.equals(this.vitalData.getEcg())) {
                this.ecgData.sendCurve(Controller.setEcgData(list));
            }
        } else if (bl) {
            this.ecgData.setHR(1);
            this.ecgData.plotAsystolie();
        } else {
            this.ecgData.sendCurve(Controller.setEcgData(list));
        }
    }

    private void handleDataForGraphAfterReceive(int n, int n2) {
        int n3 = 0;
        if (n < n3) {
            this.ecgData.setHR(1);
            this.ecgData.notConnected();
        }
    }

    public static ObservableList<ObservableList<ECGPoint>> setEcgData(List<float[][]> list) {
        if (list == null) {
            return null;
        }
        ObservableList observableList = FXCollections.observableArrayList();
        for (float[][] fArray : list) {
            ObservableList observableList2 = FXCollections.observableArrayList();
            for (float[] fArray2 : fArray) {
                observableList2.add((Object)new ECGPoint(fArray2[0], fArray2[1], fArray2[2]));
            }
            observableList.add((Object)observableList2);
        }
        return observableList;
    }

    private void setECGData() {
        if (this.ecgData == null) {
            this.ecgData = new ECGData();
            this.addFirstGraph("ECG1", this.ecgData.getGraphECG1());
            this.createNormalGraphPane(this.secondGraph, "CO2", (Chart)this.ecgData.getGraphCO2());
        }
    }

    private ArrayList createListWithNewValuesFromVitalData(VitalData vitalData) {
        if (this.newValues == null) {
            this.newValues = new ArrayList();
        }
        this.newValues.add(this.hearthRateIndex, Double.valueOf(vitalData.getHeartRate()));
        this.newValues.add(this.SpO2Index, Double.valueOf(vitalData.getSpO2()));
        this.newValues.add(this.PPIndex, Double.valueOf(vitalData.getPP()));
        this.newValues.add(this.NIBPIndex, 0.0);
        this.newValues.add(this.CO2Index, Double.valueOf(vitalData.getCO2()));
        this.newValues.add(this.TempIndex, Double.parseDouble(vitalData.getTemperature()));
        return this.newValues;
    }

    public void clear() {
        this.defibrilatorHandle.clear();
        this.NIBPhandler.clear();
        this.changingValuesAnimation.stopAnimation();
    }
}

