/*
 * Decompiled with CFR 0.152.
 */
package PETER_Monitor.vital_monitor;

import Language.LoadFXMLWithResourceBundle;
import PETER_Monitor.vital_monitor.PlaySounds;
import PETER_Monitor.vital_monitor.settings_monitor.ValuesAboutStateOfAplication;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.layout.GridPane;
import javafx.util.Duration;

public class DefibrilatorHandle {
    private Timeline reloading;
    private Timeline countingTimeLast;
    private Timeline countingTimeTotal;
    private Timeline analyseAnimation;
    private GridPane defibrilator;
    private Label typeOfDefibrilator;
    private Label power;
    private Label numberOfShocksLabel;
    private Label timeLastLabel;
    private Label timeTotalLabel;
    private Label infoLabel;
    private ProgressBar reload;
    private ProgressBar analyse;
    private Button shock;
    private Button power50;
    private Button power100;
    private Button power150;
    private Button power200;
    private Button lowImpedance;
    private Button mediumImpedance;
    private Button highImpedance;
    private Button closeDefibrilator;
    private int numberOfShocks;
    private int timeLast;
    private int timeTotal;
    private double powerValue;
    private boolean startOfDef;
    private boolean isAED;
    private boolean analysaResult;
    private boolean isAnalysaComplete;
    private boolean terapyElectrods;
    private boolean electrods;
    private int impedance;
    private PlaySounds playSounds;
    private boolean activeSounds;
    private int defaultVolumeSound = 5;

    public DefibrilatorHandle(GridPane gridPane, Label label, Label label2, Label label3, Label label4, Label label5, ProgressBar progressBar, Button button, Label label6, ProgressBar progressBar2, Button button2) {
        this.defibrilator = gridPane;
        this.typeOfDefibrilator = label;
        this.power = label2;
        this.numberOfShocksLabel = label3;
        this.timeLastLabel = label4;
        this.timeTotalLabel = label5;
        this.reload = progressBar;
        this.shock = button;
        this.startOfDef = false;
        this.infoLabel = label6;
        this.analyse = progressBar2;
        this.playSounds = new PlaySounds(this.defaultVolumeSound);
        this.closeDefibrilator = button2;
        this.terapyElectrods = false;
        this.electrods = false;
        this.activeSounds = true;
    }

    public void setImpedance(int n) {
        this.impedance = n;
    }

    public void setActiveSounds(boolean bl) {
        if (!bl) {
            this.activeSounds = false;
            this.playSounds.setVolume(0);
        } else {
            this.activeSounds = true;
            this.playSounds.setVolume(this.defaultVolumeSound);
        }
    }

    public void setActivePowerButton(Button button, Button button2, Button button3, Button button4, Button button5) {
        String string = "-fx-background-color:white; -fx-text-fill:black;";
        this.power50 = button2;
        this.power100 = button3;
        this.power150 = button4;
        this.power200 = button5;
        switch (button.getText()) {
            case "50 J": {
                button2.setStyle(string);
                button3.setStyle("");
                button4.setStyle("");
                button5.setStyle("");
                this.powerValue = 50.0;
                break;
            }
            case "100 J": {
                button2.setStyle("");
                button3.setStyle(string);
                button4.setStyle("");
                button5.setStyle("");
                this.powerValue = 100.0;
                break;
            }
            case "150 J": {
                button2.setStyle("");
                button3.setStyle("");
                button4.setStyle(string);
                button5.setStyle("");
                this.powerValue = 150.0;
                break;
            }
            case "200 J": {
                button2.setStyle("");
                button3.setStyle("");
                button4.setStyle("");
                button5.setStyle(string);
                this.powerValue = 200.0;
            }
        }
        this.power.setText(button.getText());
    }

    public boolean isActiveSound() {
        return this.activeSounds;
    }

    public void defibStart(String string, GridPane gridPane, GridPane gridPane2) {
        if (string.equals(LoadFXMLWithResourceBundle.getLangResource().getString("monitor.userPanel.aed"))) {
            this.setModeDefibrilator(true, LoadFXMLWithResourceBundle.getLangResource().getString("monitor.defibrilator.mod.aed"), gridPane, gridPane2);
            ValuesAboutStateOfAplication.isDefibrilatorManualOn = false;
            ValuesAboutStateOfAplication.isDefibrilatorAEDOn = true;
            this.changeElectrods();
        } else {
            this.setModeDefibrilator(false, LoadFXMLWithResourceBundle.getLangResource().getString("monitor.defibrilator.mod.manual"), gridPane, gridPane2);
            ValuesAboutStateOfAplication.isDefibrilatorAEDOn = false;
            ValuesAboutStateOfAplication.isDefibrilatorManualOn = true;
            this.infoLabel.setText(LoadFXMLWithResourceBundle.getLangResource().getString("monitor.defibrilator.bottomMenu.energy"));
        }
        this.showDefibrilator();
    }

    public void reloadDefibrilator(boolean bl) {
        if (this.reloading == null && this.startOfDef) {
            this.disablePowerButtons(true);
            double d = this.powerValue / 1000.0 * 2.0;
            if (bl) {
                this.infoLabel.setText(LoadFXMLWithResourceBundle.getLangResource().getString("monitor.defibrilator.charge"));
            }
            this.changeCloseButton(true);
            this.reloading = new Timeline(new KeyFrame[]{new KeyFrame(Duration.seconds((double)d), actionEvent -> this.reloadDefRun(), new KeyValue[0])});
            this.reloading.setCycleCount(-1);
            this.reloading.play();
        }
    }

    public void startShock() {
        Platform.runLater(() -> {
            this.reload.setProgress(0.0);
            this.numberOfShocksLabel.setText(++this.numberOfShocks + "");
            this.timeLast = 0;
            this.timeLastLabel.setText("00:00");
            this.shock.setDisable(true);
            this.disablePowerButtons(false);
            this.disableImpedanceButtons(false);
            this.changeCloseButton(false);
            this.infoLabel.setText(LoadFXMLWithResourceBundle.getLangResource().getString("monitor.defibrilator.shockGiven"));
            this.playSounds.stopShockReadyAnimation();
            this.playSounds.playSound("shock_given.wav");
        });
        if (this.countingTimeLast == null) {
            this.countingTimeLast = new Timeline(new KeyFrame[]{new KeyFrame(Duration.seconds((double)1.0), actionEvent -> this.setTimeLast(), new KeyValue[0])});
            this.countingTimeLast.setCycleCount(-1);
            this.countingTimeLast.play();
        }
    }

    public void setElectrods(boolean bl, boolean bl2) {
        if (bl != this.electrods || bl2 != this.terapyElectrods) {
            this.electrods = bl;
            this.terapyElectrods = bl2;
            if (this.defibrilator.isVisible()) {
                this.changeElectrods();
            }
        }
    }

    private void setTimeTotal() {
        String string = "";
        int n = this.timeTotal / 60;
        int n2 = this.timeTotal % 60;
        string = n < 10 ? string + "0" + n + ":" : string + n + ":";
        string = n2 < 10 ? string + "0" + n2 : string + n2;
        this.timeTotalLabel.setText(string);
        ++this.timeTotal;
    }

    private void setTimeLast() {
        String string = "";
        int n = this.timeLast / 60;
        int n2 = this.timeLast % 60;
        string = n < 10 ? string + "0" + n + ":" : string + n + ":";
        string = n2 < 10 ? string + "0" + n2 : string + n2;
        if (n == 0 && n2 == 1 && !this.isAED) {
            this.infoLabel.setText(LoadFXMLWithResourceBundle.getLangResource().getString("monitor.defibrilator.bottomMenu.energy"));
        }
        if (n == 0 && n2 == 4 && this.isAED && this.analyseAnimation == null) {
            this.infoLabel.setText(LoadFXMLWithResourceBundle.getLangResource().getString("monitor.defibrilator.KPR"));
            this.playSounds.playSound("do_kpr.wav");
        }
        if (n == 2 && n2 == 0 && this.isAED) {
            this.infoLabel.setText(LoadFXMLWithResourceBundle.getLangResource().getString("monitor.defibrilator.startAnalyse"));
            this.playSounds.playSound("start_analyse_ekg.wav");
        }
        this.timeLastLabel.setText(string);
        ++this.timeLast;
    }

    public void showDefibrilator() {
        if (this.countingTimeTotal == null) {
            this.defibrilator.setVisible(true);
            this.startOfDef = true;
            Platform.runLater(() -> {
                this.powerValue = 200.0;
                this.power.setText((int)this.powerValue + " J");
                this.numberOfShocks = 0;
                this.numberOfShocksLabel.setText(this.numberOfShocks + "");
                this.timeLast = 0;
                this.timeLastLabel.setText("00:00");
                this.timeTotal = 1;
                this.timeTotalLabel.setText("00:01");
            });
            this.countingTimeTotal = new Timeline(new KeyFrame[]{new KeyFrame(Duration.seconds((double)1.0), actionEvent -> this.setTimeTotal(), new KeyValue[0])});
            this.countingTimeTotal.setCycleCount(-1);
            this.countingTimeTotal.play();
        }
    }

    public void hideDefibrilator() {
        this.defibrilator.setVisible(false);
        this.startOfDef = false;
        this.countingTimeLast = this.stopAnimation(this.countingTimeLast);
        this.countingTimeTotal = this.stopAnimation(this.countingTimeTotal);
    }

    public void changeElectrods() {
        if (!this.setElectrodsAction()) {
            return;
        }
        if (!this.changeTerapyElectrods()) {
            return;
        }
        if (this.isAED) {
            this.infoLabel.setText(LoadFXMLWithResourceBundle.getLangResource().getString("monitor.defibrilator.startAnalyse"));
            this.playSounds.playSound("start_analyse_ekg.wav");
        } else {
            this.infoLabel.setText(LoadFXMLWithResourceBundle.getLangResource().getString("monitor.defibrilator.bottomMenu.energy"));
        }
    }

    private boolean changeTerapyElectrods() {
        if (!this.terapyElectrods) {
            this.infoLabel.setText(LoadFXMLWithResourceBundle.getLangResource().getString("monitor.defibrilator.freeTherapyElektrode"));
            this.playSounds.playSound("connect_electrods_for_terapy.wav");
            return false;
        }
        return true;
    }

    public void runAnalyza(boolean bl) {
        if (!(this.electrods && this.terapyElectrods && this.isAED && this.analyseAnimation == null)) {
            return;
        }
        this.infoLabel.setText(LoadFXMLWithResourceBundle.getLangResource().getString("monitor.defibrilator.dontTouch"));
        this.playSounds.playSound("dont_touch_pacient.wav");
        this.isAnalysaComplete = false;
        this.analysaResult = bl;
        this.changeCloseButton(true);
        this.analyseAnimation = new Timeline(new KeyFrame[]{new KeyFrame(Duration.seconds((double)0.5), actionEvent -> this.analyseAnimation(), new KeyValue[0])});
        this.analyseAnimation.setCycleCount(-1);
        this.analyseAnimation.play();
    }

    public void setImpedanceFromRemoter(int n, Button button, Button button2, Button button3) {
        String string = "-fx-background-color:white; -fx-text-fill:black;";
        this.lowImpedance = button;
        this.mediumImpedance = button2;
        this.highImpedance = button3;
        switch (n) {
            case 0: {
                button.setStyle(string);
                button3.setStyle("");
                button2.setStyle("");
                break;
            }
            case 1: {
                button2.setStyle(string);
                button.setStyle("");
                button3.setStyle("");
                break;
            }
            case 2: {
                button3.setStyle(string);
                button2.setStyle("");
                button.setStyle("");
            }
        }
        this.setImpedance(n);
    }

    private void disablePowerButtons(boolean bl) {
        this.power50.setDisable(bl);
        this.power100.setDisable(bl);
        this.power150.setDisable(bl);
        this.power200.setDisable(bl);
    }

    private void disableImpedanceButtons(boolean bl) {
        this.lowImpedance.setDisable(bl);
        this.mediumImpedance.setDisable(bl);
        this.highImpedance.setDisable(bl);
    }

    private void changeCloseButton(boolean bl) {
        if (bl) {
            this.closeDefibrilator.setText(LoadFXMLWithResourceBundle.getLangResource().getString("global.cancel"));
            this.closeDefibrilator.setOnAction(actionEvent -> this.cancelReloading());
        } else {
            this.closeDefibrilator.setText(LoadFXMLWithResourceBundle.getLangResource().getString("global.close"));
            this.closeDefibrilator.setOnAction(actionEvent -> this.hideDefibrilator());
        }
    }

    private void cancelReloading() {
        this.analyseAnimation = this.stopAnimation(this.analyseAnimation);
        this.reloading = this.stopAnimation(this.reloading);
        this.analyse.setProgress(0.0);
        this.reload.setProgress(0.0);
        this.disableImpedanceButtons(false);
        this.disablePowerButtons(false);
        this.changeCloseButton(false);
        this.shock.setDisable(true);
        this.playSounds.stopShockReadyAnimation();
        if (this.isAED) {
            this.changeElectrods();
        } else {
            this.infoLabel.setText(LoadFXMLWithResourceBundle.getLangResource().getString("monitor.defibrilator.bottomMenu.energy"));
        }
    }

    private Timeline stopAnimation(Timeline timeline) {
        if (timeline != null) {
            timeline.stop();
        }
        return null;
    }

    public boolean isAED() {
        return this.isAED;
    }

    private void setModeDefibrilator(boolean bl, String string, GridPane gridPane, GridPane gridPane2) {
        this.typeOfDefibrilator.setText(string);
        this.isAED = bl;
        gridPane2.setVisible(bl);
    }

    private void analyseAnimation() {
        double d = this.analyse.getProgress();
        this.analyse.setProgress(d + 0.07);
        if (d > 0.25 && this.analysaResult) {
            this.reloadDefibrilator(false);
        }
        if ((int)d == 1 && !this.analysaResult) {
            this.infoLabel.setText(LoadFXMLWithResourceBundle.getLangResource().getString("monitor.defibrilator.dontShock"));
            this.playSounds.playSound("dont_give_shock.wav");
        }
        if ((int)d == 1) {
            this.analyse.setProgress(0.0);
            this.analyseAnimation = this.stopAnimation(this.analyseAnimation);
            this.isAnalysaComplete = true;
        }
    }

    private boolean setElectrodsAction() {
        if (!this.electrods) {
            this.infoLabel.setText(LoadFXMLWithResourceBundle.getLangResource().getString("monitor.defibrilator.freeECGElektrode"));
            this.playSounds.playSound("free_ekg_electrod.wav");
            return false;
        }
        return true;
    }

    private void reloadDefRun() {
        if ((int)this.reload.getProgress() < 1) {
            this.reload.setProgress(this.reload.getProgress() + 0.05);
            return;
        }
        if (!this.handleShockReady()) {
            return;
        }
        this.chargeWithAnalyse();
    }

    private boolean handleShockReady() {
        if (this.impedance != 1) {
            this.infoLabel.setText(LoadFXMLWithResourceBundle.getLangResource().getString("monitor.defibrilator.wrongImpedance"));
            return false;
        }
        this.reloading = this.stopAnimation(this.reloading);
        this.disableImpedanceButtons(true);
        this.shock.setDisable(false);
        if (!this.isAED) {
            this.infoLabel.setText(LoadFXMLWithResourceBundle.getLangResource().getString("monitor.defibrilator.shockReady"));
            this.playSounds.playSound("give_shock.wav");
            this.playSounds.startShockReadyAnimation();
            return false;
        }
        return true;
    }

    private void chargeWithAnalyse() {
        if ((int)this.reload.getProgress() == 1 && this.isAnalysaComplete) {
            if (this.analysaResult) {
                this.infoLabel.setText(LoadFXMLWithResourceBundle.getLangResource().getString("monitor.defibrilator.giveShock"));
                this.playSounds.playSound("give_shock.wav");
                this.playSounds.startShockReadyAnimation();
            } else {
                this.infoLabel.setText(LoadFXMLWithResourceBundle.getLangResource().getString("monitor.defibrilator.dontShock"));
                this.playSounds.playSound("dont_give_shock.wav");
            }
        }
    }

    public void pauseAnimations() {
        if (this.reloading != null) {
            this.reloading.pause();
        }
        if (this.playSounds != null) {
            this.playSounds.stopSound();
        }
        if (this.countingTimeLast != null) {
            this.countingTimeLast.pause();
        }
        if (this.countingTimeTotal != null) {
            this.countingTimeTotal.pause();
        }
        if (this.analyseAnimation != null) {
            this.analyseAnimation.pause();
        }
        this.playSounds.stopShockReadyAnimation();
    }

    public void resumeAnimation() {
        if (this.reloading != null) {
            this.reloading.play();
        }
        if (this.countingTimeLast != null) {
            this.countingTimeLast.play();
        }
        if (this.countingTimeTotal != null) {
            this.countingTimeTotal.play();
        }
        if (this.analyseAnimation != null) {
            this.analyseAnimation.play();
        }
    }

    public void clear() {
        if (this.reloading != null) {
            this.reloading.stop();
        }
        if (this.playSounds != null) {
            this.playSounds.stopSound();
            this.playSounds.stopShockReadyAnimation();
        }
        if (this.countingTimeLast != null) {
            this.countingTimeLast.stop();
        }
        if (this.countingTimeTotal != null) {
            this.countingTimeTotal.stop();
        }
        if (this.analyseAnimation != null) {
            this.analyseAnimation.stop();
        }
        this.reloading = null;
        this.playSounds = null;
        this.countingTimeLast = null;
        this.countingTimeTotal = null;
        this.analyseAnimation = null;
    }
}

