/*
 * Decompiled with CFR 0.152.
 */
package PETER_Monitor.vital_values;

import PETER_Monitor.vital_monitor.settings_monitor.SettingsValues;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;
import javafx.scene.paint.Color;

public class SimpleVitalFunction {
    protected final String nameShortcut;
    protected final String unitsShortcut;
    protected SimpleIntegerProperty minValue;
    protected SimpleIntegerProperty maxValue;
    protected SimpleIntegerProperty actualValue;
    protected ObjectProperty<Color> colorOfFont;
    protected int maxPosibleValue;
    protected int minPosibleValue;
    protected GridPane panel;
    protected Pane background;
    protected Label actualValueLabel;
    protected Label nameShortcutLabel;
    protected Label unitsShortcutLabel;
    protected Label minValueLabel;
    protected Label maxValueLabel;
    protected boolean changeComplete;
    protected boolean isLabelBind;
    protected double speedOfTransition;

    public SimpleVitalFunction(String string, String string2, SimpleIntegerProperty simpleIntegerProperty, SimpleIntegerProperty simpleIntegerProperty2, Color color, int n, int n2) {
        this.nameShortcut = string;
        this.unitsShortcut = string2;
        this.minValue = new SimpleIntegerProperty(0);
        this.maxValue = new SimpleIntegerProperty(0);
        this.actualValue = new SimpleIntegerProperty(0);
        this.minPosibleValue = n;
        this.maxPosibleValue = n2;
        this.colorOfFont = new SimpleObjectProperty((Object)color);
        this.saveNumeralData(simpleIntegerProperty, simpleIntegerProperty2);
        this.init();
    }

    public SimpleVitalFunction(String string, String string2, Color color, int n, int n2) {
        this.nameShortcut = string;
        this.unitsShortcut = string2;
        this.actualValue = new SimpleIntegerProperty(0);
        this.minPosibleValue = n;
        this.maxPosibleValue = n2;
        this.colorOfFont = new SimpleObjectProperty((Object)color);
        this.init();
    }

    private void init() {
        this.changeComplete = false;
        this.background = new Pane();
        this.createGridpane();
        this.fillGridpane();
        this.isLabelBind = false;
        this.speedOfTransition = 10.0;
    }

    public void saveNumeralData(SimpleIntegerProperty simpleIntegerProperty, SimpleIntegerProperty simpleIntegerProperty2) {
        this.minValue.bind((ObservableValue)simpleIntegerProperty);
        this.maxValue.bind((ObservableValue)simpleIntegerProperty2);
        this.checkValues(simpleIntegerProperty, simpleIntegerProperty.intValue());
        this.checkValues(simpleIntegerProperty2, simpleIntegerProperty2.intValue());
        simpleIntegerProperty.addListener((observableValue, number, number2) -> this.checkValues(simpleIntegerProperty, number2.intValue()));
        simpleIntegerProperty2.addListener((observableValue, number, number2) -> this.checkValues(simpleIntegerProperty2, number2.intValue()));
    }

    private void checkValues(SimpleIntegerProperty simpleIntegerProperty, int n) {
        if (n > this.maxPosibleValue) {
            simpleIntegerProperty.set(this.maxPosibleValue);
        }
        if (n < this.minPosibleValue) {
            simpleIntegerProperty.set(this.minPosibleValue);
        }
    }

    private void createGridpane() {
        this.panel = new GridPane();
        GridPane.setMargin((Node)this.background, (Insets)new Insets(0.0, 1.0, 0.0, 1.0));
        ColumnConstraints columnConstraints = new ColumnConstraints(50.0, -1.0, -1.0);
        ColumnConstraints columnConstraints2 = new ColumnConstraints(100.0, -1.0, -1.0);
        ColumnConstraints columnConstraints3 = new ColumnConstraints(30.0, -1.0, -1.0);
        columnConstraints.setHgrow(Priority.SOMETIMES);
        columnConstraints.setHgrow(Priority.SOMETIMES);
        columnConstraints3.setHgrow(Priority.SOMETIMES);
        columnConstraints3.setHalignment(HPos.RIGHT);
        columnConstraints2.setHalignment(HPos.CENTER);
        this.panel.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{columnConstraints, columnConstraints2, columnConstraints3});
        RowConstraints rowConstraints = new RowConstraints(10.0, 30.0, -1.0);
        RowConstraints rowConstraints2 = new RowConstraints(10.0, 30.0, -1.0);
        RowConstraints rowConstraints3 = new RowConstraints(10.0, 30.0, -1.0);
        rowConstraints.setVgrow(Priority.SOMETIMES);
        rowConstraints2.setVgrow(Priority.SOMETIMES);
        rowConstraints3.setVgrow(Priority.SOMETIMES);
        this.panel.getRowConstraints().addAll((Object[])new RowConstraints[]{rowConstraints, rowConstraints2, rowConstraints3});
    }

    protected void fillGridpane() {
        this.prepareLabels();
        this.panel.add((Node)this.background, 0, 0, 3, 3);
        this.panel.add((Node)this.nameShortcutLabel, 0, 0, 1, 1);
        this.panel.add((Node)this.unitsShortcutLabel, 0, 2, 1, 1);
        this.panel.add((Node)this.actualValueLabel, 1, 1, 1, 1);
        this.panel.add((Node)this.minValueLabel, 2, 1, 1, 1);
        this.panel.add((Node)this.maxValueLabel, 2, 2, 1, 1);
    }

    protected void prepareLabels() {
        this.unitsShortcutLabel = new Label(this.unitsShortcut);
        this.nameShortcutLabel = new Label(this.nameShortcut);
        this.minValueLabel = new Label("---");
        this.maxValueLabel = new Label("---");
        this.actualValueLabel = new Label("--");
        if (this.minValue.greaterThan(0).get()) {
            this.minValueLabel.textProperty().bind((ObservableValue)this.minValue.asString());
        }
        if (this.maxValue.greaterThan(0).get()) {
            this.maxValueLabel.textProperty().bind((ObservableValue)this.maxValue.asString());
        }
        this.unitsShortcutLabel.setPadding(new Insets(0.0, 0.0, 0.0, 10.0));
        this.nameShortcutLabel.setPadding(new Insets(0.0, 0.0, 0.0, 10.0));
        this.minValueLabel.setPadding(new Insets(0.0, 10.0, 0.0, 0.0));
        this.maxValueLabel.setPadding(new Insets(0.0, 10.0, 0.0, 0.0));
        this.actualValueLabel.setAlignment(Pos.CENTER);
        this.actualValueLabel.setStyle("-fx-font-size:50;");
        this.unitsShortcutLabel.textFillProperty().bind(this.colorOfFont);
        this.nameShortcutLabel.textFillProperty().bind(this.colorOfFont);
        this.minValueLabel.textFillProperty().bind(this.colorOfFont);
        this.maxValueLabel.textFillProperty().bind(this.colorOfFont);
        this.actualValueLabel.textFillProperty().bind(this.colorOfFont);
    }

    public double getSpeedOfTransition() {
        return this.speedOfTransition;
    }

    public double getActualValue() {
        return this.actualValue.doubleValue();
    }

    public Color getColorOfFont() {
        return (Color)this.colorOfFont.get();
    }

    public GridPane getPanel() {
        return this.panel;
    }

    public int getMaxValue() {
        if (this.maxValue == null) {
            return -1;
        }
        return this.maxValue.intValue();
    }

    public int getMinValue() {
        if (this.minValue == null) {
            return -1;
        }
        return this.minValue.intValue();
    }

    public String getNameShortcut() {
        return this.nameShortcut;
    }

    public String getUnitsShortcut() {
        return this.unitsShortcut;
    }

    public int getMinPosibleValue() {
        return this.minPosibleValue;
    }

    public int getMaxPosibleValue() {
        return this.maxPosibleValue;
    }

    public boolean getChangeComplete() {
        return this.changeComplete;
    }

    public SimpleIntegerProperty getActualValueProperty() {
        return this.actualValue;
    }

    public void setChangeComplete(boolean bl) {
        this.changeComplete = bl;
    }

    public void setMinPosibleValue(int n) {
        this.minPosibleValue = n;
    }

    public void setMaxPosibleValue(int n) {
        this.maxPosibleValue = n;
    }

    public void setActualValue(double d) {
        if (!this.isLabelBind) {
            this.actualValueLabel.textProperty().bind((ObservableValue)this.actualValue.asString());
            this.isLabelBind = true;
        }
        this.actualValue.set((int)d);
    }

    public void setMaxValue(int n) {
        this.maxValue.set(n);
    }

    public void setMinValue(int n) {
        this.minValue.set(n);
    }

    public void setColorOfFont(Color color) {
        this.colorOfFont.set((Object)color);
    }

    public void verifyHealthBorders() {
        if (this.actualValue.lessThan((ObservableNumberValue)this.minValue).get()) {
            String[] stringArray = SettingsValues.BOTTOMwarning.toString().split("x");
            this.background.setStyle("-fx-background-color: #" + stringArray[1] + ";");
            return;
        }
        if (this.actualValue.greaterThan((ObservableNumberValue)this.maxValue).get()) {
            String[] stringArray = SettingsValues.TOPwarning.toString().split("x");
            this.background.setStyle("-fx-background-color: #" + stringArray[1] + ";");
            return;
        }
        this.background.setStyle("-fx-background-color:transparent;");
    }

    public void setSpeedOfTransition(double d) {
        this.speedOfTransition = d;
    }

    public void setDefaultView() {
        this.actualValueLabel.textProperty().unbind();
        this.actualValueLabel.setText("--");
        this.actualValue.set(0);
        this.isLabelBind = false;
    }

    public void setDeadState() {
        this.actualValueLabel.textProperty().unbind();
        this.actualValueLabel.setText("0");
        this.actualValue.set(0);
        this.isLabelBind = false;
    }

    public void clear() {
        this.panel.getChildren().clear();
        GridPane gridPane = (GridPane)this.panel.getParent();
        gridPane.getChildren().remove((Object)this.panel);
    }
}

