/*
 * Decompiled with CFR 0.152.
 */
package PETER_Monitor.vital_ecg;

import PETER_Monitor.vital_ecg.IChart;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.scene.chart.AreaChart;
import javafx.scene.chart.Axis;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;

public class CO2Chart
extends AreaChart<Number, Number>
implements IChart {
    private final ObservableList<XYChart.Data<Number, Number>> dataPlot = FXCollections.observableArrayList();
    private final XYChart.Series<Number, Number> series = new XYChart.Series(this.dataPlot);
    private final Queue<Float> timeQueue;
    private final NumberAxis xAxis;
    private final ExecutorService ex;
    private Task animation;
    private Task breath;
    private float CO2Value;
    private float tmpCO2Value;
    private float timeX;
    private double WAIT;
    private boolean plotting;

    public CO2Chart(NumberAxis axis, NumberAxis axis1) {
        super((Axis)axis, (Axis)axis1);
        this.xAxis = axis;
        this.ex = Executors.newWorkStealingPool();
        this.timeQueue = new LinkedList<Float>();
        this.getData().add(this.series);
        this.setAnimated(false);
        this.setCreateSymbols(false);
        this.breathing();
        this.animation();
        this.initValues();
    }

    private void initValues() {
        this.CO2Value = 0.0f;
        this.timeX = 0.0f;
        this.WAIT = 1.9999999552965164E7;
    }

    private void breathing() {
        final Random rand = new Random();
        this.breath = new Task(){
            int time = 1;

            protected Void call() throws Exception {
                while (!this.isCancelled()) {
                    CO2Chart.this.plotting = !CO2Chart.this.plotting;
                    CO2Chart.this.tmpCO2Value = CO2Chart.this.plotting ? CO2Chart.this.CO2Value : 0.0f;
                    this.time = rand.nextInt(2) + 1;
                    TimeUnit.SECONDS.sleep(this.time);
                }
                return null;
            }
        };
        this.ex.submit((Runnable)this.breath);
    }

    private void animation() {
        this.animation = new Task(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Void call() throws Exception {
                while (true) {
                    if (this.isCancelled()) break;
                    Queue queue = CO2Chart.this.timeQueue;
                    synchronized (queue) {
                        CO2Chart.this.timeQueue.add(Float.valueOf(CO2Chart.this.timeX));
                    }
                    Platform.runLater(() -> {
                        Queue queue = CO2Chart.this.timeQueue;
                        synchronized (queue) {
                            while (!CO2Chart.this.timeQueue.isEmpty()) {
                                CO2Chart.this.dataPlot.add((Object)new XYChart.Data(CO2Chart.this.timeQueue.remove(), (Object)Float.valueOf(CO2Chart.this.tmpCO2Value)));
                            }
                        }
                        if (CO2Chart.this.dataPlot.size() > 250) {
                            CO2Chart.this.dataPlot.remove(0, CO2Chart.this.dataPlot.size() - 250);
                        }
                    });
                    CO2Chart.this.xAxis.setLowerBound((double)(CO2Chart.this.timeX - 5.0f));
                    CO2Chart.this.xAxis.setUpperBound((double)CO2Chart.this.timeX);
                    TimeUnit.NANOSECONDS.sleep((long)CO2Chart.this.WAIT);
                    CO2Chart.this.timeX = CO2Chart.this.timeX + 0.02f;
                    if (!((double)CO2Chart.this.timeX >= 1.0E7)) continue;
                    CO2Chart.this.timeX = 0.0f;
                }
                CO2Chart.this.breath.cancel();
                return null;
            }
        };
        this.ex.submit((Runnable)this.animation);
    }

    public void setCO2(int value) {
        if (value > 0) {
            this.CO2Value = value;
        }
    }

    @Override
    public void die() {
        this.animation.cancel();
        this.breath.cancel();
        this.ex.shutdownNow();
    }
}

