/*
 * Decompiled with CFR 0.152.
 */
package PETER_Monitor.vital_monitor.settings_monitor;

import PETER_Monitor.vital_monitor.settings_monitor.Alerts;
import PETER_Monitor.vital_monitor.settings_monitor.SettingsValues;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class WriteSettings {
    public static void writeSettings() {
        WriteSettings.createFolder("data");
        WriteSettings.createFolder("data/settings");
        File file = new File("data/settings/settings.cfg");
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(file));){
            WriteSettings.writeLanguage(bw);
            WriteSettings.writeBoundaries(bw);
            WriteSettings.writeSound(bw);
            WriteSettings.writeWarningColor(bw);
        }
        catch (Exception e) {
            Alerts.warningAlert("Chyba p\u0159i ukl\u00e1d\u00e1n\u00ed", "Chyba v nastaven\u00ed", "Nebylo mo\u017en\u00e9 ulo\u017eit va\u0161e nastaven\u00ed. Bylo na\u010dteno zp\u011bt defaultn\u00ed.");
        }
    }

    private static void createFolder(String pathToFolder) {
        File dir = new File(pathToFolder);
        if (!dir.exists()) {
            dir.mkdir();
        }
    }

    private static void writeLanguage(BufferedWriter bw) throws IOException {
        bw.write("language=" + SettingsValues.locale);
        bw.newLine();
    }

    private static void writeSound(BufferedWriter bw) throws IOException {
        bw.write("muteAll=" + SettingsValues.ALLSounds);
        bw.newLine();
        bw.write("muteDefibrillator=" + SettingsValues.DEFIBRILATORSound);
        bw.newLine();
        bw.write("muteNIBP=" + SettingsValues.NIBPSound);
        bw.newLine();
        bw.write("muteECG=" + SettingsValues.ECGSound);
        bw.newLine();
    }

    private static void writeBoundaries(BufferedWriter bw) throws IOException {
        bw.write("HRmin=" + SettingsValues.HRmin.get());
        bw.newLine();
        bw.write("HRmax=" + SettingsValues.HRmax.get());
        bw.newLine();
        bw.write("HRcolor=" + SettingsValues.HRcolor.toString());
        bw.newLine();
        bw.write("Spo2min=" + SettingsValues.SPO2min.get());
        bw.newLine();
        bw.write("Spo2max=" + SettingsValues.SPO2max.get());
        bw.newLine();
        bw.write("Spo2color=" + SettingsValues.SPO2color.toString());
        bw.newLine();
        bw.write("PPmin=" + SettingsValues.PPmax.get());
        bw.newLine();
        bw.write("PPmax=" + SettingsValues.PPmax.get());
        bw.newLine();
        bw.write("PPcolor=" + SettingsValues.PPcolor.toString());
        bw.newLine();
        bw.write("NIBPcolor=" + SettingsValues.NIBPcolor.toString());
        bw.newLine();
        bw.write("ETCO2min=" + SettingsValues.ETCO2min.get());
        bw.newLine();
        bw.write("ETCO2max=" + SettingsValues.ETCO2max.get());
        bw.newLine();
        bw.write("ETCO2color=" + SettingsValues.ETCO2color.toString());
        bw.newLine();
        bw.write("Tempmin=" + SettingsValues.TEMPmin.get());
        bw.newLine();
        bw.write("Tempmax=" + SettingsValues.TEMPmax.get());
        bw.newLine();
        bw.write("Tempcolor=" + SettingsValues.TEMPcolor.toString());
        bw.newLine();
    }

    private static void writeWarningColor(BufferedWriter bw) throws IOException {
        bw.write("TOPwarning=" + SettingsValues.TOPwarning.toString());
        bw.newLine();
        bw.write("BOTTOMwarning=" + SettingsValues.BOTTOMwarning.toString());
        bw.newLine();
    }
}

