/*
 * Decompiled with CFR 0.152.
 */
package PETER_Monitor.vital_values;

import PETER_Monitor.vital_monitor.settings_monitor.SettingsValues;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;
import javafx.scene.paint.Color;

public class SimpleVitalFunction {
    protected final String nameShortcut;
    protected final String unitsShortcut;
    protected SimpleIntegerProperty minValue;
    protected SimpleIntegerProperty maxValue;
    protected SimpleIntegerProperty actualValue;
    protected ObjectProperty<Color> colorOfFont;
    protected int maxPosibleValue;
    protected int minPosibleValue;
    protected GridPane panel;
    protected Pane background;
    protected Label actualValueLabel;
    protected Label nameShortcutLabel;
    protected Label unitsShortcutLabel;
    protected Label minValueLabel;
    protected Label maxValueLabel;
    protected boolean changeComplete;
    protected boolean isLabelBind;
    protected double speedOfTransition;

    public SimpleVitalFunction(String nameShortcut, String unitsShortcut, SimpleIntegerProperty minValue, SimpleIntegerProperty maxValue, Color colorOfFont, int minPosibleValue, int maxPosibleValue) {
        this.nameShortcut = nameShortcut;
        this.unitsShortcut = unitsShortcut;
        this.minValue = new SimpleIntegerProperty(0);
        this.maxValue = new SimpleIntegerProperty(0);
        this.actualValue = new SimpleIntegerProperty(0);
        this.minPosibleValue = minPosibleValue;
        this.maxPosibleValue = maxPosibleValue;
        this.colorOfFont = new SimpleObjectProperty((Object)colorOfFont);
        this.saveNumeralData(minValue, maxValue);
        this.init();
    }

    public SimpleVitalFunction(String nameShortcut, String unitsShortcut, Color colorOfFont, int minPosibleValue, int maxPosibleValue) {
        this.nameShortcut = nameShortcut;
        this.unitsShortcut = unitsShortcut;
        this.actualValue = new SimpleIntegerProperty(0);
        this.minPosibleValue = minPosibleValue;
        this.maxPosibleValue = maxPosibleValue;
        this.colorOfFont = new SimpleObjectProperty((Object)colorOfFont);
        this.init();
    }

    private void init() {
        this.changeComplete = false;
        this.background = new Pane();
        this.createGridpane();
        this.fillGridpane();
        this.isLabelBind = false;
        this.speedOfTransition = 10.0;
    }

    public void saveNumeralData(SimpleIntegerProperty minValue, SimpleIntegerProperty maxValue) {
        this.minValue.bind((ObservableValue)minValue);
        this.maxValue.bind((ObservableValue)maxValue);
        this.checkValues(minValue, minValue.intValue());
        this.checkValues(maxValue, maxValue.intValue());
        minValue.addListener((observable, oldValue, newValue) -> this.checkValues(minValue, newValue.intValue()));
        maxValue.addListener((observable, oldValue, newValue) -> this.checkValues(maxValue, newValue.intValue()));
    }

    private void checkValues(SimpleIntegerProperty simpleIntegerProperty, int newValue) {
        if (newValue > this.maxPosibleValue) {
            simpleIntegerProperty.set(this.maxPosibleValue);
        }
        if (newValue < this.minPosibleValue) {
            simpleIntegerProperty.set(this.minPosibleValue);
        }
    }

    private void createGridpane() {
        this.panel = new GridPane();
        GridPane.setMargin((Node)this.background, (Insets)new Insets(0.0, 1.0, 0.0, 1.0));
        ColumnConstraints column1 = new ColumnConstraints(50.0, -1.0, -1.0);
        ColumnConstraints column2 = new ColumnConstraints(100.0, -1.0, -1.0);
        ColumnConstraints column3 = new ColumnConstraints(30.0, -1.0, -1.0);
        column1.setHgrow(Priority.SOMETIMES);
        column1.setHgrow(Priority.SOMETIMES);
        column3.setHgrow(Priority.SOMETIMES);
        column3.setHalignment(HPos.RIGHT);
        column2.setHalignment(HPos.CENTER);
        this.panel.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{column1, column2, column3});
        RowConstraints row1 = new RowConstraints(10.0, 30.0, -1.0);
        RowConstraints row2 = new RowConstraints(10.0, 30.0, -1.0);
        RowConstraints row3 = new RowConstraints(10.0, 30.0, -1.0);
        row1.setVgrow(Priority.SOMETIMES);
        row2.setVgrow(Priority.SOMETIMES);
        row3.setVgrow(Priority.SOMETIMES);
        this.panel.getRowConstraints().addAll((Object[])new RowConstraints[]{row1, row2, row3});
    }

    protected void fillGridpane() {
        this.prepareLabels();
        this.panel.add((Node)this.background, 0, 0, 3, 3);
        this.panel.add((Node)this.nameShortcutLabel, 0, 0, 1, 1);
        this.panel.add((Node)this.unitsShortcutLabel, 0, 2, 1, 1);
        this.panel.add((Node)this.actualValueLabel, 1, 1, 1, 1);
        this.panel.add((Node)this.minValueLabel, 2, 1, 1, 1);
        this.panel.add((Node)this.maxValueLabel, 2, 2, 1, 1);
    }

    protected void prepareLabels() {
        this.unitsShortcutLabel = new Label(this.unitsShortcut);
        this.nameShortcutLabel = new Label(this.nameShortcut);
        this.minValueLabel = new Label("---");
        this.maxValueLabel = new Label("---");
        this.actualValueLabel = new Label("--");
        if (this.minValue.greaterThan(0).get()) {
            this.minValueLabel.textProperty().bind((ObservableValue)this.minValue.asString());
        }
        if (this.maxValue.greaterThan(0).get()) {
            this.maxValueLabel.textProperty().bind((ObservableValue)this.maxValue.asString());
        }
        this.unitsShortcutLabel.setPadding(new Insets(0.0, 0.0, 0.0, 10.0));
        this.nameShortcutLabel.setPadding(new Insets(0.0, 0.0, 0.0, 10.0));
        this.minValueLabel.setPadding(new Insets(0.0, 10.0, 0.0, 0.0));
        this.maxValueLabel.setPadding(new Insets(0.0, 10.0, 0.0, 0.0));
        this.actualValueLabel.setAlignment(Pos.CENTER);
        this.actualValueLabel.setStyle("-fx-font-size:50;");
        this.unitsShortcutLabel.textFillProperty().bind(this.colorOfFont);
        this.nameShortcutLabel.textFillProperty().bind(this.colorOfFont);
        this.minValueLabel.textFillProperty().bind(this.colorOfFont);
        this.maxValueLabel.textFillProperty().bind(this.colorOfFont);
        this.actualValueLabel.textFillProperty().bind(this.colorOfFont);
    }

    public double getSpeedOfTransition() {
        return this.speedOfTransition;
    }

    public double getActualValue() {
        return this.actualValue.doubleValue();
    }

    public Color getColorOfFont() {
        return (Color)this.colorOfFont.get();
    }

    public GridPane getPanel() {
        return this.panel;
    }

    public int getMaxValue() {
        if (this.maxValue == null) {
            return -1;
        }
        return this.maxValue.intValue();
    }

    public int getMinValue() {
        if (this.minValue == null) {
            return -1;
        }
        return this.minValue.intValue();
    }

    public String getNameShortcut() {
        return this.nameShortcut;
    }

    public String getUnitsShortcut() {
        return this.unitsShortcut;
    }

    public int getMinPosibleValue() {
        return this.minPosibleValue;
    }

    public int getMaxPosibleValue() {
        return this.maxPosibleValue;
    }

    public boolean getChangeComplete() {
        return this.changeComplete;
    }

    public SimpleIntegerProperty getActualValueProperty() {
        return this.actualValue;
    }

    public void setChangeComplete(boolean changeComplete) {
        this.changeComplete = changeComplete;
    }

    public void setMinPosibleValue(int minPosibleValue) {
        this.minPosibleValue = minPosibleValue;
    }

    public void setMaxPosibleValue(int maxPosibleValue) {
        this.maxPosibleValue = maxPosibleValue;
    }

    public void setActualValue(double actualValue) {
        if (!this.isLabelBind) {
            this.actualValueLabel.textProperty().bind((ObservableValue)this.actualValue.asString());
            this.isLabelBind = true;
        }
        this.actualValue.set((int)actualValue);
    }

    public void setMaxValue(int maxValue) {
        this.maxValue.set(maxValue);
    }

    public void setMinValue(int minValue) {
        this.minValue.set(minValue);
    }

    public void setColorOfFont(Color colorOfFont) {
        this.colorOfFont.set((Object)colorOfFont);
    }

    public void verifyHealthBorders() {
        if (this.actualValue.lessThan((ObservableNumberValue)this.minValue).get()) {
            String[] color = SettingsValues.BOTTOMwarning.toString().split("x");
            this.background.setStyle("-fx-background-color: #" + color[1] + ";");
            return;
        }
        if (this.actualValue.greaterThan((ObservableNumberValue)this.maxValue).get()) {
            String[] color = SettingsValues.TOPwarning.toString().split("x");
            this.background.setStyle("-fx-background-color: #" + color[1] + ";");
            return;
        }
        this.background.setStyle("-fx-background-color:transparent;");
    }

    public void setSpeedOfTransition(double speedOfTransition) {
        this.speedOfTransition = speedOfTransition;
    }

    public void setDefaultView() {
        this.actualValueLabel.textProperty().unbind();
        this.actualValueLabel.setText("--");
        this.actualValue.set(0);
        this.isLabelBind = false;
    }

    public void setDeadState() {
        this.actualValueLabel.textProperty().unbind();
        this.actualValueLabel.setText("0");
        this.actualValue.set(0);
        this.isLabelBind = false;
    }

    public void clear() {
        this.panel.getChildren().clear();
        GridPane gridpane = (GridPane)this.panel.getParent();
        gridpane.getChildren().remove((Object)this.panel);
    }
}

