/*
 * Decompiled with CFR 0.152.
 */
package PETER_Monitor.vital_values;

import PETER_Monitor.vital_values.SimpleVitalFunction;
import java.util.ArrayList;

public class TransitionToNewValues {
    public boolean transition(ArrayList<SimpleVitalFunction> simpleVitalFunctions, ArrayList newValues) {
        int transitionCompleteCount = 0;
        for (int i = 0; i < simpleVitalFunctions.size() && !newValues.isEmpty() && !simpleVitalFunctions.isEmpty(); ++i) {
            SimpleVitalFunction function = simpleVitalFunctions.get(i);
            double newValue = (Double)newValues.get(i);
            if (function.getChangeComplete()) {
                ++transitionCompleteCount;
                continue;
            }
            if (newValue == -1.0) {
                function.setDefaultView();
                continue;
            }
            if (newValue == 0.0) {
                function.setDeadState();
                continue;
            }
            if (function.getActualValue() < newValue) {
                function.setActualValue(this.higherValue(function.getActualValue(), newValue, function.getSpeedOfTransition()));
            } else if (function.getActualValue() > newValue) {
                function.setActualValue(this.lowerValue(function.getActualValue(), newValue, function.getSpeedOfTransition()));
            }
            if (function.getActualValue() == newValue) {
                function.setChangeComplete(true);
                ++transitionCompleteCount;
            }
            function.verifyHealthBorders();
        }
        return transitionCompleteCount == simpleVitalFunctions.size();
    }

    private double lowerValue(double oldValue, double newValue, double addKoeficient) {
        if (oldValue - addKoeficient > newValue) {
            return oldValue - addKoeficient;
        }
        return newValue;
    }

    private double higherValue(double oldValue, double newValue, double addKoeficient) {
        if (oldValue + addKoeficient < newValue) {
            return oldValue + addKoeficient;
        }
        return newValue;
    }
}

