/*
 * Decompiled with CFR 0.152.
 */
package Language;

import java.net.URL;
import java.util.Locale;
import java.util.ResourceBundle;
import javafx.fxml.FXMLLoader;

public class LoadFXMLWithResourceBundle {
    private static ResourceBundle langResource;
    private static String baseName;

    public static ResourceBundle resourceBundleExists(Locale locale) {
        String string;
        ClassLoader classLoader = LoadFXMLWithResourceBundle.class.getClassLoader();
        if (classLoader.getResource(string = baseName + "_" + locale.getLanguage() + ".properties") != null) {
            Locale.getDefault();
            Locale.setDefault(locale);
            langResource = ResourceBundle.getBundle(baseName, locale.getDefault());
        } else {
            langResource = LoadFXMLWithResourceBundle.getDefaultResourceBundle();
        }
        return langResource;
    }

    private static ResourceBundle getDefaultResourceBundle() {
        Locale.getDefault();
        Locale.setDefault(new Locale("cs"));
        return ResourceBundle.getBundle(baseName, Locale.getDefault());
    }

    public static FXMLLoader loadFXML(URL uRL) {
        FXMLLoader fXMLLoader;
        langResource = LoadFXMLWithResourceBundle.resourceBundleExists(Locale.getDefault());
        if (uRL == null) {
            return null;
        }
        try {
            fXMLLoader = new FXMLLoader(uRL, langResource);
        }
        catch (Exception exception) {
            Locale.getDefault();
            Locale.setDefault(new Locale("cs"));
            fXMLLoader = new FXMLLoader(uRL, langResource);
        }
        return fXMLLoader;
    }

    public static ResourceBundle getLangResource() {
        return langResource;
    }

    static {
        baseName = "Language/Language";
    }
}

