package language;

import javafx.fxml.FXMLLoader;

import java.net.URL;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;

import data.Utils;

/**
 * Created by BobrZlosyn on 09.08.2016.
 */
public class LoadFXMLWithResourceBundle{
    private static ResourceBundle langResource;
    private static String baseName = "Language/Language";


    public static ResourceBundle resourceBundleExists(  Locale locale) {
        ClassLoader loader = LoadFXMLWithResourceBundle.class.getClassLoader();
        String properties = baseName + "_" + locale.getLanguage() + ".properties";


        if( loader.getResource(properties) != null){
            Locale.setDefault(locale);
            langResource = ResourceBundle.getBundle(baseName, Locale.getDefault());
        }else{
            langResource = getDefaultResourceBundle();
        }
        return langResource;
    }

    private static ResourceBundle getDefaultResourceBundle(){

        Locale.setDefault(new Locale("cs"));
        return ResourceBundle.getBundle(baseName, Locale.getDefault());
    }


    public static FXMLLoader loadFXML(URL url){
    	Properties properties = Utils.loadProperties(Utils.GENERAL_PROP_PATH);
        String language = properties.getProperty(Utils.GENERAL_LANG);
        langResource = LoadFXMLWithResourceBundle.resourceBundleExists(new Locale(language));
        FXMLLoader fXMLLoader;

        if(url == null){
            return null;
        }

        //odchyceni chyby kdy nejsou kompletni preklady daneho jazyka - nutno zmenit na defaultni (cs)
        try {
            fXMLLoader = new FXMLLoader(url , langResource);
        }catch (Exception e){
            Locale.setDefault(new Locale("cs"));
            fXMLLoader = new FXMLLoader(url , langResource);
        }

        return fXMLLoader;
    }


    public static ResourceBundle getLangResource() {

        return langResource;
    }
}
