/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package communication;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.BindException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;

import data.VitalData;
import gui_components.Alerts;
import vital_monitor.Controller;

/**
 *
 * @author Ludek Kanak
 *
 *         Klient
 */
public class Client {

	/**
	 * klient je ukoncen
	 */
	private boolean monitorClosed = false;

	/**
	 * pouzivany port
	 */
	private int usingPort;
	private String monitorName;

	private VitalData data;
	private Controller controller;
	private static final Logger LOG = java.util.logging.Logger.getLogger(Client.class.getName());

	public Client(Controller controller, String monitorName, int port) {
		this.controller = controller;
		this.monitorName = monitorName;
		this.usingPort = port;
	}

	public void startListening(String ip) {

		try (Socket clientSocket = new Socket(ip, usingPort)) {
			clientSocket.setSoTimeout(2500); // TODO
			monitorClosed = false;
			DataOutputStream os = null;
			ObjectInputStream ois = null;
			String messagge;
			while (!monitorClosed) {
				DataInputStream is = new DataInputStream(clientSocket.getInputStream());
				try {
					messagge = is.readUTF();
				} catch (SocketException se) { // monitor byl ukoncen
					LOG.log(Level.FINE, se.getMessage(), se);
					return;
				} catch (EOFException se) { // ovaladac byl ukoncen
					LOG.log(Level.FINE, se.getMessage(), se);
					return;
				}
				switch (messagge) {
				case "CLIENT_TEST":
					LOG.log(Level.INFO, "Recieved message: CLIENT_TEST");
					os = new DataOutputStream(clientSocket.getOutputStream());
					os.writeUTF("CLIENT_OK");
					break;
				case "DATA":
					LOG.log(Level.INFO, "Recieved data");
					os = new DataOutputStream(clientSocket.getOutputStream());
					os.writeUTF("CLIENT_READY");
					ois = new ObjectInputStream(clientSocket.getInputStream());
					data = readData(ois);
					controller.setData(data);
					break;
				case "SERVER_CLOSE":
					LOG.log(Level.INFO, "Remoter diconnected");
					break;
				}
			}
		} catch (IOException ex) {
			LOG.log(Level.SEVERE, null, ex);
		}
	}

	public String getRemoterIpAddress(String monitorName) throws SocketException{
		try (DatagramSocket dataSocket = new DatagramSocket(usingPort, InetAddress.getByName(Const.IP_TO_LISTEN))) {
			String ip = null;
			monitorClosed = false;
			while (!monitorClosed) {
				LOG.log(Level.FINE, "Listening on broadcast");
				ip = listenOnBroadcast(dataSocket, monitorName);
				LOG.log(Level.FINE, "Remoter(" + ip + ") was found");
				if (ip != null) {
					return ip;
				}
			}
		}catch (UnknownHostException e) {
			e.printStackTrace();
		}
		return null;
	}

	/**
	 * Precteni prichozich dat
	 *
	 * proud dat od serveru
	 * 
	 * @return
	 * @throws SocketException
	 * @throws IOException
	 */
	private VitalData readData(ObjectInputStream ois) throws SocketException, IOException {
		VitalData data = null;
		try {
			data = (VitalData) ois.readObject();

		} catch (ClassNotFoundException ex) {
			ex.printStackTrace();
		}
		return data;
	}

	private String listenOnBroadcast(DatagramSocket dataSocket, String monitorName) {
		try {
			dataSocket.setBroadcast(true);
			byte[] recievedData = new byte[Const.SIZE_OF_BUFFER];
			DatagramPacket receivePacket = new DatagramPacket(recievedData, recievedData.length);
			dataSocket.setSoTimeout(1000); // TODO
			dataSocket.receive(receivePacket); // cekani na data

			String recieveMessage = new String(receivePacket.getData()).trim();
			LOG.log(Level.INFO, "Recieve message: " + recieveMessage);

			if (recieveMessage.startsWith(Const.VERIFICATION_STRING)) { // overeni komunikace

				byte[] sendData = monitorName.getBytes();
				DatagramPacket sendPacket = new DatagramPacket(sendData, sendData.length, receivePacket.getAddress(),
						receivePacket.getPort());
				dataSocket.send(sendPacket);
			}

			if (recieveMessage.startsWith(Const.COMMUNICATION_START)) {
				return receivePacket.getAddress().getHostAddress();
			}

			return null;
		} catch (SocketTimeoutException ex) {
			LOG.log(Level.FINEST, "Broadcast connection timeout.");
			return null;
		} catch (SocketException ex) {
			ex.printStackTrace();
		} catch (IOException ex) {
			ex.printStackTrace();
		}
		return null;
	}

	public boolean isMonitorClosed() {
		return monitorClosed;
	}

	public void setMonitClosed(boolean monitorClosed) {
		this.monitorClosed = monitorClosed;
	}

}
