package vital_monitor;

import javafx.animation.Animation;
import javafx.animation.KeyFrame;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.layout.GridPane;
import javafx.scene.media.AudioClip;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;
import javafx.util.Duration;
import language.KeysForLanguage;
import language.LoadFXMLWithResourceBundle;

import java.time.LocalTime;


/**
 * Created by BobrZlosyn on 9. 4. 2016.
 */
public class NIBPHandler {

    private ProgressBar NIBPprogress;
    private Timeline pressureTL;
    private Label mode, valueOfMode, pressure, pressure2, NIBPtime;
    private Button start, changeMode, closeNIBP;
    private GridPane NIBPGridPane, NIBPOverview;
    private int activeMode, sysPressure, diaPressure, actualMeasurement, runCount;
    private final String[][] mods;
    private String[][] measurement;
    private boolean NIBPmax;
    private AudioClip clip;

    //promenne pro animaci
    private double maxValue;
    private boolean isSoundActive;
    private int volume;
    private NIBPVitalLabel nibpVitalLabel;

    public NIBPHandler(ProgressBar progress, Label mode, Label valueOfMode, Label pressure, Label pressure2,
                       Button start, Button changeMode, GridPane NIBPGridPane, Label NIBPtime, GridPane NIBPOverview, Button closeNIBP,
                       NIBPVitalLabel nibpVitalLabel) {

        NIBPprogress = progress;
        this.mode = mode;
        this.nibpVitalLabel = nibpVitalLabel;
        this.valueOfMode = valueOfMode;
        this.pressure = pressure;
        this.pressure2 = pressure2;
        this.start = start;
        this.changeMode = changeMode;
        this.NIBPGridPane = NIBPGridPane;
        this.NIBPtime = NIBPtime;
        this.NIBPOverview = NIBPOverview;
        this.closeNIBP = closeNIBP;
        activeMode = 0;
        actualMeasurement = 0;
        measurement = new String[5][3];
        this.mods = new String[3][2];
        setMeasurement();
        setMods();
        NIBPmax = false;
        clip = new AudioClip(getClass().getResource("/vital_monitor/sounds_monitor/nibp_sound_correct.wav").toExternalForm());
        isSoundActive = false;
        volume = 5;
    }

    /**
     * spousti animaci pro mereni tlaku
     *
     * @param sysPressure namereny sysPressure
     * @param diaPressure namereny diaPressure
     */
    public void runPressure(int sysPressure, int diaPressure) {
        if (pressureTL != null) {
            return;
        }

        maxValue = Double.parseDouble(mods[activeMode][1]) / 300;
        runCount = 0;

        pressureTL = new Timeline(new KeyFrame(Duration.seconds(0.7), e -> setNIBPprogress()));
        pressureTL.setCycleCount(Animation.INDEFINITE);
        pressureTL.playFromStart();

        setNewPressureLabels();
        clip.setVolume(volume);
        clip.play();

        closeNIBP.setDisable(true);
        this.sysPressure = sysPressure;
        this.diaPressure = diaPressure;
        changeMode.setDisable(true);
        start.setDisable(true);
        NIBPOverview.setVisible(false);
    }

    /**
     * overuje zda je zapnute mereni tlaku
     *
     * @return true pokud je zapnute mereni tlaku
     */
    public boolean isNIBPRunning() {
        return pressureTL != null;
    }


    /**
     * nastavuje mod mereni NIBP
     */
    public void setMode() {
        Platform.runLater(() -> {
            activeMode++;
            activeMode %= 3;

            mode.setText(mods[activeMode][0]);
            valueOfMode.setText(mods[activeMode][1]);
        });
    }

    /**
     * zobrazi nahled peti namerenych hodnot
     */
    public void showOverview() {
        int font;

        NIBPOverview.getChildren().clear();

        for (int i = 0; i < 5; i++) {
            if (!measurement[i][1].equals(LoadFXMLWithResourceBundle.getLangResource().getString(KeysForLanguage.NIBP_SMALL_VALUE))) {
                font = 32;
            } else {
                font = 24;
            }

            addLabelWithNIBP(font, i, 0);
            addLabelWithNIBP(font, i, 1);
            addLabelWithNIBP(font, i, 2);
        }
    }

    /**
     * zobrazi gridpane s tlakem
     */
    public void showPressure() {
        NIBPGridPane.setVisible(true);
    }

    /**
     * skryje gridpane s tlakem
     */
    public void hidePressure() {
        Platform.runLater(() -> {
            if (pressureTL != null) {
                pressureTL.pause();
                NIBPprogress.setProgress(0);
                changeMode.setDisable(false);
                start.setDisable(false);
            }
        });
        NIBPGridPane.setVisible(false);
    }

    /**
     * nastavuje labely pro nahled probehnutych mereni
     */
    private void setMeasurement() {
        for (int i = 0; i < 5; i++) {
            measurement[i][0] = LoadFXMLWithResourceBundle.getLangResource().getString(KeysForLanguage.NIBP_BIG_VALUE);
            measurement[i][1] = LoadFXMLWithResourceBundle.getLangResource().getString(KeysForLanguage.NIBP_SMALL_VALUE);
            measurement[i][2] = "--:--";
        }
    }

    /**
     * definovani jednotlivych modu
     */
    private void setMods() {
        this.mods[0][0] = LoadFXMLWithResourceBundle.getLangResource().getString(KeysForLanguage.NIBP_MODE_ADULT);
        this.mods[0][1] = "180";
        this.mods[1][0] = LoadFXMLWithResourceBundle.getLangResource().getString(KeysForLanguage.NIBP_MODE_CHILD);
        this.mods[1][1] = "120";
        this.mods[2][0] = LoadFXMLWithResourceBundle.getLangResource().getString(KeysForLanguage.NIBP_MODE_NEONAT);
        this.mods[2][1] = "90";
    }

    /**
     * vypocteni tlaku a zobrazovani na labelu
     */
    private void setNIBPLabel() {
        int sysP = sysPressure;
        int diaP = diaPressure;

        String presString = sysP + "/" + diaP;
        pressure.setText(presString);
        nibpVitalLabel.setNIBP(sysP, diaP);

        int map = ((2 * diaP) + sysP) / 3;

        String mapString = "(" + map + ")";
        pressure2.setText(mapString);
        nibpVitalLabel.setMapPressureLabel(mapString);

        String time = getTime();
        NIBPtime.setText(LoadFXMLWithResourceBundle.getLangResource().getString(KeysForLanguage.NIBP_LAST_TIME) + time);

        measurement[actualMeasurement][0] = presString;
        measurement[actualMeasurement][1] = mapString;
        measurement[actualMeasurement][2] = time;
        actualMeasurement++;
        actualMeasurement %= 5;
    }

    /**
     * kmitani u mereni tlaku
     *
     * @param runCount cislo aktualniho mereni
     */
    private void waitingInMeassure(int runCount) {
        if (runCount % 2 == 0) {
            NIBPprogress.setProgress(NIBPprogress.getProgress() + 0.02);
        } else {
            NIBPprogress.setProgress(NIBPprogress.getProgress() - 0.03);
        }
    }

    /**
     * ziskani aktualni casu v pocitaci
     *
     * @return vraci cas
     */
    private String getTime() {
        return String.format("%02d:%02d", LocalTime.now().getHour(), LocalTime.now().getMinute());
    }

    /**
     * nastavuje labely namereneho tlaku na nulove hodnoty
     */
    private void setNewPressureLabels() {
        pressure.setText(LoadFXMLWithResourceBundle.getLangResource().getString(KeysForLanguage.NIBP_BIG_VALUE));
        pressure2.setText(LoadFXMLWithResourceBundle.getLangResource().getString(KeysForLanguage.NIBP_SMALL_VALUE));
    }

    /**
     * nastavuje progress bar tlaku
     */
    private void setNIBPprogress() {
        if (!NIBPmax) {
            NIBPprogress.setProgress(NIBPprogress.getProgress() + 0.07);

            if (maxValue <= NIBPprogress.getProgress()) {
                NIBPmax = true;
            }
        } else {
            decreasingNIBP();
        }
    }

    /**
     * animace snizovani pri mereni tlaku
     */
    private void decreasingNIBP() {
        double value = NIBPprogress.getProgress();
        if (value < (maxValue - 0.1) && clip.isPlaying()) {
            waitingInMeassure(runCount++);
            return;
        }

        value -= 0.08;

        if (value <= 0) {
            endOfNIBPMeasurrement();
        } else {
            NIBPprogress.setProgress(value);
        }
    }

    /**
     * konec namereni tlaku, vynulovani vsech hodnot
     */
    private void endOfNIBPMeasurrement() {
        NIBPmax = false;// nastavi dosazeni maxima na false
        pressureTL.stop(); //zastavi animaci
        pressureTL = null;

        setNIBPLabel();  // nastavi namerene hodnoty
        NIBPprogress.setProgress(0);
        changeMode.setDisable(false); //obnovi meneni modu
        start.setDisable(false); //
        closeNIBP.setDisable(false);
        stopPlayingClip();

        if (NIBPOverview.isVisible()) {
            showOverview();
        }
    }

    /**
     * pridani labelu s namerenym tlakem do nahledu
     *
     * @param font velikost fontu
     * @param i    cislo indexu ve foru
     * @param j    cislo sloupce v gridpane
     */
    private void addLabelWithNIBP(int font, int i, int j) {
        Label text = new Label(measurement[i][j]);
        text.setTextFill(Color.WHITE);
        text.setFont(new Font(font));
        NIBPOverview.add(text, j, i);
    }

    public void pauseAnimation() {
        if (pressureTL != null) {
            pressureTL.pause();
        }
    }

    public void resumeAnimation() {
        if (pressureTL != null) {
            pressureTL.play();
        }
    }

    public void stopPlayingClip() {
        if (clip.isPlaying()) {
            clip.stop();
        }
    }

    public void setVolume(int volume) {
        if (volume == 0) {
            stopPlayingClip();
        }

        this.volume = volume;
    }

    public boolean getVolumeActive() {
        return this.volume > 0;
    }

    public void clear() {
        if (pressureTL != null) {
            pressureTL.stop();
        }
        pressureTL = null;
        stopPlayingClip();
    }
}




