package vital_monitor;

import javafx.application.Platform;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.control.Label;

public class NIBPVitalLabel extends VitalLabel {

    public NIBPVitalLabel() {
        super();
        prepareLabelsNIBP();
    }

    private void prepareLabelsNIBP() {
        actualValueLabel.setText("---/---");
        actualValueLabel.setStyle("-fx-font-size:25;");
        actualValueLabel.setPadding(new Insets(0, 0, 30, 0));

        Label mapLabel = new Label("(---)");
        mapLabel.textProperty().bindBidirectional(mapPressureLabelProperty());
        mapLabel.setAlignment(Pos.CENTER);
        mapLabel.setStyle("-fx-font-size:20;");
        mapLabel.textFillProperty().bind(colorLabelProperty());
        mapLabel.setPadding(new Insets(30, 0, 0, 0));

        minPossibleValueProperty().set(0);
        maxPossibleValueProperty().set(0);

        setVisibleMinMaxValues(false);

        this.add(mapLabel, 1, 1, 1, 1);
    }

    public void setNIBP(int sys, int dia) {
        Platform.runLater(() -> actualValueLabel.setText(String.valueOf(sys) + "/" + String.valueOf(dia)));
    }

    public final StringProperty mapPressureLabelProperty() {
        if (mapPressureLabel == null) {
            mapPressureLabel = new SimpleStringProperty(this, "mapPressure", "(---)");
        }
        return mapPressureLabel;
    }

    private StringProperty mapPressureLabel;

    public final void setMapPressureLabel(String value) {
        mapPressureLabelProperty().set(value);
    }

    public final String getMapPressureLabel() {
        return mapPressureLabel == null ? "" : mapPressureLabel.getValue();
    }


}
