package vital_sample_vizual;

import java.io.File;
import java.net.MalformedURLException;
import javafx.application.Application;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Scene;
import javafx.scene.SceneAntialiasing;
import javafx.scene.chart.Axis;
import javafx.scene.chart.LineChart;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import vital_ecg.ECGData;
import vital_ecg.ECGLineChart;
import vital_parser.ECGParser;

/**
 *
 * @author Patrik Patera
 * @version 1.00
 */
public class SamplesViz extends Application {

    /**
     * X-ova osa ECG1 grafu.
     */
    private final Axis xAxisECG = new NumberAxis(0, 2, 0.1);
    /**
     * Y-ova osa ECG1 grafu.
     */
    private final Axis yAxisECG = new NumberAxis(-0.5, 1, 1);

    public static void main(String[] args) {
        launch(args);
    }

    @Override
    public void start(Stage stage) throws Exception {
       //ECGParser.transformData("data\\ecg\\Fibrilation\\c_fibrilation2.csv", "data\\ecg\\Fibrilation\\c_fibrilation3.csv", 0f, 1.515f);
        //ECGParser.rewriteData("data\\ecg\\c_2AVBlockT1-4.csv", "data\\ecg\\c_2AVBlockT1-4T.csv", 0.148f);
       // ECGParser.plusXSampleValue("data\\ecg\\c_2AVBlockT1-3.csv", "data\\ecg\\c_2AVBlockT1-3T.csv", 0.8498535f , 309);
        ObservableList<XYChart.Data<Float, Float>> data
                = vital_parser.ECGParser.setData("data\\ecg\\Fibrilation\\c_fibrilation3.csv");
        ObservableList<XYChart.Series<Float, Float>> series = FXCollections.observableArrayList();
        XYChart.Series<Float, Float> ser = new XYChart.Series<>(data);
        
        series.add(ser);

        LineChart chart = new LineChart(xAxisECG, yAxisECG, series);
        chart.setCreateSymbols(false);
      

        Scene scene = new Scene(chart, 800, 130, false, SceneAntialiasing.BALANCED);

        try {
            scene.getStylesheets().add((new File("src/PETER_mognitor/vital_monitor/monitorCSS.css")).toURI().toURL().toExternalForm());
        } catch (MalformedURLException ex) {
            System.err.println("Bad loaded css!");
        }

        stage.setScene(scene);
        stage.show();

        stage.setOnCloseRequest((WindowEvent to) -> {
            System.out.println("Exit application");
            data.clear();
        });
    }

}
