package settings;

import gui_components.IPaneSetting;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.geometry.Insets;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.RowConstraints;
import javafx.scene.paint.Color;
import language.KeysForLanguage;
import language.LoadFXMLWithResourceBundle;

import java.util.Locale;
import java.util.ResourceBundle;

import data.Utils;

public class CreateGeneralPanel implements IPaneSetting {
	private static final ResourceBundle langResource =  LoadFXMLWithResourceBundle.getLangResource();
    private GridPane createGeneralPanel(){
        GridPane pane = new GridPane();
        pane.setPadding(new Insets(15,0,0,25));
        ColumnConstraints name = new ColumnConstraints(200);
        ColumnConstraints setting = new ColumnConstraints(200);
        RowConstraints row1 = new RowConstraints();
        RowConstraints row2 = new RowConstraints(40);
        RowConstraints row3 = new RowConstraints(40);
        RowConstraints row4 = new RowConstraints(40);
        pane.getColumnConstraints().addAll(name, setting);
        pane.getRowConstraints().addAll(row1,row2, row3, row4);

        Label title = new Label(langResource.getString(KeysForLanguage.MONITOR_GENERAL));
        Label label = new Label(langResource.getString(KeysForLanguage.MONITOR_GENERAL_LANG));
        Label changeLabel = new Label("");

        ComboBox comboBox = new ComboBox(FXCollections.observableArrayList(langResource.getString(KeysForLanguage.MONITOR_GENERAL_CS), langResource.getString(KeysForLanguage.MONITOR_GENERAL_EN)));
        //ComboBox comboBox = new ComboBox(FXCollections.observableArrayList("Čeština"));

        if(Locale.getDefault().getLanguage().equals("cs")){
            comboBox.getSelectionModel().select(0);
        }else{
            comboBox.getSelectionModel().select(1);
        }

        comboBox.setOnAction(event -> {
            if(comboBox.getSelectionModel().getSelectedIndex() == 0){
                Locale.setDefault(new Locale("cs"));
                Utils.updateProperties(Utils.GENERAL_LANG, "cs", Utils.GENERAL_PROP_PATH);
            }else {
                Locale.setDefault(new Locale("en"));
                Utils.updateProperties(Utils.GENERAL_LANG, "en", Utils.GENERAL_PROP_PATH);
            }
        });

        comboBox.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue != null) {
                Platform.runLater(() -> {
                    changeLabel.setTextFill(Color.RED);
                    changeLabel.setText(langResource.getString(KeysForLanguage.COMMON_CHANGE_LANG));
                });
            }
        });

        pane.add(title,0,0);
        pane.add(changeLabel, 1 , 0);
        pane.add(label, 0, 1);
        pane.add(comboBox, 1, 1);

        return  pane;
    }

    private void saveGeneralChanges(){
      //TODO save language
    }

    @Override
    public String toString(){
        return langResource.getString(KeysForLanguage.MONITOR_GENERAL_LANG);
    }

    @Override
    public void saveChanges() {
        saveGeneralChanges();
    }

    @Override
    public GridPane getContent() {
        return createGeneralPanel();
    }
}
