/*
 * Decompiled with CFR 0.152.
 */
package PETER_Monitor.vital_ecg;

import PETER_Monitor.vital_ecg.ECGData;
import PETER_Monitor.vital_ecg.ECGPoint;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javafx.application.Platform;

public class ECGAnimation {
    private Runnable animation;
    private ScheduledFuture<?> animateTask;
    private final ECGData ecg;
    private final ScheduledExecutorService executor;
    private double wait;
    private boolean beepSound;

    public ECGAnimation(ScheduledExecutorService executor, ECGData ecg) {
        this.ecg = ecg;
        this.executor = executor;
        this.beepSound = true;
        this.setAnimation();
    }

    private void setAnimation() {
        this.animation = () -> Platform.runLater(() -> {
            if (!this.ecg.isListEmpty()) {
                ECGPoint value = this.ecg.removePoint();
                this.ecg.getGraphECG1().addData(value.getPlotting(), value.getXValue(), value.getECG1YValue());
                this.ecg.decPoint();
                if (this.beepSound) {
                    value.beep();
                }
            }
        });
    }

    public ScheduledFuture<?> getAnimation() {
        return this.animateTask;
    }

    public void setBeep(boolean beep) {
        this.beepSound = beep;
    }

    public void setNewAnimation(double time) {
        this.wait = time;
        this.animateTask = this.executor.scheduleAtFixedRate(this.animation, 0L, (long)this.wait, TimeUnit.NANOSECONDS);
    }
}

