/*
 * Decompiled with CFR 0.152.
 */
package PETER_Monitor.vital_monitor;

import Language.LoadFXMLWithResourceBundle;
import PETER_Communications.com_protocol.Client;
import PETER_Communications.com_protocol.VitalData;
import PETER_Monitor.vital_monitor.Controller;
import PETER_Monitor.vital_monitor.settings_monitor.LoadSettings;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Application;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Stage;

public class Main
extends Application {
    private static Client client;
    public static Stage primaryStage;

    public void start(Stage primaryStage) throws Exception {
        LoadSettings.loadSettings(0);
        FXMLLoader fXMLLoader = LoadFXMLWithResourceBundle.loadFXML(((Object)((Object)this)).getClass().getResource("Monitor.fxml"));
        if (fXMLLoader == null) {
            System.out.println("Couldnt load fxml or resource bundle!");
            return;
        }
        Parent root = (Parent)fXMLLoader.load();
        primaryStage.setTitle("PETER-MONITOR");
        primaryStage.setScene(new Scene(root, 1080.0, 720.0));
        primaryStage.getScene().getStylesheets().add((Object)((Object)((Object)this)).getClass().getResource("monitorCSS.css").toExternalForm());
        primaryStage.setMinHeight(720.0);
        primaryStage.setMinWidth(1000.0);
        primaryStage.show();
        Controller controller = (Controller)fXMLLoader.getController();
        client = new Client();
        client.start();
        Main.recive(controller);
        primaryStage.setOnCloseRequest(we -> {
            client.closeClient();
            if (controller.getECGData() != null) {
                controller.getECGData().clear();
                controller.clear();
            }
        });
        Main.primaryStage = primaryStage;
    }

    public static void recive(Controller controller) {
        Thread th = new Thread(() -> {
            while (!client.isCloseClient()) {
                while (client.isAlive()) {
                    try {
                        TimeUnit.MILLISECONDS.sleep(1000L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                VitalData recieveData = client.recieveData();
                if (recieveData != null) {
                    controller.setData(recieveData);
                    continue;
                }
                if (!client.isCloseServer()) continue;
                client = new Client();
                client.start();
            }
        });
        th.start();
    }

    public static void main(String[] args) {
        Main.launch((String[])args);
    }

    public static Client getClient() {
        return client;
    }
}

