/*
 * Decompiled with CFR 0.152.
 */
package PETER_Monitor.vital_monitor;

import Language.LoadFXMLWithResourceBundle;
import PETER_Monitor.vital_values.NIBPVitalFunction;
import java.time.LocalTime;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.layout.GridPane;
import javafx.scene.media.AudioClip;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.util.Duration;

public class NIBPHandler {
    private ProgressBar NIBPprogress;
    private Timeline pressureTL;
    private Label mode;
    private Label valueOfMode;
    private Label pressure;
    private Label pressure2;
    private Label NIBPtime;
    private Button start;
    private Button changeMode;
    private Button closeNIBP;
    private GridPane NIBPGridPane;
    private GridPane NIBPOverview;
    private int activeMode;
    private int sysPressure;
    private int diaPressure;
    private int actualMeasurement;
    private int runCount;
    private final String[][] mods;
    private String[][] measurement;
    private boolean NIBPmax;
    private AudioClip clip;
    private double maxValue;
    private NIBPVitalFunction nibpVitalFunction;
    private boolean isSoundActive;
    private int volume;

    public NIBPHandler(ProgressBar progress, Label mode, Label valueOfMode, Label pressure, Label pressure2, Button start, Button changeMode, GridPane NIBPGridPane, Label NIBPtime, GridPane NIBPOverview, Button closeNIBP) {
        this.NIBPprogress = progress;
        this.mode = mode;
        this.valueOfMode = valueOfMode;
        this.pressure = pressure;
        this.pressure2 = pressure2;
        this.start = start;
        this.changeMode = changeMode;
        this.NIBPGridPane = NIBPGridPane;
        this.NIBPtime = NIBPtime;
        this.NIBPOverview = NIBPOverview;
        this.closeNIBP = closeNIBP;
        this.activeMode = 0;
        this.actualMeasurement = 0;
        this.measurement = new String[5][3];
        this.mods = new String[3][2];
        this.setMeasurement();
        this.setMods();
        this.NIBPmax = false;
        this.clip = new AudioClip(this.getClass().getResource("/PETER_Monitor/vital_monitor/sounds_monitor/nibp_sound.wav").toExternalForm());
        this.isSoundActive = false;
        this.volume = 5;
    }

    public void setNibpVitalFunction(NIBPVitalFunction nibpVitalFunction) {
        this.nibpVitalFunction = nibpVitalFunction;
    }

    public void runPressure(int sysPressure, int diaPressure) {
        if (this.pressureTL != null) {
            return;
        }
        this.maxValue = Double.parseDouble(this.mods[this.activeMode][1]) / 300.0;
        this.runCount = 0;
        this.pressureTL = new Timeline(new KeyFrame[]{new KeyFrame(Duration.seconds((double)0.7), e -> this.setNIBPprogress(), new KeyValue[0])});
        this.pressureTL.setCycleCount(-1);
        this.pressureTL.playFromStart();
        this.setNewPressureLabels();
        this.clip.setVolume((double)this.volume);
        this.clip.play();
        this.closeNIBP.setDisable(true);
        this.sysPressure = sysPressure;
        this.diaPressure = diaPressure;
        this.changeMode.setDisable(true);
        this.start.setDisable(true);
        this.NIBPOverview.setVisible(false);
    }

    public boolean isNIBPRunning() {
        return this.pressureTL != null;
    }

    public void setMode() {
        Platform.runLater(() -> {
            ++this.activeMode;
            this.activeMode %= 3;
            this.mode.setText(this.mods[this.activeMode][0]);
            this.valueOfMode.setText(this.mods[this.activeMode][1]);
        });
    }

    public void showOverview() {
        this.NIBPOverview.getChildren().clear();
        for (int i = 0; i < 5; ++i) {
            int font = !this.measurement[i][1].equals(LoadFXMLWithResourceBundle.getLangResource().getString("monitor.nibp.value.small")) ? 32 : 24;
            this.addLabelWithNIBP(font, i, 0);
            this.addLabelWithNIBP(font, i, 1);
            this.addLabelWithNIBP(font, i, 2);
        }
    }

    public void showPressure() {
        this.NIBPGridPane.setVisible(true);
    }

    public void hidePressure() {
        Platform.runLater(() -> {
            if (this.pressureTL != null) {
                this.pressureTL.pause();
                this.NIBPprogress.setProgress(0.0);
                this.changeMode.setDisable(false);
                this.start.setDisable(false);
            }
        });
        this.NIBPGridPane.setVisible(false);
    }

    private void setMeasurement() {
        for (int i = 0; i < 5; ++i) {
            this.measurement[i][0] = LoadFXMLWithResourceBundle.getLangResource().getString("monitor.nibp.value.big");
            this.measurement[i][1] = LoadFXMLWithResourceBundle.getLangResource().getString("monitor.nibp.value.small");
            this.measurement[i][2] = "--:--";
        }
    }

    private void setMods() {
        this.mods[0][0] = LoadFXMLWithResourceBundle.getLangResource().getString("monitor.nibp.mode.adult");
        this.mods[0][1] = "180";
        this.mods[1][0] = LoadFXMLWithResourceBundle.getLangResource().getString("monitor.nibp.mode.child");
        this.mods[1][1] = "120";
        this.mods[2][0] = LoadFXMLWithResourceBundle.getLangResource().getString("monitor.nibp.mode.neonat");
        this.mods[2][1] = "90";
    }

    private void setNIBPLabel() {
        int sysP = this.sysPressure;
        int diaP = this.diaPressure;
        String presString = "" + sysP + "/" + diaP;
        this.pressure.setText(presString);
        this.nibpVitalFunction.setDiaAndSysPressure(diaP, sysP);
        int map = (2 * diaP + sysP) / 3;
        String mapString = "(" + map + ")";
        this.pressure2.setText(mapString);
        this.nibpVitalFunction.setMapPressure(map);
        String time = this.getTime();
        this.NIBPtime.setText(LoadFXMLWithResourceBundle.getLangResource().getString("monitor.nibp.value.last") + time);
        this.measurement[this.actualMeasurement][0] = presString;
        this.measurement[this.actualMeasurement][1] = mapString;
        this.measurement[this.actualMeasurement][2] = time;
        ++this.actualMeasurement;
        this.actualMeasurement %= 5;
    }

    private void waitingInMeassure(int runCount) {
        if (runCount % 2 == 0) {
            this.NIBPprogress.setProgress(this.NIBPprogress.getProgress() + 0.02);
        } else {
            this.NIBPprogress.setProgress(this.NIBPprogress.getProgress() - 0.03);
        }
    }

    private String getTime() {
        String time = "";
        int hour = LocalTime.now().getHour();
        time = hour < 10 ? time + "0" + hour + ":" : time + "" + hour + ":";
        int minute = LocalTime.now().getMinute();
        time = minute < 10 ? time + "0" + minute : time + "" + minute;
        return time;
    }

    private void setNewPressureLabels() {
        this.pressure.setText(LoadFXMLWithResourceBundle.getLangResource().getString("monitor.nibp.value.big"));
        this.pressure2.setText(LoadFXMLWithResourceBundle.getLangResource().getString("monitor.nibp.value.small"));
    }

    private void setNIBPprogress() {
        if (!this.NIBPmax) {
            this.NIBPprogress.setProgress(this.NIBPprogress.getProgress() + 0.07);
            if (this.maxValue <= this.NIBPprogress.getProgress()) {
                this.NIBPmax = true;
            }
        } else {
            this.decreasingNIBP();
        }
    }

    private void decreasingNIBP() {
        double value = this.NIBPprogress.getProgress();
        if (value < this.maxValue - 0.1 && this.clip.isPlaying()) {
            this.waitingInMeassure(this.runCount++);
            return;
        }
        if ((value -= 0.08) <= 0.0) {
            this.endOfNIBPMeasurrement();
        } else {
            this.NIBPprogress.setProgress(value);
        }
    }

    private void endOfNIBPMeasurrement() {
        this.NIBPmax = false;
        this.pressureTL.stop();
        this.pressureTL = null;
        this.setNIBPLabel();
        this.NIBPprogress.setProgress(0.0);
        this.changeMode.setDisable(false);
        this.start.setDisable(false);
        this.closeNIBP.setDisable(false);
        this.stopPlayingClip();
        if (this.NIBPOverview.isVisible()) {
            this.showOverview();
        }
    }

    private void addLabelWithNIBP(int font, int i, int j) {
        Label text = new Label(this.measurement[i][j]);
        text.setTextFill((Paint)Color.WHITE);
        text.setFont(new Font((double)font));
        this.NIBPOverview.add((Node)text, j, i);
    }

    public void pauseAnimation() {
        if (this.pressureTL != null) {
            this.pressureTL.pause();
        }
    }

    public void resumeAnimation() {
        if (this.pressureTL != null) {
            this.pressureTL.play();
        }
    }

    public void stopPlayingClip() {
        if (this.clip.isPlaying()) {
            this.clip.stop();
        }
    }

    public void setVolume(int volume) {
        if (volume == 0) {
            this.stopPlayingClip();
        }
        this.volume = volume;
    }

    public boolean getVolumeActive() {
        return this.volume > 0;
    }

    public void clear() {
        if (this.pressureTL != null) {
            this.pressureTL.stop();
        }
        this.pressureTL = null;
        this.stopPlayingClip();
    }
}

