/*
 * Decompiled with CFR 0.152.
 */
package PETER_Monitor.vital_monitor.settings_monitor;

import Language.LoadFXMLWithResourceBundle;
import PETER_Monitor.vital_monitor.settings_monitor.Alerts;
import PETER_Monitor.vital_monitor.settings_monitor.SettingsValues;
import PETER_Monitor.vital_monitor.settings_monitor.WriteSettings;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Locale;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.scene.paint.Color;

public class LoadSettings {
    private static String separator = "=";
    private static int valueIndex = 1;

    public static void loadSettings(int numberOfTry) {
        File file = new File("data/settings/settings.cfg");
        if (!file.exists() && file.isDirectory()) {
            WriteSettings.writeSettings();
        }
        try (BufferedReader br = new BufferedReader(new FileReader(file));){
            LoadSettings.loadLanguage(br);
            LoadSettings.loadBoundaries(br);
            LoadSettings.loadSound(br);
            LoadSettings.loadWarningColor(br);
        }
        catch (Exception e) {
            if (numberOfTry == 0) {
                WriteSettings.writeSettings();
                LoadSettings.loadSettings(1);
            }
            Alerts.warningAlert("Chyba p\u0159i na\u010d\u00edt\u00e1n\u00ed", "Chyba v nastaven\u00ed", "Nebylo mo\u017en\u00e9 na\u010d\u00edst va\u0161e nastaven\u00ed. Aplikace byla spu\u0161t\u011bna v defaultn\u00edm nastaven\u00ed.");
        }
    }

    private static void loadLanguage(BufferedReader br) throws IOException {
        String line = br.readLine();
        String language = line.split(separator)[valueIndex];
        LoadFXMLWithResourceBundle.resourceBundleExists(new Locale(language));
        SettingsValues.locale = language;
    }

    private static void loadBoundaries(BufferedReader br) throws Exception {
        SettingsValues.HRmin = LoadSettings.setUpValuesForVitalBoundaries(br);
        SettingsValues.HRmax = LoadSettings.setUpValuesForVitalBoundaries(br);
        String line = br.readLine();
        SettingsValues.HRcolor = Color.valueOf((String)line.split(separator)[valueIndex]);
        SettingsValues.SPO2min = LoadSettings.setUpValuesForVitalBoundaries(br);
        SettingsValues.SPO2max = LoadSettings.setUpValuesForVitalBoundaries(br);
        line = br.readLine();
        SettingsValues.SPO2color = Color.valueOf((String)line.split(separator)[valueIndex]);
        SettingsValues.PPmin = LoadSettings.setUpValuesForVitalBoundaries(br);
        SettingsValues.PPmax = LoadSettings.setUpValuesForVitalBoundaries(br);
        line = br.readLine();
        SettingsValues.PPcolor = Color.valueOf((String)line.split(separator)[valueIndex]);
        line = br.readLine();
        SettingsValues.NIBPcolor = Color.valueOf((String)line.split(separator)[valueIndex]);
        SettingsValues.ETCO2min = LoadSettings.setUpValuesForVitalBoundaries(br);
        SettingsValues.ETCO2max = LoadSettings.setUpValuesForVitalBoundaries(br);
        line = br.readLine();
        SettingsValues.ETCO2color = Color.valueOf((String)line.split(separator)[valueIndex]);
        SettingsValues.TEMPmin = LoadSettings.setUpValuesForVitalBoundaries(br);
        SettingsValues.TEMPmax = LoadSettings.setUpValuesForVitalBoundaries(br);
        line = br.readLine();
        SettingsValues.TEMPcolor = Color.valueOf((String)line.split(separator)[valueIndex]);
    }

    private static void loadSound(BufferedReader br) throws Exception {
        String line = br.readLine();
        SettingsValues.ALLSounds = Boolean.parseBoolean(line.split(separator)[valueIndex]);
        line = br.readLine();
        SettingsValues.DEFIBRILATORSound = Boolean.parseBoolean(line.split(separator)[valueIndex]);
        line = br.readLine();
        SettingsValues.NIBPSound = Boolean.parseBoolean(line.split(separator)[valueIndex]);
        line = br.readLine();
        SettingsValues.ECGSound = Boolean.parseBoolean(line.split(separator)[valueIndex]);
    }

    private static SimpleIntegerProperty setUpValuesForVitalBoundaries(BufferedReader br) throws Exception {
        String line = br.readLine();
        int number = Integer.parseInt(line.split(separator)[valueIndex]);
        return new SimpleIntegerProperty(number);
    }

    private static void loadWarningColor(BufferedReader br) throws Exception {
        String line = br.readLine();
        SettingsValues.TOPwarning = Color.valueOf((String)line.split(separator)[valueIndex]);
        line = br.readLine();
        SettingsValues.BOTTOMwarning = Color.valueOf((String)line.split(separator)[valueIndex]);
    }
}

