/*
 * Decompiled with CFR 0.152.
 */
package PETER_Remoter.remoter_GUI;

import Language.LoadFXMLWithResourceBundle;
import PETER_Communications.com_protocol.Server;
import PETER_Communications.com_protocol.VitalData;
import PETER_Remoter.remoter_GUI.Alerts;
import PETER_Remoter.remoter_GUI.ECGParser;
import PETER_Remoter.remoter_GUI.Main;
import PETER_Remoter.remoter_GUI.QuerySendData;
import PETER_Remoter.remoter_GUI.settings_remoter.Settings;
import java.math.BigDecimal;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.Slider;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.stage.Stage;
import javafx.util.Callback;
import javafx.util.Duration;

public class Controller
implements Initializable {
    @FXML
    StackPane heartRateStack;
    @FXML
    StackPane ppStack;
    @FXML
    StackPane sysPressureStack;
    @FXML
    StackPane diaPressureStack;
    @FXML
    StackPane respirationRateStack;
    @FXML
    StackPane spo2Stack;
    @FXML
    StackPane co2Stack;
    @FXML
    StackPane temperatureStack;
    @FXML
    TabPane userPanels;
    @FXML
    Label heartRateLabel;
    @FXML
    Label ppLabel;
    @FXML
    Label sysPressureLabel;
    @FXML
    Label diaPressureLabel;
    @FXML
    Label respirationRateLabel;
    @FXML
    Label statusOfConnectionLabel;
    @FXML
    Circle statusOfConnectionCircle;
    @FXML
    Label spo2Label;
    @FXML
    Label co2Label;
    @FXML
    Label time;
    @FXML
    Label temperatureLabel;
    @FXML
    TableView queryTable;
    @FXML
    TableColumn nameOfCurveColumn;
    @FXML
    TableColumn timeOfCurveColumn;
    @FXML
    CheckBox successOfAnalysesChB;
    @FXML
    CheckBox connectECGElectrodsChB;
    @FXML
    CheckBox connectElectrodsForTerapyChB;
    @FXML
    CheckBox successOfDefibrilationChB;
    @FXML
    ComboBox impendaceCB;
    @FXML
    CheckBox hearthRateChB;
    @FXML
    CheckBox PPChB;
    @FXML
    CheckBox systolicPressureChB;
    @FXML
    CheckBox diastolicPressureChB;
    @FXML
    CheckBox respiratoryRateChB;
    @FXML
    CheckBox SPO2ChB;
    @FXML
    CheckBox ETCO2ChB;
    @FXML
    CheckBox temperatureChB;
    @FXML
    ToggleButton minutes;
    @FXML
    ToggleButton seconds;
    @FXML
    Button addToQueryButton;
    @FXML
    Button newTaskButton;
    @FXML
    Button updateQueryButton;
    @FXML
    Button cancelUpdateQueryButton;
    @FXML
    Button reconnectButton;
    @FXML
    Button sendButton;
    @FXML
    GridPane columnWidthGridPane;
    @FXML
    private ListView graphList;
    @FXML
    CheckMenuItem defibrilatorSendImmediately;
    @FXML
    ComboBox curveOfResurection;
    private boolean fibrilation;
    private Slider ppSlider;
    private Slider sysPressureSlider;
    private Slider diaPressureSlider;
    private Slider temperatureSlider;
    private Slider respirationRateSlider;
    private Slider spo2Slider;
    private Slider co2Slider;
    private Slider heartRateSlider;
    private Timeline setTimeAnimation;
    private ObservableList<QuerySendData> data;
    private int selectQueryIndex;
    private String curveName;
    private boolean send;
    private boolean asystolia;
    private int minuteKoeficient;
    private boolean electrodesWasChange;

    public void initialize(URL location, ResourceBundle resources) {
        this.setListOfGraphs();
        this.timerRun();
        this.send = false;
        this.fibrilation = false;
        this.minuteKoeficient = 1;
        this.selectQueryIndex = -1;
        this.data = FXCollections.observableArrayList();
        this.asystolia = false;
        this.settingUpTable();
        this.electrodesWasChange = false;
        this.setSlidersLayout();
        this.settingUpBinding();
        this.cancelUpdateQueryButton.setOnAction(event -> this.cancelUpdateAction());
        this.updateQueryButton.setOnAction(event -> this.saveChangesQuery());
        this.setStatusOfConnection(false);
        this.setToggleButtons();
        this.setDefibrilatorRetrieverData();
        this.graphList.getItems().forEach(o -> {
            if (!o.equals("Asystolie")) {
                this.curveOfResurection.getItems().add(o);
            }
        });
        this.curveOfResurection.getSelectionModel().select(0);
        this.impendaceCB.getItems().setAll((Collection)FXCollections.observableArrayList((Object[])new String[]{LoadFXMLWithResourceBundle.getLangResource().getString("monitor.defibrilator.impedance.low"), LoadFXMLWithResourceBundle.getLangResource().getString("monitor.defibrilator.impedance.medium"), LoadFXMLWithResourceBundle.getLangResource().getString("monitor.defibrilator.impedance.high")}));
        this.impendaceCB.getSelectionModel().select(1);
    }

    public void exitApplication() {
        Platform.exit();
    }

    public void fullscreen() {
        Stage stage = (Stage)this.time.getScene().getWindow();
        stage.setFullScreen(true);
    }

    @FXML
    public void settings() {
        Settings settings = new Settings();
        settings.showSettings(0);
    }

    public String getTemperatureSliderValue() {
        BigDecimal bd = new BigDecimal(this.temperatureSlider.getValue());
        double number = (bd = bd.setScale(1, 4)).doubleValue();
        if (number % 1.0 != 0.0) {
            return "" + number;
        }
        int n = (int)number;
        return "" + n;
    }

    public double getSliderValue(Slider slider, int valueIfFibrilation, int valueIfAsystolia) {
        if (this.fibrilation && valueIfFibrilation != -1) {
            slider.setValue((double)valueIfFibrilation);
            return valueIfFibrilation;
        }
        if (this.asystolia && valueIfAsystolia != -1) {
            return valueIfAsystolia;
        }
        return slider.getValue();
    }

    public int getTime() {
        return Integer.parseInt(this.time.getText());
    }

    public boolean getSuccessOfAnalyses() {
        return this.successOfAnalysesChB.isSelected();
    }

    public boolean getSuccessOfDefibrilation() {
        return this.successOfDefibrilationChB.isSelected();
    }

    public int getImpendace() {
        return this.impendaceCB.getSelectionModel().getSelectedIndex();
    }

    public void setTime(int newTime) {
        if (newTime >= 0) {
            if (newTime > 999) {
                this.time.setText("999");
            } else {
                this.time.setText("" + newTime);
            }
        } else {
            this.time.setText("0");
        }
    }

    private void setListOfGraphs() {
        this.graphList.setItems(FXCollections.observableArrayList((Object[])new String[]{"Sinus rhythm", "Sinus AMI ST elevation", "1 AV block", "2 AV block type 1", "2 AV block type 2", "3 AV block", "Ventricular fibrillation", "Ventricular tachykardia", "Asystolie"}));
        this.graphList.getSelectionModel().select(0);
    }

    private void setBindingOfSliders(Slider slider, Label label) {
        if (slider.equals(this.temperatureSlider)) {
            slider.valueProperty().addListener(observable -> label.textProperty().setValue(String.valueOf(this.getTemperatureSliderValue())));
        } else {
            slider.valueProperty().addListener(observable -> label.textProperty().setValue(String.valueOf((int)slider.getValue())));
        }
    }

    private void setZeroValues() {
        this.diaPressureSlider.setValue(this.diaPressureSlider.getMin());
        this.heartRateSlider.setValue(this.heartRateSlider.getMin());
        this.spo2Slider.setValue(this.spo2Slider.getMin());
        this.co2Slider.setValue(this.co2Slider.getMin());
        this.respirationRateSlider.setValue(this.respirationRateSlider.getMin());
        this.temperatureSlider.setValue(this.temperatureSlider.getMin());
        this.ppSlider.setValue(this.ppSlider.getMin());
        this.sysPressureSlider.setValue(this.sysPressureSlider.getMin());
        this.setTime(0);
    }

    @FXML
    public void resetAllValues() {
        boolean value = true;
        this.setZeroValues();
        this.successOfDefibrilationChB.setSelected(!value);
        this.successOfAnalysesChB.setSelected(!value);
        this.impendaceCB.getSelectionModel().select(1);
        this.connectECGElectrodsChB.setSelected(!value);
        this.connectElectrodsForTerapyChB.setSelected(!value);
        this.PPChB.setSelected(value);
        this.ETCO2ChB.setSelected(value);
        this.SPO2ChB.setSelected(value);
        this.temperatureChB.setSelected(value);
        this.hearthRateChB.setSelected(value);
        this.systolicPressureChB.setSelected(value);
        this.diastolicPressureChB.setSelected(value);
        this.respiratoryRateChB.setSelected(value);
        this.seconds.setSelected(true);
    }

    public void setTimeByOne(MouseEvent e) {
        this.handleSettingTime((Button)e.getSource());
    }

    @FXML
    public void startSetTimeAnimation(MouseEvent event) {
        this.setTimeAnimation = new Timeline(new KeyFrame[]{new KeyFrame(Duration.seconds((double)0.4), e -> {
            Button b = (Button)event.getSource();
            if (event.isPrimaryButtonDown()) {
                this.handleSettingTime(b);
            }
        }, new KeyValue[0])});
        this.setTimeAnimation.setCycleCount(-1);
        this.setTimeAnimation.play();
    }

    private void handleSettingTime(Button button) {
        switch (button.getText()) {
            case "+": {
                this.setTime(this.getTime() + 1 * this.minuteKoeficient);
                break;
            }
            case "-": {
                this.setTime(this.getTime() - 1 * this.minuteKoeficient);
            }
        }
    }

    @FXML
    public void stopSetTimeAnimation() {
        this.setTimeAnimation.stop();
        this.setTimeAnimation = null;
    }

    private void showUpdateItem(boolean show) {
        this.updateQueryButton.setVisible(show);
        this.cancelUpdateQueryButton.setVisible(show);
        this.addToQueryButton.setVisible(!show);
        this.newTaskButton.setVisible(!show);
    }

    @FXML
    protected void handleSendButtonAction() {
        this.send = true;
        if (this.data.isEmpty()) {
            this.addToQueryToSendInFuture();
        }
    }

    public List<float[][]> getGraphData() {
        if (this.graphList.getSelectionModel().getSelectedItems().isEmpty()) {
            this.curveName = null;
            return null;
        }
        this.curveName = this.graphList.getSelectionModel().getSelectedItem().toString();
        return this.retrieveECGData(this.curveName);
    }

    private List<float[][]> retrieveECGData(String curveName) {
        switch (curveName) {
            case "Sinus rhythm": {
                return ECGParser.loadECGData("data/ecg/meta_NormalSinRhythm.csv");
            }
            case "Sinus AMI ST elevation": {
                return ECGParser.loadECGData("data/ecg/meta_STEMI.csv");
            }
            case "1 AV block": {
                return ECGParser.loadECGData("data/ecg/meta_1AVBlock.csv");
            }
            case "2 AV block type 1": {
                return ECGParser.loadECGData("data/ecg/meta_2AVBlockT1.csv");
            }
            case "2 AV block type 2": {
                return ECGParser.loadECGData("data/ecg/meta_2AVBlockT2.csv");
            }
            case "3 AV block": {
                return ECGParser.loadECGData("data/ecg/c_3AVBlock.csv");
            }
            case "Ventricular fibrillation": {
                this.fibrilation = true;
                return ECGParser.loadECGData("data/ecg/meta_fibrilation.csv");
            }
            case "Ventricular tachykardia": {
                return ECGParser.loadECGData("data/ecg/c_VT.csv");
            }
            case "Asystolie": {
                this.asystolia = true;
            }
        }
        return null;
    }

    @FXML
    public void addToQueryToSendInFuture() {
        this.data.add((Object)new QuerySendData(this.getTime(), true, this.prepareData()));
        QuerySendData record = (QuerySendData)this.data.get(this.data.size() - 1);
        if (this.curveName == null) {
            this.data.remove((Object)record);
            Alerts.warningAlert("Nelze p\u0159idat k\u0159ivku", "Vyberte pros\u00edm n\u011bkterou k\u0159ivku ze seznamu k\u0159ivek.", "Nebyla vybr\u00e1na \u017e\u00e1dn\u00e1 k\u0159ivka.");
            return;
        }
        if (record.getQueryVitalData().getEcg() == null && !this.asystolia && !this.fibrilation) {
            this.data.remove((Object)record);
            Alerts.warningAlert("Nelze na\u010d\u00edst k\u0159ivku", "Vyberte pros\u00edm jinou k\u0159ivku ze seznamu k\u0159ivek.", "Nebylo mo\u017en\u00e9 nal\u00e9zt danou k\u0159ivku na va\u0161em PC.");
            return;
        }
        this.asystolia = false;
        this.fibrilation = false;
        record.setNameOfCurve(this.curveName);
        this.queryTable.getItems().clear();
        this.queryTable.getItems().addAll(this.data);
        this.userPanels.getSelectionModel().select(2);
        this.setTime(0);
        this.curveName = null;
    }

    @FXML
    public void deleteFromQuery() {
        int indexSelect = this.queryTable.getSelectionModel().getSelectedIndex();
        if (indexSelect == -1) {
            return;
        }
        VitalData queryData = ((QuerySendData)this.data.get(indexSelect)).getQueryVitalData();
        if (queryData == null) {
            this.data.remove(indexSelect);
            this.queryTable.getItems().clear();
            this.queryTable.getItems().addAll(this.data);
        } else {
            this.data.remove(indexSelect);
            this.queryTable.getItems().clear();
            this.queryTable.getItems().addAll(this.data);
            this.setZeroValues();
            this.showUpdateItem(false);
        }
    }

    @FXML
    private void loadValuesFromQuery() {
        this.selectQueryIndex = this.queryTable.getSelectionModel().getSelectedIndex();
        if (this.selectQueryIndex == -1) {
            return;
        }
        VitalData queryData = ((QuerySendData)this.data.get(this.selectQueryIndex)).getQueryVitalData();
        if (queryData != null) {
            for (int i = 0; i < this.graphList.getItems().size(); ++i) {
                if (!this.graphList.getItems().get(i).equals(((QuerySendData)this.data.get(this.selectQueryIndex)).getNameOfCurve())) continue;
                this.graphList.getSelectionModel().select(i);
                break;
            }
            this.diaPressureSlider.setValue((double)queryData.getDiaPressure());
            this.heartRateSlider.setValue((double)queryData.getHeartRate());
            this.spo2Slider.setValue((double)queryData.getSpO2());
            this.co2Slider.setValue((double)queryData.getCO2());
            this.respirationRateSlider.setValue((double)queryData.getRespirationRate());
            this.temperatureSlider.setValue(Double.parseDouble(queryData.getTemperature()));
            this.ppSlider.setValue((double)queryData.getPP());
            this.sysPressureSlider.setValue((double)queryData.getSysPressure());
            this.setTime(queryData.getTime());
            this.successOfAnalysesChB.setSelected(queryData.getSuccessOfAnalyse());
            this.successOfDefibrilationChB.setSelected(queryData.getSuccessOfDefibrilation());
            this.impendaceCB.getSelectionModel().select(queryData.getImpedance());
            this.showUpdateItem(true);
        } else {
            this.showUpdateItem(false);
            this.setZeroValues();
        }
    }

    private void saveChangesQuery() {
        int selectItem = this.queryTable.getSelectionModel().getSelectedIndex();
        if (selectItem != -1) {
            ((QuerySendData)this.data.get(selectItem)).setQueryVitalData(this.prepareData());
            ((QuerySendData)this.data.get(selectItem)).setNameOfCurve(this.curveName);
            ((QuerySendData)this.data.get(selectItem)).setTime(this.getTime());
            this.queryTable.refresh();
            this.queryTable.getSelectionModel().clearSelection();
            this.setZeroValues();
            this.showUpdateItem(false);
            this.selectQueryIndex = -1;
            this.curveName = null;
            this.userPanels.getSelectionModel().select(2);
        }
    }

    @FXML
    public void stopSendingData() {
        this.data.add((Object)new QuerySendData(0, false, null));
        ((QuerySendData)this.data.get(this.data.size() - 1)).setNameOfCurve("STOP");
        this.queryTable.getItems().clear();
        this.queryTable.getItems().addAll(this.data);
        this.setZeroValues();
    }

    private void timerRun() {
        Timeline t1 = new Timeline(new KeyFrame[]{new KeyFrame(Duration.seconds((double)1.0), e -> this.sendDataPrepare(), new KeyValue[0])});
        t1.setCycleCount(-1);
        t1.play();
    }

    @FXML
    public void reconnect() {
        this.send = true;
        if (this.data.isEmpty()) {
            this.curveName = "Sinus rhythm";
            int tab = this.userPanels.getSelectionModel().getSelectedIndex();
            this.addToQueryToSendInFuture();
            this.userPanels.getSelectionModel().select(tab);
        }
    }

    private void sendDataPrepare() {
        if (!this.data.isEmpty() && !((QuerySendData)this.data.get(0)).getSend()) {
            this.send = false;
            this.queryTable.getItems().remove(0);
            this.data.remove(0);
            return;
        }
        if (this.data.isEmpty() || !this.send) {
            this.send = false;
            return;
        }
        ((QuerySendData)this.data.get(0)).setTime(((QuerySendData)this.data.get(0)).getTime() - 1);
        this.queryTable.refresh();
        if (((QuerySendData)this.data.get(0)).getTime() < 1) {
            this.sendData();
        }
    }

    private void sendData() {
        Server server = Main.getServer();
        if (server.sendData(((QuerySendData)this.data.get(0)).getQueryVitalData()) == false) {
            server.exitServer();
            this.setStatusOfConnection(false);
            Main.startServerAgain();
        } else {
            this.setStatusOfConnection(true);
        }
        if (this.selectQueryIndex == 0) {
            this.showUpdateItem(false);
            this.setZeroValues();
        }
        --this.selectQueryIndex;
        if (!this.data.isEmpty()) {
            this.data.remove(0);
            this.queryTable.getItems().remove(0);
        }
    }

    public VitalData prepareData() {
        List<float[][]> resurectionECGCurve = null;
        List<float[][]> ecg = this.getGraphData();
        int hr = this.retriveDataByCheckBox(this.hearthRateChB, this.getSliderValue(this.heartRateSlider, 120, 0));
        int pp = this.retriveDataByCheckBox(this.PPChB, this.getSliderValue(this.ppSlider, 0, 0));
        int sp = this.retriveDataByCheckBox(this.systolicPressureChB, this.getSliderValue(this.sysPressureSlider, -1, 0));
        int dp = this.retriveDataByCheckBox(this.diastolicPressureChB, this.getSliderValue(this.diaPressureSlider, -1, 0));
        String tp = this.retriveTemperatureData(this.temperatureChB, this.getTemperatureSliderValue());
        int rr = this.retriveDataByCheckBox(this.respiratoryRateChB, this.getSliderValue(this.respirationRateSlider, -1, 0));
        int spo = this.retriveDataByCheckBox(this.SPO2ChB, this.getSliderValue(this.spo2Slider, 0, 0));
        int co2 = this.retriveDataByCheckBox(this.ETCO2ChB, this.getSliderValue(this.co2Slider, -1, 0));
        boolean successOfAnalyse = this.getSuccessOfAnalyses();
        boolean successOfDefibrilation = this.getSuccessOfDefibrilation();
        int impedance = this.getImpendace();
        boolean connectECG = this.connectECGElectrodsChB.isSelected();
        boolean connectTerapy = this.connectElectrodsForTerapyChB.isSelected();
        if (successOfDefibrilation) {
            resurectionECGCurve = this.retrieveECGData(this.curveOfResurection.getSelectionModel().getSelectedItem().toString());
        }
        VitalData data = new VitalData(hr, spo, pp, sp, dp, rr, tp, co2, ecg, this.getTime(), successOfAnalyse, successOfDefibrilation, impedance, this.asystolia, connectECG, connectTerapy, resurectionECGCurve, this.fibrilation, this.electrodesWasChange);
        return data;
    }

    private int retriveDataByCheckBox(CheckBox box, double sliderValue) {
        if (box.isSelected()) {
            return (int)sliderValue;
        }
        return -1;
    }

    private String retriveTemperatureData(CheckBox box, String sliderValue) {
        if (box.isSelected()) {
            return sliderValue;
        }
        return "-1";
    }

    private void setStatusOfConnection(boolean connection) {
        if (connection) {
            this.statusOfConnectionCircle.setFill((Paint)Color.GREEN);
            this.statusOfConnectionLabel.setText("Za\u0159\u00edzen\u00ed monitoru p\u0159ipojeno");
            this.statusOfConnectionLabel.setTextFill((Paint)Color.GREEN);
            this.reconnectButton.setVisible(false);
            this.sendButton.setDisable(false);
        } else {
            this.statusOfConnectionCircle.setFill((Paint)Color.RED);
            this.statusOfConnectionLabel.setText("Za\u0159\u00edzeni monitoru nep\u0159ipojeno");
            this.statusOfConnectionLabel.setTextFill((Paint)Color.RED);
            this.reconnectButton.setVisible(true);
            this.sendButton.setDisable(true);
        }
    }

    private void cancelUpdateAction() {
        this.queryTable.getSelectionModel().clearSelection();
        this.setZeroValues();
        this.showUpdateItem(false);
        this.selectQueryIndex = -1;
    }

    private void settingUpTable() {
        this.queryTable.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        this.nameOfCurveColumn.prefWidthProperty().bind((ObservableValue)this.queryTable.widthProperty().multiply(0.8));
        this.timeOfCurveColumn.prefWidthProperty().bind((ObservableValue)this.queryTable.widthProperty().multiply(0.2));
        this.queryTable.setOnMouseClicked(event1 -> this.loadValuesFromQuery());
        this.nameOfCurveColumn.setCellValueFactory((Callback)new PropertyValueFactory("nameOfCurve"));
        this.timeOfCurveColumn.setCellValueFactory((Callback)new PropertyValueFactory("time"));
    }

    private ProgressBar getProgressBar(Slider slider, StackPane stackPane) {
        ProgressBar bar = new ProgressBar(0.0);
        bar.setRotate(270.0);
        bar.minWidthProperty().bind((ObservableValue)stackPane.heightProperty());
        bar.maxWidthProperty().bind((ObservableValue)stackPane.heightProperty());
        bar.setPadding(new Insets(0.0, 35.0, 0.0, 35.0));
        if (slider.equals(this.temperatureSlider)) {
            bar.progressProperty().bind((ObservableValue)slider.valueProperty().subtract(15).divide(slider.getMax() - slider.getMin()));
        } else {
            bar.progressProperty().bind((ObservableValue)slider.valueProperty().divide(slider.getMax()));
        }
        return bar;
    }

    private Slider getSlider(double min, double max, double value, StackPane stackPane) {
        Slider slider = new Slider(min, max, value);
        slider.setRotate(270.0);
        slider.minWidthProperty().bind((ObservableValue)stackPane.heightProperty());
        slider.maxWidthProperty().bind((ObservableValue)stackPane.heightProperty());
        slider.setPadding(new Insets(0.0, 15.0, 0.0, 15.0));
        return slider;
    }

    private void setStack(Slider slider, StackPane stackPane) {
        stackPane.getChildren().addAll((Object[])new Node[]{this.getProgressBar(slider, stackPane)});
        stackPane.getChildren().addAll((Object[])new Node[]{slider});
        stackPane.maxWidthProperty().bind((ObservableValue)this.columnWidthGridPane.widthProperty());
        stackPane.minWidthProperty().bind((ObservableValue)this.columnWidthGridPane.widthProperty());
    }

    private void setSlidersLayout() {
        this.heartRateSlider = this.getSlider(1.0, 300.0, 1.0, this.heartRateStack);
        this.setStack(this.heartRateSlider, this.heartRateStack);
        this.ppSlider = this.getSlider(1.0, 300.0, 1.0, this.ppStack);
        this.setStack(this.ppSlider, this.ppStack);
        this.sysPressureSlider = this.getSlider(1.0, 300.0, 1.0, this.sysPressureStack);
        this.setStack(this.sysPressureSlider, this.sysPressureStack);
        this.diaPressureSlider = this.getSlider(1.0, 300.0, 1.0, this.diaPressureStack);
        this.setStack(this.diaPressureSlider, this.diaPressureStack);
        this.respirationRateSlider = this.getSlider(1.0, 45.0, 1.0, this.respirationRateStack);
        this.setStack(this.respirationRateSlider, this.respirationRateStack);
        this.spo2Slider = this.getSlider(1.0, 100.0, 1.0, this.spo2Stack);
        this.setStack(this.spo2Slider, this.spo2Stack);
        this.co2Slider = this.getSlider(1.0, 60.0, 1.0, this.co2Stack);
        this.setStack(this.co2Slider, this.co2Stack);
        this.temperatureSlider = this.getSlider(15.0, 45.0, 15.0, this.temperatureStack);
        this.setStack(this.temperatureSlider, this.temperatureStack);
    }

    private void settingUpBinding() {
        this.setBindingOfSliders(this.heartRateSlider, this.heartRateLabel);
        this.setBindingOfSliders(this.ppSlider, this.ppLabel);
        this.setBindingOfSliders(this.co2Slider, this.co2Label);
        this.setBindingOfSliders(this.sysPressureSlider, this.sysPressureLabel);
        this.setBindingOfSliders(this.diaPressureSlider, this.diaPressureLabel);
        this.setBindingOfSliders(this.temperatureSlider, this.temperatureLabel);
        this.setBindingOfSliders(this.spo2Slider, this.spo2Label);
        this.setBindingOfSliders(this.respirationRateSlider, this.respirationRateLabel);
    }

    private void setToggleButtons() {
        ToggleGroup toggleGroup = new ToggleGroup();
        this.minutes.setToggleGroup(toggleGroup);
        this.seconds.setToggleGroup(toggleGroup);
        this.seconds.toFront();
        toggleGroup.selectedToggleProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue == null) {
                oldValue.setSelected(true);
            }
            ToggleButton chosenButton = (ToggleButton)toggleGroup.getSelectedToggle();
            chosenButton.toFront();
            this.minuteKoeficient = chosenButton.equals(this.minutes) ? 60 : 1;
        });
    }

    private void setDefibrilatorRetrieverData() {
        this.connectECGElectrodsChB.setOnAction(event -> {
            if (this.connectECGElectrodsChB.isSelected()) {
                this.connectElectrodsForTerapyChB.setDisable(false);
            } else {
                this.connectElectrodsForTerapyChB.setDisable(true);
                this.connectElectrodsForTerapyChB.setSelected(false);
            }
            this.electrodesWasChange = true;
            this.sendDefibrilatorDataNow();
        });
        this.connectElectrodsForTerapyChB.setOnAction(event -> {
            this.electrodesWasChange = true;
            this.sendDefibrilatorDataNow();
        });
        this.impendaceCB.setOnAction(event -> this.sendDefibrilatorDataNow());
        this.successOfAnalysesChB.setOnAction(event -> this.sendDefibrilatorDataNow());
        this.successOfDefibrilationChB.setOnAction(event -> {
            this.sendDefibrilatorDataNow();
            if (!this.successOfDefibrilationChB.isSelected()) {
                this.curveOfResurection.setDisable(true);
            } else {
                this.curveOfResurection.setDisable(false);
            }
        });
        this.curveOfResurection.setOnAction(event -> this.sendDefibrilatorDataNow());
    }

    private void sendDefibrilatorDataNow() {
        if (this.defibrilatorSendImmediately.isSelected()) {
            this.send = true;
            this.addToQueryToSendInFuture();
            this.userPanels.getSelectionModel().select(1);
            this.electrodesWasChange = false;
        }
    }
}

