/*
 * Decompiled with CFR 0.152.
 */
package PETER_Remoter.remoter_GUI;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ECGParser {
    public static final String FILES_ECG_PATH = "data/ecg/";
    public static final String FILES_ECG_EXT = ".csv";
    public static final String NORMAL_SIN = "data/ecg/meta_NormalSinRhythm.csv";
    public static final String STEMI = "data/ecg/meta_STEMI.csv";
    public static final String AV_BLOCK_1 = "data/ecg/meta_1AVBlock.csv";
    public static final String AV_BLOCK_2_TYPE1 = "data/ecg/meta_2AVBlockT1.csv";
    public static final String AV_BLOCK_2_TYPE2 = "data/ecg/meta_2AVBlockT2.csv";
    public static final String AV_BLOCK_3 = "data/ecg/c_3AVBlock.csv";
    public static final String VF = "data/ecg/meta_fibrilation.csv";
    public static final String VT = "data/ecg/c_VT.csv";

    private ECGParser() {
    }

    public static List<float[][]> loadECGData(String string) {
        ArrayList<float[][]> arrayList = new ArrayList<float[][]>();
        File file = new File(string);
        if (!file.exists() || file.isDirectory()) {
            return null;
        }
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(string));){
            String string2;
            while ((string2 = bufferedReader.readLine()) != null) {
                String[] stringArray = string2.split(",");
                int n = Integer.valueOf(stringArray[0]);
                String string3 = stringArray[1];
                arrayList.add(ECGParser.loadECGCurve(n, string3));
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(ECGParser.class.getName()).log(Level.SEVERE, null, iOException);
            arrayList = null;
        }
        return arrayList;
    }

    private static float[][] loadECGCurve(int n, String string) throws IOException {
        String string2;
        System.out.println("Loading data from " + string);
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        float[][] fArray = new float[n - 2][3];
        int n2 = 0;
        bufferedReader.readLine();
        bufferedReader.readLine();
        while ((string2 = bufferedReader.readLine()) != null) {
            String[] stringArray = string2.split(",");
            fArray[n2][0] = Float.valueOf(stringArray[0]).floatValue();
            fArray[n2][1] = Float.valueOf(stringArray[1]).floatValue();
            fArray[n2][2] = Float.valueOf(stringArray[2]).floatValue();
            ++n2;
        }
        bufferedReader.close();
        return fArray;
    }
}

