/*
 * Decompiled with CFR 0.152.
 */
package PETER_Communications.com_protocol;

import PETER_Communications.com_protocol.VitalData;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Client
extends Thread {
    private boolean serverClosed = false;
    private boolean clientClosed = false;
    private Socket clientSocket;
    private int usingPort = 55560;
    private VitalData data;

    public Client() {
        System.out.println("Client start");
    }

    @Override
    public void run() {
        try {
            String string = null;
            while (string == null) {
                if (!this.clientClosed) {
                    this.usingPort = 55555;
                    string = this.getServerIp(this.sendSocketToBroadcasts());
                    continue;
                }
                return;
            }
            this.serverClosed = false;
            this.clientConnection(string);
            DataOutputStream dataOutputStream = null;
            DataInputStream dataInputStream = null;
            ObjectInputStream objectInputStream = null;
            while (!this.serverClosed) {
                String string2;
                dataInputStream = new DataInputStream(this.clientSocket.getInputStream());
                try {
                    string2 = dataInputStream.readUTF();
                }
                catch (SocketException socketException) {
                    return;
                }
                catch (EOFException eOFException) {
                    this.serverClosed = true;
                    return;
                }
                switch (string2) {
                    case "CLIENT_TEST": {
                        dataOutputStream = new DataOutputStream(this.clientSocket.getOutputStream());
                        dataOutputStream.writeUTF("CLIENT_OK");
                        break;
                    }
                    case "DATA": {
                        System.out.println("Data");
                        dataOutputStream = new DataOutputStream(this.clientSocket.getOutputStream());
                        dataOutputStream.writeUTF("CLIENT_READY");
                        objectInputStream = new ObjectInputStream(this.clientSocket.getInputStream());
                        this.data = this.readData(objectInputStream);
                        break;
                    }
                    case "SERVER_CLOSE": {
                        this.serverClosed = true;
                    }
                }
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(Client.class.getName()).log(Level.SEVERE, null, iOException);
        }
    }

    public VitalData waitForData() {
        VitalData vitalData = null;
        while (this.data == null) {
            try {
                if (this.serverClosed || this.clientClosed) {
                    return null;
                }
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                Logger.getLogger(Client.class.getName()).log(Level.SEVERE, null, interruptedException);
            }
        }
        vitalData = this.data;
        this.data = null;
        System.out.println("Recieved data");
        return vitalData;
    }

    private boolean clientConnection(String string) {
        try {
            InetSocketAddress inetSocketAddress = new InetSocketAddress(string, this.usingPort);
            this.clientSocket = new Socket();
            this.clientSocket.connect(inetSocketAddress);
            return true;
        }
        catch (IOException iOException) {
            if (this.clientSocket != null) {
                try {
                    this.clientSocket.close();
                }
                catch (IOException iOException2) {
                    iOException2.printStackTrace();
                }
            }
            return false;
        }
    }

    private VitalData readData(ObjectInputStream objectInputStream) throws SocketException, IOException {
        VitalData vitalData = null;
        try {
            vitalData = (VitalData)objectInputStream.readObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        return vitalData;
    }

    private String getServerIp(DatagramSocket datagramSocket) {
        try {
            byte[] byArray = new byte[1024];
            DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
            datagramSocket.setSoTimeout(3000);
            try {
                datagramSocket.receive(datagramPacket);
            }
            catch (SocketTimeoutException socketTimeoutException) {
                return null;
            }
            this.usingPort = datagramPacket.getPort();
            System.out.println("Client was connected with server: " + datagramPacket.getAddress().getHostAddress());
            System.out.println("Using port: " + this.usingPort);
            return datagramPacket.getAddress().getHostAddress();
        }
        catch (SocketException socketException) {
            socketException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return null;
    }

    private DatagramSocket sendSocketToBroadcasts() {
        DatagramSocket datagramSocket = null;
        try {
            datagramSocket = new DatagramSocket();
            while (this.usingPort < 55560) {
                Object object;
                datagramSocket.setBroadcast(true);
                byte[] byArray = "CONNECTION_VERIFICATION".getBytes();
                try {
                    object = new DatagramPacket(byArray, byArray.length, InetAddress.getByName("255.255.255.255"), this.usingPort);
                    datagramSocket.send((DatagramPacket)object);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                object = NetworkInterface.getNetworkInterfaces();
                while (object.hasMoreElements()) {
                    NetworkInterface networkInterface = object.nextElement();
                    if (networkInterface.isLoopback() || !networkInterface.isUp()) continue;
                    InetAddress inetAddress = null;
                    for (InterfaceAddress interfaceAddress : networkInterface.getInterfaceAddresses()) {
                        inetAddress = interfaceAddress.getBroadcast();
                        if (inetAddress != null) continue;
                    }
                    try {
                        DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, inetAddress, this.usingPort);
                        datagramSocket.send(datagramPacket);
                    }
                    catch (Exception exception) {}
                }
                ++this.usingPort;
            }
        }
        catch (SocketException socketException) {
            socketException.printStackTrace();
        }
        return datagramSocket;
    }

    public void closeClient() {
        this.clientClosed = true;
        if (this.clientSocket != null) {
            try {
                this.clientSocket.close();
            }
            catch (IOException iOException) {
                Logger.getLogger(Client.class.getName()).log(Level.SEVERE, null, iOException);
            }
        }
        System.out.println("Client exit");
    }

    public boolean isClientClosed() {
        return this.clientClosed;
    }

    public boolean isServerClosed() {
        return this.serverClosed;
    }

    public void setClientClosed(boolean bl) {
        this.clientClosed = bl;
    }

    public Socket getClientSocket() {
        return this.clientSocket;
    }

    public void setClientSocket(Socket socket) {
        this.clientSocket = socket;
    }
}

