/*
 * Decompiled with CFR 0.152.
 */
package PETER_Monitor.vital_ecg;

import PETER_Monitor.vital_ecg.CO2Chart;
import PETER_Monitor.vital_ecg.ECGAnimation;
import PETER_Monitor.vital_ecg.ECGCalculation;
import PETER_Monitor.vital_ecg.ECGLineChart;
import PETER_Monitor.vital_ecg.ECGPoint;
import PETER_Monitor.vital_ecg.IChart;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.chart.Axis;
import javafx.scene.chart.NumberAxis;

public class ECGData {
    private final ObservableList<IChart> allECGCharts;
    private final Axis xAxisECG = new NumberAxis(0.0, 5.0, 1.0);
    private final Axis yAxisECG = new NumberAxis(-0.5, 1.0, 1.0);
    private final Axis xAxisECG2 = new NumberAxis(0.0, 5.0, 1.0);
    private final Axis yAxisECG2 = new NumberAxis(-1.0, 0.5, 1.0);
    private final NumberAxis xAxisCO2 = new NumberAxis(0.0, 5.0, 1.0);
    private final NumberAxis yAxisCO2 = new NumberAxis(0.0, 60.0, 30.0);
    private final ECGLineChart graphECG1;
    private final CO2Chart graphCO2;
    private final ScheduledExecutorService executor;
    private final Queue<ECGPoint> timeQueue;
    private final ECGAnimation animation;
    private final ECGCalculation calculation;
    private int countPoints;

    public ECGData() {
        this.allECGCharts = FXCollections.observableArrayList();
        this.executor = Executors.newScheduledThreadPool(2);
        this.timeQueue = new ConcurrentLinkedQueue<ECGPoint>();
        this.graphECG1 = this.setECGGraph();
        this.graphCO2 = this.setCO2Graph();
        this.animation = new ECGAnimation(this.executor, this);
        this.calculation = new ECGCalculation(this.executor, this);
        this.calculation.setNewCalculation();
    }

    public int getCountPoints() {
        return this.countPoints;
    }

    public synchronized void incPoint() {
        ++this.countPoints;
    }

    public synchronized void decPoint() {
        --this.countPoints;
    }

    public void sendCurve(ObservableList<ObservableList<ECGPoint>> observableList) {
        if (observableList == null) {
            return;
        }
        this.calculation.setECGData(observableList);
        this.graphECG1.setTypeCurve(false);
    }

    public void setHR(int n) {
        if (n > 0) {
            this.calculation.setHR(n);
        }
    }

    public void sendData(ECGPoint eCGPoint) {
        this.timeQueue.add(eCGPoint);
    }

    public ECGPoint removePoint() {
        return this.timeQueue.remove();
    }

    public boolean isListEmpty() {
        return this.timeQueue.isEmpty();
    }

    public void notConnected() {
        if (this.calculation != null) {
            this.calculation.notConnected();
        }
        this.graphECG1.setTypeCurve(true);
    }

    public void plotAsystolie() {
        this.notConnected();
        this.graphECG1.setTypeCurve(false);
    }

    public void changeWait(double d) {
        if (this.animation != null && this.calculation != null) {
            this.animation.getAnimation().cancel(true);
            this.calculation.getCalculation().cancel(true);
        }
        this.calculation.setNewCalculation();
        this.animation.setNewAnimation(d);
    }

    public void setWait(double d) {
        this.animation.setNewAnimation(d);
    }

    private CO2Chart setCO2Graph() {
        System.out.println("Creating new chart: ");
        CO2Chart cO2Chart = new CO2Chart(this.xAxisCO2, this.yAxisCO2);
        this.allECGCharts.add((Object)cO2Chart);
        System.out.println("Chart - CO2 was created.");
        return cO2Chart;
    }

    public ECGLineChart setECGGraph() {
        System.out.println("Creating new chart: ");
        ECGLineChart eCGLineChart = new ECGLineChart((Axis<Object>)this.xAxisECG, (Axis<Object>)this.yAxisECG);
        eCGLineChart.setCreateSymbols(false);
        eCGLineChart.setLegendVisible(false);
        this.allECGCharts.add((Object)eCGLineChart);
        System.out.println("Chart - ECG1 was created.");
        return eCGLineChart;
    }

    public ECGLineChart setECG2Graph() {
        System.out.println("Creating new chart: ");
        ECGLineChart eCGLineChart = new ECGLineChart((Axis<Object>)this.xAxisECG2, (Axis<Object>)this.yAxisECG2);
        eCGLineChart.setCreateSymbols(false);
        eCGLineChart.setLegendVisible(false);
        this.allECGCharts.add((Object)eCGLineChart);
        System.out.println("Chart - ECG2 was created.");
        return eCGLineChart;
    }

    public ObservableList<IChart> getAllECGCharts() {
        return this.allECGCharts;
    }

    public ECGLineChart getGraphECG1() {
        return this.graphECG1;
    }

    public ECGLineChart getGraphECG2() {
        return null;
    }

    public CO2Chart getGraphCO2() {
        return this.graphCO2;
    }

    public void clear() {
        this.executor.shutdownNow();
    }

    public void setBeep(boolean bl) {
        this.animation.setBeep(bl);
    }
}

