/*
 * Decompiled with CFR 0.152.
 */
package PETER_Monitor.vital_monitor.settings_monitor;

import Language.LoadFXMLWithResourceBundle;
import PETER_Monitor.vital_monitor.settings_monitor.SettingsValues;
import PETER_Monitor.vital_monitor.settings_monitor.WriteSettings;
import PETER_Remoter.remoter_GUI.Alerts;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Locale;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.scene.paint.Color;

public class LoadSettings {
    private static String separator = "=";
    private static int valueIndex = 1;

    public static void loadSettings(int n) {
        File file = new File("data/settings/settings.cfg");
        if (!file.exists() && file.isDirectory()) {
            WriteSettings.writeSettings();
        }
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(file));){
            LoadSettings.loadLanguage(bufferedReader);
            LoadSettings.loadBoundaries(bufferedReader);
            LoadSettings.loadSound(bufferedReader);
            LoadSettings.loadWarningColor(bufferedReader);
        }
        catch (Exception exception) {
            if (n == 0) {
                WriteSettings.writeSettings();
                LoadSettings.loadSettings(1);
            }
            Alerts.warningAlert("Chyba p\u0159i na\u010d\u00edt\u00e1n\u00ed", "Chyba v nastaven\u00ed", "Nebylo mo\u017en\u00e9 na\u010d\u00edst va\u0161e nastaven\u00ed. Aplikace byla spu\u0161t\u011bna v defaultn\u00edm nastaven\u00ed.");
        }
    }

    private static void loadLanguage(BufferedReader bufferedReader) throws IOException {
        String string = bufferedReader.readLine();
        String string2 = string.split(separator)[valueIndex];
        LoadFXMLWithResourceBundle.resourceBundleExists(new Locale(string2));
        SettingsValues.locale = string2;
    }

    private static void loadBoundaries(BufferedReader bufferedReader) throws Exception {
        SettingsValues.HRmin = LoadSettings.setUpValuesForVitalBoundaries(bufferedReader);
        SettingsValues.HRmax = LoadSettings.setUpValuesForVitalBoundaries(bufferedReader);
        String string = bufferedReader.readLine();
        SettingsValues.HRcolor = Color.valueOf((String)string.split(separator)[valueIndex]);
        SettingsValues.SPO2min = LoadSettings.setUpValuesForVitalBoundaries(bufferedReader);
        SettingsValues.SPO2max = LoadSettings.setUpValuesForVitalBoundaries(bufferedReader);
        string = bufferedReader.readLine();
        SettingsValues.SPO2color = Color.valueOf((String)string.split(separator)[valueIndex]);
        SettingsValues.PPmin = LoadSettings.setUpValuesForVitalBoundaries(bufferedReader);
        SettingsValues.PPmax = LoadSettings.setUpValuesForVitalBoundaries(bufferedReader);
        string = bufferedReader.readLine();
        SettingsValues.PPcolor = Color.valueOf((String)string.split(separator)[valueIndex]);
        string = bufferedReader.readLine();
        SettingsValues.NIBPcolor = Color.valueOf((String)string.split(separator)[valueIndex]);
        SettingsValues.ETCO2min = LoadSettings.setUpValuesForVitalBoundaries(bufferedReader);
        SettingsValues.ETCO2max = LoadSettings.setUpValuesForVitalBoundaries(bufferedReader);
        string = bufferedReader.readLine();
        SettingsValues.ETCO2color = Color.valueOf((String)string.split(separator)[valueIndex]);
        SettingsValues.TEMPmin = LoadSettings.setUpValuesForVitalBoundaries(bufferedReader);
        SettingsValues.TEMPmax = LoadSettings.setUpValuesForVitalBoundaries(bufferedReader);
        string = bufferedReader.readLine();
        SettingsValues.TEMPcolor = Color.valueOf((String)string.split(separator)[valueIndex]);
    }

    private static void loadSound(BufferedReader bufferedReader) throws Exception {
        String string = bufferedReader.readLine();
        SettingsValues.ALLSounds = Boolean.parseBoolean(string.split(separator)[valueIndex]);
        string = bufferedReader.readLine();
        SettingsValues.DEFIBRILATORSound = Boolean.parseBoolean(string.split(separator)[valueIndex]);
        string = bufferedReader.readLine();
        SettingsValues.NIBPSound = Boolean.parseBoolean(string.split(separator)[valueIndex]);
        string = bufferedReader.readLine();
        SettingsValues.ECGSound = Boolean.parseBoolean(string.split(separator)[valueIndex]);
    }

    private static SimpleIntegerProperty setUpValuesForVitalBoundaries(BufferedReader bufferedReader) throws Exception {
        String string = bufferedReader.readLine();
        int n = Integer.parseInt(string.split(separator)[valueIndex]);
        return new SimpleIntegerProperty(n);
    }

    private static void loadWarningColor(BufferedReader bufferedReader) throws Exception {
        String string = bufferedReader.readLine();
        SettingsValues.TOPwarning = Color.valueOf((String)string.split(separator)[valueIndex]);
        string = bufferedReader.readLine();
        SettingsValues.BOTTOMwarning = Color.valueOf((String)string.split(separator)[valueIndex]);
    }
}

