#This dataset was formatted by R. Olszewski as part of his thesis
#“Generalized feature extraction for structural	pattern recognition
#in time-series data,” at Carnegie Mellon University, 2001. Each
#series traces the electrical activity recorded during one
#heartbeat. The two classes are a normal heartbeat and a Myocardial
#Infarction. 	
@problemName ECG200
@timeStamps false
@missing false
@univariate true
@equalLength true
@seriesLength 96
@classLabel true -1 1
@data
0.42518938,1.4185988,2.6687913,3.298629,2.2645539,0.16517949,-0.95972652,0.28266835,0.84285041,0.68345828,1.0820879,0.72257693,0.10981136,-0.69660907,-0.66226782,-0.83998475,-0.9352974,-0.89536172,-0.924266,-1.0881774,-1.1135846,-1.1306807,-1.2018949,-1.5395089,-1.5352271,-1.4684167,-2.0780119,-1.8565474,-1.9828685,-2.0412115,-1.7938604,-1.986162,-1.9469026,-1.7065927,-1.3251418,-1.1470663,-0.86362855,-0.3560151,-0.20488964,0.18301001,0.51804502,0.61929087,0.8226008,0.97677914,0.84313124,1.1858633,1.1736722,0.82464362,0.88404066,0.77681046,0.87503343,0.79528912,0.5541665,0.67989868,0.61355127,0.62308979,0.46371175,0.58587802,0.62258644,0.31403255,0.42167617,0.63939179,0.47075583,0.2999824,0.24744652,0.31995727,0.29976787,0.20092536,0.15236844,0.069306841,0.29062635,0.096216962,0.37971509,0.79163123,0.60666163,0.80154377,0.69631286,0.20438861,0.20512207,-0.045158702,-0.18401683,0.11577475,-0.098131601,-0.17835982,-0.10711954,-0.19349136,-0.01819567,-0.22049304,-0.15255651,-0.11701065,-0.14515959,-0.11666838,-0.19926184,-0.10983685,-0.14248753,0.098758141:1
0.65392929,2.1772899,3.6447828,2.2792033,0.97836744,-0.38829581,-0.91191107,-0.1483295,0.30543881,-0.23009793,-0.45153026,0.22411262,-0.5500537,-0.93397675,-0.84162867,-0.76372666,-1.3909766,-0.6689088,-1.1802675,-1.3660292,-1.0036442,-1.4862011,-1.423197,-1.4979271,-1.5305333,-1.8142696,-1.96406,-1.9561028,-1.9342636,-1.9209254,-1.9846345,-1.7969277,-1.7170511,-1.7414882,-0.6764969,-0.60389183,-0.59468017,0.071467012,0.047549391,0.61708119,0.59071819,0.71932863,1.0536052,0.96741443,1.158224,0.86430759,0.85691205,1.3663656,0.64580799,0.63117316,0.92912436,0.40601792,0.64876759,0.72482809,0.40074692,0.40507652,0.68893333,0.4065435,0.31947623,0.72530557,0.29840154,0.50472338,0.39582716,0.39907452,0.55468947,0.18392687,0.46103951,0.10682418,0.63123766,0.6714936,-0.10681911,0.39294205,0.61102903,0.494914,1.0281772,0.81266735,0.50016704,0.47656365,0.43260871,0.49185901,0.015040557,-0.098010351,0.027623277,-0.11759046,0.10646585,-0.064094792,0.09988317,0.14139541,-0.23909183,0.24742389,-0.08515001,0.0077999134,0.40786757,-0.19491519,0.17110719,0.19702731:1
0.4049532,0.55399598,0.72409707,1.4490394,2.0126163,1.6244769,1.2047262,1.1175109,0.56209949,-0.01155647,-0.15105966,-0.16572346,-0.14970342,-0.30398491,-0.43954993,-0.25122211,-0.22646161,-0.4912359,-0.71847128,-0.81903348,-0.74290198,-0.7948623,-1.005411,-0.85466727,-0.66471926,-0.96605927,-1.2505506,-1.1487526,-1.0818054,-1.2298593,-1.3294278,-1.3435001,-1.3886114,-1.4697899,-1.5294459,-1.452891,-1.4384976,-1.637808,-1.6376426,-1.5163258,-1.6251909,-1.618808,-1.4995338,-1.5293524,-1.4132334,-1.1665569,-1.0704061,-1.0126004,-0.82338723,-0.50277435,-0.2399464,-0.13586856,-0.010560904,0.091757775,0.0014218949,0.02042256,0.36190933,0.52336517,0.3128456,0.29046759,0.49794164,0.50440911,0.41827686,0.42280451,0.39191814,0.38606759,0.46857705,0.41159191,0.26010842,0.34163266,0.55040005,0.60481591,0.49418306,0.38606561,0.50209789,0.59110914,0.47619963,0.6601066,0.92872313,0.80165834,0.78014427,0.93483624,0.98102392,1.0928671,1.1516277,1.2032218,1.2979384,1.243332,1.4636156,1.6949161,1.4561148,1.5703717,1.9345838,1.4975555,0.81257,0.39063926:1
1.0880883,2.0119486,2.3017332,1.6301994,0.63676804,-0.14050174,0.54795351,1.0750706,0.89686111,1.1379428,1.0467255,0.39015947,-0.46317712,-0.51645207,-0.74817246,-0.87015185,-0.83992999,-0.97205469,-1.0872074,-1.0664408,-1.278173,-1.3919322,-1.5276555,-1.7228096,-1.801991,-2.1096839,-2.2310059,-2.357204,-2.4322719,-2.4445194,-2.4420065,-2.1762332,-1.9420498,-1.6635462,-1.1241928,-0.79667565,-0.54655837,-0.14020788,0.14577748,0.28797309,0.37698469,0.53601913,0.67511312,0.60613107,0.55656433,0.62991541,0.54547619,0.51445898,0.51199872,0.53433124,0.56863698,0.5746794,0.64081463,0.61316837,0.68489368,0.6789633,0.57326541,0.62904358,0.67098544,0.61306061,0.52403193,0.60200549,0.54795209,0.49908517,0.47377212,0.44468815,0.51529158,0.3836756,0.40506973,0.39257337,0.38534412,0.3598727,0.53323719,0.64407727,0.76067102,0.66065604,0.43446362,0.39989758,0.31932493,0.23362588,0.14269709,0.17477607,0.13423191,0.055882364,0.14142074,0.17334646,0.12523891,0.071349197,0.13819719,0.11639861,0.13119804,0.11941168,0.082967892,0.15134818,0.27391506,0.34940474:1
0.44362091,0.94728503,1.9240844,2.1597897,1.4994468,0.96450776,0.22325623,-0.4249456,0.12127867,0.83019719,0.727048,0.64882969,0.78787726,0.64334572,0.46729178,0.3194819,-0.17812671,-0.58916449,-0.58226404,-0.65667671,-0.79056317,-0.78660913,-0.8467418,-0.87257731,-0.82201965,-0.86338103,-0.93887922,-0.98620385,-1.0143798,-1.0444798,-1.1341521,-1.2342781,-1.2507234,-1.2202701,-1.2281892,-1.2555401,-1.2890325,-1.3498909,-1.3901746,-1.4293026,-1.5214215,-1.5942712,-1.5927046,-1.4813207,-1.3056734,-1.2215905,-1.1057604,-0.87371287,-0.75198874,-0.67246003,-0.53843189,-0.54329748,-0.58819691,-0.47782002,-0.30534995,-0.11381953,0.099232532,0.21777654,0.23858694,0.2908551,0.37789809,0.43438291,0.4723613,0.46645286,0.42763653,0.41624944,0.39828553,0.37636386,0.34308422,0.27185512,0.25390989,0.25018192,0.20264253,0.2461762,0.30065491,0.21693566,0.16253621,0.21910029,0.23344478,0.21088009,0.26067299,0.28066369,0.28014483,0.32223333,0.31510409,0.53973602,0.90051075,1.278688,2.317878,2.9162543,2.2119475,2.034753,2.0713024,1.254178,1.0378788,1.0096155:-1
0.20942637,1.2733286,2.8243142,3.5923059,2.2236616,0.57037406,-0.93877272,-0.81280266,-0.0093585905,-0.26645765,-0.27935723,-0.25966804,-0.042980281,-0.4064509,-0.7746623,-0.90003017,-0.90025688,-0.94289438,-1.0010728,-1.11785,-1.0500333,-1.0509152,-1.2686037,-1.3748736,-1.4947954,-1.539804,-1.6244323,-1.7513756,-1.7631204,-1.8548043,-1.9274127,-1.9001424,-1.9487849,-1.6607885,-1.5623166,-1.2527629,-0.90950183,-0.73362037,-0.10499264,0.080045367,0.241404,0.48930428,0.64837451,0.87816228,0.80705536,1.0020489,1.0784331,0.98459314,1.0091948,0.81767494,0.8875262,0.83767033,0.6312626,0.79488356,0.73821005,0.64248839,0.66695296,0.52493071,0.63109505,0.62513251,0.68333848,0.55490848,0.52569864,0.54503821,0.49242159,0.6624228,0.46678446,0.31168606,0.32150904,0.37618574,0.42516799,0.55112686,0.22800944,0.66563972,0.99353974,0.74102462,0.53702414,0.36586726,0.52548366,0.21086661,0.1065221,0.28931566,-0.0024839491,-0.052848197,-0.10541955,0.12373618,-0.067402666,-0.2714003,-0.070282474,-0.10555504,-0.0010386352,-0.065470019,-0.17466079,-0.00496291,-0.028693299,-0.037258042:1
1.0850983,1.8537059,1.8341764,1.5500005,1.3830018,1.0015947,0.25534766,-0.33286445,-0.44420432,-0.13844863,0.014409364,-0.27576,-0.43485926,-0.24974153,-0.21085802,-0.46427156,-0.81977759,-1.0245609,-1.003218,-1.0540625,-1.1012694,-0.9946936,-1.0830202,-1.1879027,-1.1113112,-1.2913485,-1.4203416,-1.1872251,-1.1988179,-1.3785137,-1.3527438,-1.4479202,-1.6078549,-1.5897483,-1.6422127,-1.7671951,-1.7548349,-1.7185782,-1.7605288,-1.7169465,-1.4992004,-1.3645956,-1.3755258,-1.0770797,-0.57810475,-0.49260638,-0.48388483,-0.11746025,0.1074884,0.11183024,0.26293131,0.40576935,0.46511975,0.55696002,0.58161379,0.57143271,0.61756289,0.6325473,0.60372944,0.59852282,0.5807564,0.50525199,0.45073392,0.44970579,0.43589843,0.40810321,0.36511971,0.32002786,0.32298259,0.33049109,0.36513341,0.4570896,0.43393995,0.35410653,0.52126178,0.80169655,0.86086684,0.8335902,0.96120249,1.0926919,1.112147,1.168798,1.2393278,1.2066695,1.104153,0.94637784,0.82267068,0.85005808,0.96500627,1.0962552,1.1081421,0.99474361,1.1263143,1.336455,0.99878355,0.33469719:1
1.7092211,2.7528523,1.6829902,1.2418618,-0.037972104,-0.21758892,0.78964563,0.54742834,0.30210378,0.33906542,-0.10047946,-0.44529518,-0.57598109,-0.9207572,-0.77172504,-1.1704455,-0.81815039,-0.94015055,-1.1584194,-1.2336452,-1.4284852,-1.4998186,-1.4969223,-1.8198198,-1.9943259,-1.6908569,-2.300812,-2.3535052,-2.3138032,-2.4247686,-1.8332078,-2.1235422,-2.2359136,-1.1068787,-1.1048193,-0.71410217,-0.14530638,0.022185016,0.44112003,0.41526343,0.83749722,0.71985104,0.82643145,0.70108358,0.71184173,0.78842372,0.53612366,0.58108428,0.813672,0.60100423,0.42498647,0.74736093,0.7942348,0.75368838,0.76415348,0.59061615,0.75449047,0.69706223,0.53816061,0.58230398,0.8357462,0.38417015,0.56462207,0.6884838,0.23341844,0.50537,0.35998205,0.38358787,0.39429369,0.3790856,0.48102232,0.29297337,0.3981071,0.53330449,0.64801905,0.8102375,0.66636109,0.56732651,0.53227073,0.24854627,0.14714747,0.33657243,0.11446555,0.043912189,0.26192804,0.094237554,0.11046463,0.20485062,0.2573572,-0.055266721,0.11102102,0.30866849,0.048724018,0.072166918,0.34802451,0.6584883:1
1.6243869,2.9533979,2.6974247,2.697235,1.0675545,0.21036978,1.157593,1.3789152,0.99474778,0.94820639,0.78186994,-0.36978837,-0.52354553,-0.44849519,-0.99299786,-0.84255545,-1.0632025,-1.0693172,-1.163306,-1.3059159,-1.1572979,-1.2089145,-1.3698139,-1.4610979,-1.4881568,-1.716204,-1.7804745,-1.7765498,-1.7869436,-1.8950475,-2.009183,-1.9089064,-1.6417216,-1.5935618,-1.4735916,-1.0894121,-0.76751502,-0.47884266,-0.004158978,0.2516776,0.43615535,0.80119892,0.66986105,0.81885607,0.93841388,1.0038027,0.8509804,0.75494876,0.77366171,0.64593695,0.70543103,0.65919127,0.62832969,0.60965326,0.5233954,0.57715439,0.4590126,0.38407683,0.58278299,0.39092993,0.31147346,0.41964494,0.36059033,0.39369015,0.27062481,0.20570896,0.28969335,0.19919906,0.13854582,0.20859371,0.23017642,0.074264638,0.197576,0.34140166,0.51925827,0.70871063,0.53955467,0.29732261,0.34602121,0.14900119,-0.16181354,0.0678152,-0.075625184,-0.32658224,-0.098217926,-0.051469011,-0.19686164,-0.3302979,-0.17180379,-0.1360794,-0.30421001,-0.17234917,-0.11777179,-0.14551213,0.14445496,0.28463695:1
0.79567475,0.9502404,1.1466679,1.7491252,2.4258016,2.6709641,2.4624665,2.0670781,1.6233579,1.088265,0.48325747,0.029067671,-0.10205782,-0.045985726,-0.067182598,-0.19722394,-0.2485563,-0.16774872,-0.14832422,-0.28560195,-0.40439817,-0.44400887,-0.57232183,-0.74243746,-0.76085833,-0.73913887,-0.79702819,-0.82658122,-0.86103224,-0.92441019,-0.92853065,-1.0558294,-1.342795,-1.4240432,-1.3925323,-1.6146891,-1.8213559,-1.7714491,-1.812784,-2.0056145,-1.9994011,-1.8152135,-1.7312891,-1.7231695,-1.595469,-1.3787969,-1.2431864,-1.1277632,-0.82712383,-0.43367487,-0.24352558,-0.24418688,-0.13786127,0.12819149,0.28449563,0.27788564,0.34869189,0.47325956,0.46019376,0.43604088,0.46587407,0.36677829,0.29225774,0.45376562,0.5617359,0.44966833,0.36502024,0.37485964,0.38958319,0.43390585,0.45581797,0.40363272,0.39960026,0.49559394,0.56183973,0.54000099,0.5069879,0.48365207,0.46294595,0.5407128,0.71064026,0.7848302,0.74619101,0.73161313,0.68733161,0.53590909,0.43032121,0.48710724,0.57974138,0.56283371,0.46409311,0.40246792,0.44930481,0.55808223,0.56857857,0.40117688:-1
1.3983408,3.1540817,3.4377208,2.3056705,0.18942863,1.147842,1.0036473,0.5406101,0.94414293,-0.34031732,-0.74986316,-1.0246178,-1.0516524,-1.1798576,-1.5755576,-1.3238841,-1.4734458,-1.5490872,-1.5381923,-2.1342943,-1.8030426,-1.8195414,-2.1249959,-1.8755409,-1.9400493,-1.8706804,-1.7457523,-1.4340817,-1.02053,-0.66547783,-0.19563852,-0.076358809,0.19969877,0.75945819,0.60410229,0.98194143,0.85422106,0.7641782,0.78129153,0.73856427,0.82464716,0.58899476,0.95400218,0.58387086,0.7609336,0.59681046,0.66612566,0.68017823,0.367999,0.77613228,0.49409847,0.55069373,0.30045556,0.4819926,0.41942019,0.23437249,0.24053281,0.13784189,0.39594908,0.1986789,0.11382885,0.2049012,0.41500754,0.049823534,0.1099592,0.20408384,0.20339462,0.11126605,0.010617737,0.14707947,0.18872793,0.034310464,-0.020825512,0.13108857,0.25924048,0.11000057,-0.15175859,0.64657453,0.54080264,0.54621407,0.37650325,0.2169475,0.076583798,-0.24089566,-0.20835214,-0.38329468,-0.22726309,-0.060736099,-0.64441214,-0.3285149,-0.16558149,-0.58693754,-0.25855697,-0.45279814,-0.31072814,-0.20251214:-1
-0.28508899,0.012340509,-0.41994724,-0.0073278178,-0.4725052,-0.70130495,-1.2613408,-1.5949753,-0.40193819,-0.96093398,-1.4998977,-1.3521346,-1.5175473,-1.2411062,-1.3214816,-1.3415551,-1.497784,-1.7727273,-1.7618055,-1.5856029,-1.7310799,-1.886959,-1.8220688,-2.005937,-1.6262921,-1.4335271,-1.5656756,-1.2569998,-1.142585,-0.47613427,-0.67823908,-0.12215353,-0.0043410739,0.043118206,0.63395137,0.3635064,0.62594227,0.57210058,0.51669989,0.77135408,0.45756612,0.69759574,0.71813376,0.52977066,0.28579604,0.4974927,0.64167847,0.43911686,0.35805885,0.57810233,0.60812488,0.53994656,0.68572202,0.39300372,0.4430444,0.5686108,0.3710138,0.47246382,0.42897912,0.54433556,0.42546872,-0.007826348,0.52994866,0.74601601,0.49197768,0.81139536,1.01706,0.90748997,0.70762685,0.63678795,0.44023067,0.5170181,0.18217669,0.42535885,0.43189337,0.21950474,0.22932122,0.1480024,0.28685537,0.32664566,0.089938435,0.056731597,0.38761465,0.15340031,0.53271593,-0.058986894,0.07712739,1.2397105,0.83983856,2.3964256,3.292648,2.0157003,2.0465054,0.57867173,-0.46050501,0.29093904:1
-1.6681931,-2.0533347,-2.2353323,-2.1738372,-1.741502,-1.5408022,-1.9629656,-2.2387671,-1.877941,-1.4731916,-1.4222628,-1.4689805,-1.2587109,-0.67357547,-0.3547567,-0.90398078,-1.2959837,-0.63830793,-0.26174727,-0.92380216,-1.1221055,-0.5184318,-0.50317938,-0.9408434,-0.85857096,-0.72244107,-0.93731992,-0.90434929,-0.62739182,-0.61420148,-0.82486721,-1.0526152,-1.0510185,-0.60750915,-0.22938628,-0.34758114,-0.40724565,-0.17114043,-0.18176962,-0.29376235,0.0098178391,0.28884706,0.16010207,0.25653017,0.77225683,0.90957806,0.47048701,0.27526296,0.72315654,1.1870492,1.0995432,0.79061478,0.79760956,0.9619543,0.91375651,0.87497972,1.092558,1.1783378,0.95717349,0.89770437,1.0668536,1.0890979,1.0749827,1.1691707,1.0614204,0.83989265,0.920194,1.0513619,0.87866971,0.78330051,1.0555175,1.3320173,1.2849244,0.99258577,0.78249959,0.8855666,0.99452363,0.78719417,0.69751609,1.0187138,1.178678,0.98272675,0.89250482,0.75743497,0.30507559,0.090893643,0.29973618,0.33900096,0.21857648,0.31778449,0.32052118,0.021831414,3.8931541E-4,0.43778365,0.56669745,-0.029252054:-1
1.0235784,1.4785416,2.2060474,2.8263091,2.4762642,1.6743566,1.0884254,0.43254283,-0.15023378,-0.32054309,-0.42413533,-0.53525708,-0.4661938,-0.50811196,-0.71508462,-0.73232132,-0.55193334,-0.34564772,-0.24823897,-0.44283865,-0.74503037,-0.76394799,-0.61871512,-0.64551694,-0.73673245,-0.65402836,-0.50797116,-0.57084216,-0.83414086,-0.98022658,-0.87397375,-0.80126851,-1.0025006,-1.2908607,-1.4001277,-1.4493026,-1.6141941,-1.6598662,-1.4850653,-1.48279,-1.6745339,-1.704159,-1.695134,-1.7284449,-1.5231181,-1.2962632,-1.2832336,-1.1100699,-0.83130305,-0.79751809,-0.66104823,-0.27560624,-0.14157177,-0.24355615,-0.15018721,0.14210478,0.38728135,0.35035916,0.07887864,0.051216942,0.33052721,0.41790084,0.32285633,0.36096013,0.38437642,0.34134531,0.43526628,0.50847031,0.41637279,0.42048126,0.58859118,0.66471924,0.6169954,0.62102728,0.6899465,0.71086728,0.66887896,0.66223872,0.76268118,0.96787829,1.1969836,1.2519952,1.0265586,0.83315502,0.99328798,1.160336,0.94286046,0.72598338,0.86622795,1.0608436,1.0785506,0.97807484,0.85989583,0.92785557,1.0143007,0.64819166:-1
1.2806801,1.570831,1.915334,2.3362032,2.7350768,2.9284487,2.811203,2.4532867,2.0378798,1.6964592,1.4204942,1.1253556,0.75796872,0.35345329,-0.0024522743,-0.23449028,-0.31305458,-0.27555227,-0.2096735,-0.21104971,-0.31069175,-0.43958321,-0.49432698,-0.43579974,-0.33922779,-0.31363352,-0.38318436,-0.47433165,-0.49639536,-0.43570023,-0.35011127,-0.28570768,-0.2593413,-0.27502302,-0.33755521,-0.41313781,-0.41670057,-0.31360525,-0.20236773,-0.25649677,-0.50838965,-0.76382985,-0.78700928,-0.57426344,-0.39352708,-0.48503451,-0.80027355,-1.065166,-1.0916977,-0.96190575,-0.87657128,-0.9194986,-1.0094541,-1.064689,-1.1147029,-1.213913,-1.3277383,-1.354267,-1.2685905,-1.1697342,-1.1630796,-1.2365629,-1.2730668,-1.1907806,-1.0228813,-0.86577026,-0.7811141,-0.75220465,-0.72919217,-0.66634692,-0.53540486,-0.3354678,-0.10215377,0.087807956,0.17386595,0.16455068,0.13112505,0.14910601,0.23192582,0.35334075,0.49032931,0.62966976,0.73920438,0.75482785,0.66170552,0.54379903,0.53068083,0.66927061,0.85228554,0.92927955,0.85298512,0.71977403,0.65628169,0.68351697,0.72929537,0.72617319:-1
0.9432554,1.4452319,2.1293021,2.2951971,1.5656669,0.97279656,0.33107865,-0.056666291,0.22622647,0.41797382,0.22829976,0.13148799,0.26162268,0.38476476,0.22333387,-0.17722902,-0.45418191,-0.55534834,-0.65051131,-0.66495414,-0.77035974,-0.86318671,-0.82750064,-1.0353524,-1.0293107,-0.86470487,-1.2364281,-1.4661528,-1.4016502,-1.5633617,-1.7030687,-1.8134626,-1.9487553,-2.019205,-2.1105126,-2.0985275,-1.9791937,-1.9657925,-1.9209262,-1.6892437,-1.5019344,-1.3792432,-1.2145991,-1.0157584,-0.65123948,-0.35815279,-0.25441176,-0.098119061,-0.021057747,0.035700667,0.25219347,0.34361812,0.33704869,0.49339789,0.52396899,0.4343584,0.52840802,0.44379609,0.35271908,0.46322585,0.31351418,0.32487953,0.40828946,0.31209012,0.47449741,0.34380206,0.22204429,0.52014878,0.45869096,0.49903518,0.6986806,0.69253402,0.95317279,1.0819412,1.0092799,1.1209672,1.083061,0.96393239,0.92468128,0.81876184,0.74801439,0.71482654,0.63382934,0.70491505,0.81384929,0.68178963,0.63360142,0.6299216,0.5979552,0.73917141,0.67749219,0.54199945,0.57031817,0.42713405,0.62119839,0.63540869:1
0.53020645,2.1402172,2.7660792,1.5309952,-0.4230289,-0.96724318,0.14792859,0.53637254,0.62569253,0.73849091,0.52001518,-0.064808948,-0.85676168,-0.85303437,-1.1860429,-1.1871913,-1.2813872,-1.5152556,-1.2569009,-1.5210845,-1.432023,-1.4443959,-1.7064034,-1.5016786,-1.5433835,-1.6106134,-1.8976426,-1.7897672,-1.7042705,-1.9932822,-1.63921,-1.7822647,-1.758795,-1.5581568,-1.4014517,-0.91188949,-0.62490093,-0.37235721,-0.052260528,0.28534522,0.45860241,0.70074994,0.87433718,0.98717032,1.0111742,0.94099426,1.0344019,0.95367014,0.88246847,0.9624795,0.90363378,0.90195314,0.90598267,0.83861564,0.90507984,0.99314308,0.84603325,0.87075829,0.91765664,0.74751176,0.84847886,0.82533732,0.61607967,0.68065855,0.6502045,0.57944452,0.52808357,0.36473027,0.45604938,0.48082388,0.33560612,0.50230596,0.46281685,0.57774089,0.72469684,0.77669786,0.66842125,0.33836423,0.29062674,0.2163158,0.097943508,0.03596374,0.0031463401,0.02766701,-0.017149529,-0.0029763293,-0.097044566,-0.097693403,-0.14334566,-0.14896863,-0.061405073,-0.15811635,-0.12756947,-0.1217336,0.037188906,0.23033705:1
1.0800264,1.9942631,1.1223293,1.5190259,0.23159264,-0.53387261,0.39174722,0.34919358,0.12182368,0.20368747,-0.13612628,-0.95929044,-0.90909734,-1.1099904,-1.2027228,-1.2181541,-1.3085844,-1.3829693,-1.4186686,-1.4715671,-1.4577204,-1.5880218,-1.7044052,-1.6371158,-1.7918609,-1.8883982,-1.9090601,-2.0383234,-2.0432347,-2.0329399,-2.0430083,-1.9364222,-1.8771077,-1.5165753,-1.3866965,-1.0514129,-0.59895076,-0.45755625,-0.034726445,0.14357106,0.31805541,0.49442687,0.61187727,0.7038164,0.62767192,0.69392083,0.6222679,0.65809981,0.62395682,0.58700571,0.72744796,0.70011422,0.67868374,0.69685928,0.80109241,0.70686106,0.74971181,0.79453729,0.7285877,0.60991571,0.62293282,0.75308636,0.71088416,0.564612,0.57634358,0.68149039,0.57028047,0.55971012,0.62406211,0.42834778,0.49473132,0.56549673,0.64575143,0.84425763,0.97163705,0.93127807,0.83295021,0.67711215,0.55847263,0.51629579,0.43222505,0.51233594,0.43975483,0.33868432,0.44312852,0.36157799,0.41625273,0.34883713,0.36861872,0.44581779,0.39093878,0.38801484,0.47189633,0.36190198,0.61935354,0.88333826:1
1.5643963,1.7482197,0.77474638,1.2544602,0.89997541,-0.37567736,-0.79080618,-1.1931323,-1.164659,-1.1867189,-1.4062845,-1.4138052,-1.6411388,-1.54582,-1.5845103,-1.743763,-1.9586241,-1.8943288,-1.9077027,-2.0006481,-2.0722836,-2.1593688,-2.1978214,-2.2192242,-2.0101897,-1.94627,-1.5544773,-1.2214721,-1.1612732,-0.61035196,-0.22985737,0.070742,0.14810667,0.44681452,0.64101445,0.7724852,0.64356848,0.75628418,0.84952797,0.67585812,0.76490077,0.75149641,0.71947083,0.71344172,0.62756476,0.62963803,0.69117203,0.70855278,0.62610442,0.66432633,0.58596803,0.71740281,0.61417546,0.52597191,0.63074705,0.55835858,0.62812429,0.59321689,0.51352255,0.59995676,0.59140136,0.45250943,0.47187178,0.58684491,0.48447546,0.54131764,0.41436727,0.52472037,0.49982664,0.71554793,0.77544044,0.855971,0.84822259,0.7758579,0.6971799,0.42933698,0.39876303,0.37410816,0.39196372,0.13966203,0.23662477,0.30362929,0.33941046,0.13728296,0.16860834,0.2160925,0.25731524,0.1900001,0.27372741,0.28663592,0.11045239,0.16826602,0.21823028,0.23506495,0.46984467,0.49932317:-1
1.0589187,1.725795,0.90853488,1.3851054,1.0411848,0.57228089,-0.013527232,-0.58847754,-0.45486079,-0.69142025,-0.59339456,-0.92490949,-0.99056385,-0.96006994,-1.2018749,-1.0311651,-1.3818098,-1.5855789,-1.5235625,-1.8379309,-1.9860123,-2.0047721,-1.9917542,-1.9893073,-2.1549127,-2.1232846,-1.7059063,-1.4068069,-1.2171735,-0.85868265,-0.69379524,-0.26357642,0.13933276,0.30825345,0.4085049,0.68495993,0.82037332,0.79000082,1.0216456,0.81646046,0.88444777,1.0404727,0.65261728,0.82739061,0.59930781,0.66283539,0.69471752,0.51520121,0.66643817,0.50477893,0.47763657,0.65158677,0.49403273,0.33289524,0.37715727,0.40210482,0.61078016,0.37716964,0.15167448,0.23898429,0.2922396,0.20097301,0.13639521,0.25623597,0.49347516,0.70105615,0.72347741,0.77749342,0.57391621,0.19914919,0.27113719,0.062120227,-0.32082604,-0.19131176,-0.36330897,-0.31205237,-0.049681729,-0.18579682,-0.37861481,-0.30860961,-0.071403627,-0.29809771,-0.40381867,-0.3537211,-0.26179547,-0.10408916,-0.50610942,0.23314894,0.5163702,2.3168371,3.3391189,1.7997182,1.3069905,-0.31340674,-0.73429484,0.28863614:1
2.2860238,2.4366522,2.3529955,-0.34188086,-1.3509822,-1.5758904,-1.6428912,-1.9825338,-2.0715503,-2.2615941,-2.4454086,-2.4321368,-2.6443139,-2.6264359,-2.5431081,-2.3707387,-1.8416526,-1.3253951,-0.49182607,0.093824972,0.51341088,1.0093267,1.1208998,1.1625987,1.0617182,0.92003119,0.84326683,0.71488464,0.70969958,0.69972873,0.59568666,0.56162581,0.55847999,0.66859381,0.37860448,0.36261979,0.44195837,0.19110168,0.2752102,0.17269449,0.084121285,0.17822509,0.022290294,0.11159151,0.12669322,-0.027581394,0.14936044,0.022057774,0.12141211,0.19302579,0.086601362,0.22964652,0.082968696,0.1583322,0.14205898,0.058015044,0.035472749,-0.002317362,0.11784918,0.012387662,0.062612477,0.1328354,0.066937604,0.18064613,0.14134221,0.12197552,0.2982227,0.13709768,0.24508943,0.18794375,0.19376324,0.25529511,0.15591979,0.23505865,0.17975738,0.14056105,0.16095652,0.20738071,0.28027735,0.2523668,0.45390201,0.78227736,1.0478737,1.0044231,0.34958922,0.12823727,0.13653203,-0.11789072,0.014033671,0.079702191,-0.12770929,-0.0046908362,-0.10881782,0.069738179,0.030709027,0.54054194:-1
0.59383984,0.89949497,2.7955822,3.0829319,1.8261749,0.20856986,-0.10003207,0.78243839,0.89689947,0.99168253,0.74846283,0.22270471,-0.35101024,-0.71428085,-0.79221872,-0.92529582,-1.0216309,-1.2229367,-1.1344717,-1.1010462,-1.3740149,-1.5085317,-1.4761033,-1.497716,-1.7606397,-1.8296171,-1.6739257,-1.9337676,-2.1567221,-1.8631865,-2.0183445,-2.0290149,-1.6841828,-1.4387103,-1.3209476,-0.97110251,-0.29988154,0.038750771,0.31616268,0.67526651,0.90751022,1.0674841,1.0541597,1.1618832,1.0994137,0.98926482,0.88678315,0.80945506,0.92935127,0.72222583,0.60203828,0.7362878,0.69844821,0.70809992,0.70688241,0.70352749,0.60789631,0.648789,0.62269259,0.52861431,0.45392017,0.42669877,0.56126484,0.33613522,0.32966633,0.34857477,0.10821554,0.26112077,0.12783441,0.17517372,0.19045498,0.10833409,0.18752253,0.2045717,0.23927946,0.55283341,0.62476932,0.52900018,0.36995057,0.16726157,0.17095038,-0.071835506,-0.178751,-0.16206826,-0.23461126,-0.16321261,-0.26383443,-0.20788606,-0.24123382,-0.26733819,-0.17630911,-0.17962533,-0.17057512,-0.20585797,-0.042945582,0.022114524:1
-0.16979947,1.136997,2.2905471,2.5376071,1.6253238,-0.18529399,-1.4290927,-0.87607867,-0.12678736,-0.30123413,-0.3511966,-0.55171449,-0.53170119,-0.64040374,-1.1574105,-1.099805,-1.1901692,-1.3582285,-1.161153,-1.6538415,-1.5596707,-1.0874757,-1.6503382,-1.9026788,-1.6535112,-1.7524449,-1.8331096,-1.9048266,-2.0907195,-1.7648387,-1.7292234,-1.9102457,-1.6070189,-1.197288,-1.2650618,-0.99103606,-0.34145928,0.017173503,0.091954546,0.15320019,0.43771972,0.54806384,0.85507131,0.82826288,0.85755542,1.0933189,0.78021198,0.71766094,0.8187625,0.69917013,0.67283328,0.62609756,0.53336323,0.54712254,0.7568194,0.6599877,0.49799278,0.5383947,0.6644235,0.70930893,0.70829786,0.54330981,0.51847535,0.77675097,0.67081455,0.43192722,0.60915168,0.63870124,0.59352465,0.6804107,0.38237519,0.60503711,0.88944743,0.69432336,1.1614298,1.0423931,0.81427189,1.0795522,0.53502741,0.33474268,0.72308722,0.37024806,-0.038491203,0.42097727,0.36005873,0.09523671,0.08965657,0.095979341,0.21826647,0.19554964,0.13080471,0.058245364,0.22840186,0.14786522,0.091818651,0.43224348:1
0.069191614,1.2792481,2.7318273,2.871786,2.305235,0.77955596,-0.73663447,-0.17040375,0.52267597,0.23154351,0.38847574,0.21481539,-0.32252864,-0.34847258,-0.70060763,-1.0970698,-0.89725538,-0.8953439,-1.3183359,-0.88495272,-1.1837839,-1.6638313,-1.2353436,-1.4734901,-1.7498892,-1.5675393,-1.6833519,-1.994186,-1.8193777,-1.9660108,-2.2143988,-2.1080045,-1.4651175,-1.5603976,-1.5536772,-1.0730687,-0.9455595,-0.49148165,-0.38960581,-0.092557315,0.7296192,0.73926615,0.44559833,0.75890032,1.2377159,0.96074616,1.0402219,1.0842393,0.93858275,0.90236772,0.83211063,0.84225259,0.53542518,0.73190415,0.95938921,0.63621333,0.60600381,0.70457895,0.55616921,0.81111963,0.29398528,0.56505605,0.6936828,0.33958195,0.58400577,0.39741937,0.37002225,0.28959907,0.58834546,0.34412977,0.11477253,0.43471551,0.092935224,0.34481968,0.71900318,0.65689219,0.7538831,0.58198493,0.37331589,0.32285135,0.10992047,-0.12964523,0.043994042,0.050380639,0.034999538,-0.087647226,-0.062467252,0.030928322,-0.1558687,-0.2328192,-0.12890621,-0.02152003,-0.0070461774,-0.11899604,-0.076080821,0.04527055:1
1.1619595,0.71889683,0.33206986,1.6464138,0.65658459,-1.645442,0.41723664,0.28423758,-0.36777559,0.2054231,-0.40684665,-0.64694818,-1.5145099,-0.43185986,-1.7996858,-1.7005178,-0.75053447,-1.2869067,-1.0214442,-1.9637384,-1.2263683,-2.2304693,-2.5218354,-0.91454066,-1.3983971,-1.1065512,-1.5547738,-0.87086983,-0.49161064,0.6617696,-0.52855527,0.78400692,1.6608755,0.26871202,0.75735947,1.7962481,0.69842691,0.12030058,1.2180418,0.26266105,-0.16612944,0.95325493,1.5219747,0.10340843,0.16848171,-0.12816521,0.48735866,0.31061573,0.68521421,0.20405088,-0.17640991,0.46434757,-0.2466541,0.57987176,-0.45322375,-0.09431623,0.27847891,0.50138711,0.49795921,-0.1890951,0.20966655,-0.13136451,0.11871338,-0.12220322,0.27743577,0.67204607,0.15605036,1.2640087,0.33784853,0.51905812,-0.10102124,0.27365031,0.6351325,-0.52384764,-0.14135812,-0.37534146,-0.1111561,-0.36418672,-0.57454325,-0.17439003,-0.56253697,0.063392339,-0.67770463,-0.048850652,-0.68551485,-0.53529472,0.41587585,-0.88018088,-0.11980887,1.8030903,2.9954724,3.0976558,2.0386985,0.41850937,-1.2530251,-0.48742854:1
-0.10785525,0.22798785,0.12129083,-0.072086796,0.20807709,-0.49248406,-1.2330783,-0.52326583,-0.66374243,-1.2550452,-1.195765,-1.1017394,-1.0233752,-1.4365385,-1.3083032,-1.5393488,-1.7108352,-1.4305559,-1.536925,-1.9587138,-1.8166046,-1.8469605,-1.9326108,-2.0150324,-1.7827193,-1.5276745,-1.639512,-1.0408082,-1.1181881,-0.58059608,-0.28786473,0.36205289,0.57227967,0.27862561,0.83022946,0.99571736,0.97180356,1.0106649,1.136433,1.1848465,0.95452731,0.72337342,0.44553268,1.0825185,0.65928191,0.43863151,0.61302374,0.47007868,0.57559,0.77066916,0.59386748,0.47471584,0.54968677,0.63553258,0.63568829,0.18037629,0.80698256,0.32146459,0.16520568,0.45390075,0.39764266,0.086192962,0.27900242,0.5863552,0.45762973,0.66309039,0.69735661,1.0670857,0.95321071,0.57609948,0.61562653,0.25947796,0.23359728,-0.12618793,0.071184622,0.249268,-0.049626279,0.041298285,-0.076148697,-0.14419695,-0.0020130826,0.0099816802,-0.25987563,0.14202814,0.043487149,-0.34394458,0.05221379,-0.10669793,1.0408467,1.532182,2.3810383,3.2940431,1.7736995,0.073276818,-1.2280832,-0.51256875:1
0.60629826,0.96132617,1.5694187,1.99187,1.7737542,1.6618841,1.6923238,1.1973563,0.54023845,0.085227217,-0.22383348,-0.17281739,-0.091975138,-0.37683527,-0.58307639,-0.53950146,-0.49262148,-0.45116126,-0.54331918,-0.76019842,-0.80394444,-0.80969407,-0.99251645,-1.054989,-0.89897496,-0.92498256,-1.1594209,-1.2252087,-1.2113005,-1.3642973,-1.4870961,-1.5685648,-1.7774584,-1.8551213,-1.7526029,-1.8419041,-2.0175223,-1.9357264,-1.7690541,-1.7245362,-1.6080368,-1.4002762,-1.3732941,-1.3997718,-1.1105554,-0.69224644,-0.52788179,-0.43026236,-0.16087809,-0.0045159618,-0.062038155,0.01914966,0.24120738,0.30676265,0.2631586,0.30751321,0.45298349,0.54870043,0.48085203,0.45303063,0.58177038,0.60236193,0.54465028,0.63807698,0.70402227,0.65452501,0.63352277,0.58449993,0.5875742,0.75369474,0.84374717,0.82564909,0.84008572,0.82772126,0.91117414,1.029984,0.87142013,0.7395863,0.85312138,0.86400511,0.8863172,0.99888043,0.91768355,0.93655242,1.0540102,0.75952979,0.47289977,0.58727105,0.59935107,0.49818526,0.58398687,0.61123369,0.55737016,0.66117883,0.67507024,0.33624349:-1
0.15982206,1.2420159,2.2446138,1.9317841,1.4816205,-0.12822301,-0.30749698,0.56413162,0.028760396,0.099704776,0.089407364,-0.5137988,-0.73748605,-0.73574626,-0.88075878,-0.91189115,-0.9915558,-1.0712817,-1.1562952,-1.2346508,-1.2942054,-1.4602631,-1.5775772,-1.595919,-1.685364,-1.8743286,-1.9332825,-1.991898,-2.1822696,-2.1728733,-2.2172188,-2.1303851,-1.9773811,-1.8801774,-1.5958501,-1.3068534,-0.96172595,-0.5012974,-0.22462087,-0.0030180723,0.32726616,0.48572348,0.54610411,0.60549104,0.5359487,0.66270334,0.5303948,0.47115379,0.53624768,0.43032845,0.42245245,0.38971027,0.4624417,0.39518535,0.32112909,0.48284253,0.43689039,0.38655865,0.41072704,0.42508159,0.34282727,0.37915956,0.52024763,0.43263498,0.36274918,0.45207364,0.55596525,0.55410339,0.48433984,0.54976293,0.64023623,0.59028065,0.57942207,0.72095353,0.96052642,1.0116902,1.0739238,1.1073053,0.87336865,0.75603648,0.71437968,0.65442931,0.56454847,0.47655972,0.58059747,0.55697901,0.46980882,0.39694337,0.54188497,0.56014332,0.53625923,0.56064724,0.57978913,0.57874724,0.69413467,0.71599354:1
2.680214,2.8652761,2.8729752,3.2810722,2.5760916,1.3759437,0.42399853,-0.22249679,-0.48343412,-0.63600907,-0.74129908,-0.80886865,-0.97498964,-1.0712077,-1.149548,-1.1688486,-1.2459457,-1.2619599,-1.3858875,-1.3071176,-1.4996717,-1.5092282,-1.6496099,-1.7265553,-1.5608821,-1.6571968,-1.5776886,-1.4304052,-1.2870166,-1.0266848,-0.71607269,-0.45037574,-0.12320194,0.22866651,0.31451316,0.50084246,0.69574261,0.75725108,0.75787769,0.85374536,0.86414551,0.79703261,0.79214137,0.675568,0.66589507,0.65767354,0.60148157,0.53793616,0.57000207,0.57647711,0.53706998,0.62958907,0.66426993,0.73125647,0.6803034,0.81911321,0.89411753,0.53049395,0.613699,0.61908993,0.60981854,0.38367213,0.20005118,-0.03625964,-0.04969382,-0.02091296,-0.14702029,-0.14526701,-0.22783355,-0.19432663,-0.21846229,-0.29424691,-0.28739556,-0.27401418,-0.2531472,-0.32638005,-0.28441752,-0.32472756,-0.30484133,-0.37471013,-0.39422719,-0.33922909,-0.28418313,-0.3468265,-0.41075769,-0.32279207,-0.26929795,-0.30344826,-0.24059159,-0.16013298,-0.03728352,-0.054517528,-0.03683349,-0.043404989,0.25551133,0.58876554:-1
0.036420104,1.8337151,3.1172225,1.8123943,1.286245,-0.016664408,-0.92312518,0.067486529,0.37857682,0.0080445436,-0.04723896,0.21581113,-0.49128865,-1.0822225,-0.86331993,-0.84920834,-1.1090319,-1.1190511,-0.99359128,-1.297531,-1.2461759,-1.3625891,-1.5868695,-1.5181842,-1.6482311,-1.53085,-1.6400178,-1.8346816,-1.987281,-1.8568604,-1.777792,-2.0562772,-1.8478569,-1.6207289,-1.642456,-1.2195633,-0.73281594,-0.64400086,-0.42456672,0.17612416,0.26440584,0.37345995,0.86223162,0.72255279,0.93571562,1.0569099,1.0269631,0.95109619,0.83288052,1.0652118,1.0164323,0.65769724,0.55820809,0.95729407,0.90031316,0.6747296,0.8998951,0.69429809,1.1855413,0.70106416,0.69002268,0.80586664,0.7201408,0.6708997,0.50149262,0.82416497,0.46165262,0.69558105,0.58810208,0.29119507,0.48373082,0.28049276,0.3906313,0.72255664,0.86607607,0.886461,0.67763372,0.48822106,0.44838623,0.32768377,0.16965711,0.24363381,0.077312278,-0.049856225,0.079042755,0.056897921,-0.071808499,0.13360307,-0.14685517,-0.28662033,0.070109435,-0.12376912,-0.12280526,-0.026731721,-0.14168881,0.020018477:1
0.13863406,0.24119766,2.1532369,2.5507704,1.4748177,0.54335886,-0.61578843,-0.21148987,0.5031623,0.3296842,0.12750538,-0.055928823,-0.37618943,-0.91936179,-0.82049032,-0.88664,-1.1001348,-1.0775616,-1.1234749,-1.1315202,-1.2718251,-1.2696182,-1.355948,-1.4870496,-1.4638344,-1.6854883,-1.7614237,-1.9423017,-2.0274683,-1.9763218,-2.2254436,-2.3379494,-2.0945052,-1.9565038,-1.7980986,-1.4214329,-0.96948002,-0.71750939,-0.31030111,0.217314,0.40301308,0.62499995,0.71957934,0.86304271,0.85686776,0.72308502,0.85231376,0.87313678,0.56062206,0.59126012,0.88734739,0.78366022,0.71035237,0.78196809,0.73447299,0.88604183,0.89670245,0.72245441,0.86185912,0.84376729,0.72038608,0.67667293,0.67564569,0.64957021,0.5128948,0.50844482,0.47321749,0.38451433,0.49635133,0.55719451,0.41441449,0.48636197,0.54900099,0.65256134,0.78080005,0.9303921,0.95299204,0.68763849,0.62483303,0.55830595,0.35792733,0.23566213,0.2042857,0.24623942,0.095603558,0.22388966,0.13160546,0.089910383,0.10438611,0.046141569,0.16485572,-0.064741944,0.079929796,0.16283398,0.12501455,0.43911897:1
0.3160304,1.0345263,2.5256104,3.9027094,2.3934459,0.41920865,-1.0030248,-1.0651012,-0.33089898,-0.46347516,-0.68668938,-0.98274034,-0.411896,-0.60323459,-1.0302274,-0.56563156,-1.0030611,-0.95210866,-0.95684136,-1.1508289,-1.2421446,-1.3006424,-1.2657616,-1.5724465,-1.4905586,-1.5436712,-1.7498134,-1.7155002,-1.7825207,-1.8647317,-1.721542,-1.7409749,-1.698142,-1.1774286,-1.0987553,-1.0055653,-0.39328879,-0.12945792,0.13352806,0.49237236,0.61264523,0.79078966,0.96285742,1.0024821,1.1051105,0.94878925,1.0509682,1.0324254,0.76817666,0.82553218,0.77530511,0.66127375,0.68087398,0.56330331,0.57399265,0.77402431,0.60313209,0.64932932,0.70652539,0.46530869,0.8248869,0.65554183,0.55709528,0.63621611,0.47626458,0.46419058,0.37133395,0.54297943,0.22136272,0.25743794,0.31513015,0.19356083,0.25288218,0.61226903,0.91260079,0.86152597,0.62402278,0.5477932,0.39062777,0.21825289,0.25624803,-0.004380252,-0.15323704,-0.078978457,-0.046626029,0.0029555131,-0.050973196,-0.22434381,-0.142418,-0.056718622,-0.11689388,-0.068066912,-0.036429407,-0.18581283,-0.15902021,0.057148761:1
0.73148234,0.835888,1.0080201,1.6623269,2.3611783,2.5114375,2.1656241,1.7693083,1.4419866,0.85476836,0.12921595,-0.023226234,0.36002532,0.43798453,0.093518703,-0.050475549,0.15327347,0.31745816,0.17364803,-0.17746256,-0.43330307,-0.51455464,-0.56017132,-0.56675241,-0.55796851,-0.65277813,-0.7412633,-0.72066311,-0.78148443,-0.96769335,-1.0322923,-1.0088992,-1.2069145,-1.4851195,-1.5274542,-1.6356439,-1.9804521,-2.0489191,-1.8642917,-1.9551634,-2.0741558,-1.8677786,-1.7251716,-1.8116558,-1.7556014,-1.4940243,-1.2678466,-1.0680056,-0.83412425,-0.7061212,-0.60100645,-0.37370514,-0.26451167,-0.19900011,0.12589989,0.26440011,0.034778448,0.1206123,0.43802658,0.38900707,0.29177872,0.43957255,0.45491121,0.34725408,0.43226671,0.55224454,0.48694007,0.41883289,0.46747485,0.47725622,0.47787763,0.58199783,0.59486476,0.48074548,0.49627447,0.58322445,0.57958855,0.56889533,0.55477007,0.55695331,0.6724384,0.7721244,0.82956916,0.95502232,0.9211847,0.64969517,0.52577456,0.59713703,0.56861495,0.51733145,0.59702145,0.59431013,0.45959866,0.50518774,0.65658262,0.4904695:-1
0.64059666,1.7076401,3.871794,3.709475,1.6353485,-0.49970753,0.30255111,1.2235484,0.86325645,0.85429816,0.72436613,-0.41530233,-0.70833543,-0.551624,-0.58542724,-1.7583782,-0.98215898,-1.2033072,-1.322379,-0.96994801,-1.505512,-1.5007307,-2.4376713,-1.944601,-2.1773125,-2.1654456,-2.1598565,-1.9217227,-1.5589615,-1.2745247,-0.90085198,-0.4738973,-0.10908845,0.0030073545,0.295226,0.57728898,0.69627804,0.64270561,0.64070182,0.82459084,0.58201584,0.51581037,0.71800578,0.6051398,0.82693441,0.41372195,0.24337972,0.61736587,0.62270208,0.46436776,0.49769992,0.44485978,0.3537225,0.27002942,0.30259758,0.27440004,0.15414307,0.056848911,0.31814198,0.06444372,0.14592979,0.36112087,-0.14421116,0.22205699,-0.024640807,-0.012687456,0.040490792,0.045745205,-0.22882818,0.010619432,-0.19029031,-0.065198703,-0.057923581,-0.072175175,0.015025597,-0.053442102,0.4747676,0.54241979,0.78573068,0.77391644,0.45427321,-0.05616224,-0.093675197,-0.18540185,-0.19759134,-0.41380761,-0.12708003,-0.23805816,-0.36257413,-0.025180292,-0.089570705,0.052523808,-0.14616146,-0.21829645,0.35291896,0.29315839:-1
0.49312853,-0.16531586,0.15139728,-0.16919048,-0.11642917,-0.29158872,-1.1011008,-0.38796402,-1.0501215,-1.3373678,-0.50359082,-1.2553884,-1.0443392,-0.90071757,-1.4514778,-1.2634857,-1.5540015,-1.5079502,-1.2979431,-1.3895699,-1.8539678,-1.708668,-1.769196,-1.6305065,-1.6557639,-2.4644588,-1.4729503,-1.7535522,-1.9228162,-0.74682062,-1.0156557,-0.64048414,-0.52294144,-0.052853454,0.057584625,0.10352442,0.44235925,0.30483113,0.80033719,0.21629253,0.19550988,0.54598173,0.4409268,0.45539944,0.22009104,0.37561192,0.59150428,0.37122716,0.41065821,0.44210139,0.2929463,0.28973057,0.44326661,0.41266916,0.20249362,0.2928399,0.52201393,0.67287818,0.89096026,0.40130423,0.28739834,0.22689834,0.34787474,0.53805356,0.33577318,0.70664854,0.87434171,0.98186897,0.9720852,0.59325369,0.42947994,0.36207243,0.21271843,0.33685861,0.11721065,0.031787576,0.28446482,0.16237337,0.18767582,0.28578458,0.2535072,0.42735803,0.39553072,0.2836868,0.46953609,0.43285973,0.44751303,0.45728661,0.75961942,0.83961745,2.0794437,3.2302551,2.7598046,2.4225612,1.2404364,0.18496945:1
1.0760589,1.4729932,1.5853609,2.593772,3.2723322,2.5665357,1.7176778,1.1175359,0.25415481,-0.17146171,-0.15830402,-0.13241443,-0.016520662,-0.028476062,-0.097867483,-0.18181096,-0.41044123,-0.57686734,-0.78919741,-0.98702096,-1.0347715,-1.1917416,-1.2055284,-1.0468641,-1.0866698,-1.0506917,-0.9906237,-1.2291182,-1.3663573,-1.3190876,-1.4391145,-1.4785257,-1.3532026,-1.577181,-1.8687929,-1.600751,-1.3830248,-1.7265472,-1.8422694,-1.4400553,-1.2622454,-1.3131299,-1.0120294,-0.69453351,-0.74138017,-0.57857127,-0.095896962,0.081785593,-0.06174114,-0.11866671,0.075298668,0.44138498,0.6247572,0.45796393,0.34159504,0.42277322,0.39717469,0.36704887,0.38708415,0.3102577,0.38777445,0.31858306,-0.038678809,-0.0077212205,0.17557705,0.20876378,0.24151261,0.1269552,0.29044469,0.55446158,0.37808547,0.47235677,0.85878241,1.0383436,1.224478,1.229995,1.0596159,1.1213518,1.0428477,0.65823202,0.59543576,0.67191914,0.49692921,0.62499103,0.76407756,0.44438997,0.40344772,0.51332425,0.27884435,0.22380606,0.32179402,0.12522785,-0.09792865,0.042913517,0.23230105,0.1127158:1
0.75668095,1.9939374,2.9188187,1.6314611,0.14965259,-1.2783955,-1.2688683,-0.23274184,-0.39015098,-0.33556601,-0.50812949,-0.53009594,-0.46491732,-1.0748192,-1.0457869,-1.0779969,-1.2321976,-1.2604454,-1.3449784,-1.2384383,-1.6228899,-1.5955513,-1.584802,-1.5645673,-1.3947825,-1.8646846,-1.8384459,-1.8059927,-1.7463308,-1.9360269,-1.6822875,-1.7924333,-1.6082228,-1.201061,-1.1797543,-0.94808404,-0.35476197,-0.27083976,-0.16025539,0.52787591,0.36743348,0.54021532,0.76598134,0.52431307,0.85289037,1.1108584,0.67051151,0.9501362,0.83264635,0.83166634,0.77368724,0.65623773,1.0614708,0.55934208,0.60512594,0.67193736,0.8599991,0.78700308,0.64008929,0.73173241,0.75548127,0.95328134,0.85532857,0.44650884,0.74639756,0.81877342,0.38987784,0.6011577,0.62620499,0.52545236,0.54347539,0.29568603,0.77802727,0.96218489,0.76077514,1.1674645,0.79333119,0.66711935,0.75369948,0.38943087,0.53004018,0.29926768,0.23003887,0.18363047,0.19650833,0.40582704,0.12831927,-0.19167565,0.1000771,0.22134767,0.32135834,0.17298435,-0.2708667,0.17463995,0.37784662,-0.045403648:1
1.6156806,2.624588,1.6999076,1.6757652,0.29811621,0.021736392,0.87619074,0.6468895,0.4107476,0.16658331,-0.25412778,-0.83364598,-0.76670936,-0.93468521,-1.0266553,-1.1424775,-1.111296,-1.1240438,-1.2615288,-1.351113,-1.425616,-1.4031961,-1.5596195,-1.7171129,-1.7561187,-1.8562779,-1.9804337,-2.0940137,-2.0938302,-2.2333489,-2.0952845,-2.0975296,-1.9164711,-1.612255,-1.4144518,-0.85107907,-0.45018587,-0.24302769,0.12592845,0.44640644,0.60110097,0.66772961,0.79090522,0.77676871,0.67765219,0.66114096,0.62785504,0.54221129,0.57021533,0.59092476,0.58797018,0.57874621,0.52394841,0.58173166,0.5834322,0.60259823,0.65571477,0.60676622,0.66444889,0.5273163,0.58243659,0.66620228,0.59128772,0.52918358,0.49680488,0.58983881,0.45435132,0.41292394,0.49453396,0.48516905,0.49639896,0.40302107,0.54171184,0.63900347,0.71683091,0.94474337,0.85878845,0.60659317,0.57862032,0.5366307,0.34552744,0.24003206,0.24136537,0.2898527,0.19494484,0.22473317,0.30970755,0.20462055,0.21263906,0.18422802,0.19733423,0.22402272,0.23993173,0.14706159,0.23653446,0.46080801:1
1.8763402,2.0949432,2.0096315,1.2110545,-0.86976721,-1.037898,-1.5065568,-1.6621312,-1.7144999,-2.058363,-2.0362482,-2.5218031,-2.5846491,-2.9614963,-3.0144511,-2.9544267,-2.5339321,-1.9709744,-1.2559629,-0.43838206,0.049713856,0.71138619,0.84968512,0.98846164,0.96568129,0.87553362,0.76091078,0.76941208,0.65352276,0.65268197,0.57507564,0.5225663,0.5359249,0.46707148,0.42014021,0.45719472,0.32432486,0.33795966,0.39065042,0.31351527,0.33009651,0.28714876,0.23194429,0.28637966,0.22583034,0.24609452,0.25954493,0.23433664,0.28988412,0.21606836,0.20859193,0.17459766,0.15478193,0.24624704,0.21117761,0.15842111,0.23586755,0.21904891,0.25404915,0.27155506,0.1601355,0.19195217,0.22542692,0.18010204,0.30865175,0.1100423,0.22120786,0.18754781,0.10402497,0.22174906,0.11258932,0.15934472,0.1580951,0.14940205,0.23927785,0.18227123,0.1365123,0.22511659,0.15080858,0.22137133,0.23052177,0.31213686,0.68964207,0.68726796,0.6739282,0.48256977,0.15736797,0.03684197,0.10577335,0.046108058,-2.4534395E-4,0.095611146,-0.076761549,0.18631463,0.093712149,0.20007529:-1
1.4044241,2.1289175,2.416292,2.5858338,2.5820968,2.1239733,1.4743078,0.86903996,0.26981487,0.049066063,0.17744697,0.054154289,-0.040206611,0.1427454,0.067400948,-0.032539759,0.051486774,-0.30060314,-0.73295114,-0.63398668,-0.52169173,-0.63176253,-0.73926564,-0.90187273,-0.93772599,-0.77356255,-0.7725235,-0.95434727,-1.1442874,-1.348356,-1.4485036,-1.42576,-1.4977118,-1.6657739,-1.7517728,-1.7333308,-1.7286307,-1.7997792,-1.8273114,-1.7028212,-1.5721691,-1.5812227,-1.5739457,-1.3639384,-1.100121,-0.94785202,-0.79295181,-0.65146552,-0.58289978,-0.3519349,-0.073959186,-0.09489644,-0.085388421,0.17833589,0.25626643,0.13846469,0.18467907,0.31317999,0.34362165,0.315864,0.35823039,0.51988355,0.55886164,0.35969841,0.30534286,0.5596822,0.68086854,0.49143969,0.43477289,0.62980103,0.67714391,0.59315435,0.62969581,0.67760122,0.72294994,0.80577774,0.76888711,0.70478789,0.67045755,0.53276622,0.54678141,0.75935323,0.69836318,0.4579942,0.475298,0.54342049,0.39006044,0.30506086,0.43567051,0.4705839,0.3639035,0.37061843,0.47415499,0.57884323,0.6426173,0.49788416:-1
0.54377655,1.4578173,2.8397687,3.4633205,2.1314177,0.28359021,-0.87746433,0.055407566,0.87638209,0.74576063,0.3563326,0.2389869,0.61262719,-0.72411723,-0.76910993,-0.55197637,-0.87024871,-0.81393945,-0.95639521,-0.98834261,-0.90689577,-1.2961801,-1.3921566,-1.2626546,-1.4357516,-1.4789937,-1.6735268,-1.7559147,-1.7261248,-1.9997807,-1.8599405,-2.0996356,-1.9869872,-1.7253984,-1.8936298,-1.3086411,-0.89451751,-0.95600584,-0.38284316,0.057386499,0.052142436,0.42962488,0.68397135,0.7378562,0.91086141,0.81702008,1.018135,0.94383353,0.74010233,0.93520431,0.72790766,0.62270015,0.61048473,0.52475139,0.726029,0.76394153,0.67147802,0.52270078,0.68685517,0.67094418,0.56059067,0.70932576,0.37996988,0.34185608,0.68406127,0.38782944,0.29077456,0.389813,0.22149804,0.35409005,0.3835971,0.2185309,0.24925866,0.39199801,0.84408568,0.67287441,0.58278427,0.55902655,0.29253736,0.28052765,0.068820863,0.18991305,0.0031405204,-0.18689515,-0.13690944,-0.042242414,-0.047590629,-0.24822402,-0.12560639,-0.21217045,0.06403561,-0.089648044,-0.46801467,-0.030846465,-0.2376691,-0.16706887:1
-0.45599196,-0.65614477,-0.52700581,-0.5364332,-0.64130124,-0.44137582,-0.29416951,-0.72511796,-1.1482633,-1.1323596,-1.1308492,-1.169539,-1.0263052,-1.1054373,-1.4148244,-1.3332247,-0.98320427,-1.0477096,-1.4579836,-1.6398141,-1.5869842,-1.6125714,-1.6257862,-1.5411839,-1.5613687,-1.6530892,-1.6764349,-1.662669,-1.5340455,-1.3822419,-1.5243173,-1.7160235,-1.4495822,-0.98901339,-0.87174781,-0.87753541,-0.58605606,-0.26836675,-0.21069818,-0.094717868,0.1583725,0.24194521,0.33093919,0.65421722,0.78982389,0.55830679,0.53594576,0.85901704,0.87103123,0.56913937,0.6298992,0.83169214,0.6493963,0.53067524,0.65622375,0.5356294,0.41281322,0.59638099,0.56662113,0.29704278,0.30620777,0.36562874,0.14329081,0.11662142,0.54036929,0.80372054,0.63824052,0.63582457,0.97474592,1.1103151,0.99077695,1.0663633,1.3009222,1.3621834,1.2925522,1.2558235,1.1831358,1.0796825,1.0820313,1.0909069,1.0079373,1.0036086,1.0538069,1.0310777,1.0939127,1.1388805,0.90664353,0.71229415,0.7897246,0.86191121,0.92993308,0.97170867,0.84762976,0.7760058,0.91538898,0.63656949:1
1.8736406,2.1874467,1.5087844,1.9780172,1.7962383,0.67738586,-0.14842976,-0.53957315,-0.75872894,-0.90175483,-0.95987884,-1.1773249,-1.2501404,-1.2607268,-1.3765078,-1.4355049,-1.4462453,-1.6237191,-1.7887041,-1.7262991,-1.8446083,-2.0626155,-2.1496229,-2.2455079,-2.1872747,-2.0863684,-2.0076897,-1.9565567,-1.5772268,-1.174263,-0.95718386,-0.49567198,-0.048790909,0.21336158,0.43891711,0.5379448,0.66087856,0.88578142,0.91892835,0.77206631,0.7393265,0.92372481,0.75377858,0.602403,0.61545912,0.66860157,0.82726852,0.57916182,0.53225229,0.67632279,0.63666783,0.55800131,0.51224316,0.61786192,0.4937291,0.59587355,0.57130988,0.28175059,0.47949256,0.48696027,0.40362601,0.34452181,0.4362196,0.34902208,0.26675041,0.24229499,0.35680408,0.32386127,0.21242041,0.28930716,0.36300682,0.71080659,0.80788002,0.6833121,0.65579074,0.58518707,0.58216714,0.30494286,0.195874,0.19488465,0.18199739,0.1120193,0.044810228,0.23847719,0.072872734,0.17478916,0.095530199,0.13485073,0.18680017,0.085023698,0.22163737,0.099913325,0.15590675,0.14961741,0.039562114,0.28285073:-1
1.223899,2.5149813,2.7744978,1.6965002,-0.13858263,-0.25478365,1.077329,1.0047626,1.030641,1.1105528,0.17097497,-0.32536698,-0.7776603,-0.85305646,-0.79914988,-0.96794992,-1.0379429,-1.0345015,-1.10302,-1.2876407,-1.3073502,-1.4414625,-1.5890993,-1.6823692,-1.8400466,-1.7261829,-1.8824731,-2.0612407,-1.9701552,-2.0302232,-2.0491363,-1.950241,-1.8522501,-1.5372405,-1.227027,-0.95124285,-0.46240952,-0.10031885,0.13382968,0.41453456,0.6737358,0.84169856,0.75953123,0.82633894,0.85306428,0.73158447,0.71670208,0.86734036,0.8808069,0.71566405,0.74231215,0.8669259,0.80176607,0.7167813,0.87211863,0.85711766,0.63099256,0.6848233,0.64344915,0.62067731,0.49180797,0.60356391,0.31980132,0.12300858,0.33263522,0.16725049,0.28667693,0.06834357,0.022174157,0.30631633,0.13497825,0.28266483,0.19974463,-0.2393389,0.13024086,0.52797624,0.54014055,0.81127194,0.55636737,0.50859957,0.61896553,-0.029309839,-0.15697083,0.047588321,0.55365065,0.10114766,-0.065065164,0.15834206,0.080382908,-0.012514952,-0.31256594,0.25879754,0.37493276,-0.23239096,0.088584069,0.13639256:1
0.15020668,0.38658643,1.8514467,3.1711625,2.6586516,2.1712009,0.80498634,-1.0290281,-0.54771323,-0.088308378,-0.60023372,-0.52726638,-0.63977726,-0.46467257,-0.27580569,-1.0126205,-0.94217268,-0.65276837,-0.94351306,-1.14872,-1.0689078,-1.1973269,-1.3490007,-1.1124201,-1.6863943,-1.700894,-1.3444903,-2.025155,-1.6364708,-1.8662425,-2.1146797,-1.7395853,-1.7933878,-1.5836695,-1.4555735,-1.3418661,-0.72884906,-0.31707994,-0.060493482,0.16516132,0.50414869,0.92411702,0.89329492,1.0589658,1.2080998,1.1922239,1.127093,0.94579878,1.0997365,0.87124455,0.69781586,1.0763263,0.63614459,0.54447649,0.98918546,0.64274815,0.51785458,0.4849622,0.68288567,0.43551863,0.44164364,0.42005399,0.51099011,0.62350191,0.23031706,0.41015427,0.31536873,0.37799879,0.5234909,0.16759965,0.36473858,0.27103755,0.34091868,0.69182982,0.8414201,0.77056674,0.62979628,0.59473695,0.39523743,0.2888523,0.022219096,-0.1102343,0.024821496,-0.21823861,-0.084417767,0.031211948,-0.1277159,-0.30567466,-0.31108671,-0.19813277,-0.14490439,-0.23614708,-0.13533187,-0.24072958,-0.28498355,0.21213431:1
0.43779223,0.67367903,2.3641329,3.299659,1.8592367,0.78023315,-0.62695151,-0.81829076,0.34657927,0.39193594,-0.042022666,-0.082843897,0.027795131,-0.82431683,-0.97943149,-0.83789588,-1.1380056,-0.9564567,-1.1260166,-1.1798617,-1.2468014,-1.4698437,-1.5070016,-1.5835112,-1.5314238,-2.040942,-2.2083742,-1.7718986,-1.9709917,-2.1824467,-2.0416371,-1.9966405,-1.7813776,-1.4881994,-1.186105,-0.78367733,-0.70831999,-0.32165043,0.35856761,0.31628764,0.50259069,0.86109581,0.73646961,0.99810455,1.0343952,0.79546566,0.97060771,0.88344466,0.8228949,0.61067303,0.65987372,0.64684021,0.4611027,0.7708364,0.46377355,0.50858005,0.62330695,0.59742503,0.44867042,0.58460856,0.55903792,0.28904181,0.71991542,0.43757124,0.24321288,0.53953313,0.19203854,0.36731454,0.3517963,0.28109207,0.3226241,0.24535812,0.2776227,0.4998088,0.82817954,0.73274319,1.0221043,1.0322724,0.51372632,0.39286908,0.33801047,0.35643674,0.047662288,0.075818975,-0.014602828,0.093766542,0.045865363,0.31625556,-0.12182036,-0.27029478,0.39358059,0.033227086,0.033721679,0.15508726,0.03198766,0.2337134:1
0.1372554,1.6368046,3.3389392,2.8709939,2.2654466,0.67691883,-1.2431003,-0.40510293,0.18722024,-0.35645723,-0.31345632,-0.07635705,-0.049202414,-0.68526964,-0.83086948,-0.52865779,-0.76963416,-1.0425053,-0.7736739,-1.1963924,-0.99026874,-0.84958358,-1.3753242,-1.4785871,-1.4101935,-1.6290322,-2.0598035,-1.4668653,-1.7270771,-2.1762979,-1.9423007,-1.8261897,-1.9295353,-1.3503182,-1.3256533,-0.75084005,-0.32070007,-0.52734444,0.30045071,0.37266149,0.74358464,1.0709123,0.9133492,1.2326332,0.86927611,1.1682756,1.2084919,0.84344801,0.95919977,0.65343431,0.92040062,0.80239076,0.46528465,0.56935757,0.46699627,0.96164748,0.63977526,0.32978852,0.42654579,0.68482852,0.61320527,0.13423234,0.63695844,0.49817448,0.36354567,0.51855095,0.30600745,0.34500687,-0.20215972,0.47388037,0.36472618,0.057231852,0.1904532,0.4963161,0.83611703,0.87626509,0.95807693,0.57358496,0.10948298,0.33262589,0.17236942,-0.23543652,-0.11539445,-0.23067351,-0.19901669,-0.050444323,0.050939249,-0.2140543,-0.40339865,-0.13535183,-0.1417094,-0.30070054,-0.16567956,-0.064258262,-0.36593121,-0.39325942:1
1.5423648,2.2054099,2.0003195,1.5515938,0.95155931,0.36457029,-0.15658825,-0.23716865,-0.014344756,-0.11731519,-0.39941987,-0.28717459,-0.13251307,-0.2081434,-0.31363833,-0.59068823,-0.92449381,-0.92075448,-0.824658,-0.95990161,-1.0486444,-0.93051969,-0.91374985,-1.0696706,-1.1178172,-1.068652,-1.1574786,-1.3548394,-1.4870033,-1.5074018,-1.48477,-1.5255938,-1.6516123,-1.7298139,-1.7227859,-1.7664353,-1.8223636,-1.7581424,-1.6514642,-1.5781861,-1.4757296,-1.3204581,-1.1536037,-0.99282614,-0.7994288,-0.54667773,-0.30773461,-0.1640531,-0.019585773,0.22321843,0.360813,0.27641438,0.26881076,0.45751124,0.56850619,0.55024006,0.58308627,0.58889058,0.49504371,0.50257187,0.55623966,0.47303524,0.47062234,0.5736829,0.4992745,0.40506503,0.49633045,0.55278916,0.48435185,0.44467202,0.46503334,0.51171972,0.59172273,0.63905587,0.62359548,0.65038212,0.73435597,0.81846462,0.94216049,1.0518811,1.0447851,1.07863,1.2547778,1.2964906,1.130142,1.0916216,1.1822506,1.096765,0.96284004,1.0148811,1.0000778,0.87804008,1.0171559,1.0771717,0.55727908,0.055576834:1
0.69250645,1.5643993,2.713644,2.9425774,1.7597325,-0.26248261,-0.23454662,0.58009068,0.49659279,0.41037192,0.32828183,0.2330151,-0.32225913,-0.3919215,-0.55524648,-0.66176362,-0.73494033,-0.75552765,-0.80231498,-0.98568961,-1.1208778,-1.1551976,-1.346829,-1.496043,-1.5482506,-1.7911131,-1.9799163,-2.0448379,-2.0705324,-2.2869392,-2.2807475,-2.2317454,-2.15044,-2.0684735,-1.5321545,-1.1697472,-1.0461838,-0.23153766,0.063167347,0.13466271,0.50182074,0.76039972,1.0307195,0.65444166,0.86271631,0.83980173,0.84999941,0.77870231,0.55100149,0.76830441,0.6291346,0.56064312,0.61232055,0.67321837,0.67322852,0.56951371,0.79925665,0.66064446,0.37792076,0.78154055,0.58662643,0.40808372,0.57165135,0.48108583,0.52600021,0.4499426,0.46000764,0.37774823,0.20158427,0.24914728,0.1930196,0.22459407,0.28850582,0.33735845,0.55382123,0.70212803,0.53705737,0.48282887,0.4749892,0.15967629,0.22115506,0.046991926,-0.15674858,0.22585131,-0.11655147,0.19152075,0.018159053,-0.027625379,-0.0050951034,0.017750599,0.14650938,0.09158258,0.13423925,-0.11527231,0.22106745,0.24449746:1
1.0749812,1.0965125,0.91769875,1.4957191,0.68845953,-0.41575514,-0.60610359,-0.65186328,-0.70173364,-0.78737533,-0.93286744,-0.96000116,-0.95878753,-1.2235578,-1.2750845,-1.3622362,-1.5447347,-1.5210024,-1.6257606,-1.7311794,-1.9017064,-1.8171205,-1.831736,-2.0322566,-1.7775598,-1.6527526,-1.6311086,-1.4048149,-1.1009742,-0.89703202,-0.42032839,-0.023263512,0.33421179,0.79541644,0.93570667,1.0719338,1.3849463,1.3838677,1.3283809,1.4015816,1.2318692,1.1058422,1.0221802,0.86987652,0.87763734,0.72418934,0.66508221,0.75692607,0.66477599,0.57201866,0.54191041,0.61424874,0.45446961,0.30557168,0.51276567,0.34588602,0.24299901,0.28726903,0.035608568,0.16068652,0.27685588,-0.055748202,0.051223783,0.064962152,-0.0099430585,0.012343568,0.020955253,0.34303428,0.35033114,0.42146774,0.28606819,0.045210707,-0.1678592,-0.23848344,-0.3506258,-0.36283601,-0.43504192,-0.41915261,-0.19199037,-0.38622736,-0.33400315,-0.1622077,-0.38309263,-0.27201373,-0.14298331,-0.31666228,-0.15938695,-0.33917865,0.27420546,0.25904459,1.3007494,3.0112042,2.2381786,1.8388487,0.98280131,-0.16258157:1
0.93633579,2.2879492,3.7139248,2.6314533,2.3472057,1.3642251,-0.53709164,0.23894284,1.0844948,0.70575583,0.61224166,0.81037421,0.50588513,-0.24707728,-0.68009062,-0.44321677,-0.72477827,-0.72399736,-0.8519025,-1.0509563,-0.80863899,-1.1607743,-1.3018797,-1.2507989,-1.5255968,-1.3475694,-1.5225983,-1.7867377,-1.6548114,-1.8099895,-1.5770626,-2.0981346,-1.9255828,-1.6006608,-1.6169615,-1.4785501,-1.1758206,-0.82619001,-0.57794676,-0.16820225,-0.12510301,0.5729127,0.44601727,0.35455247,0.85794995,0.84104063,0.90098195,0.85505253,0.90054532,0.68300533,0.68611787,0.78541314,0.41603306,0.62208512,0.50424361,0.46607759,0.47242522,0.55160398,0.52107382,0.50529816,0.30387421,0.52172196,0.5242695,0.15090938,0.47799232,0.34510146,0.30231762,0.46727892,0.072301116,0.25313497,0.3025627,0.31847554,0.29731747,0.7206253,0.68561961,0.51933394,0.4133342,0.32374913,0.27199036,-0.17148534,-0.21685283,-0.034204828,-0.032132963,-0.56648363,-0.18169001,-0.090850808,-0.22823035,-0.23048607,-0.45437712,-0.31385517,-0.16835278,-0.23006802,-0.34598791,-0.32083286,-0.15670979,-0.11180636:1
1.7655778,2.7365064,3.1220208,1.9741164,-0.20114083,-0.57294754,-0.8171734,-1.3829964,-1.2795959,-1.4614506,-1.6288777,-1.7437804,-2.0807924,-2.2395965,-2.4210745,-2.5352793,-2.2132074,-2.3210987,-1.5223166,-0.61030621,-0.53318812,0.28708945,0.55613036,0.82606401,0.90926885,0.90504036,1.0124162,0.7550718,0.82642206,0.78584311,0.69747413,0.70140166,0.58177468,0.51897645,0.4053626,0.44918356,0.37948221,0.26162962,0.3896318,0.24220051,0.28581441,0.13971148,0.11702733,0.10161039,-0.016433925,0.1190827,-0.032056744,-0.025446952,-0.0040904404,0.0012857829,0.056539171,-0.094801446,-0.095070728,0.0078464934,-0.085501445,0.0031600065,-0.095048605,0.060342887,-0.098384668,0.015449283,0.028541057,0.087749218,0.10338688,0.051405769,0.0030624289,0.085818975,-0.032706953,0.0060764603,-0.017288949,-0.091792839,-0.085872067,-0.080555281,-0.017089242,-0.13069276,-0.062469291,0.031400818,-0.1694236,-0.030477155,0.26718308,-0.02723642,0.16496458,-0.016189443,-0.45253313,-0.32410373,-0.03354772,-0.25133883,-0.36693669,-0.27980629,-0.1965621,-0.34988781,-0.050861566,-0.10209959,1.3539758,2.883938,2.0255926,0.19147849:-1
0.64102476,0.78144862,0.88416609,1.235363,1.7822533,2.2190292,2.3508011,2.1110252,1.5957958,1.063145,0.52142782,0.089056841,0.15312644,0.23243566,-0.11493769,-0.16519731,0.0050114648,-0.147887,-0.06105321,0.0364535,-0.44410712,-0.67930921,-0.52997336,-0.64674373,-0.70794328,-0.66332382,-0.86068289,-0.95978567,-0.92760524,-1.1408748,-1.3644748,-1.2862324,-1.193629,-1.3326165,-1.4695059,-1.4895899,-1.6006902,-1.7773328,-1.810176,-1.7355971,-1.7049569,-1.7245919,-1.7077957,-1.5944493,-1.3966984,-1.1870547,-0.99165905,-0.77086462,-0.55761568,-0.38746259,-0.1684685,0.115819,0.31440818,0.37648685,0.42047364,0.49756688,0.5742429,0.64786069,0.66169844,0.60514873,0.62955517,0.71172604,0.67400771,0.61554664,0.67771784,0.72072449,0.6626563,0.61586575,0.66175217,0.71094751,0.61472699,0.52311663,0.58872297,0.59110691,0.58550909,0.69481236,0.54690974,0.36458426,0.66020785,0.86848308,0.64102476,0.5403233,0.63558105,0.70833353,0.74262672,0.61751985,0.58715767,0.82479075,0.96971208,0.92599815,0.5296564,-0.13748443,-0.45768497,-1.0612424,-2.0233606,-1.3760141:-1
0.87576018,1.0602834,1.1660909,1.5715622,2.1504463,2.4237919,2.2931347,1.9796383,1.5372766,0.95307152,0.36338671,-0.03009182,-0.077746314,0.035657347,-0.091948847,-0.37410644,-0.42463293,-0.28266677,-0.1808281,-0.22850174,-0.43882662,-0.58027001,-0.52448979,-0.52729025,-0.65758134,-0.71662846,-0.78157868,-0.96682669,-1.0441131,-0.96231815,-1.0699085,-1.3744601,-1.4913509,-1.4951208,-1.668501,-1.815334,-1.8172514,-1.8833377,-1.9528679,-1.8945627,-1.8401506,-1.8064295,-1.6883992,-1.556156,-1.4991539,-1.4178095,-1.1669677,-0.82307673,-0.60604045,-0.5078833,-0.33237951,-0.077746314,0.079471093,0.11352411,0.1541877,0.20355221,0.21084478,0.30881037,0.45302921,0.39902648,0.34746604,0.52289449,0.64229101,0.65671139,0.64230588,0.42484677,0.34746604,0.59433565,0.49572307,0.1541877,0.26345748,0.46599918,0.41189216,0.46553855,0.54877886,0.46343305,0.41446862,0.39577683,0.34746604,0.38200944,0.47640252,0.65671139,0.88084565,0.8765733,0.74690795,0.69599093,0.56269199,0.48920349,0.62115699,0.6498634,0.7211375,0.9287882,0.75956222,0.56651483,0.86184355,0.8615456:-1
-0.29433117,-0.6775513,-1.2341813,-1.4942151,-0.74850079,-0.54260662,-0.71105018,-0.94434808,-1.172303,-0.92882288,-1.0067115,-0.91964843,-1.2267554,-1.3506054,-1.5204872,-1.5370839,-1.908971,-2.2047295,-1.8224055,-2.2822204,-2.2578037,-2.2155735,-1.9696635,-1.5925876,-1.5515565,-0.87581654,-0.8742252,-0.45636101,0.45571087,-0.091060994,0.38117312,0.61649676,0.46349122,0.73274252,0.62444937,0.61904806,0.64406826,0.54900925,0.67983418,0.68933928,0.51494122,0.72387267,0.24105657,0.90690588,1.0540478,0.42309794,0.65052011,0.51321352,0.72150478,0.62036473,0.99956057,0.33745647,0.54580452,0.86672632,0.35589545,0.50112661,0.34693254,0.4791124,0.33988587,0.23565716,0.39442266,0.70854371,0.20533819,0.25820315,0.6247042,0.41125727,0.51214138,0.51291039,0.95973485,0.8822961,0.68511355,0.66025998,0.62428064,0.46354036,0.21402877,0.24363357,0.18588185,0.34237035,0.36129715,0.085302729,0.28139417,0.47881699,-0.39921605,0.31190595,0.74958529,-0.25223341,0.34240825,0.38549853,1.203324,2.49066,2.2772273,1.9773481,1.2078131,0.20156706,-0.8893552,-1.1228739:-1
0.5622482,1.2482263,2.138522,3.3979096,2.4893368,2.1362093,1.5944177,0.10480252,0.18004321,0.37961863,0.20185274,0.077896856,-0.088256617,-0.46343284,-0.872883,-0.74920511,-0.7470112,-1.0063887,-1.1121702,-1.2161593,-1.2845845,-1.3343599,-1.401274,-1.4114717,-1.3777348,-1.6860678,-1.7648285,-1.6559934,-1.8599434,-2.0229406,-1.9597021,-1.9378344,-1.8688981,-1.7814562,-1.6728711,-1.1833427,-0.73667317,-0.48116489,-0.21960743,0.1564008,0.50752827,0.81407372,0.67637843,0.85479233,0.93231543,0.87180649,0.95379931,0.77716127,0.82421274,0.6020635,0.54503347,0.67507057,0.67928226,0.62222422,0.40252801,0.57093539,0.53209804,0.63037469,0.31609001,0.33754484,0.3899561,0.49900117,0.31925424,0.40470043,0.38332249,0.21225657,0.2111446,0.14737809,0.28442334,0.36099604,0.30566991,0.087239338,0.33808449,0.70695067,0.59254589,0.70908441,0.39906677,0.29020937,0.48021765,0.18137034,0.080515697,0.029967635,0.026970318,-0.063522203,0.018219818,-0.19569637,0.017465854,-0.026782518,-0.31962018,0.014184541,-0.18758113,-0.038432868,-0.12142869,-0.15857635,-0.0035939414,-0.27150372:-1
0.68138107,0.69872029,2.3085323,3.2013299,2.0057489,1.1982078,0.0017246397,0.12822404,0.98156717,0.83822967,0.81583512,0.71819919,0.27614138,-0.78515701,-0.74610247,-0.63017192,-1.1242459,-1.0464207,-1.1361928,-1.5237298,-1.0194399,-1.3338684,-1.6141365,-1.5148716,-1.7453212,-1.405058,-1.8618959,-1.8884385,-1.8013186,-2.1474184,-1.6765014,-2.0410364,-1.9461336,-1.6654614,-1.7266584,-1.116417,-0.98200987,-0.78358888,-0.10833111,0.20946856,0.26776771,0.49616331,0.74587226,0.98255827,0.90688095,0.8245124,0.96131051,0.78785032,0.85148369,1.0071089,0.67616149,0.41475396,0.52623293,0.82055494,0.75934186,0.52526776,0.65999763,0.79498807,0.63944465,0.76927604,0.57335495,0.49320346,0.62911513,0.28437161,0.43392192,0.41489831,0.1450843,0.25598142,0.28665935,0.29902773,-0.019791938,0.48680966,0.13029657,0.36784499,0.7923259,0.72886927,0.81990911,0.28215201,0.288499,0.376058,0.013059514,-0.070014612,-0.091061469,-0.091925857,0.074580142,-0.016078931,-0.2186583,-0.095913242,-0.22705751,-0.059847892,0.0075215342,-0.094511279,7.7464183E-4,-0.13210669,-0.071404345,-0.10685886:1
0.50504272,0.80024798,1.0476767,1.6014455,2.4006891,2.7304464,2.3052418,1.6404921,1.0557388,0.43174293,-0.10203908,-0.25647312,-0.14279031,-0.07252206,-0.1020255,-0.15308149,-0.19862451,-0.11337716,0.085583918,-0.047141058,-0.55972156,-0.71056218,-0.41244456,-0.49643148,-0.94818309,-1.0120763,-0.79379134,-0.82235718,-0.9782269,-1.0287371,-1.0693469,-1.152926,-1.2388283,-1.3016555,-1.3203421,-1.3924933,-1.5558481,-1.6200558,-1.5908037,-1.6650127,-1.7283359,-1.6567183,-1.6521545,-1.6931115,-1.5725372,-1.4810434,-1.524749,-1.3501415,-0.94818309,-0.75616909,-0.80522935,-0.75373408,-0.53937812,-0.32827113,-0.14833016,0.022377693,0.10731776,0.1227293,0.18803954,0.24676528,0.20791351,0.23417131,0.38582696,0.43832478,0.39796292,0.48392274,0.63786652,0.70269939,0.67425519,0.57576768,0.54822604,0.71021998,0.79568788,0.59212062,0.42509402,0.55324641,0.73256746,0.7879305,0.8906648,1.0617865,1.0557388,0.87274706,0.77912278,0.78680049,0.70162018,0.60412502,0.69389,0.84996252,0.85687634,0.81574021,0.86830564,0.86102645,0.75964128,0.80286578,0.84960266,0.51010671:-1
-1.0101742,-0.8647034,-0.7659573,-1.0819068,-0.79498156,-0.58739934,-0.93700776,-0.95779035,-0.98305556,-1.1843672,-1.091682,-1.1795999,-1.2759349,-1.236349,-1.3889997,-1.4298495,-1.4201431,-1.5728762,-1.6923451,-1.6828447,-1.7545439,-1.9666656,-1.9535004,-1.6906844,-1.6339962,-1.8384511,-1.7720385,-1.2956525,-1.116578,-1.1670937,-0.84930905,-0.59033502,-0.41059909,-0.058455257,0.14967036,0.26297753,0.35220543,0.41899505,0.3477222,0.32675772,0.63740125,0.67428426,0.59330165,0.7143127,0.62275858,0.62246246,0.71468604,0.61940304,0.62423928,0.73212494,0.74240865,0.64694569,0.60310008,0.71610315,0.81203443,0.78015619,0.78989661,0.8224502,0.78663774,0.85116069,0.95186875,0.93115282,0.92787075,0.99087669,1.0139786,1.0583837,1.1420664,1.0630634,0.81048035,0.65457347,0.65446129,0.57660666,0.44956913,0.44998978,0.48251915,0.48204833,0.4331813,0.37490491,0.40253144,0.39088045,0.32860298,0.35860815,0.37823008,0.34434165,0.37582607,0.38538426,0.46837176,0.75209805,1.24157,1.9859709,2.2217314,1.5941004,0.9466064,0.37033602,-0.28751865,-0.43359237:-1
0.69272211,0.74811534,0.7895437,1.3499099,2.0051231,2.296517,2.3925257,2.3843048,2.0566038,1.51135,0.99596477,0.45197087,0.11152249,0.28886376,0.38819086,0.023259814,-0.11674095,0.063520423,0.0077666692,-0.061391795,-0.011393609,-0.26326954,-0.55536813,-0.50673249,-0.47939124,-0.59438626,-0.60128189,-0.65167764,-0.8855077,-1.0335869,-1.0057775,-1.0627652,-1.2912705,-1.4645209,-1.4906952,-1.5822056,-1.8189217,-1.9715614,-1.9640453,-1.9743073,-1.9814005,-1.8938478,-1.8659322,-1.8464611,-1.6065654,-1.3941083,-1.4127136,-1.2546842,-0.81484632,-0.5524232,-0.53310397,-0.43711763,-0.21204948,-0.014944183,0.062382325,0.089578684,0.18891791,0.27292283,0.23431256,0.24676252,0.37954692,0.401777,0.30507193,0.33048861,0.42926546,0.38913504,0.34681849,0.51717746,0.6777657,0.58726757,0.46581249,0.50814773,0.56159913,0.54618521,0.51191477,0.40083637,0.25937232,0.316235,0.55973799,0.70718852,0.71790117,0.74766634,0.67913471,0.45174133,0.37791971,0.46979054,0.42619658,0.37813984,0.5047644,0.58074608,0.54370142,0.52014228,0.50636635,0.56090936,0.58821369,0.29966722:-1
1.2497142,0.86570383,-0.12114912,-0.5005106,-0.65795092,-1.3527062,-1.8255116,-1.9723096,-1.98656,-2.0441174,-2.4235607,-2.4858927,-2.2979282,-2.6742293,-2.6230374,-2.2925873,-1.9214344,-1.5349643,-0.77979434,-0.098910042,0.24753729,0.7107344,0.86902189,1.0538628,0.99258888,0.47653672,0.82209852,0.37644067,0.33334323,0.52730579,0.45662653,0.3301827,0.3344539,0.20741139,0.22624639,0.026610062,0.14278314,-0.010408575,-0.050763214,-0.064003779,-0.057103389,-0.010881226,-0.086624595,-0.072816688,-0.010354802,-0.15469198,0.071867029,-0.061860875,0.018251822,0.17386325,-0.040628696,0.10416445,0.13707723,0.057566574,0.15604063,0.065996296,0.11521939,0.1706731,0.10598144,0.30725559,0.069986989,0.16137191,0.2254547,0.058882239,0.17005538,0.28304579,0.051532095,0.33157316,0.30992335,0.19352991,0.34170179,0.28463376,0.38449474,0.29158293,0.3924264,0.5763087,0.38403099,0.67741638,0.77748215,0.95855473,0.74693764,0.62591159,0.28167521,0.3946828,0.21833376,0.33006332,0.21721235,0.17161918,0.27617869,0.20711296,0.47200518,1.3996258,3.3496009,2.7055933,0.27166896,-0.11207688:-1
0.36403282,1.4715364,3.0356105,3.3170816,1.8895868,0.20388102,-1.3955946,-0.64823346,-0.29267021,-0.9651853,-0.67807086,-1.0026936,-0.62339658,-0.61989972,-0.76588197,-0.86737684,-0.97257919,-0.77881307,-0.81301594,-0.97499578,-1.114716,-1.0173478,-1.1814726,-1.4810112,-1.3819725,-1.4867221,-1.57829,-1.6761863,-1.6915303,-1.7444949,-1.7744803,-1.7382277,-1.6282548,-1.5280597,-1.4326124,-1.0108638,-0.70154522,-0.34541254,0.010484237,0.18487607,0.63005517,0.73132226,0.85016725,0.99266986,1.1750297,1.2543173,1.1140873,1.0379457,1.0454706,0.9818487,0.86826344,0.80462491,0.8907429,0.85980781,0.70657826,0.79141569,0.82408707,0.87888004,0.76066812,0.79018996,0.79892468,0.77542089,0.71478926,0.57535681,0.69037614,0.5954735,0.44686637,0.42926331,0.33538212,0.38703855,0.32687987,0.27000627,0.36521117,0.56544474,0.67662953,0.66527452,0.49695108,0.21217455,0.18501157,0.29702362,0.15083033,-0.12691218,-0.1626199,-0.11927522,-0.11949697,-0.060797485,-0.20476261,-0.15283786,-0.16388868,-0.19308283,-0.19835534,-0.28793388,-0.20222234,-0.21000398,-0.20104334,-0.11075041:1
-0.49175734,0.035443256,1.8378725,3.0770251,1.4223204,-0.1862581,-1.7629717,-1.5778285,-0.060018411,-0.51461492,-0.76195719,-0.37880445,-0.38475724,-0.98772292,-1.1045435,-1.2415146,-1.0308915,-1.1029452,-1.743376,-0.70504009,-1.0516323,-1.7311261,-1.1281264,-1.2743133,-1.2551415,-1.5619672,-1.5239405,-1.2850845,-1.4933627,-1.6651099,-1.5034776,-1.3936914,-1.8010783,-1.3942867,-0.79620386,-0.9189735,-0.7170714,-0.26325763,-0.22877487,0.34572597,1.0421312,0.56596575,0.99529141,1.2993669,1.1040138,1.0775133,1.1040099,1.4905894,1.416708,1.0093244,1.0513035,1.0346572,0.99432499,1.1545602,1.1046787,0.94846081,1.0034019,0.98941785,1.0536056,0.94722462,0.56272371,0.83782502,1.0625337,0.66309143,0.55652261,0.53646461,0.73591991,0.68182724,0.14680471,0.54632103,0.62891913,0.2895612,0.68378213,0.66181575,0.78501531,0.54583257,0.49486659,0.31462193,-0.030838138,0.18850528,0.013532854,0.16190368,-0.11070673,-0.031227178,-0.068280996,-0.27966985,-0.45917101,-0.054900047,0.071921228,-0.50504482,-0.060237926,-0.094736458,-0.34535723,-0.36048466,-0.34180015,0.48882809:1
1.3237939,1.9914275,2.3386808,2.3495087,1.8749694,1.1355438,0.20885535,0.16838705,0.93476919,1.0701841,0.7500062,0.73373596,0.93040809,0.70905989,-0.059523091,-0.59665397,-0.69033937,-0.76534691,-0.84989613,-0.90909541,-1.0459178,-1.1246391,-1.1177964,-1.1840845,-1.2388339,-1.2754767,-1.3367017,-1.3472243,-1.3794396,-1.4242937,-1.4294279,-1.5060325,-1.5096147,-1.2813915,-1.2156769,-1.4068907,-1.4493444,-1.371223,-1.2816693,-1.2270824,-1.2797391,-1.277554,-1.2418428,-1.151218,-0.94177952,-0.75731324,-0.51686183,-0.24753561,-0.043721174,0.12236041,0.11207385,0.057165528,0.13719667,0.23081196,0.34685512,0.48037179,0.5295454,0.55223056,0.59452062,0.60163635,0.60443004,0.58472371,0.50995924,0.46927305,0.42320308,0.38505041,0.36733989,0.26091442,0.19702236,0.17729304,0.14034949,0.18030079,0.15288872,0.073643907,0.063509197,0.048546475,0.065178077,0.071869853,0.026007056,0.0039707131,-0.008008074,0.027750578,0.019493447,-0.028270327,-0.020557482,-0.0182216,0.23503091,0.51502338,1.1135884,2.195602,2.0707306,1.6529562,1.9494406,1.3020991,0.74124709,0.64370465:-1
0.51892523,0.57624325,0.64826039,0.98023195,1.5835712,2.0409823,2.0516162,1.894276,1.9179727,1.9212653,1.5506018,0.93448599,0.46480263,0.25594217,0.1816497,0.13681403,0.071463216,-0.0014641256,0.012569595,0.1523926,0.26874031,0.18739561,-0.097049709,-0.42047515,-0.60727985,-0.62105641,-0.59519324,-0.65323262,-0.73928739,-0.77563381,-0.83392278,-0.97444639,-1.0596213,-0.98350224,-0.90303322,-0.96900206,-1.1055411,-1.1978197,-1.26663,-1.338057,-1.3995399,-1.4803225,-1.5752473,-1.6059567,-1.5798028,-1.609417,-1.7012484,-1.7433746,-1.7059553,-1.6322768,-1.5314911,-1.4193901,-1.3377577,-1.2522455,-1.0982706,-0.92694294,-0.7950055,-0.64068087,-0.42275686,-0.23629778,-0.1325293,-0.0194419,0.14663791,0.28395281,0.34491222,0.42182082,0.56733606,0.69263951,0.72072177,0.72657647,0.79527229,0.85338804,0.82872018,0.80701824,0.87418949,0.91706237,0.81169608,0.68486221,0.74252352,0.91114032,0.90423974,0.67436337,0.49888821,0.54247103,0.64088678,0.63494212,0.59366344,0.60301756,0.62181013,0.61726515,0.61581687,0.64559116,0.73011319,0.82915569,0.79281013,0.56249241:-1
0.8145691,0.77047226,0.75609828,1.3824053,2.3074906,2.6592636,2.2674988,1.732183,1.4204729,1.0281642,0.29419139,-0.39718009,-0.50706511,-0.12026389,0.16559944,0.0079594078,-0.38405945,-0.64441075,-0.62331723,-0.43774344,-0.28356058,-0.24929473,-0.40437326,-0.81639546,-1.2066499,-1.0880049,-0.66938093,-0.66672093,-1.0432043,-1.1780057,-1.0643907,-1.0741326,-1.1500008,-1.1219296,-1.1197708,-1.2241623,-1.3381355,-1.4397256,-1.5439841,-1.6013158,-1.5865537,-1.5331475,-1.4346344,-1.2915845,-1.2750173,-1.4890588,-1.6010687,-1.3649012,-1.179278,-1.2854846,-1.2436381,-0.90355407,-0.69788175,-0.64972928,-0.37613512,-0.01073772,0.04196548,-0.036011093,0.17399783,0.49011252,0.50616394,0.45006713,0.61814334,0.6662216,0.56032787,0.81137118,1.1153775,0.85578377,0.5962877,0.85404471,0.99958108,0.86829491,0.91981297,0.80429885,0.34179006,0.33505164,0.774749,0.79553515,0.59811117,0.79962379,0.95002019,0.60031258,0.25564411,0.31575229,0.4986793,0.55340604,0.57876178,0.65277674,0.69545445,0.69709283,0.73793463,0.79737785,0.85889618,0.97632232,0.97364247,0.63043908:-1
0.35492536,1.4890719,2.6333119,3.033823,2.0505272,0.51714139,-1.2854731,-0.60594735,-0.12197258,-0.72733147,-0.17907583,-0.71110108,-0.43552575,-0.59816128,-1.2148404,-0.6993994,-1.0101744,-1.2052631,-0.99539016,-1.0704363,-1.2259984,-1.3661871,-1.3909215,-1.4234809,-1.4558006,-1.6424904,-1.6421572,-1.7675558,-1.9914067,-1.8067669,-1.707832,-1.7375491,-1.6656581,-1.5112762,-1.2311371,-0.94742831,-0.44142399,-0.28899649,-0.1182168,0.52036387,0.59413566,0.78382269,1.0834531,1.1450062,1.2471819,1.2067953,1.1127127,1.135817,1.1951944,0.95714952,0.83607269,0.97383861,0.80848144,0.71675938,0.71682621,0.71385104,0.72315379,0.66637145,0.68979737,0.68717588,0.66144333,0.60605994,0.47249846,0.6612322,0.54239562,0.30913784,0.57035109,0.54938211,0.33351283,0.19054535,0.30814286,0.28859373,0.22559341,0.3185848,0.77887291,0.8472532,0.60130961,0.55212903,0.37489672,0.32143182,0.14120814,-0.045327079,-0.038039684,-0.18646582,-0.19034518,-0.099968178,-0.053632945,-0.1454569,-0.13839752,-0.20893234,-0.25362682,-0.10636201,-0.14111354,-0.22462354,-0.17492094,-0.017747444:1
0.056940582,1.1904011,2.2570638,1.5184608,1.3771251,-0.11158443,-1.6023664,-0.26089791,0.066122312,-0.35380021,-0.18037148,-0.21899085,-0.50039996,-1.0926288,-0.9126989,-1.097683,-1.4573629,-1.085422,-1.3432624,-1.2866397,-1.1783192,-1.7002373,-1.5371368,-1.4445748,-1.6943723,-1.9658566,-1.9592419,-1.7189319,-2.1275644,-2.1272008,-2.0813504,-1.9163889,-1.8377305,-1.7615174,-1.2188289,-1.0573791,-0.83786273,-0.3619156,-0.059697361,0.43326207,0.51739541,0.42373959,0.77927827,0.82120174,0.88062104,0.84581742,0.71510312,0.6571464,0.79220787,0.56312722,0.53379752,0.75096958,0.57466547,0.54485624,0.44566131,0.66320767,0.50302774,0.56942949,0.68636575,0.46485235,0.76537293,0.44609344,0.47652436,0.51307237,0.48160392,0.66321023,0.32240753,0.56630502,0.41290947,0.5993163,0.52234299,0.46070155,0.55549731,0.85369444,0.9980594,1.08158,1.1456011,0.87417885,0.66246828,0.63421164,0.60203015,0.37928531,0.38634747,0.55654226,0.46639918,0.24134608,0.49054162,0.38046487,0.36513117,0.43762985,0.28190103,0.40715155,0.73410336,0.48669628,0.42533628,0.78231152:1
0.95930664,2.2486938,3.6590968,2.8260034,2.2485512,0.8641853,-1.0003856,0.20886124,0.45355268,0.5370042,0.25467241,-0.013037846,0.68739477,-0.64883815,0.080934094,-0.68447038,-1.0729976,-0.38867383,-1.1561248,-0.91791002,-0.93718965,-1.1883495,-0.71043678,-1.6206685,-1.454922,-0.73188627,-1.5627587,-1.57601,-1.5154073,-1.5367618,-1.8202938,-1.6193008,-1.3399999,-1.2374414,-1.2399217,-0.74019429,-0.64271358,-0.1364176,0.28280764,-0.15880333,0.73392425,0.58744065,0.83191316,0.88713807,0.75168065,1.2563081,0.87389665,0.9430319,1.1470778,0.9050338,0.31326303,0.8055573,0.92109553,0.41580293,1.3272315,0.46789505,0.92032179,0.45652364,0.63090555,0.9587363,0.69685625,0.36417208,0.82718445,0.41368384,0.20807111,0.75859648,0.066104483,0.4514198,0.18669066,0.43994088,0.1498024,0.098727711,0.27599866,0.22542866,0.58538164,-0.074785135,0.48585844,0.6510264,-0.20416517,0.062668045,-0.55735361,-0.23418169,-0.11147779,-0.86091274,-0.60989237,-0.52190695,-0.65007545,-0.93381573,-0.70294118,-0.65856431,-0.74917851,-0.45627372,-0.94549191,-0.81448994,-0.76834725,-0.88768496:1
0.67025214,2.4506494,3.6815845,2.4744457,1.9195914,0.077082982,-0.97833631,0.33861298,0.16474021,-0.2864259,-0.14104643,-0.080486883,-0.40155999,-0.63813841,-0.56033823,-0.731392,-0.82062345,-1.0131949,-1.0303159,-0.9337215,-1.2067073,-1.2832339,-1.1626839,-1.3884912,-1.5430799,-1.5661514,-1.7111472,-1.7416544,-1.8136323,-1.8376146,-1.9932825,-1.8150274,-1.9826338,-1.7051249,-1.3465202,-1.25903,-0.771887,-0.47637916,-0.103311,0.26511711,0.41645635,0.65936665,1.0040981,0.92661611,1.0128742,0.88872775,0.9062941,1.0217663,0.7184112,0.67243365,0.71922775,0.74348902,0.68085548,0.63767986,0.66020297,0.57538918,0.75413125,0.55675176,0.91836422,0.57303231,0.30073627,0.68476178,0.63647602,0.43797795,0.41524148,0.50382052,0.15900849,0.33827073,0.51809059,0.045175839,0.18581196,0.14943406,0.20140083,0.44459781,0.54634356,0.80388077,0.75106595,0.53742571,0.39428161,0.18880879,0.1622361,0.021834972,-0.1160947,0.077399091,-0.0058007417,-0.022991962,-0.18456586,0.10119337,-0.16436161,-0.11020138,-0.16877884,-0.30358664,0.26705857,-0.27035037,-0.33413544,0.043461953:1
0.95580435,1.6039636,2.7285965,4.1475633,2.9426236,1.3820926,0.037530656,-0.33990319,0.46548063,0.79717903,0.74515791,0.37792595,0.65861595,0.33099701,-0.21331133,-0.351201,-0.68406766,-0.52348759,-0.80275018,-0.87463984,-0.8929084,-1.0573737,-0.99852166,-1.2663137,-1.3345377,-1.4939978,-1.6191527,-1.5098192,-1.6151145,-1.9413475,-1.8304472,-1.8242407,-1.6829499,-1.8018774,-1.6662002,-1.2757845,-1.0465461,-0.77405332,-0.45259063,0.053832693,0.073645665,0.3420666,0.57678304,0.57466514,0.86268838,0.8774562,0.77519115,1.1101505,0.88178392,0.65930768,0.8021495,0.65555006,0.64574369,0.65704286,0.57298842,0.4389181,0.5351542,0.57720038,0.3520897,0.46342746,0.29998452,0.4762011,0.35575686,0.16218675,0.24443291,0.32939372,0.31407215,-0.12586423,0.28943147,0.13592556,0.094153297,-0.013442522,-0.010296976,0.38763598,0.47999151,0.72097592,0.28183682,0.41535194,0.51914611,-0.19918033,-0.013676959,-0.17692082,-0.20536191,-0.37695452,-0.34481379,-0.13304548,-0.39867611,-0.3048562,-0.45503643,-0.36621837,-0.13703222,-0.51095641,-0.4146873,-0.28984291,-0.47194409,-0.34589799:1
0.47692228,1.6295008,3.0631284,2.7918722,2.3752358,0.99371348,-0.84643067,-0.39837859,0.4822259,0.2491754,-0.0047162226,0.099627186,-0.0016956917,-0.46165118,-0.65116931,-0.56244972,-1.2102613,-0.84628622,-1.0091734,-1.2859811,-0.90831878,-1.2537969,-1.4476941,-1.6446289,-1.5834382,-1.4380506,-1.8364334,-2.0701185,-2.0320455,-1.6738497,-2.0544205,-1.9217328,-1.8655746,-1.4484915,-1.3391285,-1.2660247,-0.44053526,-0.28030446,0.012598713,0.44086564,0.58488973,0.53742513,0.92550308,1.120986,0.87364922,1.1220642,1.1710572,0.57889307,0.82421872,1.0829776,0.58847163,0.62102605,0.54070408,0.44683045,0.8116453,0.58177897,0.52412889,0.54319225,0.38570693,0.8056977,0.58158303,0.34852257,0.4970651,0.4686762,0.71864967,0.36113743,0.23069174,0.37211202,0.26168216,0.58379336,0.10666696,0.20373953,0.32099379,0.72687218,0.95573998,0.68694979,0.55714977,0.13900759,0.44052786,0.29641215,-0.31652697,0.17446549,-0.12344543,-0.46543796,0.18430741,-0.21958798,-0.28680368,-0.2317362,-0.14118261,-0.081754592,-0.21098828,-0.2143592,-0.20619926,-0.16248607,-0.21566986,0.15650034:1
2.1813772,3.2211784,2.1939397,1.5685176,0.232277,0.46372134,1.2246526,0.76000069,0.6877796,0.18127321,-0.46470856,-0.68668635,-0.77871694,-0.92241727,-0.94234921,-0.94488113,-1.0457658,-1.1143255,-1.1451062,-1.2973043,-1.4189536,-1.4476749,-1.589423,-1.7828645,-1.8352168,-1.8712783,-2.0622471,-2.1952156,-2.1670423,-2.2290518,-2.1804881,-1.7044198,-1.5007536,-1.1514809,-0.63728186,-0.32917863,0.15060442,0.38101379,0.62690907,0.83687998,0.7521484,0.96740174,0.92486369,0.74314503,0.74133464,0.74178024,0.6819611,0.61033809,0.60396803,0.69141985,0.66411359,0.60642309,0.73185441,0.67145292,0.55460603,0.60641373,0.56759102,0.56106498,0.47152943,0.48606477,0.40400506,0.31480811,0.33057612,0.28302269,0.28752047,0.25329891,0.25501557,0.26017431,0.18729456,0.1528421,0.22611947,0.21698484,0.13504704,0.22807846,0.21546731,0.28915229,0.67891821,0.75003223,0.5237445,0.40461513,0.35403565,0.1930678,-0.008266888,0.027061448,-0.023906107,-0.10168163,0.053984173,-0.012636369,0.003174923,0.060461694,0.069107966,0.083359442,0.010582573,-0.031686072,0.064157823,0.21769913:1
1.670402,3.0745132,3.230077,3.0176159,1.3922998,0.48824828,1.5547017,1.6314282,1.3531635,1.7423332,1.1030198,0.051690155,-0.23572024,-0.38245192,-0.58390221,-0.64253437,-0.70971714,-0.80732351,-0.94617629,-1.0035692,-1.025631,-1.1175855,-1.2645552,-1.2951057,-1.3171006,-1.489459,-1.5891075,-1.6856485,-1.7291228,-1.8027024,-1.8681445,-1.7330139,-1.647151,-1.5416448,-1.3352999,-1.0138335,-0.70103488,-0.4962226,-0.13267033,0.19194038,0.32945227,0.4988389,0.72832701,0.80043709,0.73371918,0.73976831,0.80840528,0.71324245,0.62399148,0.57331011,0.53162125,0.53510085,0.48262012,0.47634098,0.49719238,0.48294248,0.43967047,0.48654749,0.45139752,0.31545426,0.33375852,0.2602648,0.25725347,0.2352272,0.17072715,0.21179458,0.13609431,0.062736623,-0.0033787306,0.074261105,-0.017519334,-0.061236039,0.18633125,0.35477841,0.44633141,0.37051523,0.26432842,0.15509145,-0.058507751,-0.15497595,-0.19162868,-0.20793798,-0.33027627,-0.43672308,-0.38138834,-0.34241153,-0.44084543,-0.39458053,-0.36367897,-0.38429965,-0.34474027,-0.36834476,-0.26915871,-0.32783905,-0.22879733,0.13538986:1
0.078866691,1.018874,2.2278793,2.2173914,1.4306816,-0.40199324,-1.0452275,0.17359872,0.25217119,0.18301489,0.41123493,-0.032737609,-0.57782223,-0.952341,-0.96171601,-1.2242356,-1.0908278,-1.2022525,-1.2531256,-1.2328012,-1.3101605,-1.3523171,-1.4641347,-1.4712121,-1.585889,-1.5892763,-1.7449113,-1.8879282,-1.7580956,-1.9515795,-2.0248193,-1.8794733,-1.941332,-1.8873659,-1.6828334,-1.3574569,-1.1047932,-0.7632659,-0.43586379,-0.17323685,0.2487182,0.28784215,0.59426256,0.86408667,0.77903095,0.82312073,1.1187946,0.91232254,0.81672935,0.80124099,0.76168452,0.89771009,0.81098879,0.86863827,0.84403535,0.89414207,0.84574354,0.90469381,0.8927965,0.86073513,0.84255704,0.81980747,0.76454442,0.72999755,0.71760647,0.63070627,0.64070977,0.57935426,0.48782754,0.51452945,0.52812863,0.47795757,0.56904381,0.8148966,1.0017285,0.8062509,0.64758907,0.63566785,0.57025206,0.38819374,0.18114828,0.28111188,0.17471463,0.061852116,0.21368168,0.22872387,0.063878685,-0.0074787094,0.074222344,0.10770482,0.09792526,-0.014010622,0.09422061,0.071778734,0.18890088,0.53427216:1
0.53311732,1.0395197,1.7557696,2.7659477,3.1379215,2.75319,1.7817734,0.70184315,1.0646099,1.3162977,0.81521107,0.75527104,0.82273259,-3.8172055E-4,-0.41522331,-0.68975931,-0.90282338,-1.067124,-1.2214746,-1.2095994,-1.3439903,-1.4311564,-1.3340533,-1.4125172,-1.5457133,-1.7149773,-1.6698684,-1.652039,-1.8121325,-1.8337757,-1.8527079,-1.7751935,-1.899801,-1.7756002,-1.5719261,-1.326803,-1.1358556,-0.98164333,-0.62491315,-0.4469816,-0.24584167,-0.035558805,0.1715467,0.2489289,0.25526618,0.25069886,0.28865946,0.39313876,0.30567496,0.34900765,0.27310457,0.20763287,0.1087695,0.1543002,0.33800178,0.13569708,0.18977726,0.40389518,0.30338244,0.51639846,0.3483898,0.27775727,0.64576056,0.27798966,0.5154284,0.48788181,0.42121896,0.4838371,0.42925367,0.39307132,0.31547854,0.41295727,0.35967709,0.5265714,0.61139732,0.52679948,0.35231508,0.58546351,0.33575926,0.35749152,0.14291607,0.19728624,0.22323351,0.060383882,0.091327746,0.10286963,0.079919564,0.076562587,0.058677205,0.055115338,0.24175249,0.069937974,0.23255331,0.082874452,0.26748819,0.14495218:-1
0.46577266,2.1142584,2.6073044,1.79958,0.88132815,0.50251064,1.0419075,1.2005564,1.1295043,1.2117074,0.45155534,-0.38084951,-0.56797431,-0.72182442,-0.88240475,-0.88847413,-0.98721578,-1.0982019,-1.1683736,-1.3293297,-1.3309737,-1.4109985,-1.4938742,-1.5858822,-1.8711463,-1.8666451,-1.9100297,-2.1899175,-2.2980981,-2.2380998,-2.2255482,-2.1345596,-1.8799557,-1.6106735,-1.2427392,-0.88880113,-0.35878652,-0.023803087,0.17432464,0.56042377,0.62042463,0.79172558,0.75490884,0.79255746,0.93935959,0.70641036,0.73642988,0.82669468,0.72077185,0.69365008,0.73833497,0.80155218,0.66280786,0.66762952,0.70370705,0.58974935,0.62242969,0.48881482,0.51009997,0.5412742,0.4048245,0.40488487,0.36583516,0.39627529,0.34579286,0.27868808,0.27559614,0.2219543,0.32994877,0.17806352,0.17715459,0.29316207,0.16632991,0.34376929,0.52419047,0.62365953,0.77656076,0.49918,0.32663994,0.32189008,0.084575465,0.060439507,0.098219477,0.03133354,0.075200333,0.11707121,-0.01447721,-0.026496828,0.030139124,-0.010568237,0.12455247,0.063738698,-0.0080612691,0.079776515,0.21816711,0.35710391:1
0.46534775,0.86049958,1.2476174,1.9870516,2.2654945,1.6395444,0.93328555,0.25285834,-0.25699658,-0.0060432968,0.11954721,-0.10340298,0.034742569,0.021528243,-0.17384474,-0.39922427,-0.75047787,-0.76217279,-0.83220214,-0.96400344,-0.8606827,-0.87614074,-1.0095328,-1.1380701,-1.2213233,-1.2856782,-1.3646118,-1.4739756,-1.6265837,-1.7051476,-1.8183639,-1.9645848,-2.0070487,-2.03913,-2.0252782,-1.935198,-1.9553242,-1.8829083,-1.5872931,-1.3123154,-1.0635525,-0.87609134,-0.648412,-0.30358476,-0.12212478,0.0030657501,0.0091498918,0.081268905,0.2775444,0.30202262,0.3647182,0.26954038,0.17137908,0.43314535,0.5189243,0.40653348,0.34003295,0.36089865,0.34410792,0.23980316,0.35344265,0.51659516,0.40212719,0.38425069,0.6112351,0.63128643,0.5225027,0.65654667,0.78018606,0.88039722,1.1083572,1.1873636,1.2469601,1.3023589,1.3304858,1.352072,1.185111,1.0766714,0.97196291,0.81429786,0.7585369,0.66956674,0.74731963,0.88566401,0.86940672,0.62283187,0.2893406,0.26770119,0.30203998,0.36985735,0.32577056,0.032964142,0.08108739,0.20155412,0.31643336,0.34738726:1
0.3913855,1.7239941,2.9399291,3.0112082,2.144914,0.66535045,-1.0995074,-0.65457967,0.27442388,0.19472952,0.2206657,-0.02327296,0.31428375,-0.28003844,-0.98395084,-0.62100059,-0.97348924,-1.0253369,-0.84685126,-1.2933025,-1.119106,-1.2835085,-1.4362692,-1.2887936,-1.5721362,-1.6190579,-1.7442997,-1.7656329,-1.9797946,-1.9908815,-1.744769,-2.1103077,-1.8022265,-1.6869475,-1.5289967,-0.91862581,-0.92503692,-0.65491791,-0.19054035,0.15822514,0.4369225,0.62650819,0.76119042,0.86281597,1.0486919,1.025004,1.2012496,0.97986705,0.98375011,0.97947176,0.71687158,0.97842835,0.69430189,0.55120309,0.6973946,0.55288373,0.58690224,0.49332512,0.44804676,0.56398653,0.54759124,0.41742685,0.41133923,0.42892711,0.48692874,0.35910134,0.29787423,0.42996129,0.18818616,0.29735146,0.21440555,0.25654324,0.64476505,0.66302041,0.62241002,0.9262183,0.65980963,0.47390372,0.52228034,0.097271337,0.099376388,4.4548697E-4,-0.17390122,-0.036751593,-0.046597364,0.13454916,-0.18533238,-0.19694201,-0.010848931,-0.083848022,-0.14801676,-0.17042965,-0.019805635,-0.15745775,-0.093491421,0.07899031:1
0.58968397,1.984269,3.4949999,2.4300018,2.2080556,1.1824721,-0.86969168,-0.55347535,0.53496219,0.33756494,0.10123388,0.29272761,-0.043278027,0.020984267,-0.77185371,-0.89639769,-0.65300549,-1.1746363,-0.94744575,-1.000348,-1.3026163,-1.1526983,-1.2976585,-1.4156187,-1.4033284,-1.6284549,-1.6914022,-1.503673,-1.7719298,-1.813182,-1.8544211,-1.6935943,-1.7952573,-1.7249407,-1.241455,-1.2477316,-0.98924967,-0.62310947,-0.37996753,0.12024125,0.3163845,0.36185821,0.53298757,0.85690536,0.8783533,0.90752488,1.1849657,1.0111918,0.87473523,0.91643659,1.0131947,0.8764922,0.82695544,0.95459868,0.65893798,0.79245464,0.60286946,0.69106638,0.73557575,0.67771943,0.61942201,0.42766516,0.59856864,0.69176753,0.41910279,0.49612385,0.5527153,0.33855048,0.32286355,0.22138403,0.37919867,0.24203294,0.31416125,0.66906224,0.66357868,0.71380586,0.65530295,0.37681966,0.20287656,0.14352777,0.04576299,-0.16105387,-0.11697239,-0.086090341,-0.25955029,-0.19490593,-0.29506464,-0.37961997,-0.32642834,-0.44835406,-0.31370803,-0.39244829,-0.49393349,-0.48703479,-0.55024821,-0.11686356:1
0.57138805,0.8845268,2.7096404,3.6136917,2.3942264,1.7524188,0.39156481,0.2007513,1.2758028,1.0361823,0.85284057,0.84278385,0.38425294,-0.37084394,-0.53553249,-0.71658542,-0.85034738,-0.92156244,-0.89340905,-0.95054123,-1.1352175,-1.1514591,-1.1761313,-1.3148932,-1.3509847,-1.4365069,-1.6612706,-1.7194177,-1.7705092,-1.8025874,-1.9304247,-1.953996,-1.8882623,-1.8570967,-1.7533768,-1.5142001,-1.1592284,-0.87459617,-0.5933298,-0.19917726,0.15667429,0.35485334,0.52370217,0.78594365,0.88183886,0.87731447,0.93861292,0.89347987,0.84259177,0.71878089,0.60739246,0.65885804,0.64998451,0.62353068,0.53279371,0.544125,0.6305443,0.47582082,0.5190336,0.50465047,0.41564481,0.39882699,0.38907594,0.39146643,0.32330904,0.24771917,0.23519879,0.32021892,0.20302484,0.090436158,0.21904758,0.16721075,0.046701811,0.25958312,0.51358198,0.62817094,0.59822253,0.35866989,0.33829374,0.26935595,-0.0059596324,-1.713146E-4,-0.062884739,-0.16485503,-0.19260839,-0.1325883,-0.16072665,-0.20593638,-0.28744148,-0.22798251,-0.15270191,-0.28865068,-0.24638894,-0.17958497,-0.18590604,-0.068481258:1
0.55993409,0.76902644,1.0958605,1.8707357,2.2525407,1.793885,1.1417774,0.57478855,-0.12848182,-0.2904433,-0.11781587,-0.31484148,-0.23323431,-0.12269841,-0.16272481,-0.18656013,-0.58887263,-0.77606613,-0.7586034,-0.99023098,-1.0353447,-1.0096752,-1.2308257,-1.3417123,-1.3863013,-1.5009298,-1.6079254,-1.7932316,-1.7512963,-1.879713,-2.0841733,-1.9380774,-2.1147331,-2.1284397,-1.9875907,-2.0290484,-1.7597435,-1.6122895,-1.4576073,-1.1984661,-1.027926,-0.72216517,-0.52577794,-0.24595961,0.10948701,0.18078623,0.30641227,0.53270969,0.5187684,0.44440426,0.59841435,0.66815438,0.58747806,0.70250092,0.68789684,0.57201137,0.70674663,0.7029934,0.61206434,0.65601679,0.65181643,0.60063723,0.58030933,0.57923461,0.49117159,0.50714148,0.68667313,0.65604017,0.56890027,0.69815024,0.66628874,0.52329711,0.63781129,0.70545223,0.64629491,0.62877514,0.57434436,0.59750921,0.63289625,0.55066322,0.67836173,0.72798791,0.42861507,0.4664119,0.64449594,0.73930477,0.86794068,0.7077367,0.61542688,0.5630538,0.44605603,0.42547748,0.31478177,0.46998982,0.70364171,0.4114437:-1
0.085606859,0.20033018,0.44254959,-0.074110728,-0.39873263,-0.74501807,-0.94189496,-0.91756009,-0.87399176,-0.93419513,-1.0732258,-1.1763083,-1.582369,-1.1445534,-1.3344943,-1.9947303,-1.4051448,-1.4698552,-2.4011571,-1.7930655,-2.1171632,-2.5094923,-2.1436528,-2.3202441,-1.9641172,-1.8184396,-1.5769791,-1.2943121,-0.9695516,-0.35619464,0.02339693,-0.20830204,0.045680557,0.29934126,0.28691939,0.85142076,0.33631844,0.080540808,0.50281645,0.236145,0.48056223,0.21414726,0.51355133,0.74076585,0.28945996,0.39928519,0.51228099,0.54993423,0.54808613,0.64475877,0.67616861,0.63035024,0.61930416,0.52644621,0.61074712,0.45358276,0.73551065,0.44409767,0.45948759,0.51652861,0.45432812,0.43456323,0.32290891,0.59191409,0.48440149,0.34148442,0.63351068,0.74360279,0.77171397,0.78039653,0.64436544,0.49663431,0.57912091,0.33131751,0.3413505,0.29924634,0.42623168,0.42957084,0.23426454,0.4254791,0.26974055,0.36605927,0.41770413,0.40599312,0.37223232,0.40010873,0.44371775,0.58986398,0.65684245,1.0598391,2.1734864,2.3619708,2.0963836,1.2713453,0.33713659,0.59390474:1
-0.088079169,0.15605752,1.6035128,2.980953,2.6943733,2.0361801,0.11366261,-1.4711839,0.017416851,0.51127461,0.003208757,0.4751396,0.1201551,-0.29144555,-0.64413456,-0.83209064,-0.89836085,-0.86357516,-0.78801963,-0.86733977,-1.0536001,-1.0446194,-1.1228087,-1.4085798,-1.5626684,-1.61534,-1.7103063,-1.9675102,-2.0857554,-2.0956076,-2.0107156,-2.102501,-2.047285,-1.7798123,-1.5602883,-1.3395939,-1.0339659,-0.60788598,-0.1764891,0.083550221,0.29518197,0.67103893,0.87683267,0.96933528,0.9758778,1.0833139,1.016151,0.9910862,0.93147417,0.87623508,0.93072762,0.64645369,0.68975511,0.78345092,0.55072411,0.60577667,0.56559343,0.58751566,0.58272453,0.41676267,0.44885521,0.47547624,0.48373114,0.47276744,0.43547477,0.53159386,0.42420896,0.25310186,0.32490242,0.35563943,0.30530178,0.2712651,0.46286379,0.71939065,0.88729936,0.79913648,0.76821524,0.71580219,0.34386953,0.1837727,0.12142045,-0.071496633,-0.11881777,-0.031619463,-0.061518826,-0.048540598,0.069990419,0.071385628,-0.010831069,-0.11875472,-0.027527131,-0.063227063,-0.12199058,0.018781647,-0.038154473,-0.0037016044:1
0.86278066,1.3209292,1.87969,2.4597327,2.7039762,2.6255609,2.5423065,2.3932316,1.9359774,1.3121806,0.77592851,0.35139858,0.096854689,0.051060255,-0.049176655,-0.34655151,-0.51085686,-0.3247979,-0.087656671,-0.047907909,-0.07925283,-0.069970984,-0.11066186,-0.25118726,-0.42966585,-0.56987795,-0.59461159,-0.5337791,-0.53366049,-0.63704818,-0.71840764,-0.74486854,-0.84907546,-1.0445251,-1.1717314,-1.1724665,-1.1680473,-1.2601015,-1.4003106,-1.4968115,-1.5308552,-1.5624937,-1.6270044,-1.6505967,-1.5612989,-1.4343318,-1.3887173,-1.4041068,-1.3812526,-1.3078113,-1.2169334,-1.0927381,-0.93064173,-0.79126859,-0.69812922,-0.55915806,-0.33774158,-0.17252192,-0.16980185,-0.17856535,-0.0074975153,0.23016415,0.30172527,0.2351575,0.23663401,0.33233806,0.38880628,0.37980747,0.39875499,0.50238191,0.62175743,0.63728765,0.54470068,0.4948071,0.54178887,0.52360493,0.3974649,0.37124313,0.49892224,0.58663415,0.5973956,0.63001226,0.58114232,0.37090768,0.23670287,0.32416991,0.41731241,0.39449358,0.41796993,0.51700008,0.51952393,0.44922436,0.50662613,0.66404584,0.65311769,0.391242:-1
0.66077834,0.7870391,1.2010623,2.2060852,2.2694559,1.4551775,0.77735494,0.063461287,-0.34341922,-0.30430161,-0.17267406,-0.22026867,-0.40444746,-0.3088849,-0.33487637,-0.25117899,-0.67633099,-1.3248846,-0.90520771,-1.0817584,-1.4870078,-1.2916932,-1.2275011,-1.2497451,-1.7138081,-1.9219664,-1.7754372,-1.9532735,-2.0189643,-1.9566189,-1.9406427,-1.862256,-2.0494958,-2.0497934,-1.6343925,-1.7057993,-1.6328461,-0.93361314,-0.96972325,-0.92027773,-0.21707401,-0.23154776,-0.13140703,-0.078626909,1.048573E-5,0.62166174,0.40144251,0.29333126,0.71454306,0.54479361,0.42092994,0.74314976,0.68046346,0.3841917,0.62541826,0.63934408,0.49795745,0.68535539,0.48803167,0.50614958,0.81493716,0.84079661,0.84354489,0.66216882,0.60457253,0.92594665,1.0761371,0.92011947,0.84305908,0.93813927,0.93769351,0.69718494,0.65629835,0.67775399,0.58330643,0.80017883,0.7275541,0.44902745,0.62229839,0.57828829,0.37784653,0.60214545,0.59995044,0.43848686,0.36422965,0.2617178,0.47454369,0.55131368,0.57975026,0.56213433,0.26106759,0.22942017,0.22269406,0.1881117,0.37941186,0.32272573:-1
1.917562,2.3772484,2.3291479,2.358087,2.2860929,2.6011213,2.1746643,0.84643642,0.0906239,-0.12106542,-0.40025827,-0.60610019,-0.71170231,-0.85560743,-0.90578907,-0.95508605,-1.104952,-1.1551642,-1.1296698,-1.164098,-1.2645178,-1.333458,-1.3060475,-1.2869534,-1.2974743,-1.334972,-1.4381593,-1.5583545,-1.6743717,-1.6690496,-1.57739,-1.6185453,-1.6086723,-1.5035489,-1.4069847,-1.1904006,-1.03743,-0.89143692,-0.58780849,-0.40888244,-0.22793923,0.11075462,0.35777338,0.50794357,0.58366669,0.53148964,0.51103091,0.61506117,0.69404617,0.68682811,0.67271985,0.62184389,0.5135349,0.46677107,0.49489695,0.49941397,0.44164564,0.36126588,0.40683036,0.49343188,0.43366811,0.42783646,0.47225759,0.43237199,0.50855931,0.62593824,0.63051392,0.68496935,0.82725036,0.90068331,0.77587705,0.57470313,0.54267984,0.65399883,0.72316311,0.64744924,0.5052885,0.38128163,0.17624517,0.0015811691,-0.024710555,-0.076202486,-0.12519229,-0.15932352,-0.22696433,-0.19530853,-0.17505793,-0.24154804,-0.21784334,-0.17567373,-0.22183492,-0.22255405,-0.19139426,-0.10761844,0.11672472,0.098142295:-1
0.706779,0.68580632,0.65167529,1.2827006,1.9827605,1.9082054,1.5776849,1.6373827,1.500565,0.74891961,0.032790026,-0.19184691,-0.15008001,-0.1130313,-0.2379588,-0.50125173,-0.59887101,-0.42348763,-0.36078304,-0.61929058,-0.81507508,-0.72600164,-0.63491632,-0.71648173,-0.90861093,-1.048465,-1.0229033,-1.0771734,-1.2603176,-1.2611787,-1.2878764,-1.4842868,-1.3813882,-1.2316889,-1.5613066,-1.8312884,-1.7514231,-1.7784926,-1.8151996,-1.6952356,-1.7006044,-1.7383027,-1.6109544,-1.4605021,-1.3408294,-1.2316889,-1.078937,-0.80595759,-0.64172042,-0.63398716,-0.39434623,-0.037705055,0.0010267382,-0.068111141,0.060623028,0.22365446,0.30454752,0.32751354,0.30122516,0.32133359,0.39774788,0.45432531,0.51206669,0.52416971,0.44918033,0.43799376,0.53821657,0.59367549,0.55049702,0.49607597,0.48844732,0.55246736,0.67868526,0.7233564,0.66151032,0.73487274,0.86625075,0.72971436,0.59440405,0.83891742,1.0873876,1.0017633,0.9626176,1.0737731,0.86129456,0.62317862,0.95685646,1.1281851,0.76777451,0.90429141,1.3107944,1.1237268,1.0904008,1.3107944,0.8070371,0.14191352:-1
0.83027511,1.5740392,2.0308007,1.9090934,1.2589242,0.50268598,-0.1439511,0.17252408,0.59796879,0.42608301,0.6592269,0.69615174,0.4817784,0.16821418,-0.58363345,-0.76568318,-0.95885583,-0.96712065,-0.7563203,-0.93165007,-1.2177129,-1.28345,-1.2855708,-1.4371846,-1.5740631,-1.6400071,-1.6541038,-1.8384378,-2.138909,-2.2048105,-2.2484673,-2.3046269,-2.2316483,-2.1088564,-1.9531228,-1.874271,-1.5708927,-1.2333415,-1.0351735,-0.55473678,-0.33055917,-0.19685165,0.24201489,0.37050774,0.41383902,0.5840125,0.63831011,0.65356353,0.58496027,0.591863,0.67056847,0.67419519,0.65668948,0.58672146,0.5385455,0.60808589,0.70970687,0.60568376,0.63800423,0.68871068,0.50695707,0.64685599,0.6022591,0.52989622,0.53598903,0.47247986,0.5625294,0.49957325,0.63125338,0.5507415,0.57643684,0.61601239,0.54173649,0.77762952,0.86396615,0.84421959,0.82261719,0.66275471,0.62996846,0.39057838,0.2733049,0.28225743,0.19125198,0.47536819,0.31386641,0.16328673,0.18253511,0.14801366,0.3577673,0.35302604,0.20821063,0.22755385,0.33805789,0.28075295,0.52007063,0.68048583:1
0.23115346,1.5228599,2.9568155,1.5944337,1.6469891,0.38599557,-1.5245517,-0.2413155,0.60543375,0.13952734,0.21060329,0.44792623,-0.5763516,-0.87788835,-0.73011615,-1.4087019,-1.2535762,-1.0442411,-1.422141,-1.3172042,-1.3177734,-1.5376348,-1.3056402,-1.4101758,-1.8755354,-1.6975597,-1.7357886,-2.0123656,-1.8644696,-1.955647,-1.7929893,-1.9513781,-1.7351307,-1.5172137,-1.1411322,-1.0310683,-1.0748102,-0.36601896,-0.23307056,0.029769044,0.38665855,0.43959421,0.68293758,0.85679737,0.94000202,0.81581457,1.017692,1.1332421,0.78334969,0.8305288,0.82410396,0.7191757,0.77437547,0.5540637,0.63827099,0.76900529,0.56539508,0.75839216,0.64690864,0.61801787,0.84432764,0.59588488,0.73142001,0.60771213,0.68047882,0.75005543,0.17071857,0.55763188,0.56125025,0.42617373,0.56260243,0.34650044,0.88747524,0.79108873,0.97825971,1.1466371,0.56776527,0.55798277,0.50240527,0.37442934,0.24533978,0.17536214,0.055166427,0.032002905,0.087669144,-6.0396983E-4,0.15307756,-0.054235174,-0.041637299,0.10905815,-0.15166988,0.045550888,-0.081951176,-0.23501286,0.24308695,0.20365377:1
1.837276,2.7664855,2.0085606,1.4621088,0.39826061,0.89087986,1.3132057,0.8951143,1.1363781,0.55658571,-0.15403742,-0.30764653,-0.45418913,-0.71033597,-0.64488676,-0.78902452,-0.87381552,-1.0598572,-1.1969449,-1.268501,-1.541234,-1.6733893,-1.807913,-2.133031,-2.3429571,-2.3985182,-2.560607,-2.6498044,-2.453185,-2.207275,-1.8966293,-1.5077871,-0.92782315,-0.62774308,-0.24013488,0.18053239,0.27030872,0.44189322,0.55784369,0.61444359,0.62870935,0.59608782,0.52228116,0.5074428,0.43358358,0.52869376,0.62654482,0.44268536,0.48476449,0.64344391,0.61711209,0.56903974,0.56233441,0.56459387,0.56652117,0.56015556,0.49571453,0.57403288,0.36950058,0.46328355,0.41309271,0.31331061,0.42879368,0.40858846,0.32295905,0.30127987,0.3735826,0.27371006,0.32961518,0.29071014,0.29873772,0.29203512,0.12449381,0.21414429,0.21988241,0.35379744,0.72686296,0.59867502,0.48036371,0.46737068,0.26986635,0.13849611,0.055265448,0.15637095,0.012092981,0.0067297564,0.14415209,-0.071147174,-0.040017417,0.047248659,0.043925805,-0.0023283388,0.050661317,0.16827172,0.042472653,0.086801895:1
1.0832881,1.54703,1.0616474,-0.5740058,-0.82536893,-1.2138107,-1.5939865,-1.7101337,-1.7125671,-1.9524916,-2.4166774,-2.3308669,-2.6703373,-2.8395457,-2.7588256,-2.8155168,-1.9570365,-1.5277585,-0.83487457,0.08166405,0.62664826,0.77799985,1.0254729,0.9951393,0.87222813,0.78699609,0.66598191,0.59878545,0.43527795,0.4281378,0.42853906,0.42396567,0.33986719,0.31660748,0.12750888,0.26991393,-0.0065142587,0.2040379,-0.021702558,0.22231237,0.13985478,-0.15150553,0.17925628,-0.013910809,-0.052342552,-0.012825696,0.055887308,-0.0088709326,0.20992399,0.064228445,0.10625521,0.066235564,0.10834292,0.055965316,0.044673525,0.099891025,0.016048549,0.070867822,0.078137447,0.1306602,0.25107199,0.17260484,0.274229,0.27451349,0.13703077,0.14488635,0.032760607,0.12100038,0.22744249,0.20412602,0.39760163,0.24831167,0.25104547,0.26249651,0.083685814,0.19170103,0.4300977,0.61294665,0.68168945,0.24840556,0.33630608,0.035416388,0.025993086,0.12136751,0.27288318,0.13494584,0.14185368,0.21084105,0.20215627,0.19760704,0.44576304,1.2961841,2.7626006,2.7476851,0.92683544,0.1501122:-1
1.0379714,1.3215896,1.4640647,2.05956,2.7697641,3.0756739,2.6892398,2.0649812,1.5416372,1.0061187,0.29589163,-0.14982764,-0.041504005,0.11439181,-0.080505171,-0.2085682,0.04787464,0.19271238,-0.13858314,-0.46967404,-0.47508564,-0.50408329,-0.64475438,-0.63562396,-0.58317734,-0.63654288,-0.66866443,-0.73299248,-0.91078576,-0.99070531,-0.958715,-1.0860789,-1.2953652,-1.2633313,-1.1365542,-1.2965409,-1.5495272,-1.5083785,-1.4098384,-1.5575063,-1.6882769,-1.6162618,-1.5453373,-1.5335003,-1.4744507,-1.3990499,-1.3561406,-1.2927868,-1.1535809,-0.9592758,-0.79752771,-0.71120035,-0.60885443,-0.37971777,-0.12139335,-0.062695947,-0.10218966,0.083110801,0.32678526,0.28692565,0.2014605,0.28897452,0.31218974,0.28900412,0.35423636,0.32891396,0.32967934,0.55011105,0.60088909,0.40683532,0.47198199,0.67440032,0.55634221,0.34787623,0.37566627,0.52800945,0.67464963,0.72859209,0.67899108,0.70495344,0.74810709,0.58052293,0.37968715,0.36926979,0.39036392,0.38668382,0.49460244,0.60142333,0.55631296,0.47360469,0.47809125,0.44832993,0.44162097,0.52470294,0.63276301,0.44701801:1
0.30918726,1.3356134,2.9713573,4.110566,2.589952,0.59588268,-0.90857797,-0.95236393,0.38433414,0.49653049,0.18876174,-0.018092084,-0.035778497,-0.043788683,-0.47558298,-0.59456484,-0.68198578,-0.80053155,-0.70994721,-1.1346445,-1.0809364,-0.90870417,-0.97524198,-1.3945351,-1.4813599,-0.85212115,-1.5160528,-1.9550019,-1.5997168,-1.5092707,-1.8025204,-1.5527083,-1.371299,-1.637964,-1.2486114,-0.75947828,-0.74836928,-0.39485207,-0.067017518,0.069544731,0.56266712,0.53533583,0.47610255,1.2287688,1.0894927,0.92315122,1.1173662,0.89569554,1.0062187,0.95265292,0.83835226,0.98305113,0.6430811,0.74132431,1.1019626,0.47613552,0.32422243,1.0115386,0.852055,0.45905431,0.52912948,0.67030924,0.51348096,0.65114678,0.51364271,0.096409881,0.50216073,0.48455791,0.22915293,0.12521759,-0.06701591,0.1514765,0.20295379,0.29864282,0.72961523,0.41286892,0.33085062,0.68638981,0.049434185,0.17630551,-0.091357624,-0.65114305,0.098258994,-0.70064516,-0.18526963,-0.18926225,-0.74196999,-0.61691746,-0.51673403,-0.32896218,-0.4211523,-0.58629334,-0.95375258,-0.41799006,-0.22878306,-0.81309534:1
1.1990016,1.7377959,2.0043458,2.3153024,2.1712273,1.5987905,1.0605047,0.65000944,-0.022424838,-0.37234745,0.075418434,0.32077583,-0.17792747,-0.35865345,0.042769603,0.1009282,-0.25883886,-0.54557146,-0.74616119,-0.8410183,-0.80007864,-0.8801663,-1.0435205,-0.94523389,-0.73182488,-0.88573572,-1.2796206,-1.3630377,-1.2144529,-1.3091011,-1.4928957,-1.3460665,-1.0989923,-1.2258577,-1.5834313,-1.6751788,-1.4768563,-1.3846222,-1.4951748,-1.5233104,-1.3800682,-1.3017556,-1.3931876,-1.4646537,-1.356148,-1.1403059,-0.95593895,-0.80598528,-0.61670003,-0.44468045,-0.36888095,-0.246992,-0.018737843,0.1115746,0.17432826,0.36334181,0.52346562,0.54071352,0.62219885,0.74463578,0.72880228,0.69653037,0.76357897,0.83763059,0.88066174,0.87576856,0.7872926,0.70909305,0.71624411,0.69764039,0.58886732,0.53088227,0.58348959,0.59343911,0.55460805,0.62407938,0.72539189,0.72508203,0.7269649,0.7720052,0.8009071,0.84680351,0.86337057,0.83095194,0.88040615,0.93341216,0.82641936,0.81684035,1.1668514,1.4442117,1.138372,0.64387147,0.27302138,-0.39750115,-1.1390418,-0.83194071:1
0.8438343,2.5647645,3.3431272,2.5918108,1.9899142,0.44174264,0.35640833,1.2834468,0.82081191,0.5656735,0.31938812,0.015537814,-0.14017007,-0.16033261,-0.21442211,-0.34322826,-0.64143584,-0.77483614,-0.75436096,-1.0014329,-1.2484669,-1.2074929,-1.39446,-1.5708632,-1.5503129,-1.7025778,-1.7617107,-1.9063019,-2.0251202,-1.9891328,-2.1750486,-2.1747529,-1.9095347,-1.7570956,-1.4710978,-1.1371702,-0.72890365,-0.18120011,0.14304575,0.4307335,0.69722405,0.76751216,0.87736854,0.93257346,0.85493573,0.78680101,0.81841172,0.81701732,0.69404898,0.5824825,0.6004455,0.61669407,0.60167227,0.61894159,0.56969869,0.44695554,0.32713152,0.45097386,0.45908165,0.32002413,0.34839708,0.40818659,0.31444215,0.25370435,0.40733175,0.35195393,0.20562496,0.29859778,0.24782942,0.24708095,0.23061234,0.12441488,0.4129936,0.49256506,0.48699514,0.64942309,0.3810608,0.25005876,0.16176728,-0.078092758,-0.099280945,-0.16719066,-0.22659964,-0.35911074,-0.22647839,-0.15403691,-0.24396924,-0.24276035,-0.35648789,-0.24567248,-0.18487849,-0.27734381,-0.10510265,-0.16977436,-0.023764313,0.25873182:1
1.3984722,2.8747708,3.4534283,2.8979189,1.2600432,0.17333181,1.2892934,1.4700538,1.0283981,1.3331515,0.8777579,0.13769432,-0.53790388,-0.5387386,-0.75247795,-0.85124951,-0.87406414,-0.98542464,-0.92481279,-1.1423109,-1.1989013,-1.3274471,-1.3253523,-1.3118421,-1.6152854,-1.4893921,-1.5192434,-1.6435679,-1.7651363,-1.7808627,-1.7693679,-1.7036462,-1.5808381,-1.514497,-1.2562319,-0.84451015,-0.58471624,-0.25497409,0.094084758,0.32433591,0.55107838,0.74528092,0.95069877,0.93071939,0.9546492,0.93944269,0.88432477,0.77201014,0.72589135,0.68655497,0.51253385,0.5094377,0.56239388,0.50984199,0.51744012,0.6385411,0.59637104,0.5173034,0.42445349,0.38003208,0.4663492,0.49547786,0.34917531,0.28875307,0.39152232,0.26706048,0.13009224,0.13547225,0.1469021,0.21992705,0.058654254,0.056372273,0.086485371,0.081060454,0.36814576,0.42225387,0.32815171,0.097204519,0.093596469,0.17122378,-0.075630537,-0.22009723,-0.38431352,-0.11452093,-0.31720837,-0.51161624,-0.4062422,-0.52575455,-0.43942227,-0.398495,-0.36673933,-0.3991981,-0.4011091,-0.37107683,-0.45118047,-0.10021497:1
1.1136848,1.2759515,1.1717696,1.5545506,2.2805574,2.6366145,2.5146246,2.3631699,2.2908442,1.9977034,1.4460902,0.89958497,0.48563996,0.26313326,0.29406487,0.34376334,0.12968127,-0.13711442,-0.13280653,-2.1203208E-4,0.0098817709,-0.096064399,-0.25735378,-0.43236708,-0.51327196,-0.49664463,-0.52650745,-0.62988083,-0.71908856,-0.79905176,-0.92787733,-1.0341605,-1.0101813,-0.95694064,-1.0624701,-1.2500013,-1.3195625,-1.340979,-1.4703282,-1.5992998,-1.6095968,-1.6075118,-1.6499077,-1.6682428,-1.6649397,-1.6204273,-1.4843869,-1.4045185,-1.4872706,-1.4781004,-1.1803313,-0.84553996,-0.7308889,-0.7033779,-0.56484376,-0.35516238,-0.1865453,-0.053823743,0.073487655,0.15092643,0.18914477,0.25183877,0.28538033,0.24813057,0.2898822,0.44070419,0.47102845,0.38613676,0.42230345,0.49573157,0.4363915,0.41457686,0.46795906,0.3414711,0.14351733,0.20515967,0.38156602,0.39731845,0.38625482,0.48875603,0.59378758,0.64134859,0.61041713,0.43416825,0.25075548,0.30207927,0.48435699,0.47408666,0.32389267,0.38720001,0.57590077,0.42619681,0.077526796,0.14854868,0.47963844,0.35869955:-1
2.3182077,2.1397723,1.7942428,2.3445082,1.7244001,0.43150114,-0.46493276,-0.54241432,-0.83061992,-1.0304621,-1.0085366,-1.1021802,-1.2180437,-1.401442,-1.4139842,-1.5972161,-1.5951558,-1.662081,-1.7522677,-1.773032,-1.8930211,-1.9964,-2.0150844,-1.9543972,-1.9917178,-1.7743523,-1.6854017,-1.590773,-1.2452911,-0.83688913,-0.50086307,-0.17639789,0.29573971,0.43734757,0.68310889,0.94412037,1.0149309,1.1787161,1.0307682,1.1340155,1.1034208,1.0138814,0.83077624,0.85890163,0.71828765,0.84246549,0.72874428,0.69399081,0.67370002,0.6608787,0.68798483,0.53086131,0.58514143,0.53566934,0.59422713,0.29636702,0.33528204,0.4613322,0.33880822,0.27371213,0.33858363,0.40207336,0.25174685,0.33942136,0.16636575,0.12388623,0.28512037,0.061394392,0.2364906,0.47822144,0.51324236,0.71127693,0.64604118,0.51639063,0.43384229,0.14031974,0.043500662,0.12525496,-0.042819092,-0.26119278,-0.038989788,0.0056067503,-0.065313223,-0.10326394,-0.20858581,-0.10717359,-0.099291982,-0.23994788,-0.065850438,-0.090294413,-0.23489981,-0.032726877,-0.10266846,-0.064538765,0.28500798,0.4709143:-1
2.3953288,3.2836971,2.9185984,2.2790724,1.3932101,0.59204362,0.044003474,0.11027605,0.19821254,-0.011563777,0.023423599,0.2307394,0.26553835,-0.012758292,-0.54509781,-0.67987629,-0.68834857,-0.88596588,-0.76514215,-0.74203011,-0.89423145,-0.84096703,-0.94464485,-1.0277772,-0.8763005,-0.94337974,-1.1446141,-1.2123907,-1.3656036,-1.4738265,-1.4376218,-1.6150668,-1.7579095,-1.8037791,-1.8862005,-1.7157575,-1.6622751,-1.7559916,-1.5452774,-1.3495277,-1.1727089,-0.85319675,-0.69565434,-0.6153026,-0.40289409,-0.23116115,-0.013831581,0.21217697,0.15261597,0.34363292,0.57655582,0.44157153,0.56860661,0.48610606,0.45244988,0.8493017,0.47190121,0.29797681,0.65326878,0.17103482,-0.067739431,0.36776239,0.41515125,0.27954934,0.31923027,0.38973131,0.36861998,0.44662737,0.62430584,0.63196034,0.76893741,1.0582381,1.0761224,1.1212512,1.3442518,1.2499929,1.0466347,1.0931659,0.91598542,0.53523954,0.53367827,0.49414563,0.023635268,-0.074234368,0.29127406,0.24966594,-0.049051062,-0.09908478,0.027990872,0.1413533,0.085649959,0.0053042892,0.14987519,0.10350999,0.072659649,0.21594169:1
