#This dataset was formatted by R. Olszewski as part of his thesis
#“Generalized feature extraction for structural	pattern recognition
#in time-series data,” at Carnegie Mellon University, 2001. Each
#series traces the electrical activity recorded during one
#heartbeat. The two classes are a normal heartbeat and a Myocardial
#Infarction. 	
@problemName ECG200
@timeStamps false
@missing false
@univariate true
@equalLength true
@seriesLength 96
@classLabel true -1 1
@data
0.50205548,0.54216265,0.72238348,1.4288852,2.1365158,2.281149,1.9362737,1.46889,1.0088451,0.38028224,-0.29677967,-0.51392868,-0.25564469,-0.10720254,-0.28782655,-0.41800901,-0.31916313,-0.2603787,-0.35035721,-0.50548599,-0.71088709,-0.82391982,-0.89970154,-1.1539497,-1.2298306,-1.044091,-1.2020312,-1.3921949,-1.1301083,-1.1798666,-1.6492718,-1.7265754,-1.6083704,-1.6628022,-1.6506724,-1.6973094,-1.8386968,-1.8025962,-1.7805361,-1.8251665,-1.6447633,-1.4238097,-1.3921949,-1.3604156,-1.2001781,-0.91863234,-0.68591581,-0.66794346,-0.51272154,-0.10169069,0.063954259,0.082614311,0.23760718,0.17479318,0.12320539,0.5033942,0.6838702,0.47499476,0.53279711,0.72354995,0.6644198,0.64793559,0.75705403,0.7320716,0.62021499,0.60629677,0.67795016,0.68908363,0.59880728,0.54264656,0.58180737,0.63063068,0.6644198,0.6863178,0.65738251,0.65088944,0.72173837,0.73970645,0.69148052,0.69522947,0.7501145,0.85384485,0.91601888,0.82774969,0.88090557,1.0888307,0.93104294,0.61029836,0.63889427,0.68467857,0.58323764,0.64052167,0.70858515,0.70501088,0.71381545,0.43376464:-1
0.1476469,0.8046684,0.36777149,0.24389371,0.026613882,-0.27440211,0.096730583,-0.74773064,-1.6097771,-1.1795931,-1.0559264,-1.1287774,-0.68603867,-0.79878866,-1.7142791,-1.6498584,-1.0326988,-1.4239179,-1.7824333,-1.0251257,-1.7989086,-1.7936136,-1.0854783,-1.5743899,-1.0360595,-2.130021,-2.0386213,-0.05501273,-1.1401949,-0.70427521,0.048723084,-0.47585411,0.52586518,0.24477767,0.67993176,0.9286012,0.57304095,1.2316066,1.0433243,1.5802281,1.2905714,0.75051788,0.97756667,1.1415881,1.5299044,0.84768163,0.7667604,0.56568218,1.0846257,1.0573685,0.50308411,0.95328821,0.45419824,1.1989698,0.84971989,-0.13771474,0.63112045,0.69407501,0.51507095,0.5592294,0.555712,0.46969403,0.38882121,0.34312937,0.53559788,0.90070837,0.65684587,0.69003294,0.9525963,0.54776991,-0.16769268,0.011531941,-0.17648785,-0.27770647,-0.22483592,-0.91072293,-0.037931787,0.071667671,-1.0489198,-0.63621758,-0.38663674,-0.50751228,-0.7166559,-0.46375771,-0.46044227,-0.77079245,-0.53350348,-0.4002281,0.17608413,1.111768,2.4384282,2.7348886,1.7360544,0.036856551,-1.2650744,-0.20802439:1
0.31664616,0.24319908,0.37047144,1.0637381,1.6781871,1.7595575,1.6977172,1.612159,1.1681877,0.49995704,-0.022362533,-0.23531816,-0.11827251,-0.071027356,-0.32298644,-0.43356208,-0.31865971,-0.29565486,-0.41773284,-0.68247969,-0.88183977,-0.84332048,-0.88365177,-1.0300185,-1.0552655,-1.1686368,-1.3639905,-1.3376111,-1.2612936,-1.4097822,-1.6345041,-1.7032377,-1.6770249,-1.7826278,-1.9968716,-2.0563716,-1.9378809,-1.8794116,-1.9154266,-1.8455069,-1.658135,-1.5094832,-1.3934261,-1.2328683,-1.0243483,-0.76864001,-0.51129373,-0.30956399,-0.13196163,0.035054082,0.14215881,0.22580665,0.34369036,0.42858907,0.4695677,0.56978192,0.67566632,0.69988535,0.73256075,0.7716652,0.73812943,0.7236995,0.80687593,0.87898449,0.85579127,0.80638433,0.79250094,0.80381413,0.78193839,0.70043908,0.73595994,0.86416166,0.70766984,0.45875614,0.60014556,0.82513646,0.80003425,0.76282112,0.75544283,0.65376588,0.52644092,0.47733909,0.57494596,0.69842456,0.72241431,0.77159793,0.76422904,0.61062146,0.55290034,0.56678608,0.60400236,0.77706781,0.81234542,0.74884814,0.81804204,0.53934704:-1
1.1688741,2.0759008,1.7601405,1.6064459,1.9490456,1.3028421,0.45933154,0.51641212,0.85217953,0.98922717,0.82125349,0.57644764,0.74308944,0.8529702,0.30745835,-0.13039065,-0.062199969,-0.10072696,-0.23281819,-0.23446477,-0.21475573,-0.23041257,-0.22755149,-0.23100238,-0.46347873,-0.72421462,-0.78788488,-0.98668657,-1.224672,-1.2881418,-1.3641481,-1.4282213,-1.5017669,-1.6480837,-1.7058362,-1.6867905,-1.7057193,-1.7776833,-1.8693132,-1.8583761,-1.7377167,-1.7291486,-1.7281054,-1.5460373,-1.4591025,-1.4107518,-1.1634273,-0.90741874,-0.71621062,-0.58176337,-0.44252605,-0.20704617,-0.026462658,0.11703627,0.22063662,0.26431516,0.40505498,0.46497434,0.43416264,0.4868072,0.43938773,0.36961087,0.41314866,0.3978947,0.31876371,0.26371736,0.28886308,0.35824403,0.32673714,0.22921539,0.20441776,0.24438588,0.26263199,0.24388475,0.22750228,0.24578495,0.23295916,0.16461077,0.17153767,0.16669037,0.099141394,0.14693663,0.13341444,0.12529443,0.20271343,0.18640913,0.41900645,0.72388755,1.3239469,2.1364876,1.7465965,1.4702205,1.8935123,1.2569493,0.80040658,0.73153981:-1
0.64865752,0.75202595,2.6362312,3.4557156,2.1181574,0.52062024,-0.18862656,0.78081841,0.93377469,0.70140202,1.006133,0.39578379,-0.36970304,-0.73820206,-0.72908415,-0.90693968,-0.87096235,-1.060217,-1.1979584,-0.98160194,-1.2724972,-1.2873802,-1.2766979,-1.5397017,-1.3466101,-1.5352169,-1.7634184,-1.6888209,-1.8093685,-1.8638914,-1.9944534,-1.8898102,-1.9257132,-1.8336293,-1.6618298,-1.3425104,-1.0113174,-0.67271665,-0.21615671,0.052871572,0.56208966,0.70087985,0.94692677,1.0049973,1.0275423,1.1916636,0.96885533,0.84461754,0.77949209,0.743938,0.67335291,0.50527636,0.66254685,0.60770289,0.54610457,0.68716257,0.54300417,0.45314766,0.48578457,0.44067902,0.53915332,0.36957146,0.37731573,0.47011338,0.32144799,0.32551344,0.25125875,0.2705711,0.27716131,0.15517117,0.12095431,0.32639509,0.47395183,0.59473611,0.69819946,0.82678088,0.57516625,0.40119607,0.34996612,0.14805279,-0.033206288,-0.11426641,0.12034538,-0.22010169,-0.15122608,-0.077444659,-0.097868776,-0.13678697,-0.34023669,-0.089441428,-0.080297278,-0.19258444,-0.30470444,-0.45455625,0.31459,0.5821895:1
0.40473265,1.2808587,2.5151479,1.2995187,1.4534323,0.47427508,-1.3965619,-0.64708079,0.4319451,0.13244512,-0.40660902,0.23056633,-0.12135267,-0.9186398,-1.2467709,-1.3483736,-1.1902833,-1.0112698,-2.0039201,-1.3270367,-0.97603428,-1.8636169,-1.4876914,-1.6161399,-1.9575634,-1.7006637,-1.5184788,-1.8975843,-2.1771748,-1.8727894,-1.7752905,-1.6681586,-1.9333433,-1.4896118,-1.1507331,-1.0781561,-0.77372316,-0.5202207,-0.20525277,-0.026608191,0.29905385,0.19431966,0.70179318,0.67189094,0.85378659,0.67685205,0.89891601,0.77225822,0.6498631,0.63881629,0.67025023,1.0374359,0.43305326,0.65715862,0.52901327,0.56207051,1.0283513,-0.019686467,1.1777618,0.84790423,0.16943202,0.67343368,0.6352647,0.74822003,0.64016663,0.59131589,0.43168075,0.71749974,0.59541636,0.45848779,0.48356648,0.65571268,0.49079447,1.0668703,0.92914878,0.93902615,1.3121779,0.58060433,0.57095928,0.52277452,0.44632254,0.6206822,0.049713371,0.2698563,0.41891845,-0.064345669,0.37646912,0.27781111,0.22567582,0.15909081,0.40835397,0.54001519,-0.027791159,0.20347623,0.34696389,0.33918469:1
1.2050062,2.0318554,2.4472937,2.7394479,2.7458899,2.2763553,1.5253659,0.76059655,0.18844767,-0.029051462,-0.049523678,-0.20996418,-0.37415034,-0.24863758,-0.095016682,-0.099479162,-0.12141585,-0.35854858,-0.73913476,-0.78765165,-0.70894109,-0.75975595,-0.74105769,-0.88170685,-1.018906,-0.58138267,-0.35899328,-0.92421814,-1.0948085,-0.66136445,-0.78512404,-1.2881566,-1.3345034,-1.267791,-1.5021425,-1.6399716,-1.5339625,-1.566857,-1.7309945,-1.7196664,-1.6684945,-1.7355071,-1.6472869,-1.3875588,-1.3096055,-1.3196536,-1.1003919,-0.90045831,-0.93434224,-0.76519269,-0.31750385,-0.12712004,-0.12393914,0.094417909,0.28842606,0.26134707,0.28973234,0.40727778,0.43663741,0.44930812,0.57086672,0.71117799,0.67270791,0.50102225,0.50474276,0.6440953,0.5693421,0.40637792,0.45022584,0.51752375,0.50276501,0.57193338,0.63469281,0.6493091,0.70308117,0.58769289,0.355199,0.39096336,0.55882641,0.6110082,0.69257515,0.79444623,0.89688657,1.0514822,0.9391156,0.5557415,0.44731137,0.5646415,0.48760026,0.42100331,0.54976604,0.5054632,0.28184434,0.34683145,0.52637517,0.22788969:-1
0.59824137,1.0987288,1.6835287,2.4789134,2.8024127,2.438696,1.7176569,1.0093086,0.25735084,-0.22155853,-0.13558175,-0.1912687,-0.30697176,-0.16764052,-0.098005103,-0.056259596,-0.3234,-0.6301811,-0.56971894,-0.70940747,-0.75032305,-0.67332704,-0.98010141,-1.2071136,-1.1813802,-1.0263965,-1.2994876,-1.9288823,-1.9076361,-1.8688252,-1.9906124,-2.0116357,-2.4026522,-2.1440318,-1.6618146,-1.9393573,-1.8722725,-1.5546911,-1.3011939,-1.0164506,-0.97927654,-0.70625453,-0.30337161,-0.012646325,0.169673,0.091329657,0.25028041,0.38726526,0.25792917,0.42929196,0.51751195,0.40467528,0.51198192,0.57732858,0.52189259,0.55256222,0.60213932,0.54817524,0.41385248,0.37404084,0.51866444,0.55101816,0.41477723,0.48080068,0.59543525,0.56873712,0.72196906,0.84312816,0.6168265,0.60801778,0.77629989,0.61682123,0.59952044,0.68892604,0.5307274,0.54462062,0.65981978,0.56485534,0.47263422,0.45420433,0.40649302,0.31572594,0.15547546,0.15012374,0.35439193,0.37869259,0.39462999,0.5257822,0.279348,-0.069657784,0.027543961,0.15302475,0.042231911,0.13426885,0.29615038,0.06293182:-1
0.32800826,1.2102222,2.5976534,2.2107785,1.6216664,-0.23932105,-1.5987116,-0.60213646,-0.08660337,0.026581391,-0.30304941,-0.37246008,-0.27912982,-0.94947081,-0.9640863,-0.95486094,-1.2032956,-1.3401393,-1.3715076,-1.1738752,-1.4189553,-1.5592412,-1.3084412,-1.8123748,-1.699133,-1.5041931,-2.0016292,-1.8574369,-1.9543183,-1.7167091,-2.1675454,-1.6748811,-1.8145649,-1.5073572,-0.99970388,-1.0499143,-0.51484779,-0.29834696,0.12887592,0.37943089,0.47460243,0.60646546,1.0355295,0.9076036,1.0428804,0.91986476,1.1408321,0.85017406,0.78688814,1.0158116,0.78087507,0.80101238,0.65621393,0.6961819,0.67790021,0.90150874,0.65491565,0.81448478,0.85914247,0.68344701,0.64021189,0.79177879,0.56013986,0.63391226,0.77200739,0.41966977,0.63479984,0.53577461,0.32129593,0.48255678,0.57630614,0.28996466,0.68976896,0.85559866,0.75653094,0.86012922,0.72387774,0.4458859,0.52091469,0.59710275,0.0041582105,0.18873901,0.35839279,-0.16948401,0.31336029,0.12599111,-0.046115194,0.099801472,-0.05288849,0.11905553,0.061988986,-0.060122169,-0.030952939,0.001111159,0.22771811,0.23970956:1
1.668206,2.8481734,2.5169776,2.1727729,0.72046706,0.72537573,1.6386019,1.2929038,1.6095656,1.395034,0.1492802,-0.33322555,-0.45278197,-0.78508967,-0.82853298,-0.82657129,-0.97349672,-1.1701115,-1.1505492,-1.2575322,-1.4203531,-1.48459,-1.4657847,-1.3779393,-1.6042484,-1.7756386,-1.7615261,-2.0809162,-2.227107,-1.957896,-2.1089526,-1.89408,-1.8003226,-1.464235,-1.0480598,-0.89517518,-0.49069907,-0.017316799,0.20345441,0.27883112,0.67502424,0.65510886,0.68048762,0.71907747,0.72019,0.65602258,0.53604253,0.66836543,0.68619346,0.55904631,0.56085022,0.65964585,0.70940886,0.61547611,0.63125517,0.56741509,0.40070829,0.45704242,0.50830249,0.41179677,0.40052745,0.36189013,0.26791711,0.32174868,0.26268828,0.22581812,0.25668612,0.14650693,0.12344467,0.10569229,0.19601456,0.06434636,0.08059776,0.33326736,0.29294268,0.38261291,0.6815076,0.61509956,0.32699335,0.165494,0.09622552,0.018381314,-0.036049008,-0.022687817,-0.0061312772,-0.014322565,-0.15436469,-0.017805312,-0.0075062626,0.0053624637,-0.026597446,-0.048192086,-0.032347036,-0.21405366,0.05603087,0.14788919:1
0.48223006,0.98683211,1.4437677,2.1864284,2.5175393,1.878655,1.0926861,0.35257487,-0.29388443,-0.11538824,0.32008756,0.20484042,0.09906004,0.22945554,0.24823268,0.18641973,-0.18922971,-0.53960038,-0.45736717,-0.55985517,-0.68034464,-0.53120819,-0.55707366,-0.70828793,-0.79252432,-0.80892495,-0.89253087,-1.1835253,-1.3928976,-1.4238268,-1.6533368,-1.856352,-1.8704229,-2.2614426,-2.453607,-2.2074149,-2.2577907,-2.1794258,-1.9632911,-1.8399026,-1.5235893,-1.3561556,-1.0186789,-0.47368223,-0.34465464,-0.17375591,0.20482204,0.29904266,0.31969949,0.5891394,0.78199311,0.65391305,0.64801647,0.81655292,0.78281835,0.77050817,0.82553256,0.67838148,0.53792373,0.53594711,0.56489515,0.5541468,0.48341517,0.43787624,0.40430356,0.39575539,0.48234983,0.51771464,0.47598645,0.53858068,0.63027485,0.61814456,0.6643433,0.86471428,1.1087905,1.2390306,1.0899692,0.84222734,0.93301907,0.89372385,0.40913431,0.29969234,0.35868333,0.16955164,0.28576098,0.32195206,0.033172873,0.0068894041,-0.057385843,-0.30633237,-0.06741053,0.22519356,0.06938688,0.058976001,0.20719931,0.13314702:1
0.27482721,0.48103668,0.91926414,1.5386127,2.0466195,2.2471427,1.8813336,1.2234635,0.58100914,-0.013895524,0.075209638,0.32472237,-0.0998377,-0.16934754,0.0027368262,-0.068218734,-0.26885261,-0.87451394,-0.96353972,-0.63926924,-0.97817777,-1.0722797,-0.84334825,-1.1584434,-1.2610084,-1.1861971,-1.4552122,-1.6929553,-1.9015054,-1.681844,-1.5709794,-2.0163766,-2.1418538,-2.0269626,-1.9896808,-1.815479,-2.0673586,-2.1749792,-1.5897112,-1.3725735,-1.2477559,-0.88125119,-0.6872476,-0.40212389,-0.20059631,-0.071597842,0.031612797,0.080364427,0.21287398,0.3354064,0.47743425,0.53826973,0.48987919,0.51794475,0.53220601,0.48414343,0.48955919,0.51085975,0.42388961,0.49546141,0.7047736,0.56084504,0.43955004,0.58182821,0.61366758,0.63757675,0.66634325,0.63429892,0.65031586,0.70749353,0.76192815,0.75524205,0.78469797,0.9191244,0.96093655,0.91454644,0.99706479,1.0213727,0.83071642,0.75422812,0.73992558,0.53291993,0.44239105,0.50658326,0.44782721,0.42828057,0.43737808,0.3422193,0.38030214,0.36825288,0.25368051,0.29288411,0.29816396,0.3171801,0.42303507,0.26151674:1
-0.70630453,-0.22618127,0.21619952,-0.31772657,-0.64897192,-1.2193491,-1.524295,-1.5080601,-1.5508989,-1.6004537,-1.6891668,-1.3953936,-1.4708313,-1.5817696,-1.3080662,-1.3220377,-1.3201542,-1.3945806,-1.2384409,-1.3179835,-1.4283442,-1.3303188,-1.3595008,-1.3505409,-1.4492425,-1.4248941,-1.2990896,-1.1066066,-0.97070858,-0.78746971,-0.40474516,-0.23162907,-0.067758632,0.14492215,0.42255456,0.53402642,0.35755296,0.52821483,0.4617568,0.36351216,0.313566,-0.023153428,0.2423185,-0.0023966644,0.0079621215,0.025180826,-0.046041074,0.31519173,0.21896092,0.30766391,0.53138597,0.41760631,0.48482066,0.56905186,0.70470753,0.67666848,0.63186926,0.80665436,0.67985002,0.57379448,0.69169559,0.70951523,0.68260676,0.60653853,0.62393644,0.53698955,0.79352766,1.1080892,1.0154766,1.1737391,0.67925679,0.57059741,0.48242833,0.33532385,0.415497,0.26353051,0.26492582,0.19964877,0.22967746,0.32640105,0.20278218,0.18153191,0.23192633,0.38609804,0.26526622,0.24689965,0.33816714,0.12088731,0.33196993,0.64158999,1.5313945,3.12484,3.3320526,2.6537407,1.1553846,-0.36681942:1
0.98754646,2.8132911,3.8502628,2.3797891,1.6998137,0.078576335,-0.59667118,0.82701885,0.87119579,0.80990883,0.84297108,0.60561297,0.089042884,-0.59212075,-0.64018804,-0.58381473,-1.021813,-0.87248309,-0.97818045,-1.0883289,-1.0609642,-1.2332062,-1.3973797,-1.4201622,-1.2854148,-1.6192753,-1.6767422,-1.5017018,-1.6669005,-1.8556772,-1.9268678,-1.5274143,-1.6123279,-1.6619347,-1.2214505,-1.0313656,-0.56222713,-0.14094272,-0.044415415,0.40790194,0.64344005,0.52700599,0.96391793,1.1173067,0.86714949,1.1099007,0.94822195,0.90597994,0.80929904,0.8630134,0.76800848,0.57859233,0.83727355,0.42243563,0.55999064,0.74246549,0.55067561,0.52511349,0.63924848,0.47647589,0.39718967,0.54513339,0.3330331,0.36683921,0.44647151,0.078466812,0.20627515,0.33430092,0.10823433,0.0034538347,0.028080629,0.28769202,0.24131422,0.69449025,0.67393263,0.49159487,0.5070639,0.10098599,0.25562729,-0.080152137,-0.40710484,-0.17139404,-0.44053475,-0.32062696,-0.37312979,-0.42548927,-0.24189468,-0.69143558,-0.40364135,-0.29384537,-0.5591784,-0.19439362,-0.55988427,-0.70637758,-0.30707688,-0.22249628:1
0.50112303,0.72913063,0.83374023,1.2557705,2.0013616,2.5040332,2.4541953,2.2203273,2.1224353,1.9165236,1.3821329,0.73544948,0.22085538,-0.04881732,0.058893288,0.37064182,0.35392528,-0.056939609,-0.27014949,-0.030288404,0.18392629,0.034146417,-0.18551869,-0.1769411,-0.14088564,-0.33827446,-0.56327929,-0.53183852,-0.39902793,-0.47085456,-0.69888015,-0.86421976,-0.92543852,-0.92040642,-0.88177787,-0.94323662,-1.2015819,-1.4695271,-1.496398,-1.4124957,-1.56781,-1.9120904,-1.9972442,-1.7388993,-1.5818148,-1.716598,-1.7979588,-1.6296142,-1.4509832,-1.4278371,-1.4234267,-1.3124234,-1.1325473,-0.92964111,-0.71796579,-0.53865342,-0.41701616,-0.29451916,-0.13417765,-0.029799267,-0.047161714,-0.059706364,0.087574776,0.29597052,0.35727159,0.30529841,0.3596797,0.53631147,0.60598555,0.52141357,0.49248463,0.56384421,0.5486995,0.45977545,0.53210383,0.75307517,0.84651787,0.7551361,0.69976801,0.73676406,0.65962871,0.45889683,0.42427792,0.57514723,0.55918781,0.35328436,0.3580163,0.60588882,0.71096266,0.61971023,0.56493009,0.55611367,0.56181896,0.65818662,0.63971097,0.24261796:-1
2.2487902,3.5350384,2.8882737,2.7209197,0.86212017,0.3755771,1.6392038,1.2831241,1.1570711,1.1850721,0.59537694,-0.05150871,-0.43380888,-0.37916601,-0.52318316,-0.71830401,-0.71356612,-0.82040631,-0.85969474,-1.0077108,-1.1345552,-1.0714557,-1.1277623,-1.3159615,-1.5013693,-1.5051951,-1.6538586,-1.8809025,-1.8100991,-1.8814254,-1.9864112,-1.9802986,-1.7677252,-1.4316559,-1.2489468,-0.92451407,-0.49763379,-0.15127407,0.19643811,0.36145691,0.52481618,0.78185211,0.85574991,0.86800457,0.82624508,0.78078015,0.72518763,0.65159462,0.65550067,0.52495374,0.56875127,0.72005592,0.5729603,0.50084141,0.49535629,0.51489919,0.5163807,0.40598206,0.42214327,0.41079177,0.3194716,0.31647894,0.30740853,0.25230219,0.098817208,0.058965974,0.14112748,0.074438681,0.010571305,0.018008545,0.06032822,-0.0052835382,-0.039992762,0.085052042,0.23214528,0.38484877,0.40289912,0.39355616,0.24032629,0.053103837,-0.015459353,-0.19510253,-0.19249284,-0.34953564,-0.43444403,-0.23053023,-0.27959324,-0.39912965,-0.35639212,-0.25185433,-0.31717097,-0.35169056,-0.25222444,-0.2754384,-0.29134662,-0.20508485:1
0.31930911,2.0916954,3.4437763,2.2330166,2.3024139,0.62160769,-0.88666448,0.24808104,0.49880185,-0.098005224,-0.030765777,0.34472022,-0.38987174,-0.62012368,-1.0453047,-1.0410438,-0.61869683,-1.1784057,-1.1975206,-1.0880619,-1.3816531,-1.2971845,-1.3249303,-1.501298,-1.6616468,-1.8333884,-1.8141706,-1.6741169,-1.8588047,-1.9986341,-2.0455699,-1.8967705,-1.6343955,-1.3429893,-1.1656694,-0.90722241,-0.5020325,-0.1439111,0.20306092,0.6738644,0.70463673,0.63686847,1.1166565,0.66957454,1.1391991,1.2432912,0.77798058,0.93665667,0.70713413,0.88868946,0.9200951,0.74580973,0.65805635,0.4053932,0.82966271,0.74840541,0.5809532,0.62708381,0.48055791,0.56559193,0.6678784,0.56885552,0.45093787,0.4585795,0.38092638,0.34950893,0.39879126,0.22800942,0.14285328,0.10983773,0.20422445,0.10185956,0.27016878,0.45458897,0.68958872,0.92953394,0.50570993,0.36376327,0.44699331,0.29017508,0.040298406,-0.20253657,-0.083446265,-0.15863462,-0.042542894,-0.19342755,-0.16064206,-0.20791505,-0.16577684,-0.18602181,-0.18400319,-0.02605305,-0.27751489,-0.12845581,-0.042731837,-0.17717182:1
0.6303957,2.1919773,3.5209004,2.7300388,2.1389401,0.56072695,-0.67853152,0.73745468,1.1284541,0.61621496,0.95796663,0.84746895,-0.0042978538,-0.49077663,-0.53657841,-0.75626983,-0.8623727,-0.92217942,-0.91724381,-1.0339617,-1.0888734,-1.1075535,-1.1772523,-1.3366449,-1.5629357,-1.4416866,-1.5250047,-1.807127,-1.9284675,-1.9496758,-1.819808,-1.7579563,-1.7316727,-1.674876,-1.3019642,-1.0401643,-0.7638732,-0.34104548,-0.16280014,0.24012595,0.31242077,0.53646954,1.0895203,0.83278792,0.81900637,0.90212204,0.79193508,0.88963177,0.77246854,0.7469912,0.66540339,0.52013208,0.7012037,0.82642646,0.66509135,0.42308822,0.68346718,0.7785762,0.36476564,0.65740999,0.90881109,0.72742986,0.4116391,0.24151131,0.41591219,0.32387831,0.27553765,0.20409279,0.22254801,0.31690479,0.084497126,0.35334228,0.37652863,0.65982328,0.81620248,0.68012713,0.31022602,-0.20623397,0.030208269,0.094015152,-0.10082389,-0.28888674,-0.26615541,-0.15192877,-0.4778374,-0.22496145,-0.27264759,-0.484068,-0.51663144,-0.57430419,-0.1411563,-0.44795985,-0.73801942,-0.39860496,-0.48868911,-0.23231543:1
1.0880765,1.5640399,1.3688902,1.2501573,1.4914982,1.6825891,1.2269507,0.34396908,-0.33531682,-0.72931956,-0.94971983,-1.0159285,-1.0660428,-1.1633754,-1.2074661,-1.2347116,-1.3248416,-1.3649445,-1.3312292,-1.356372,-1.370512,-1.3339249,-1.3781622,-1.3952861,-1.4009589,-1.4920148,-1.5029839,-1.5535053,-1.5988639,-1.4645683,-1.516411,-1.6458347,-1.5075231,-1.4002917,-1.3866241,-1.2240926,-1.0355959,-0.88889497,-0.67086707,-0.50035903,-0.30486991,-0.042425979,0.011476354,0.10149345,0.25839805,0.1373443,0.10318456,0.25942847,0.28884496,0.37561229,0.45706007,0.24608338,0.1670573,0.34107174,0.26229991,0.22048166,0.36496225,0.28835255,0.28827916,0.40272726,0.36496225,0.43108901,0.47695407,0.34008248,0.48674992,0.74087597,0.60662226,0.64531556,0.88255983,0.70573837,0.56069736,0.5381514,0.42585609,0.5963963,0.77936324,0.73281109,0.62376104,0.49063238,0.43944916,0.25488385,0.19750421,0.40071896,0.24904405,0.20962139,0.36496225,0.12984442,0.24432215,0.58525362,0.54764375,1.0933019,2.1507955,2.3850658,1.9938723,1.7602863,1.2692178,0.39910334:-1
0.5264121,1.0079024,1.7898944,2.3580139,2.3014737,2.0870246,1.9675564,1.5140547,0.75045389,0.11539967,-0.22783536,-0.20111247,0.0014060274,-0.090393416,-0.36348937,-0.43495219,-0.42163636,-0.38390173,-0.24369553,-0.29330432,-0.59897814,-0.79239756,-0.79440992,-0.74223293,-0.70061494,-0.84145907,-1.1115483,-1.189314,-1.172079,-1.3321921,-1.5125598,-1.560419,-1.6294781,-1.7536262,-1.8152875,-1.8171945,-1.8183641,-1.8307318,-1.8100596,-1.6991048,-1.54577,-1.4566662,-1.4365454,-1.4095046,-1.2618154,-0.91441063,-0.52657305,-0.39644392,-0.50146707,-0.45028828,-0.13146598,0.069685738,0.045052045,0.12483771,0.26294534,0.2428136,0.3090242,0.4591846,0.29894485,0.096622746,0.32105926,0.55117831,0.35607157,0.19536367,0.41527749,0.5729076,0.41172368,0.33065713,0.45350512,0.4586406,0.39882301,0.494015,0.60765852,0.63189399,0.59523745,0.53274663,0.60443758,0.68789901,0.54608739,0.58014005,0.94054621,1.0174775,0.88870856,1.0290469,1.0391371,0.77887393,0.7795607,0.85121082,0.65955611,0.6312745,0.83081463,0.82709376,0.73991266,0.82409383,0.80693862,0.49505124:-1
-0.36808017,-0.62198358,-0.60141727,-0.62828928,-0.61144343,-0.39257197,-0.32274168,-0.57911647,-0.89648815,-0.9948452,-0.81096441,-0.74245493,-1.0150701,-1.0731354,-0.85638102,-1.0930954,-1.5145011,-1.3941725,-1.1909184,-1.5410888,-1.8866602,-1.7607609,-1.916579,-2.0768171,-1.7355405,-1.918453,-2.1974395,-1.7578711,-1.5190403,-1.585452,-1.3944578,-1.003315,-0.6906748,-0.48888243,-0.11740004,0.25205028,0.153349,0.13985183,0.55046178,0.54731812,0.31909548,0.50850911,0.62449724,0.59734396,0.61482105,0.47970538,0.46921327,0.63920536,0.49066668,0.3388896,0.51168528,0.58297709,0.50136524,0.44552905,0.49031067,0.57064332,0.54944186,0.6226834,0.70378381,0.70743103,0.83658141,0.97671097,1.0447076,1.1005165,1.1871488,1.2850059,1.2504146,1.1659265,1.0236343,0.81085304,0.69145775,0.56948125,0.58941742,0.70348381,0.68204818,0.59810378,0.23660011,0.11398171,0.39492419,0.34853846,0.38970864,0.45654441,0.15365625,0.18117864,0.36646374,0.29835318,0.55686438,0.96894031,1.3547533,2.1901509,2.4654772,1.646662,0.92194246,0.27019593,-0.49064016,-0.45251328:1
0.08725314,1.2520477,1.9706734,1.7369054,1.3942079,-0.28091459,-0.36111772,0.82250354,0.057914995,0.019468541,0.2184925,-0.68816176,-0.93545714,-0.99010877,-1.0866248,-1.1528112,-1.2421486,-1.2978639,-1.3145734,-1.3549397,-1.4753261,-1.4923176,-1.5284035,-1.6943233,-1.7820547,-1.7944331,-1.8747797,-2.0250171,-2.011048,-2.0139477,-2.1668307,-2.0968878,-1.8472235,-1.7563754,-1.5338703,-1.144208,-0.80359528,-0.43019413,-0.12211469,0.18942908,0.4492385,0.51023832,0.64912288,0.74644297,0.65568343,0.58777003,0.60879144,0.66036694,0.42151345,0.42654404,0.60489586,0.52182373,0.5714113,0.58367184,0.57611727,0.58776723,0.63383532,0.58023172,0.49449989,0.45595736,0.54473783,0.52592434,0.38214582,0.43976674,0.52711614,0.50140767,0.41953567,0.38130368,0.42180031,0.38075815,0.44102916,0.55042779,0.46371421,0.42800741,0.72512227,0.86005159,1.008694,1.0243868,0.86485997,0.87815173,0.69027609,0.63679502,0.70271127,0.55505912,0.34563621,0.55502419,0.74035298,0.44952291,0.47831376,0.56835381,0.65437888,0.53082438,0.64064978,0.73917852,0.51967381,0.64716018:1
0.47041178,1.1748488,2.2214786,3.9038609,2.7879987,1.0087323,-0.58596686,-1.114817,-0.12519509,0.11704067,0.20179858,-0.38598629,-0.20846672,0.25844822,-0.29346312,-0.10047724,-0.44661919,-0.94101217,-0.71326638,-0.80758438,-0.95976323,-1.0230287,-1.2076556,-1.2410564,-1.3355131,-1.5213725,-1.5576032,-1.5766115,-1.7348497,-1.9569032,-1.7295609,-2.0988834,-1.7148509,-1.7751271,-1.6744488,-1.3307911,-1.2737656,-0.66548051,-0.69212143,-0.25276116,0.077724652,0.04161385,0.47523099,0.80391968,0.91850262,1.1074806,0.77580526,1.052794,1.0120119,0.72443783,0.95483584,0.63820354,0.80321316,0.80865492,0.35048747,0.59308132,0.81393851,0.63892725,0.46192926,1.3950243,0.24079772,0.058935948,0.80172289,0.060674966,0.56301153,0.38523352,0.10923447,0.47034604,0.16641582,0.18778965,0.43108177,0.3340818,0.30683461,0.80995113,1.1522226,0.5408318,0.90570745,0.73703156,0.055853564,0.20591019,-0.015736798,0.090974722,-0.22159296,-0.2804552,-0.44835145,-0.04101777,0.037214251,-0.19196349,-0.33125672,-0.05707169,-0.044218663,-0.21300695,-0.14713871,-0.14602941,0.086343138,-0.14779453:1
1.3510633,2.8253475,2.6405387,1.2185972,-0.056741817,1.1969525,0.72468158,0.96665163,0.54982412,-0.98860325,-1.0896612,-1.3796467,-1.4933006,-1.5358864,-1.6085794,-1.7979364,-1.8713879,-1.8084146,-1.9634411,-1.8674521,-1.9725184,-1.974003,-1.8118577,-1.7760929,-1.6584819,-1.5790928,-1.2089554,-0.95651798,-0.57893192,0.0091407399,0.41393379,0.79693596,1.1532698,1.3466296,1.5805981,1.6579084,1.5706004,1.4357052,1.3710045,1.1873345,0.97515895,0.90662467,0.80631102,0.79696583,0.60693675,0.64409607,0.43638846,0.4173406,0.39732821,0.27774806,0.3563615,0.22353753,0.218878,0.21645073,0.22628126,0.051749369,0.057490234,0.14059423,0.0081304607,-0.013382516,0.042685178,0.062064605,-0.057979348,-0.05566184,0.062631029,-0.15101682,0.016422729,0.032865136,-0.14212168,-0.043954713,0.0019502207,-0.023239864,-0.043992575,0.028251186,-0.037340248,-0.011156313,0.0041186808,0.0062360765,0.22729099,0.37901905,0.40506216,0.19951882,0.29168416,-0.027799432,-0.19868525,-0.17073811,-0.28446251,-0.15061437,-0.26200415,-0.22242406,-0.27178308,-0.065167955,-0.15399404,-0.099545425,-0.072254718,0.015932976:-1
0.47527619,1.3431131,2.7848317,2.8877708,1.5500174,-0.40538954,-0.02436819,1.0565722,0.76472116,1.0003107,0.61892367,-0.26310215,-0.57270577,-0.68380925,-0.85528617,-0.87181822,-0.97463085,-1.0680316,-1.0048411,-1.1564903,-1.2206934,-1.3067336,-1.4448952,-1.4511084,-1.662704,-1.7535886,-1.75575,-1.9270272,-2.0732827,-2.1304679,-2.1625923,-2.1702212,-2.0143108,-1.7348827,-1.4720145,-1.1195179,-0.67855046,-0.24605327,0.17242743,0.48751637,0.72219379,0.87896307,0.85769667,0.89469716,0.93045816,0.74775761,0.67615078,0.71573034,0.69377634,0.65056269,0.65600825,0.69737415,0.72206868,0.74480756,0.6891006,0.68170334,0.70529202,0.67208974,0.66611669,0.60662528,0.68661784,0.53906457,0.47444208,0.55984467,0.41716552,0.43372555,0.4007906,0.32196062,0.34978547,0.33543097,0.22770578,0.19367019,0.22742227,0.17551903,0.34750821,0.61978171,0.67846578,0.56769143,0.45223543,0.3966564,0.21912562,0.042417516,0.0088995724,0.03596579,-0.062248542,-0.099531844,0.04216042,-0.051857131,-0.067828242,0.010169754,-0.019263554,-0.057951543,-0.077762082,0.07563837,0.080578491,-0.029783082:1
0.6692266,0.64016336,0.33815791,0.28531081,-0.13126681,-0.28827394,-0.33789631,-0.77754625,-0.72411581,-0.70891127,-0.90083177,-0.92681631,-1.206166,-1.2043277,-1.2900816,-1.4926257,-1.4695423,-1.6202575,-1.9641802,-2.140537,-2.2355785,-2.1912348,-2.4190612,-2.3833501,-2.3352814,-2.4091296,-1.7280794,-1.508118,-1.1367001,-0.59679096,-0.42528446,0.049137167,0.33933537,0.5951183,0.81456139,0.51347237,0.7409389,0.82628155,0.52163904,0.69541518,0.64173935,0.5767863,0.58165316,0.6270132,0.64005163,0.63360328,0.45195683,0.75507765,0.64087958,0.5253825,0.66578504,0.42517263,0.56961246,0.63776834,0.45642456,0.18157832,0.47894905,0.46425351,0.37112865,0.57090088,0.15882532,0.5223865,0.56684164,0.061079969,0.47445439,0.34933249,0.2423789,0.60357026,0.61054679,0.78138735,1.0117046,0.57541476,0.33857279,0.6034177,0.2955411,0.21154464,0.41840097,0.088503418,0.18171743,0.33434729,0.027673647,0.29401312,0.32948968,-0.03062947,0.38243103,0.22032801,0.21024644,0.15923002,0.27205537,0.41075926,1.0621578,2.5427672,2.1921942,1.5474987,0.90299398,-0.32566723:1
1.1949282,2.1907971,2.4432745,2.0007909,1.0049886,0.18298559,0.84161448,1.3158619,1.0808092,1.348972,1.147414,0.31794044,-0.39567572,-0.52295339,-0.58800575,-0.73068718,-0.8104488,-0.89688854,-0.96893386,-1.1616738,-1.2225131,-1.2840793,-1.4718455,-1.661311,-1.9441719,-2.039104,-2.1801167,-2.4142204,-2.4477675,-2.4448851,-2.2974206,-2.1031254,-1.8770823,-1.5394675,-1.1415042,-0.81260151,-0.49507519,-0.17519287,0.07494074,0.30021044,0.40394604,0.46492757,0.50599689,0.57274747,0.51675065,0.51725614,0.51176246,0.44605113,0.46327016,0.47779571,0.50613804,0.52307572,0.49089689,0.55358738,0.57940421,0.5108784,0.57680163,0.55857759,0.54380342,0.54597403,0.45310459,0.47026043,0.51533453,0.39092365,0.40203223,0.39944293,0.33478044,0.39259157,0.28207243,0.31198979,0.34734552,0.35167915,0.51548996,0.60228285,0.65119116,0.63261702,0.4099852,0.36886411,0.31356913,0.13937583,0.093670719,0.077365223,0.12533221,0.060442159,0.083074091,0.054984777,0.061965212,0.086669753,0.065612145,0.0032298112,0.10953369,0.060000817,0.040453145,0.069218255,0.17855007,0.45654674:1
0.20303954,0.4620785,0.74836772,0.99695917,0.99855221,0.84949403,0.87570482,1.0092909,0.80806681,0.16128675,-0.41905794,-0.45015898,-0.21226069,-0.33518908,-0.74453609,-0.84187552,-0.59821278,-0.46744349,-0.54607648,-0.69481032,-0.85633856,-0.90661027,-0.85141067,-0.7671981,-0.50010025,-0.2679663,-0.61161333,-1.1419276,-1.1068337,-0.91681409,-1.1133568,-1.1243013,-0.63091696,-0.41757296,-0.83858138,-1.1334201,-0.92595138,-0.8273845,-1.096835,-1.2912432,-1.383113,-1.6018684,-1.6551462,-1.4481861,-1.4093576,-1.5045071,-1.3606741,-1.1107051,-0.9906629,-0.86473975,-0.66534071,-0.53173869,-0.4564117,-0.29351677,-0.048334569,0.1432135,0.2684479,0.37448588,0.43712032,0.52029813,0.64595463,0.62296152,0.47560443,0.46532114,0.51372922,0.43557245,0.41166962,0.50660284,0.4346806,0.21509747,0.2123013,0.38697442,0.33385625,0.11874715,0.19977383,0.47825397,0.52159962,0.41185944,0.33925708,0.2328307,0.25209581,0.43315453,0.35764047,0.17873833,0.37737192,0.5720518,0.49869164,0.74312635,1.3640378,1.9802452,2.7125249,3.2698816,3.070404,2.5160159,1.9308803,0.88438617:-1
0.46679299,0.50362537,0.78866915,0.2229358,0.53730356,0.04355325,-0.26114082,0.80315578,-0.1395228,-0.61216233,-0.32442077,-0.16721713,-0.21054138,-0.95789518,-0.096172781,-0.31173137,-0.74357761,-0.87320425,-1.0822995,-0.63932937,-1.4214385,-1.884789,-0.75447711,-1.2973123,-2.540979,-2.3123259,-2.0156218,-2.2682195,-2.6171746,-2.4110906,-2.1820322,-2.1904259,-2.1644801,-1.7266159,-1.1703102,-1.2692843,-1.1404064,-0.22604982,0.29834944,0.22685559,0.39090723,0.71562147,0.77004117,0.86562574,1.0802876,1.0445707,0.70439676,0.84998655,1.2178231,0.76010925,0.46583469,0.91208319,0.93517011,0.63411733,0.59564138,0.70628078,0.91283177,0.82767998,0.61224018,0.9540478,0.97561273,0.62999832,0.53994467,0.4817332,0.6609393,0.78531361,0.82605179,0.64012639,0.27749628,0.50911507,0.69916736,0.74421755,0.033625115,0.47069981,0.77461005,0.27925622,0.44518242,0.18205782,0.68915684,0.62440027,-0.097793865,0.49746032,0.34999828,0.34933738,0.32493302,0.59795569,1.0019739,0.67440973,0.73932393,0.54086328,0.34583422,0.7777283,0.2481278,0.0042834999,0.42519351,0.11737688:1
0.15058441,1.656594,2.7067667,2.6687049,2.1616487,0.45358164,-1.1248073,-0.035755804,0.71933982,0.16920057,0.52592483,0.64460189,-0.032198206,-0.65313136,-0.64744008,-0.99854648,-0.98739107,-1.2347709,-1.1688943,-1.132583,-1.2814418,-1.2022795,-1.3473458,-1.4705966,-1.6609084,-1.7332526,-1.6761992,-1.7228702,-1.9567843,-2.0945013,-1.9965956,-1.8874305,-1.9523265,-1.5933899,-1.4014487,-1.3560129,-0.95886457,-0.48330417,-0.044625343,0.13144175,0.34893485,0.65345523,0.92827746,0.90349566,0.97048627,1.0221354,1.0770498,0.97306995,0.92998056,0.84903207,0.76882158,0.75621834,0.65609937,0.81248661,0.724854,0.60643634,0.53883091,0.59598285,0.76608981,0.65196068,0.58152192,0.50954751,0.61452675,0.68880188,0.39052644,0.30701265,0.33509223,0.42430212,0.36649593,0.16733544,0.41284926,0.53834086,0.37945446,0.54479634,0.75413877,0.71926784,0.50206206,0.30988251,0.24499447,0.1870624,0.022708647,-0.19090177,-0.089089718,-0.035984174,-0.13561674,0.03892077,-0.11521328,-0.22757884,-0.12842996,-0.1619318,-0.014223368,-0.1007102,0.10191216,0.012287898,-0.104105,0.46355293:1
-0.15738917,0.73698093,2.4996379,3.0521245,1.6280319,-0.36093506,-1.2269598,-0.0902894,0.46134368,0.26394649,0.37287578,0.1095486,-0.61703345,-1.2405919,-0.63759698,-1.1867339,-1.1788481,-1.3021618,-0.99205735,-1.004383,-1.2935122,-1.4486697,-1.7158839,-1.4317256,-1.4990846,-1.5586424,-1.85676,-2.0150859,-1.7349102,-1.6264839,-1.9218907,-2.0577809,-1.6867679,-1.4645761,-1.3867518,-1.1050826,-0.60325177,-0.28381611,0.01852978,0.30979707,0.61014797,1.1890136,0.89323066,0.98472203,1.200026,1.136819,1.1377805,1.1240111,1.0165527,0.95049934,1.0063636,0.89310823,0.65362024,0.88646385,0.94861722,0.5431492,0.85479621,0.44309256,0.35907526,1.0432701,0.82765915,0.29922593,0.49136903,0.62283443,0.24474693,0.51545871,0.50933115,0.25763912,0.54448365,0.10467057,0.30478711,0.29124101,0.06150538,0.48883963,0.48156552,0.76400489,0.57885921,0.65465996,0.57880072,-0.057641124,0.338954,0.1320958,0.076898761,-0.058980391,-0.076748768,-0.022102371,-0.16132255,0.06865574,0.1921494,-0.051263559,0.068644092,-0.017255661,0.016510036,0.1490497,-0.026306049,0.16546113:1
0.65656714,2.439455,3.7686961,2.5048154,2.0810982,0.58786769,-1.0527939,0.091880465,0.99214593,0.23873695,0.20619455,0.55427393,-0.48057051,-0.60856053,-0.63123276,-0.75097956,-0.9105596,-1.1746287,-0.95275915,-1.173999,-1.2248547,-1.0880795,-1.3026384,-1.3779335,-1.587647,-1.7171806,-1.7041702,-1.7736293,-1.8051685,-1.6335501,-1.8505269,-1.7669636,-1.6500436,-1.4334016,-1.0455713,-0.95910861,-0.65108539,-0.29491825,0.085521008,0.37741574,0.46232903,0.76958732,0.90868507,1.0654491,1.0118724,0.88326502,1.1871739,0.893563,0.72847378,0.94516327,0.59859893,0.55621742,0.69009435,0.62736479,0.59536816,0.56438527,0.73411269,0.63819072,0.51245173,0.6474743,0.75772934,0.3591961,0.59307667,0.57323765,0.18039386,0.54497909,0.33009122,0.26131178,0.34823146,0.15802124,0.20835002,0.14473466,0.30454222,0.57923734,0.58702684,0.42327712,0.67516352,0.32828563,-0.096943569,0.044244043,-0.12724098,-0.11493543,-0.28178372,-0.14773509,-0.2858337,7.0280533E-5,-0.39000289,-0.47257244,-0.10795655,-0.42759193,-0.37007859,-0.35622477,-0.42782566,-0.37963448,-0.3576884,-0.059085421:1
1.2571379,2.7809697,3.2871348,2.700352,0.86951154,0.75423951,1.5212668,1.0206125,1.0330029,0.91998275,0.0040308763,-0.4328252,-0.43523685,-0.64467814,-0.80723278,-0.78744574,-0.89934918,-0.99303352,-1.1098699,-1.1504357,-1.2722753,-1.3851092,-1.4737069,-1.5216449,-1.6190877,-1.8408816,-1.7668947,-1.9955843,-2.1403108,-1.9179246,-1.9873367,-1.8178444,-1.7714289,-1.4208218,-0.99477631,-0.73744766,-0.36325566,0.01113692,0.3764232,0.45803705,0.68402413,0.78140676,0.80419809,0.77813236,0.8654643,0.73073193,0.5854085,0.65586063,0.60165239,0.60567876,0.53661635,0.53257847,0.6359821,0.53099612,0.55949644,0.54941496,0.50059776,0.49216999,0.42445282,0.46236985,0.33620966,0.35603203,0.43532801,0.34044294,0.28557744,0.23317215,0.31345426,0.30001874,0.17777537,0.16156702,0.22713739,0.15108552,0.12896749,0.32105873,0.55903857,0.60961813,0.54140162,0.39574596,0.21263311,0.077601894,0.062430149,0.043606603,-0.12017359,-0.13750672,-0.13823033,-0.097822607,-0.35762979,-0.23568494,-0.12330699,-0.22417645,-0.2264636,-0.20708515,-0.10117279,-0.31391839,-0.16804224,0.15667789:1
0.18824682,0.54011861,2.1784493,3.4937688,2.0753308,1.2102543,-0.26732577,-0.86685963,0.28339578,0.40012091,0.14208125,0.092881754,0.18240754,-0.69088571,-0.81472327,-0.95037184,-1.1110586,-1.1942503,-1.133374,-1.1823912,-1.2967505,-1.3465192,-1.4017603,-1.5283034,-1.675998,-1.6817738,-1.6940246,-1.7275974,-2.0750283,-1.9526867,-1.9090556,-2.0473411,-1.9649807,-1.738151,-1.3949086,-1.3243972,-0.82439899,-0.31298538,-0.1590169,0.28844589,0.48422411,0.81593643,0.93325722,0.86988103,1.0163635,1.0748939,0.98014325,0.94649985,0.85434159,0.73572487,0.7186939,0.65853318,0.68489,0.70924256,0.56570213,0.55820413,0.56666706,0.58567217,0.58357824,0.4476914,0.57826374,0.52546581,0.45305751,0.47656667,0.35518571,0.45571947,0.49012269,0.38348068,0.22396411,0.3329755,0.4131472,0.10550942,0.55240783,0.79898319,0.66881835,0.8149307,0.57742444,0.44011513,0.35085284,0.18347025,0.23293268,0.14886325,0.025794922,-0.088937537,0.1061531,0.23085483,0.078553916,0.059380192,0.0014209701,0.041701978,0.16332997,-0.14498441,-0.033069499,0.22010903,0.049480863,0.12923039:1
0.5347352,1.1512282,2.6653731,4.1776046,2.9168965,1.478838,0.13561963,-0.63417895,0.37588637,0.90807948,0.58484092,0.27323378,0.39029792,0.088883087,-0.3768425,-0.51716061,-0.68466891,-0.75120423,-0.83014081,-0.728014,-0.91878724,-1.1869734,-0.83873139,-0.98957563,-1.3974539,-1.3020026,-1.4222193,-1.6337538,-1.6511988,-1.7824151,-1.8822069,-1.9508719,-1.8055552,-1.7426318,-1.4715216,-1.4031687,-1.1494597,-0.75586538,-0.56482037,0.058797055,0.046509576,0.045872935,0.48199057,0.775385,0.56919094,0.91358627,0.95468886,1.0054228,1.0377656,0.80607371,0.85119391,0.82394606,0.7131084,0.60449921,0.72206738,0.57987022,0.52553238,0.49672079,0.62104462,0.51059698,0.64136035,0.55110525,0.33226855,0.7730893,0.36450658,0.15511541,0.60077751,0.1159597,-0.0052225825,0.16481241,0.048156636,0.045531815,0.066650703,0.23052361,0.60322751,0.71238708,0.49910405,0.27300791,0.1420472,0.07157657,0.055745476,-0.14893827,-0.320406,-0.20320039,-0.37650036,-0.39701547,-0.18855204,-0.55104721,-0.22708987,-0.53982888,-0.23207756,0.10949861,-0.68768556,-0.31634669,-0.43290016,-0.38359833:1
2.0412979,2.0215905,1.9258954,2.3343605,1.1738737,-0.45254768,-0.72808871,-0.97286861,-1.1330444,-1.3083921,-1.4269104,-1.3777995,-1.4946452,-1.6391585,-1.6507469,-1.63712,-1.7475462,-1.7957816,-1.8923593,-1.8622911,-2.0314748,-2.0181803,-1.8818739,-1.8788136,-1.7021406,-1.638922,-1.3705513,-1.074531,-0.77577882,-0.325801,0.10598077,0.41984097,0.55780729,0.66172383,0.74204524,0.7688022,0.88773093,0.93061314,0.89278808,0.82587454,0.71323405,0.63487012,0.58140712,0.55860979,0.51887426,0.54622788,0.46277437,0.38710092,0.49854746,0.45849862,0.38337416,0.4624378,0.52128288,0.54289555,0.70444864,0.81086868,0.84128969,0.85245267,0.69108352,0.74737044,0.7926625,0.82489155,0.73355633,0.54221106,0.4398919,0.17818583,0.067928638,-0.042475807,-0.0067941907,0.015047884,-0.049013166,-0.094703985,-0.1140152,-0.0011615384,-0.0838521,-0.093966707,-0.078748905,1.9599784E-4,-0.0877118,-0.09344386,-0.05769818,-0.060419021,-0.057214332,-0.11642003,-0.024918867,0.088910345,0.11528339,0.066654186,0.10396027,0.23877021,0.30620836,0.33757239,0.75526593,0.86793768,0.83823445,1.3586827:-1
0.58597594,1.1371795,1.2907909,1.33595,1.2572291,0.0056128186,-0.8532002,-0.85408508,-0.95444804,-0.74570298,-0.90664719,-1.1693085,-1.2278135,-1.4456713,-1.3641394,-1.4457378,-1.6622698,-1.5050652,-1.676811,-1.8241034,-1.6514071,-1.830753,-1.6389427,-1.712566,-1.9989974,-1.7098134,-1.6747662,-1.2410327,-0.94469051,-0.98619023,-0.68197326,-0.18182055,0.041145017,0.26965257,0.48887294,0.50861388,0.81440337,0.9045377,0.84133469,0.99911654,0.70654447,0.64984516,0.78087253,0.81487211,0.87359903,0.23948804,0.97886007,0.84852437,0.27915647,0.46947185,0.55390315,0.74572117,0.54018362,0.66707285,0.43675462,0.62178002,0.44373617,0.3734015,0.47644065,0.38699714,0.77528263,0.37837448,0.1361239,0.19337036,0.21531201,0.68831277,0.86513661,1.1040074,0.53105904,0.20986348,0.47040482,0.13428334,0.051553549,0.50461939,-0.10774779,-0.28093072,-0.09797888,-0.0090136989,0.083350877,-0.27151162,-0.1728883,-0.15630351,-0.057780525,-0.19680778,-0.35654539,-0.24017552,-0.028155518,-0.25056284,0.50802148,1.3931381,2.4379164,2.9100638,1.9735478,-0.048711772,-1.5272921,-0.24101953:1
0.99970742,2.7911688,3.6556783,2.4709798,1.4594185,0.33317464,0.5504913,1.4679113,1.2131432,1.0813722,0.99656008,0.46236553,-0.36150828,-0.50390667,-0.57442722,-0.62491742,-0.7127256,-0.87725194,-0.863112,-0.94895439,-1.0918879,-1.1544232,-1.1557447,-1.2367089,-1.4393446,-1.5328602,-1.5505765,-1.697434,-1.9290225,-1.8858667,-1.978862,-1.9854938,-1.9680557,-1.8771463,-1.6102913,-1.4227857,-1.0420614,-0.65191227,-0.38674254,-0.024739535,0.34190604,0.53080641,0.52389908,0.71934155,0.83719421,0.74033281,0.75741592,0.70839631,0.67710308,0.5996245,0.52901871,0.61907775,0.5918086,0.50106959,0.51123953,0.55878267,0.44073898,0.48503107,0.50189452,0.46095598,0.39988058,0.40444837,0.40629134,0.37917143,0.32234146,0.28236162,0.35485281,0.21421836,0.18782819,0.29084646,0.16447839,0.10950107,0.15207041,0.1993418,0.29967751,0.48495387,0.60300949,0.6067196,0.43017987,0.23113939,0.22701451,0.051546402,-0.10722707,-0.09565,-0.15719648,-0.19614914,-0.11020546,-0.19871606,-0.21874786,-0.22577521,-0.28857256,-0.1600383,-0.24255383,-0.31070396,-0.26483934,-0.25434277:1
1.6163364,2.0997266,1.7879116,1.3280621,0.75938508,0.23035588,-0.18072166,-0.15454607,0.030906251,-0.075155368,-0.33687146,-0.23652244,0.017446446,0.031067473,-0.11954177,-0.42609942,-0.78787868,-0.83315607,-0.69918239,-0.7868791,-0.91889446,-0.84977911,-0.82126556,-0.94243803,-0.9580671,-0.90753234,-1.0062488,-1.125972,-1.2265875,-1.3745719,-1.3621048,-1.2954596,-1.4603632,-1.6102179,-1.6205738,-1.6907146,-1.7210371,-1.6819537,-1.6996601,-1.6466202,-1.5376434,-1.5190506,-1.4401019,-1.2364728,-1.0722291,-0.96042602,-0.82814727,-0.62651442,-0.38726802,-0.25290086,-0.15906052,0.025740575,0.14107311,0.17093826,0.30806218,0.41424251,0.37436844,0.42253746,0.55083151,0.51761864,0.41464957,0.46229599,0.56861931,0.54402707,0.46027884,0.4835684,0.53347655,0.48240607,0.44587169,0.45746729,0.41793131,0.47211456,0.62716251,0.59303616,0.48837218,0.57181713,0.7081623,0.85056025,0.99247237,0.98314222,1.0070419,1.2195438,1.3547613,1.3755222,1.4532931,1.4661577,1.3767514,1.3916463,1.4369003,1.2658986,1.1425243,1.326915,1.4148013,0.80762715,0.1164899,0.036514563:1
0.29476758,0.86093158,2.4191877,3.4520527,2.0206306,-0.019059689,-0.99335938,-0.10652825,0.54713625,0.37580845,0.4727728,0.27377468,-0.23720976,-0.94233522,-0.68503094,-0.94911582,-1.0395398,-1.1689719,-1.1913392,-0.9059242,-1.3046853,-1.4366801,-1.4286924,-1.6120869,-1.6178923,-1.7272275,-1.6543127,-1.8647479,-2.0437025,-1.7881577,-1.9843096,-2.1426461,-1.4607454,-1.7978484,-1.4780957,-1.2309291,-0.79822123,-0.023287827,-0.47024091,0.15580858,0.59327217,0.79327638,0.88352643,0.9873342,1.1383853,0.98232369,1.0010214,0.83163539,0.90998926,0.84624751,0.64582257,0.69677522,0.69267685,0.81807675,0.50115958,0.57804953,0.64158868,0.65312703,0.47728359,0.49204638,0.76712772,0.53485721,0.42846829,0.50443169,0.36799917,0.27068227,0.35391793,0.36476282,0.16523965,0.24950479,0.23825738,0.34175502,0.30403988,0.6617561,0.93488793,0.5931077,0.57686895,0.47873224,0.38042193,0.38979563,0.055126152,0.04853402,0.02372686,0.018429521,0.37602929,-0.0049700637,-0.1613087,0.081796239,0.11986411,-0.23885135,0.1956168,0.078485501,-0.15695041,0.16256033,-0.006183097,0.56791545:1
0.5807386,1.0971106,1.7440564,2.2783712,2.3894875,2.3484163,1.9432379,1.2774838,0.65341422,0.081747746,0.092010301,0.27164682,-0.223713,-0.31928843,0.15733927,0.033266964,-0.27660464,-0.4154689,-0.70769902,-0.7798772,-0.70635123,-0.82926454,-0.88312444,-0.78555149,-0.81218301,-1.159634,-1.4024688,-1.1439035,-1.1505974,-1.6302565,-1.677548,-1.5217353,-1.7507135,-1.990933,-2.086291,-2.0731697,-1.911572,-1.8444634,-1.8266953,-1.7047513,-1.5924942,-1.4081611,-1.0672233,-0.73239867,-0.6140476,-0.62365533,-0.30255211,0.11621277,0.055411688,0.066442751,0.42332142,0.45323058,0.30669245,0.35921726,0.36960693,0.38301222,0.47176348,0.46110431,0.37373316,0.29326044,0.28570498,0.33948809,0.36271362,0.38574687,0.37504944,0.32928201,0.36494342,0.36740252,0.35875166,0.52162501,0.62974813,0.6374475,0.8201197,1.0291188,1.070825,1.0505703,0.93059661,0.71313129,0.68223114,0.73019617,0.6047155,0.65791259,0.79018252,0.59636625,0.50330359,0.5148594,0.36250425,0.41891152,0.43683991,0.23026572,0.30666737,0.41880937,0.28307678,0.28666866,0.32964691,0.14763104:1
0.38123865,0.63353024,1.002302,1.5212777,1.8638942,1.7927666,1.3811552,0.85684321,0.26386347,-0.15280853,-0.1303639,0.084059923,0.034076095,-0.18460828,-0.24718659,-0.19186736,-0.10236096,-0.10079175,-0.38136518,-0.63136351,-0.60606993,-0.64047755,-0.70421571,-0.632491,-0.74384537,-0.9688458,-0.94665381,-0.84190708,-0.85262508,-0.915115,-1.070632,-1.3026119,-1.3942987,-1.3316191,-1.3642305,-1.5447106,-1.6770709,-1.7169963,-1.7519345,-1.7530924,-1.7430616,-1.8213353,-1.8324035,-1.6011439,-1.3414148,-1.2219698,-1.1242385,-1.0325074,-0.93561726,-0.69685446,-0.37407899,-0.13286473,0.013063599,0.13762721,0.30735216,0.47997495,0.58140714,0.67917086,0.79151735,0.81584029,0.78038301,0.77843241,0.81246709,0.86141506,0.85233767,0.78723205,0.79792534,0.82803079,0.80570054,0.80673359,0.75091701,0.70935151,0.82109051,0.76975229,0.59720507,0.75976065,0.96383845,0.87539839,0.82509616,0.86680864,0.85295836,0.86424777,0.89555601,1.0137696,1.1453727,1.0410415,1.0540548,1.3494831,1.4363899,1.3002423,0.95296784,0.35397519,-0.037792658,-0.60937387,-1.474071,-1.0700091:1
0.31452914,1.9123548,2.9333556,1.5788524,1.3517568,0.028089189,-1.2632887,0.032857894,0.40003933,-0.20063643,0.065543508,0.20950973,-0.69548403,-1.0077523,-0.94276255,-1.1275164,-1.095153,-1.0951984,-1.2995269,-1.4563502,-1.3408939,-1.2609331,-1.5417315,-1.698238,-1.6536663,-1.682468,-1.8680693,-2.0167442,-1.9484745,-2.0687512,-2.1358328,-1.9864864,-1.5471905,-1.6836213,-1.5096744,-0.86883463,-0.80272275,-0.32872716,-0.13563526,0.14102395,0.66481739,0.51545957,0.87494502,0.71134621,1.0102798,0.84586816,0.64720847,1.171734,0.54904041,0.79365876,0.78513749,0.34467449,0.78651213,0.48572658,0.68113477,0.60322562,0.62542157,0.55096738,0.55788416,0.59327119,0.63621326,0.84050833,0.36189828,0.44499235,0.73680784,0.33686932,0.55244374,0.37112219,0.37065549,0.68025979,0.08146743,0.4553567,0.44991117,0.43518479,1.0397024,0.63467635,0.94194723,1.0765017,0.40302246,0.50310337,0.40319452,0.18811983,0.14261348,0.20686898,0.16984613,0.17912233,0.47274545,0.21595497,-0.0015606175,0.261008,0.33200537,0.19580798,0.27623309,0.39961581,0.36897911,0.33294027:1
0.31421954,0.78106253,1.2049684,1.5346969,1.8773314,2.1582136,2.1029722,1.6779094,1.1686752,0.68953902,0.16295673,-0.22586798,-0.26498096,-0.17853669,-0.21714779,-0.2391025,-0.095147651,0.067183123,0.044738707,-0.19239807,-0.52251979,-0.75271166,-0.7633734,-0.67793966,-0.70799498,-0.83776254,-0.89701391,-0.89567536,-0.9626454,-1.0852043,-1.1786837,-1.2381379,-1.311662,-1.4525965,-1.6413078,-1.7848404,-1.8723492,-1.8906598,-1.7787761,-1.7101998,-1.8413478,-1.8897977,-1.725754,-1.6544786,-1.6172059,-1.3332645,-1.0711115,-1.053257,-0.94570387,-0.6480925,-0.46395201,-0.44029382,-0.37801159,-0.17973792,0.068041623,0.1697713,0.13236052,0.20540715,0.39916148,0.49643003,0.51251997,0.56105279,0.60312536,0.6565219,0.74428084,0.74381857,0.66879431,0.67557652,0.72364773,0.72221816,0.77217538,0.8871881,0.88714718,0.77645149,0.76292721,0.81154604,0.68923001,0.48300041,0.5368841,0.82934108,0.96538322,0.89002952,0.90713135,0.95208708,0.7811642,0.6401907,0.71962299,0.69281771,0.53890721,0.61208345,0.73607727,0.57119883,0.44656844,0.67154941,0.78798188,0.40136535:-1
0.65173918,1.2370342,2.1094477,1.4324433,0.78670067,-0.45945978,-0.36329857,-0.55752269,-1.1959349,-0.8249699,-0.78616871,-1.2286909,-1.3205729,-1.3830934,-1.3137133,-1.3088983,-1.4952363,-1.6645152,-1.6580473,-1.8050654,-1.9127306,-2.3294546,-2.5095343,-2.4365433,-2.25226,-2.6018957,-1.7742065,-1.6680736,-1.5599063,-0.66048299,-0.87372723,-0.34851131,-0.069974211,-0.1522794,-0.10986013,0.32801368,0.21190219,-0.0074185574,0.38776298,0.14009821,0.21024603,0.32263201,0.44521874,0.38708037,0.47891035,0.62107045,0.57921611,0.69960986,0.91670757,0.69036064,0.78867598,0.87630152,0.83114476,0.79840024,0.74892898,0.55054866,0.56323602,0.98123191,0.46065651,0.6243964,0.62939021,0.64997374,0.37188004,0.69082008,0.50977472,0.57865534,0.44903641,0.50170411,0.55146457,0.5184779,0.47135908,0.59085883,0.52547599,0.5670984,0.60085031,0.59996991,0.37192774,0.77951338,0.81321292,0.81717349,0.85718509,0.57841371,0.79580156,0.39816153,0.46657552,0.51741161,0.35107124,0.33964832,0.2775461,0.66992836,0.39167078,0.50667614,-0.10257616,0.29257261,0.45394247,0.38968526:-1
0.5358112,0.6007662,2.115888,3.3480717,2.0451475,1.4415876,0.10484063,-0.093578452,1.0806246,0.99424594,0.99555338,0.87982356,0.72863849,-0.35932679,-0.86489438,-0.70354973,-0.89332244,-0.99962492,-1.0895387,-1.0714517,-1.0800592,-1.3338561,-1.3746308,-1.4982365,-1.510173,-1.5826767,-1.8217105,-1.6917148,-1.8294197,-1.8667598,-1.9627095,-1.9313763,-1.737213,-1.8744234,-1.6583345,-1.206337,-0.98843838,-0.67382704,-0.31351342,0.048131147,0.36884819,0.56313559,0.71850792,0.90008507,1.047931,1.0429636,0.89953366,1.0279334,1.026368,0.91264163,0.6238852,0.77580761,0.9005532,0.51607342,0.84117045,0.57778281,0.53402255,0.80115669,0.68692175,0.58087065,0.49762567,0.45019918,0.52066011,0.45495261,0.3871647,0.3048046,0.21445674,0.20228491,0.24764394,0.22296468,-0.040042393,0.21030657,0.10010929,0.51042812,0.57268599,0.48502131,1.1681583,0.74938465,0.04494477,-0.066675367,-0.084065601,-0.04429502,-0.21687749,-0.19060671,-0.15579939,-0.34512885,-0.16215852,-0.047013086,-0.43940214,-0.33467576,-0.18828509,-0.25589394,-0.15220019,-0.24433304,-0.34811243,-0.28285676:1
1.4684175,3.2539464,3.5995103,2.3933767,0.41737672,1.071454,1.685863,1.5729415,1.7088762,1.0320818,0.05307411,-0.50839812,-0.47231375,-0.70552421,-0.78626011,-0.9431652,-1.0633661,-1.168249,-1.155859,-1.2921202,-1.4191115,-1.4850444,-1.6273653,-1.8020693,-1.8703254,-1.9727786,-2.0736688,-2.054587,-1.9235598,-1.7610525,-1.5644783,-1.1734369,-0.64637223,-0.29916933,0.033866505,0.43856506,0.55741685,0.83684083,0.86219204,0.86332303,0.73373806,0.74286369,0.71255677,0.56798877,0.55329732,0.63970949,0.53078,0.52132135,0.4875235,0.42475336,0.29269957,0.4149625,0.36965221,0.15175597,0.18999208,0.20083312,0.097209651,0.037613958,0.11253864,0.033237732,-0.02367321,0.050143982,0.02095634,-0.095082575,-0.039961331,0.039653284,0.030251268,-0.1301563,0.1155564,-0.0142366,-0.12020794,0.070485289,-0.013129003,-0.063534613,-0.060068932,0.20159924,0.12560538,0.35961784,0.48612796,0.22319232,0.2344934,0.28242688,-0.13580683,-0.18727892,-0.10947385,-0.20503522,-0.11603394,-0.17146032,-0.15398275,-0.25851518,-0.087435752,-0.068080977,-0.10364012,-0.10245353,-0.021530855,0.14479403:-1
1.450874,2.5570839,1.9918773,1.486097,1.7354962,1.338377,0.26275366,-0.1148676,0.1974278,0.42180558,0.58532859,0.62372327,0.45377072,0.54674871,0.54709414,-0.025421027,-0.3992211,-0.36481858,-0.44704226,-0.49995006,-0.51412324,-0.69395009,-0.80428474,-0.71844508,-0.6389764,-0.7243717,-0.88547627,-0.92901518,-0.86621187,-0.87417332,-0.96963206,-1.0134753,-1.0534537,-1.1475499,-1.1570454,-1.1378484,-1.2149863,-1.2789714,-1.3087057,-1.3269767,-1.301223,-1.3009373,-1.3134505,-1.349907,-1.415896,-1.3828838,-1.4170395,-1.4538743,-1.1305481,-0.8433083,-0.79132007,-0.51434893,-0.22593269,-0.13825608,0.087944204,0.36954458,0.47582154,0.40274027,0.22281146,0.15902303,0.23351695,0.29103782,0.31631407,0.26956682,0.18663139,0.18942324,0.20436166,0.15762555,0.11163348,0.07806129,0.037505075,-0.008191192,0.010155106,0.093521958,0.042215749,-0.056904462,0.043026546,0.15674891,0.15283328,0.1448568,0.10450183,0.12606128,0.20115557,0.17509916,0.1912545,0.21765326,0.26097232,0.58207622,1.084883,1.8521323,2.7458885,2.8192039,2.2613344,2.1453774,1.8595552,0.49048734:-1
0.99311088,2.7048435,3.4733421,2.2126661,0.45329533,0.047793342,0.95955986,1.1930596,1.007462,0.99132093,0.57820045,-0.019752725,-0.48965442,-0.44228661,-0.58495969,-0.4443578,-0.36681751,-0.40379975,-0.61565955,-0.83379226,-1.025003,-1.201268,-1.3762815,-1.4132188,-1.4878131,-1.7930976,-1.8546667,-2.0736805,-2.0869331,-2.0074234,-2.1524661,-2.0920997,-2.0311639,-1.8833279,-1.5725866,-1.3058619,-1.002047,-0.53302166,-0.10067188,0.10165556,0.42403295,0.65213763,0.77169086,0.91439267,0.80432214,0.80127314,0.69083304,0.61021074,0.7091267,0.65098901,0.62584063,0.6350268,0.62785003,0.67701916,0.74058694,0.76568509,0.75747855,0.63137099,0.5503832,0.57019334,0.47303239,0.38274519,0.39918361,0.33821756,0.25162563,0.23681772,0.21019813,0.19977885,0.19538199,0.15563249,0.18672692,0.15264001,0.058320816,0.14603854,0.34330537,0.44168717,0.63961804,0.64339829,0.44976835,0.41549582,0.24083847,0.11312449,0.042859218,-0.11644459,-0.089543136,-0.064282766,-0.13243209,-0.16534767,-0.12308486,-0.26683751,-0.31281061,-0.1985655,-0.11995395,-0.076979263,-0.14541578,-0.037778275:1
0.12377605,2.4334614,2.7623845,2.3959632,2.1412625,-0.41829927,0.51694526,0.3463399,-0.024068726,0.59781942,-0.41035257,-1.3711803,-1.2626738,-1.3410687,-1.439354,-1.7022762,-1.5347447,-1.5867927,-1.7684513,-1.7812406,-2.0252245,-2.0039307,-2.2033053,-2.2882265,-2.1056452,-2.1816572,-1.8756048,-1.7190811,-1.4309135,-0.8422116,-0.60268298,-0.27167349,0.043212308,0.42843503,0.41907598,0.50986322,0.73711529,0.65138486,0.50753165,0.54840182,0.48530713,0.44250036,0.41950302,0.42099329,0.44422195,0.49148377,0.34982511,0.44492622,0.30543753,0.31988394,0.34194301,0.21074101,0.19134602,0.35677577,0.14262695,0.19375202,0.30562366,0.081876195,0.12666364,0.094116222,0.14380138,0.034175938,0.14278655,0.069114893,0.22675027,0.041043601,0.20327393,0.14643482,0.09692111,0.32241503,0.039481129,0.28112422,0.18655268,0.52755881,0.30947666,0.22119106,0.40176022,0.76148521,0.84402685,0.99665027,1.0212269,0.90251967,0.60200662,0.47199256,0.45648089,0.18361577,0.21749914,0.30316616,0.27681185,0.2281094,0.41509186,0.39851671,0.13766325,0.26363448,0.59589603,0.3878846:-1
1.814836,3.1168412,2.709344,2.2893513,0.74680004,0.34330609,1.3851769,1.2283536,1.2051607,1.3629613,0.72878415,0.16295678,-0.0080553275,-0.22321765,-0.43115973,-0.48352087,-0.5467077,-0.85696251,-0.95103046,-0.93978875,-1.0726102,-1.3601239,-1.3413854,-1.4050711,-1.7154323,-1.759417,-1.8844255,-1.950008,-2.1831213,-2.1779467,-2.1525434,-2.0963579,-2.0510521,-1.802704,-1.4675531,-1.2232884,-0.78604128,-0.38868829,-0.070863958,0.15871901,0.39615348,0.60075948,0.50987172,0.5699061,0.68246625,0.52126002,0.42960377,0.36043331,0.38969564,0.42090655,0.38012997,0.36076989,0.31933386,0.39643818,0.382826,0.40484153,0.58767065,0.59500206,0.35283927,0.59457128,0.52692647,0.50865477,0.5427347,0.37860812,0.44005207,0.33123905,0.31359522,0.44666908,0.43036174,0.18632146,0.21795405,0.16279763,0.22910978,0.29358933,0.39369087,0.55408042,0.27941028,0.28295483,0.073871144,-0.17960444,0.020608281,-0.15176853,-0.02923996,-0.09605356,-0.078537956,0.16677821,0.0043439165,-0.21732801,0.094326169,0.10021276,-0.15028811,0.029410633,0.087803882,-0.0024222663,0.26674696,0.3633978:1
1.1685633,1.8563351,2.1545365,2.3218258,1.9164374,1.214881,0.52682367,0.30918951,0.61779774,0.76545115,0.69202363,0.83157467,0.85853066,0.37871281,-0.21882916,-0.54759978,-0.57829007,-0.57036241,-0.82642609,-1.0418231,-0.7989705,-0.79339385,-1.1716008,-1.2151115,-1.305476,-1.5137317,-1.4558355,-1.6207633,-1.8120478,-1.7640156,-2.0627722,-2.2859142,-2.1082389,-2.1224856,-2.1131536,-1.9369656,-1.7960732,-1.5180592,-1.4170015,-1.2032011,-0.48419464,-0.2469919,-0.21486007,0.17800355,0.15326628,0.34652261,0.5602158,0.43173761,0.43292827,0.31104039,0.46511094,0.80842949,0.75977671,0.55031466,0.48885185,0.72413274,0.75093312,0.63100588,0.71781997,0.6192352,0.47629716,0.62541035,0.64715893,0.53358724,0.77102669,0.80847799,0.45094397,0.57542273,0.70451729,0.60622152,0.73263084,0.61479159,0.78328362,0.9028789,0.58169505,0.64803104,0.72286437,0.54406191,0.27844715,0.11675102,0.1264548,0.1585669,0.26965904,-0.018007492,0.013914038,0.20245165,-0.17801548,-0.047374373,-0.090093265,-0.3091298,-0.02871342,0.0010401512,-0.031450063,-0.023117262,-0.0096170709,0.041113181:1
2.1130509,3.2390538,2.5576422,2.3156721,1.0033186,0.84966324,1.6319269,1.4242787,1.3158524,0.99924424,0.20781148,-0.42103656,-0.46503334,-0.60489143,-0.6477287,-0.81837778,-0.90049714,-0.89675992,-0.94460744,-1.0835873,-1.2033444,-1.2250112,-1.3277376,-1.5290698,-1.604899,-1.6701252,-1.8830349,-1.9134538,-1.9651992,-2.0613577,-2.0139337,-1.9866672,-1.7922721,-1.580074,-1.329047,-0.89651814,-0.55237603,-0.26007503,0.051493625,0.33432175,0.52700648,0.63982191,0.72894939,0.74235551,0.69689598,0.70678671,0.61881583,0.59308291,0.60875104,0.56287954,0.60347036,0.53784661,0.51812293,0.59629696,0.52432868,0.50674142,0.50123192,0.481598,0.47713123,0.36448407,0.42906321,0.41800232,0.33307746,0.28346888,0.26304588,0.24960836,0.16096889,0.19426417,0.16329789,0.17884684,0.076809831,0.062740042,0.281737,0.44048912,0.47879892,0.50719613,0.35508406,0.16924946,0.11046712,0.021528654,-0.085791634,-0.13028596,-0.11626912,-0.18007087,-0.16631974,-0.14237232,-0.11230398,-0.083357236,-0.15890054,-0.062688992,-0.057953761,-0.15371915,-0.10223231,-0.11091866,0.16933574,0.31289248:1
-0.19441323,-1.1007149,-1.3215892,-0.81488251,-0.34071735,-0.38421122,-0.62349815,-0.64220725,-0.55256542,-0.58374892,-0.67414434,-0.70857317,-0.73420062,-0.7671118,-0.74069201,-0.69700841,-0.73888966,-0.84594789,-0.90054696,-0.88965082,-0.88327915,-0.92932783,-1.0130808,-1.115139,-1.2142127,-1.2802051,-1.2905437,-1.29888,-1.4081455,-1.5917251,-1.6842284,-1.6191126,-1.557851,-1.6148191,-1.6866895,-1.6487589,-1.5526325,-1.4598861,-1.318757,-1.1241276,-0.9834759,-0.91710525,-0.76622029,-0.43579614,-0.062335482,0.14745944,0.20885403,0.29907317,0.4815012,0.61783845,0.6520107,0.70056931,0.82486954,0.92153559,0.97288062,1.0792456,1.1797202,1.1043549,0.92291354,0.86881536,0.92704209,0.92671744,0.88343312,0.89989121,0.89992495,0.84428614,0.87548042,0.98458243,0.91121158,0.64469009,0.54624229,0.7488074,0.90480019,0.76474744,0.56709375,0.63114909,0.91368603,1.1599834,1.2499887,1.2580716,1.293779,1.3502427,1.3011068,1.088284,0.86683333,0.81277952,0.85454896,0.81905006,0.76497783,0.87610327,1.0859015,1.1447178,1.0219842,0.92982741,0.9638794,1.0141616:-1
0.73059393,0.95465401,2.7894027,3.2344186,2.150623,0.90708836,0.41094624,0.84251916,0.99018514,0.91588143,0.60915066,0.25079411,-0.42775694,-0.73149665,-0.67576141,-0.92615471,-0.94312642,-0.99803908,-1.0254685,-1.1094105,-1.2707569,-1.1801884,-1.4132684,-1.5289884,-1.4711502,-1.6987964,-1.6617326,-1.7457081,-1.9472569,-1.9375065,-2.0973895,-2.0953513,-1.8553922,-1.8460876,-1.7779234,-1.202581,-0.75234162,-0.49988437,-0.037612581,0.31936744,0.61618064,0.74958163,0.87424134,1.0046299,0.89485371,0.98149708,0.89402279,0.69172868,0.6479818,0.58824562,0.66833144,0.66425224,0.52641713,0.54798041,0.62124967,0.56069211,0.49561756,0.48645276,0.64269558,0.51214309,0.39921706,0.50185492,0.44900105,0.3588213,0.36320459,0.36163423,0.20057977,0.2566303,0.35495588,0.16341288,0.22643823,0.1421098,0.051816255,0.33930872,0.24507334,0.53702864,0.80713103,0.63696255,0.54241627,0.36355807,0.38020759,0.090905298,-0.060212628,0.066960257,-0.15598224,-0.20973822,-0.026553855,-0.22865049,-0.26106331,-0.1606551,-0.10491354,-0.161476,-0.20260718,-0.12651805,-0.11709868,0.05895187:1
0.59401433,1.1537236,2.6051702,3.1965895,2.0619099,0.1933088,-0.39215695,0.77476198,0.74411737,0.52828631,0.60695632,0.075758462,-0.16262867,-0.75770482,-0.82668801,-0.90466799,-0.86489703,-0.92723404,-1.0822416,-1.0179055,-1.0156871,-1.2161342,-1.3557418,-1.3605295,-1.5026603,-1.6789171,-1.7439553,-1.8176574,-1.9648344,-1.9914343,-2.1455117,-2.0926588,-1.8876264,-1.9263239,-1.707235,-1.4208117,-1.2455294,-0.88839617,-0.4777579,-0.099044326,0.18898706,0.4565955,0.68388928,0.90009814,0.94101132,0.94947477,0.99893277,0.94897463,0.82744347,0.78173448,0.71188769,0.64823767,0.69262451,0.56480838,0.49460019,0.65125956,0.58689289,0.39271944,0.46809317,0.59618888,0.48342542,0.52306562,0.5137537,0.43378089,0.33661455,0.31448484,0.41624216,0.27971827,0.21400447,0.26661842,0.43474294,0.15539161,0.21200508,0.61498033,0.71676817,0.87342363,0.75727531,0.51954152,0.54603085,0.35220095,0.24965577,0.19693798,0.091654066,0.21048798,-0.015256405,0.095381521,0.1220583,-0.028834469,0.05916219,0.063779768,0.062518328,0.050870599,-0.003989843,0.054530579,0.17163876,0.11085684:1
2.0394327,1.8832347,1.9093279,2.4715339,1.1181387,0.044438534,0.02378222,-0.1854629,-0.84122924,-1.210844,-1.1649628,-1.3305675,-1.4505416,-1.6214423,-1.5285523,-1.6564765,-1.8499284,-1.4444446,-1.8181468,-1.757509,-1.5500211,-2.0486198,-2.0674221,-1.7514358,-1.8899067,-1.9401666,-1.3923952,-1.2765232,-0.96957959,-0.81353676,-0.53408863,0.18649755,0.18891511,0.52785912,1.0165503,0.98695918,1.0381347,0.90506531,0.77315071,1.1705092,0.52910902,0.65706782,0.67812941,0.5179102,0.54165506,0.47090802,0.46793846,0.59913278,0.47387851,0.50290558,0.65981579,0.38413318,0.68218534,0.75604449,0.61435762,0.98529284,1.0581193,0.85157441,0.53874142,0.90249501,0.98809047,0.65468729,0.58384122,0.22025055,0.16772921,-0.0078476486,0.047374143,-0.13176619,-0.060787931,0.077160185,-0.29065653,-0.096476165,-0.17559459,-0.17683834,-0.26148476,-0.30170242,-0.15769403,-0.16105487,-0.27517994,-0.37618733,-0.10732506,-0.064679581,-0.2052363,-0.087677274,-0.08637962,-0.088805668,0.090496632,0.058145382,3.5112091E-4,0.26841067,0.55995867,0.52745406,0.51000214,0.67704666,1.2486477,1.3726073:-1
0.46737906,0.34010397,0.35138992,0.80988876,1.2934283,1.7335345,2.1628923,2.1414868,1.6615111,1.1206418,0.45783849,-0.17802412,-0.22524688,0.03250859,-0.1168657,-0.41491491,-0.35638904,-0.2509871,-0.36715659,-0.33877526,-0.081856181,-0.12102792,-0.58705515,-0.88692107,-0.77319756,-0.70316572,-0.87018086,-0.98921601,-1.031618,-1.1907084,-1.3504713,-1.315321,-1.2073897,-1.1992221,-1.2519025,-1.3806293,-1.6770096,-1.9131597,-1.8040762,-1.6385741,-1.802632,-1.9967517,-1.816844,-1.5127925,-1.4638601,-1.5593601,-1.5239157,-1.3369984,-1.1101437,-0.89923946,-0.7352989,-0.62115511,-0.45901969,-0.19245738,0.054817614,0.20428428,0.32399129,0.41063033,0.45174631,0.55410401,0.71178704,0.77912725,0.7638632,0.77773186,0.81778039,0.85281043,0.86878147,0.82122291,0.77448351,0.81832998,0.83964346,0.7881012,0.82925862,0.90610556,0.78985702,0.59219154,0.51037025,0.48805409,0.5551999,0.76294419,0.90934581,0.96187994,1.0330292,0.8952406,0.54303703,0.48404181,0.67663296,0.5949164,0.4540119,0.72175261,0.98346048,0.75150705,0.49768455,0.71987873,0.91141946,0.49387098:-1
0.64275558,1.9652219,2.9047617,2.3393423,0.79156126,0.15917504,0.92527794,1.2314808,1.1813325,1.3698903,0.87052383,-0.17245692,-0.71374715,-0.66787891,-0.88154185,-0.88056139,-0.93676769,-1.0415576,-1.1711792,-1.0859123,-1.124883,-1.3186066,-1.4501196,-1.4573616,-1.4785816,-1.6753872,-1.7290109,-2.0020134,-2.0563651,-2.0999205,-2.1468928,-2.0228336,-2.0071527,-2.0073806,-1.5996686,-1.2477127,-1.0342535,-0.58500925,-0.23800356,0.048785229,0.27357824,0.41882652,0.6427489,0.68399842,0.703198,0.78272938,0.75175976,0.63880201,0.58432399,0.66918217,0.63540721,0.5926714,0.62951558,0.63588582,0.5999117,0.51703759,0.62038759,0.54816639,0.59089917,0.48709892,0.51182843,0.51280847,0.41523838,0.38768122,0.32056127,0.44472826,0.34956381,0.35382241,0.46867739,0.33019947,0.40549274,0.42792223,0.41080052,0.5894265,0.76784519,0.86361692,0.62072789,0.52610389,0.4397664,0.13778017,0.1135003,0.10893713,0.13049494,0.061247792,0.078585303,0.077828845,0.079985449,-0.10907211,0.065845599,0.10818746,-0.047369804,-0.098171324,-0.021278626,0.092690157,0.12069088,0.34982908:1
0.50691007,1.6370345,3.1547647,1.7402818,1.8124405,0.6171909,-1.3848904,-0.25466994,0.50182027,0.15305764,-0.075266957,0.10883743,-0.20001468,-0.71551966,-0.94438292,-0.79628119,-0.97295135,-1.1058692,-1.1303803,-1.3637825,-1.1810593,-1.350292,-1.6052023,-1.4906852,-1.6388467,-1.7028306,-1.9761219,-1.9501127,-1.860538,-2.3427803,-1.9823785,-1.5832168,-1.8470533,-1.6819993,-1.460829,-1.297685,-0.55792946,-0.38096737,-0.31140389,0.35315849,0.31504798,0.62621748,1.0197581,0.81318743,1.0338337,1.0255161,1.0324445,1.1787538,0.74439326,0.81744116,0.88087733,0.57845734,0.78842673,0.63660987,0.41239616,0.61823917,0.64190446,0.64007398,0.48912123,0.41201203,0.67667731,0.52389415,0.49946967,0.34044937,0.36466982,0.54217614,0.37836208,0.46030085,0.23009651,0.49426611,0.3347966,0.15980891,0.67293695,0.77501505,0.97858472,0.82089194,0.55729331,0.69978204,0.50512919,0.30667784,0.17112097,0.1158474,0.13145495,0.16102571,0.0099787414,0.10865763,0.048930083,-0.014351457,0.031855509,0.1392105,0.1782655,-0.10442321,0.10132481,0.21106243,0.041465507,0.2030291:1
0.59591868,1.3137186,2.7465019,4.1991449,2.7199107,1.715197,0.15929885,-0.56274529,0.9384163,1.0180912,0.69694232,0.75985712,0.74706274,0.025409363,-0.39747878,-0.69259959,-0.67263826,-0.70592656,-0.83698358,-0.85410331,-1.0416322,-0.97179172,-1.1959011,-1.4385469,-1.2723357,-1.4633253,-1.5424214,-1.5670811,-1.7616535,-1.8428245,-1.6366834,-1.7920051,-1.8138444,-1.5141021,-1.4983458,-1.2834369,-1.0092683,-0.63407808,-0.21875523,-0.063673391,0.18070968,0.40228251,0.68322934,0.59287,0.94003279,0.98085243,0.77388907,0.87522053,0.7783658,0.7959889,0.68323507,0.54214163,0.64059169,0.50922627,0.49928852,0.55352849,0.47593541,0.60663324,0.54055945,0.52308622,0.34662553,0.42162988,0.39821562,0.26746326,0.36036078,0.29793309,0.21546029,0.11282313,0.23442048,0.064902354,0.086005352,0.11529257,0.40376048,0.64651147,0.5343092,0.57351477,0.35302903,0.26353982,0.092057865,-0.17175339,-0.16070163,-0.24940706,-0.12360075,-0.41908272,-0.3202235,-0.22563804,-0.41717749,-0.29645393,-0.42934136,-0.37286401,-0.38688693,-0.53091694,-0.38205249,-0.45981887,-0.47662155,-0.29426952:1
1.2215121,3.5215769,3.6276133,3.0769932,2.0356967,-0.13592834,1.2264337,0.74404578,0.2093786,0.65520998,-0.21036739,-0.82743492,-1.0251441,-1.1013262,-1.022982,-1.4627243,-1.436744,-1.4114183,-1.6730853,-1.8698694,-1.9964448,-2.1150898,-2.1980117,-2.0530214,-2.0658047,-1.7571801,-1.6556366,-0.87854252,-0.75572895,-0.51665345,0.099858207,0.077720141,0.4159264,0.42419506,0.69321939,0.67814222,0.47881179,0.62165802,0.58121424,0.24988203,0.41374225,0.34924394,0.34486122,0.29218133,0.41368828,0.091295443,0.48129658,0.19183897,0.32476525,-0.05405613,0.2627474,0.12352279,0.029316117,0.040023614,0.15409221,0.14085676,-0.1262528,0.0062633122,0.109657,0.031423292,-0.032844966,-0.0056070895,-0.044973055,0.033773535,-0.030621995,-0.0059868958,-0.035922891,0.023524711,0.010005788,0.010863771,0.050329092,0.046130773,0.067469936,0.0078069277,0.10937357,0.053045011,-0.014841257,0.28771582,0.66467801,0.71539681,0.66527195,0.79548582,0.35688981,0.156098,-0.014453087,-0.05879335,-0.14699367,0.092278284,0.0028708814,-0.21004583,-0.0059148162,-0.10002261,-0.040720721,0.089248935,0.099830079,0.31919841:-1
0.7809784,1.3408039,1.9632789,3.0925116,3.7208991,3.0264523,1.9805153,1.0087382,-0.088959062,-0.24125413,0.38623753,0.5923369,0.65592355,0.8049269,0.55720714,0.30263564,0.43666368,0.36623393,-0.052911988,-0.27489342,-0.38187981,-0.53945163,-0.5195059,-0.54375073,-0.74428235,-0.80257018,-0.7135334,-0.72706869,-0.8910346,-0.88052164,-0.75277364,-0.99466312,-1.137075,-1.0150152,-1.3691058,-1.4847764,-1.0221708,-1.2474663,-1.7114988,-1.5263077,-1.4788375,-1.6883493,-1.5859912,-1.3635632,-1.3902638,-1.5852681,-1.5155297,-1.157178,-1.026275,-1.1042243,-0.82270643,-0.36660368,-0.3125244,-0.212619,0.20380411,0.28947628,0.21226797,0.39287985,0.50741425,0.5922262,0.76172404,0.7441493,0.65502964,0.71342145,0.8024664,0.74421351,0.56416443,0.51218704,0.55213285,0.49949489,0.49820084,0.48083508,0.32557258,0.3253825,0.444007,0.42942221,0.37472729,0.28648482,0.21085752,0.30070069,0.36982165,0.28008181,0.19298,0.20796206,0.2469873,0.20075966,0.1446385,0.18789002,0.15192271,-0.076788917,-0.096128671,0.2018451,0.21726842,-0.17631623,-0.23526339,0.015158246:1
0.28914124,0.43851407,1.8578511,3.1790404,1.9176691,0.4844841,-0.69042172,-0.97612467,0.30059564,0.68456713,-0.052810963,0.035296862,0.30537079,-0.794713,-1.2263427,-1.070343,-1.1958144,-1.2412898,-1.0606375,-1.257063,-1.3205333,-1.2959316,-1.4023509,-1.5843517,-1.6821089,-1.673094,-1.9533521,-1.977941,-1.9077707,-1.6603424,-1.966998,-1.9352513,-1.646765,-1.7517142,-1.4279413,-0.93965752,-0.77476477,-0.40595796,-0.021661904,0.30652853,0.56240864,0.60510941,0.92062107,0.91369914,1.1957627,1.0438362,1.0235478,1.1544901,0.89138749,1.0221172,0.8441698,0.7521887,0.77935123,0.68220534,0.80309438,0.49716161,0.62815879,0.66951919,0.71510853,0.66328456,0.3520508,0.45899113,0.70632428,0.60334804,0.35210943,0.23021697,0.3873167,0.27626911,0.41590847,0.61818513,-0.063743579,0.84626844,0.89760666,0.79957922,0.89144874,0.72312945,1.0286766,0.42059035,0.30022362,0.28447616,-0.055718535,0.17362511,-0.07873725,-0.006596848,0.017776907,-0.074981299,0.061268909,-0.096789729,0.037139115,-0.13069912,-0.07875785,0.21742299,-0.063450124,-0.053827365,0.12425291,0.2068647:1
-0.022584248,0.20520995,1.7449143,2.3217103,1.252388,0.45185648,-0.59501535,-0.10859517,0.53918182,0.23145563,0.25229108,-0.093439968,-0.29337387,-0.9517888,-1.0923964,-1.179427,-1.2756013,-1.3215008,-1.462929,-1.2618191,-1.3051908,-1.6134564,-1.6115185,-1.5662641,-1.4517008,-1.7714337,-2.0376665,-1.7586722,-1.8883494,-1.7658035,-1.9705345,-2.0275006,-1.8254148,-1.7608529,-1.5130674,-1.4169127,-1.3203423,-0.93720522,-0.60076418,-0.2067461,0.0089491559,0.12270819,0.64379153,0.57088896,0.63745733,0.74980074,0.81657222,0.6982016,0.64807318,0.76961676,0.76849867,0.84822455,0.63313586,0.65397945,0.85395141,0.76330824,0.74111754,0.79739505,0.84658059,0.82337661,0.68000357,0.79463285,0.83236444,0.76411454,0.66606696,0.72268864,0.78358104,0.51354987,0.62306531,0.61175672,0.58927719,0.68037148,0.60237733,0.76897688,0.98697875,1.0081204,1.0314917,0.84182237,0.69312463,0.68368051,0.56372119,0.43863922,0.39072451,0.4166316,0.24158965,0.27061807,0.33426153,0.24864997,0.39521923,0.32683218,0.08514604,0.15681753,0.26549078,0.15786587,0.1896707,0.25330914:1
0.18753379,-0.27663761,-0.30880471,-0.27084334,-0.73064539,-0.1786955,-0.40416399,-1.3154284,-1.04931,-1.1725143,-1.2252639,-1.2664036,-1.5779631,-1.5186608,-1.6223793,-1.7890883,-1.6733497,-1.958582,-2.1708271,-1.8937701,-2.1184859,-2.1488524,-2.0920793,-1.9171793,-1.3793675,-1.3947797,-1.2245431,-0.70368214,-0.51579361,-0.37018611,-0.0079399061,-0.060596143,0.049118471,0.24305585,0.1795893,0.37773484,0.13241327,0.12277799,0.58685644,0.434799,0.27736456,0.39086427,0.4275324,0.54130425,0.56743513,0.6340361,0.6102504,0.60248655,0.50072533,0.60955938,0.71631595,0.66526458,0.70036838,0.34767801,0.45850724,0.73903774,0.52361666,0.51508335,0.41768627,0.30199525,0.45724703,0.2885931,0.15256262,0.16566068,0.22198896,0.35536341,0.35025602,0.23771197,0.29322718,0.52298643,0.6218095,0.58480256,0.65454242,0.79430976,0.84635428,0.51370663,0.2658702,0.38071489,0.31812962,0.35077223,0.44350383,0.38844843,0.51552985,0.17507977,0.0873934,0.41601092,0.32665573,0.40172528,0.69112137,1.4804796,2.2212624,2.6229837,2.5891851,1.9354278,0.83474501,-0.030335993:-1
0.16455766,1.1072882,2.1469641,1.8764232,1.6426157,0.4217124,-1.3478626,-0.57436761,0.38085119,-0.14112818,-0.086251055,0.22459803,-0.22780341,-0.81511003,-1.019881,-1.1106369,-1.1851544,-1.3335503,-1.176131,-1.2988095,-1.5780603,-1.5405676,-1.6413192,-1.559647,-1.6322386,-1.8853808,-1.8132509,-1.8846031,-1.9639344,-2.0534033,-2.0121174,-1.951674,-1.909618,-1.704815,-1.3393562,-1.2274244,-0.93414898,-0.44911507,-0.25494183,-0.12825842,0.17804408,0.51285171,0.42906062,0.7831202,0.6607407,0.77236099,0.94044421,0.73659176,0.72598397,0.67048807,0.79568292,0.61386604,0.54969375,0.75667855,0.51065576,0.5362876,0.50366844,0.68026701,0.87943908,0.49186036,0.50644506,0.71269662,0.60107579,0.71051935,0.67531645,0.54587768,0.65650295,0.56396696,0.51106688,0.596023,0.4639162,0.52364033,0.7881647,1.1295005,1.1494515,0.98225971,0.89402163,0.76415056,0.68591219,0.41375288,0.38834908,0.63458404,0.31396944,0.22409245,0.47256083,0.18463793,0.35553044,0.25334405,0.11911433,0.29623045,0.32212499,0.26349909,0.20450185,0.21071244,0.3972027,0.57304911:1
0.41601568,1.1139534,2.1378086,1.9796622,0.65161616,-0.43881608,0.39646958,0.95909097,0.87090753,1.2258174,0.39357742,-0.42623237,-0.6687601,-0.87512626,-0.91726551,-0.92670864,-1.0474146,-1.0874926,-1.1044476,-1.403129,-1.4854841,-1.5943135,-1.8601465,-2.046753,-2.1796672,-2.3354512,-2.5922908,-2.5199744,-2.5636068,-2.4376588,-2.1830587,-1.7220253,-1.1826573,-0.8519289,-0.29880549,0.19869091,0.34851283,0.58371481,0.73279471,0.76716593,0.78733714,0.69326988,0.71144116,0.58582127,0.5514357,0.62029303,0.54671487,0.59147075,0.73227223,0.63572084,0.61228671,0.73885847,0.65059694,0.60937563,0.66132781,0.65501714,0.59753475,0.51081229,0.54590224,0.46808777,0.39408489,0.52063614,0.38481373,0.38326677,0.42955704,0.38067482,0.35429443,0.25855047,0.43331664,0.26673068,0.27649564,0.42484835,0.26645232,0.22431914,0.33174276,0.36996738,0.56189262,0.82878253,0.78522788,0.5016838,0.35056739,0.35980422,0.2348369,0.11808351,0.18145228,0.10988031,0.055477548,0.20030573,0.15215851,0.14969937,0.18564482,0.21463268,0.14911729,0.15756237,0.35170592,0.11957296:1
1.1593518,2.5344027,2.9723235,2.0894468,0.41626364,-0.017382074,1.2204922,1.2212464,1.066033,1.3501838,0.68139322,0.035639147,-0.36203921,-0.44150933,-0.85315246,-0.79641287,-0.74198639,-0.95344005,-1.0306164,-0.98844203,-1.1126344,-1.2711207,-1.2987385,-1.3884359,-1.5144666,-1.6665734,-1.7839511,-1.8865465,-2.0474511,-2.1838105,-2.1544763,-2.1857059,-2.0936898,-1.9738504,-1.6681437,-1.1974179,-0.98878535,-0.63066609,-0.11764925,0.14001755,0.34385896,0.57523285,0.68770474,0.74875446,0.69003713,0.7538737,0.77482939,0.66528731,0.62539553,0.64566147,0.61850929,0.60603772,0.63942927,0.64645492,0.64085722,0.55340944,0.58247839,0.589396,0.61619276,0.49229477,0.48718876,0.48857718,0.39059497,0.4283386,0.42369808,0.27419181,0.25955801,0.37310296,0.26053993,0.27551164,0.3072742,0.28528169,0.23011999,0.18064991,0.4767162,0.65199991,0.60353396,0.58548774,0.61454016,0.4406746,0.20044633,0.16804595,-0.016371308,0.013378907,-0.073255282,0.0027093835,0.047906089,-0.089623497,-0.068106286,-0.0123484,-0.011726536,-0.07990608,-0.051751977,-0.054228554,-0.081739151,0.035595301:1
0.9548887,2.1905343,3.438425,3.3063762,2.7520431,0.94861402,0.10024156,1.0080502,0.79991001,0.66919319,0.75164438,0.33961792,-0.10043702,-0.37277379,-0.40366919,-0.61250256,-0.77438015,-0.62467027,-0.87058323,-0.96719059,-0.97903958,-1.1457139,-1.0789287,-1.3019739,-1.4584022,-1.4309802,-1.6022496,-1.6908282,-1.7542855,-1.739732,-1.9576504,-1.9800571,-1.8878595,-1.8733188,-1.6835565,-1.4389982,-1.1539,-0.664543,-0.39578689,-0.17948173,0.37501079,0.49110358,0.55337516,0.77381467,0.78654607,0.76038414,0.77982162,0.67836334,0.64906624,0.62812588,0.50539457,0.51614047,0.50937568,0.44309433,0.43775475,0.50858506,0.55839082,0.41194473,0.50587482,0.4196961,0.39749103,0.42809569,0.33316956,0.35165567,0.24182589,0.25573068,0.21702394,0.080436796,0.13614363,0.14117822,0.1691803,0.11719156,0.2054532,0.50159919,0.57490406,0.56978084,0.45648774,0.29058154,0.17774619,-0.035324659,-0.10457349,0.063707074,-0.0064037312,-0.29534326,-0.10858442,-0.097027039,-0.17846205,-0.20516451,-0.12417323,-0.11820595,-0.28969662,-0.21914425,-0.19021517,-0.32017728,-0.064398032,0.21960221:1
0.26158131,0.57982062,1.049515,1.9877269,2.351593,1.5728266,0.94027428,0.32373143,-0.34593676,-0.44660582,-0.41008189,-0.27481066,-0.27100607,-0.40467442,-0.43797211,-0.69019346,-0.86851522,-0.97683688,-1.0213827,-0.91656244,-1.0851554,-1.0981035,-0.98283369,-1.0841019,-0.99017372,-1.074644,-1.3029689,-1.1845412,-1.2652706,-1.5934673,-1.5880397,-1.5621622,-1.796088,-1.7979178,-1.6160417,-1.7217674,-1.8776349,-1.7415771,-1.471459,-1.3423815,-1.4278667,-1.3991789,-1.1230322,-0.88907817,-0.58593046,-0.30253136,-0.3777073,-0.32970261,0.1143453,0.27374261,0.17509953,0.32060039,0.47897163,0.47730162,0.33470487,0.25807723,0.41822047,0.45570312,0.56325579,0.64228937,0.48337443,0.5977918,0.6160748,0.493797,0.5494112,0.60733721,0.79891833,0.69315162,0.59396758,1.0173372,1.0964061,1.0066722,1.1742992,1.2658947,1.3794796,1.3662893,1.1347884,1.2971863,1.3840377,0.99097189,1.0083584,0.967726,0.54369075,0.55492192,0.59882356,0.63388732,0.61612792,0.42185906,0.60035149,0.63078487,0.38842756,0.46511282,0.54775412,0.43415843,0.58759586,0.54978831:1
0.54309888,1.227348,2.679487,2.8579347,1.7048162,-0.020583018,-0.68932496,0.94154136,1.1063917,1.0760685,1.7448192,0.77982663,-0.21725383,-0.93104466,-0.69332449,-0.68116191,-1.0850947,-1.2432011,-0.95819628,-1.2711155,-1.3248697,-1.3877444,-1.3868555,-1.5890792,-1.6979127,-1.2655322,-2.039071,-1.8232325,-1.7430023,-2.1419924,-1.6471364,-2.0623913,-2.0291769,-1.2298643,-1.372587,-1.0862407,-0.68922668,-0.37195083,0.049284624,0.29082207,0.69879606,0.76111322,0.95658979,0.88487032,1.3254705,1.12168,0.85714374,0.82838041,0.77034371,1.0531116,0.66660903,0.33452822,0.57657724,0.72304696,0.48691358,0.43315019,0.73476578,0.47376668,0.56453023,0.29504326,0.57950571,0.5002742,0.20682548,0.71296551,0.33679193,0.15079792,0.38030674,0.18678888,-0.0094597512,0.161135,0.29586526,0.0076856356,0.17710925,0.41285417,0.26696005,0.95372582,0.81309132,0.25147222,0.4759238,0.3486487,0.21627786,-0.16607008,-0.17753246,0.071613006,-0.20267628,-0.25024911,0.082940898,-0.23944672,-0.37375371,-0.095985983,-0.17753834,-0.043046738,-0.15926192,-0.23934588,-0.060706022,-0.26418938:1
0.50871874,0.80968553,1.5528082,1.9816869,1.6243391,1.3628215,1.4121392,0.97378315,0.19369358,-0.26377121,-0.33644359,-0.18884968,-0.13284071,-0.33661722,-0.4250242,-0.28995731,-0.29897631,-0.46744708,-0.57800441,-0.69952074,-0.86183236,-0.86605151,-0.77510883,-0.83778941,-0.89223761,-0.82736862,-0.93749266,-1.0886334,-0.99066033,-0.96243856,-1.1148195,-1.1860607,-1.2780785,-1.3766805,-1.3227071,-1.3948869,-1.6385415,-1.6768466,-1.5463976,-1.4945179,-1.4416409,-1.3426498,-1.3243083,-1.2979785,-1.1485216,-1.0493542,-0.98199143,-0.69182456,-0.43398086,-0.57437581,-0.63900538,-0.11974766,0.35123945,0.18562812,0.10283419,0.48600248,0.57407331,0.40397434,0.5345357,0.58675421,0.52181179,0.72175519,0.6848584,0.35160214,0.43725082,0.71485022,0.69202144,0.60707653,0.60400921,0.65274229,0.72514513,0.68730458,0.71820754,0.87549638,0.84446562,0.84913804,1.1551799,1.2696425,1.097906,1.1794649,1.3981351,1.37286,1.4783319,1.796733,1.4383253,0.69251641,0.93092348,1.497244,1.1966548,0.85710223,0.70511449,0.1377182,-0.33259176,-0.97079591,-1.8623141,-1.2386221:-1
-0.1743352,1.3528679,2.6915514,1.6637386,1.6834037,0.5311746,-1.3537081,-0.18406623,0.45316622,-0.19759894,0.094040089,0.44589949,-0.31478967,-1.1647464,-0.99762711,-1.175502,-1.1555864,-1.2357325,-1.4046113,-1.385224,-1.4047868,-1.3337243,-1.4274843,-1.6475716,-1.79936,-1.8410863,-1.82546,-1.7910915,-1.8242385,-2.0028394,-2.0097871,-1.7300546,-1.7375591,-1.6639753,-1.4605276,-1.1407161,-0.98502676,-0.61658787,-0.11334789,-0.11708515,0.2353696,0.42662174,0.48868196,0.6563782,1.0051381,0.91308968,0.77285866,0.96660043,0.87115019,0.75099477,0.69887641,0.64589389,0.65245631,0.64119884,0.67783156,0.62033721,0.68975494,0.67414873,0.65611776,0.68502344,0.73064181,0.66933561,0.66355582,0.67114639,0.6366849,0.71059812,0.68415659,0.54002169,0.4511246,0.58766039,0.50550476,0.45309965,0.77291692,0.89361217,0.90260426,0.97000717,0.95258768,0.6038387,0.59555377,0.61378236,0.23900466,0.30504852,0.27929827,0.22291827,0.014128542,0.29554609,0.3327364,0.015242973,0.31150627,0.18321705,0.098610884,0.13708929,0.13226231,0.25320529,0.019005131,0.12422035:1
0.54278954,2.0640499,2.8059709,1.5594706,0.15867064,-0.70491116,-0.023513034,0.57809638,0.41833539,0.53746948,0.11032367,-0.18762124,-0.46296555,-0.67848725,-0.66659982,-0.72720675,-0.77209834,-0.88130547,-0.8496939,-1.2677519,-1.219541,-1.1338395,-1.4279445,-1.5642636,-1.8216128,-1.7485221,-1.9290449,-2.1355442,-2.2463926,-2.2156476,-2.1510943,-2.3312285,-1.9414192,-1.5425392,-1.392594,-0.94051585,-0.62262725,-0.14431619,0.32856278,0.5698652,0.99913614,0.96786185,0.83333595,1.2204373,1.0759235,0.95540079,1.0877,0.86271594,0.73644627,0.85793997,0.78104814,0.84238011,0.81268712,0.65457535,1.0122299,0.85268779,0.61352661,0.83037465,0.74648495,0.55807478,0.73410868,0.71616852,0.65706606,0.58363227,0.63082749,0.59398116,0.41479157,0.61573621,0.48515411,0.43624868,0.44166322,0.35273346,0.40225609,0.32067925,0.70177722,0.59395432,0.70273438,0.65788425,0.027779585,0.20896727,0.068265472,-0.11798829,-0.10501847,-0.090652478,-0.18747854,-0.13078377,-0.12055911,-0.090310053,-0.12118075,-0.24796264,-0.014804831,-0.031834254,-0.16428974,-0.063092931,-0.1060261,0.0018426594:1
0.56688351,0.59276786,2.1505681,3.3019652,1.7582258,-0.10959189,-1.3994646,-0.59941349,0.2362639,0.18299708,-0.10913651,-0.37201856,0.10176102,-0.91047504,-1.0245056,-1.0119139,-1.1543758,-1.2901829,-1.2730994,-1.1593025,-1.299877,-1.5995593,-1.4791533,-1.40468,-1.6714886,-1.6117656,-1.900671,-2.0397056,-1.8474294,-2.0187986,-2.0558872,-1.5811505,-1.7307928,-1.6191702,-1.7977861,-0.57250426,-0.36223781,-0.43257802,0.27759356,-0.17472507,1.0226472,0.62304847,1.0621585,1.1361201,0.91592227,0.95371796,0.78110657,0.95437031,0.49887536,0.82314511,0.76074078,0.50969389,0.69827638,0.19078711,0.73331042,0.30120014,0.38008205,0.85431086,0.46170592,0.22523491,0.39193027,0.53771638,0.46554921,0.334607,0.31563109,0.33141428,0.25275833,0.42246533,0.33733818,0.023032784,0.4818057,0.071660347,0.38076003,0.91484009,0.65785024,0.89767758,0.96119214,0.75030932,0.44026878,0.39289158,0.42709083,0.15915583,0.28951514,0.12219964,0.15607143,0.43353887,0.48783112,0.19882026,0.058043926,0.42292114,0.44391869,0.22725647,0.51162874,0.35540963,0.30971768,0.59314197:1
0.78922775,2.0527997,3.6115297,3.8177297,2.4657895,0.69777517,-0.7662826,0.37966856,0.76403919,0.25773427,0.53011349,0.19901945,0.35027834,-0.31242445,-0.32041774,-0.46188239,-0.5554543,-0.66719228,-0.74946479,-0.88504613,-0.98084889,-1.0631133,-1.0495432,-1.125052,-1.5179636,-1.4808782,-1.5101052,-1.6477548,-1.7577504,-1.80272,-1.7923121,-1.8687786,-1.7035305,-1.5778579,-1.3327342,-1.1428383,-0.9810673,-0.2403431,-0.14656932,0.034652327,0.607216,0.48034294,0.88051888,0.83146028,0.88194502,1.0550705,1.0051729,0.92835156,0.82209831,0.83763418,0.7933129,0.64607175,0.58251883,0.65238373,0.52280559,0.47384318,0.56195589,0.58331543,0.5285568,0.40636335,0.49938868,0.4173809,0.42487472,0.36774037,0.33871158,0.31958909,0.049830321,0.36299497,0.30737553,0.0036182657,0.033593107,-2.2251768E-4,0.15016706,0.38758647,0.34819104,0.44368902,0.46841463,0.43036021,0.14604406,-0.14166323,-0.088109529,-0.23576055,-0.3770084,-0.52753813,-0.27322359,-0.31913813,-0.48795808,-0.42076006,-0.3968943,-0.44396148,-0.4724151,-0.37748997,-0.345073,-0.34179463,-0.44912173,-0.39278702:1
0.068846565,0.80884529,2.6079585,3.6402976,2.0932971,0.42604149,-0.95675232,-0.45170082,0.29688267,0.43301091,0.35309097,-0.33603917,0.14740177,-0.67365902,-0.91681541,-0.9012812,-0.99310462,-0.93581397,-1.2372415,-1.1273011,-1.282654,-1.5474282,-1.4292195,-1.4337211,-1.4539514,-1.8290149,-1.9819172,-1.877888,-2.0599423,-1.9537648,-1.8248292,-1.9793392,-1.2836669,-1.4264365,-1.4780689,-0.78744939,-0.60358092,-0.24978571,-0.022740876,0.39847713,0.67979006,0.73841557,1.0779522,0.96626768,0.99012207,1.1601625,1.015825,0.94281447,0.86369756,0.7572688,0.57539129,0.6607389,0.88335663,0.57993723,0.54936763,0.75627311,0.52775792,0.50516629,0.62776202,0.64241568,0.61129848,0.51007263,0.44491603,0.5677236,0.41104608,0.35670535,0.48312761,0.37172147,0.40620356,0.16768971,0.32064458,0.36711015,0.44763161,0.84198405,0.89723218,0.6474705,0.47428668,0.33651308,0.28150151,0.12320494,-0.057563631,0.010401321,-0.017934473,-0.17628534,-0.23377359,0.29682625,-0.10895391,-0.16938363,-0.055744418,-0.10516754,0.018623063,-0.16231095,-0.089595219,-0.0719688,0.038689976,0.076532621:1
0.92756523,1.2653326,2.6947366,3.920299,2.6225412,1.5789118,0.32293635,0.033836143,1.3215228,1.4228921,1.0230605,1.1996819,1.1087683,0.027013266,-0.44294995,-0.51068862,-0.56287703,-0.70542121,-0.75027758,-0.89062943,-0.84207435,-0.83651524,-1.1818528,-1.1827903,-1.1317294,-1.2840467,-1.5164674,-1.6958164,-1.6965507,-1.7925315,-1.8976218,-1.8771656,-1.7712398,-1.6629641,-1.5371582,-1.2909562,-1.0182203,-0.70704915,-0.5545525,-0.21021234,0.23040657,0.20546223,0.44585189,0.60619663,0.74692934,0.7264539,0.82563918,0.98929816,0.79614569,0.63808687,0.60042026,0.75238309,0.71155734,0.46213547,0.48055229,0.60995137,0.71068658,0.41261837,0.45535569,0.58211136,0.44616485,0.42490389,0.38499871,0.37825735,0.36084126,0.37322856,0.20037254,0.077666612,0.22276803,0.068980794,0.064950174,-0.065661771,0.17737849,0.40220431,0.36716136,0.54228558,0.38647193,0.24674897,0.067658329,-0.1645918,-0.14152796,-0.40596293,-0.39321336,-0.33064101,-0.57649678,-0.4072113,-0.3543673,-0.58097188,-0.3997525,-0.48712573,-0.54087628,-0.40869314,-0.56790338,-0.47168556,-0.44379437,-0.3595461:1
0.34263832,0.88226289,1.6426063,1.9629229,1.7741008,1.6433305,1.2459171,0.56180853,-0.032995131,-0.34645009,-0.11860832,-0.052680343,-0.4085353,-0.26670168,-0.068461616,-0.2990208,-0.43211096,-0.64048897,-0.92019333,-0.95060688,-0.97577933,-1.0752105,-1.1348472,-1.1679504,-1.1909087,-1.2593464,-1.365662,-1.4339247,-1.5117986,-1.639218,-1.6745117,-1.6928927,-1.8213737,-1.8415655,-1.790643,-1.8774667,-1.8989846,-1.7790234,-1.7076467,-1.5758465,-1.3088118,-1.1428573,-1.026722,-0.74848478,-0.45905543,-0.28540927,-0.16207785,-0.1510679,-0.13861278,0.11033553,0.26845744,0.19691003,0.3415912,0.47335575,0.37148964,0.46578258,0.54089476,0.36440987,0.26527903,0.33028835,0.43267728,0.28757898,0.10055547,0.30306621,0.39592048,0.27463172,0.3942039,0.42913948,0.33962524,0.54674481,0.8220322,0.89685132,0.9553667,1.0646542,1.1424179,1.2079176,1.2096563,1.1701417,1.1038603,0.89564261,0.80437217,0.87587161,0.80603642,0.83204805,0.94484915,0.84750455,0.80586783,0.8418723,0.75077919,0.77569694,0.89391653,0.73848308,0.55957557,0.74928821,0.90113023,0.49019473:1
1.2106339,2.0033132,1.7456025,1.475794,0.19887114,0.10653092,1.0173006,0.81742798,0.99833497,0.82159462,-0.29900089,-0.67685417,-0.68235251,-0.96281272,-0.97213158,-1.0023209,-1.0992891,-1.0526758,-1.2604252,-1.3282097,-1.3951999,-1.5480231,-1.7076263,-1.9472583,-2.0772737,-2.2287107,-2.3156682,-2.4765243,-2.549976,-2.3832854,-2.190772,-2.0227201,-1.5502245,-1.1347029,-0.71965149,-0.22867963,0.10805214,0.3221329,0.49457595,0.66650334,0.66158288,0.63379278,0.55831471,0.53485272,0.48213908,0.38860263,0.39941234,0.39393721,0.39690711,0.42166085,0.38075173,0.46693248,0.48418504,0.46930643,0.55859949,0.45822607,0.47829954,0.47696808,0.49255067,0.42788022,0.49164863,0.41993751,0.38063547,0.44767977,0.36612588,0.32853491,0.31534058,0.44443883,0.3867798,0.35675378,0.44368163,0.42994058,0.47399508,0.6371973,0.78668779,1.0491275,0.87613024,0.63468906,0.64561285,0.46473292,0.46333617,0.42437091,0.26218379,0.2253518,0.34204574,0.36436619,0.25836137,0.21793416,0.26910008,0.33819337,0.29435122,0.2270549,0.40831801,0.35725521,0.61719789,0.81170786:1
0.59313603,0.80250911,0.067021556,0.052160732,-0.12167926,-0.26202288,-0.33994214,-1.0062404,-0.59898697,-0.52970494,-1.1856121,-1.0053182,-0.89876927,-1.0917618,-1.4072013,-1.4293048,-1.6250422,-1.5733116,-1.9192262,-1.74836,-1.805791,-1.8971609,-1.7293434,-2.2691788,-1.7849163,-1.7460259,-1.7475481,-0.72998752,-0.84418028,-0.42672489,-0.26633783,-0.079507284,1.1773343,0.73347594,0.65012589,1.1787742,1.079006,0.94114932,1.0895865,1.1170872,0.81479883,1.3428101,0.60501942,0.87274247,0.5123191,0.72490422,1.088469,0.77410833,0.70870558,0.79153338,0.70991321,0.48996558,0.78993928,0.50126724,0.64551575,0.76640171,0.15491479,0.41564746,0.3142384,0.42052174,0.32342367,0.27822343,-0.090264024,0.082859583,0.53525853,0.24757589,0.56139889,0.30952558,0.27271595,0.21810709,0.27393487,-0.017904864,-0.13892085,-0.21014382,-0.1137507,0.093109051,-0.42413019,-0.18865992,0.048308086,-0.66521083,-0.30484309,0.0048759833,-0.41411973,-0.19676712,-0.17918337,-0.51376342,-0.41397942,0.10872402,-0.023326113,1.2233758,3.0473088,2.402594,2.4357556,1.2766935,-0.7978437,0.093126673:1
0.70370874,2.1329849,3.5596179,3.3633563,2.6401432,1.260467,-0.49060654,-0.090413285,0.53944717,0.25431671,0.34155574,0.34724464,0.2807386,-0.058395009,-0.69286534,-0.89370968,-0.50978985,-0.85662103,-0.88452148,-0.93822468,-1.2568693,-1.065784,-1.2760981,-1.2851325,-1.4805175,-1.6128873,-1.4955172,-2.0528977,-1.6416944,-1.738472,-1.8948757,-1.7296248,-2.1026516,-1.3989201,-1.116141,-1.3825585,-1.0009164,-0.45116437,-0.11216043,-0.12544132,0.38430511,0.52268112,0.64022824,0.83679803,0.91334864,0.97374424,0.85505655,0.9168316,0.78953567,0.81599558,0.76457052,0.49983047,0.65676993,0.57289019,0.61484244,0.54089615,0.39077625,0.47798147,0.37671973,0.56613391,0.324026,0.24478462,0.43970075,0.23777299,0.25566436,0.2847559,0.34540402,0.15379756,-0.078810462,0.22459146,0.29375224,-0.082837109,0.059070814,0.37341512,0.76557009,0.42700273,0.52756719,0.50578253,0.13154282,0.12950621,-0.15099513,0.12673297,-0.23428292,-0.29217644,-0.26470573,-0.096006178,-0.184226,-0.19090339,-0.14321956,-0.24367694,-0.045045495,-0.20656957,-0.2147904,-0.20443928,-0.2594731,0.14367171:1
2.1667159,2.284215,1.7854924,1.9232385,2.2243859,1.6907376,0.59279901,-0.19814065,-0.43426533,-0.45957792,-0.5650328,-0.71309039,-0.75961482,-0.799381,-0.95621071,-1.061581,-1.0103316,-0.96559222,-1.0139493,-1.1065945,-1.2217788,-1.3070171,-1.2825839,-1.2499333,-1.3272455,-1.4259096,-1.4767839,-1.5196969,-1.5450067,-1.5457064,-1.5298879,-1.5441042,-1.6328329,-1.6235171,-1.4694138,-1.4156322,-1.4220463,-1.3089213,-1.1463607,-0.93081787,-0.67493262,-0.51149014,-0.33627523,-0.066463197,0.13638832,0.26325697,0.43954788,0.62767038,0.74825551,0.83209959,0.89968645,0.96995844,1.0676785,1.0497882,0.93097493,0.99617341,1.1629241,1.2174583,1.2604235,1.2206794,1.0665458,1.0374046,1.0280974,0.87633669,0.7183252,0.56646112,0.44231659,0.42797578,0.40983454,0.36088664,0.35148882,0.3201457,0.28116669,0.30648701,0.30455869,0.23258023,0.23221348,0.27864968,0.22146146,0.19771907,0.30678074,0.34047874,0.25722383,0.15948639,0.082376794,0.13271749,0.25138307,0.24408782,0.15267108,0.081487161,0.10038863,0.22872313,0.2538998,0.13794377,0.1993058,0.4775621:-1
0.91899571,1.0688252,0.98272169,1.5201531,2.3103544,2.3079504,1.7544429,1.5135657,1.318105,0.67161156,0.062202091,-0.055991082,0.058747605,0.030198911,-0.20713671,-0.31796969,-0.18678489,-0.22070618,-0.30589505,-0.11304074,-0.2183722,-0.7412612,-0.81072743,-0.56870234,-0.76214063,-1.0347687,-0.99950674,-0.98669998,-1.0670712,-1.1346649,-1.2243463,-1.268287,-1.335924,-1.4715307,-1.4948522,-1.5713908,-1.8626604,-1.9504453,-1.7486006,-1.7054109,-1.8033503,-1.7723573,-1.6900836,-1.6295457,-1.5751586,-1.5344025,-1.3859806,-1.1421926,-0.93927964,-0.67225032,-0.36513353,-0.26430783,-0.24073059,-0.050920263,0.17103641,0.32675755,0.50361779,0.61688495,0.58608308,0.58391661,0.66561855,0.64149646,0.57376149,0.68557701,0.78233391,0.66128551,0.60656306,0.7097423,0.73992807,0.75958848,0.81070347,0.72006148,0.59837902,0.61022571,0.65995343,0.66577939,0.53886891,0.30914391,0.34512159,0.71144273,0.94077722,0.87843816,0.8103929,0.81204616,0.74804029,0.60764791,0.50924331,0.53015995,0.55420565,0.49520923,0.51779314,0.62778032,0.63405918,0.63413117,0.64784964,0.38106202:-1
1.3971093,2.2885831,2.4340418,2.3545672,2.3225632,1.9834299,1.3102738,0.64807903,-0.017222812,-0.51081279,-0.36040726,-0.094296865,-0.42289316,-0.59953622,-0.15652846,-0.014679595,-0.31324582,-0.4369491,-0.65324945,-0.96135679,-0.79907716,-0.63679183,-0.95354458,-1.1025199,-1.0039662,-1.1739967,-1.2370328,-0.9487888,-0.92823331,-1.2255539,-1.3603722,-1.3778245,-1.4315549,-1.4836421,-1.6023814,-1.6619765,-1.5269134,-1.5467346,-1.8137025,-1.8438218,-1.6124579,-1.5420541,-1.5475049,-1.3193132,-0.98673594,-0.77435838,-0.6432177,-0.51982583,-0.41192015,-0.27226538,-0.056057664,0.13796641,0.23100576,0.31626444,0.41062443,0.43363741,0.49259458,0.59999188,0.55345609,0.51879557,0.68588751,0.67408309,0.44879707,0.5100268,0.65705181,0.45500634,0.31711476,0.46951114,0.45564687,0.31199796,0.39554644,0.50722803,0.45970314,0.46914966,0.5511582,0.51314969,0.41825968,0.41703328,0.467111,0.55602072,0.78861759,1.015674,0.92311943,0.69248872,0.72154325,0.82763507,0.72856657,0.63287419,0.67349753,0.75655298,0.85334346,0.75985986,0.49322622,0.58169929,0.83666822,0.42748505:-1
0.99292711,2.3228425,2.3505839,2.580396,2.635011,1.4674241,-0.12895384,-0.90738915,-1.0144013,-1.3187679,-1.3309024,-1.2728595,-1.3167994,-1.5566399,-1.3384669,-1.5092478,-1.5848065,-1.6530533,-1.9489427,-1.8483552,-1.8435005,-1.8497487,-1.7824383,-1.6660744,-1.5420146,-1.2042296,-0.93147576,-0.59165349,-0.29757467,-0.15772402,0.56933028,0.24728897,0.93645999,0.50760041,1.1303664,0.63644585,0.74346321,0.65923206,0.59201056,0.46852759,0.29239018,0.63852363,0.35734784,0.3773856,0.36620057,0.32036467,0.35763806,0.32480464,0.13541346,0.24938564,0.25877551,0.11292647,0.17071638,0.10999838,0.049029107,0.089260813,0.12838853,0.12960015,0.002581504,0.093249921,0.13312627,-0.1065233,0.0080988732,0.038201403,-0.11082325,-0.12041552,-0.11178477,0.049725648,0.088460607,0.26363765,0.53091178,0.16303892,0.27437666,0.023395886,0.10734881,-0.15719862,-0.10725292,0.043185199,-0.097837626,0.016612623,-0.054093949,-0.28676106,-0.10816617,-0.08924637,-0.20700951,-0.012786486,-0.18407756,-0.29055342,-0.10390106,0.038109466,0.39968041,2.0067233,2.2593691,2.0786597,0.98133858,-0.16344038:-1
0.59782907,1.2574276,2.7584957,4.0869911,2.4522113,0.81663588,-0.77634288,-0.50396426,0.58736328,0.18173346,0.1138058,-0.019752933,0.30257219,-0.35718866,-0.72212577,-0.73469728,-1.0181106,-0.68482885,-0.92543325,-1.1036499,-1.2605537,-1.0172755,-1.1808423,-1.7259903,-1.4323945,-1.9682875,-1.5941341,-1.478636,-2.3515126,-1.7501782,-1.9622735,-1.8714837,-1.5807111,-1.5556297,-1.1898148,-1.0205255,-0.40816705,-0.09337209,0.26725716,0.45376032,0.34082814,1.0665267,1.0429154,0.84210931,0.94017243,0.98393905,0.97699854,0.81587327,0.7779003,0.81860661,0.47230255,0.54607445,0.71132841,0.34545408,0.59041937,0.4565372,0.37054491,0.85178703,0.22274349,0.39840572,0.28460078,0.49736514,0.70120432,0.075299251,0.35071242,0.25875233,0.23056116,0.2887762,0.07736689,0.23689685,0.16692018,-0.069638473,0.33711756,0.61541185,0.58699084,0.71123459,0.63711648,0.54294467,0.34956668,0.16303043,-0.045172582,-0.16641273,0.10593932,-0.15697644,-0.026205127,-0.063728094,-0.37007445,-0.074981639,-0.2138222,-0.13281116,-0.21682791,-0.34657612,-0.014023039,-0.18416609,-0.17684524,-0.11922008:1
0.98308038,0.84106858,1.9682872,3.0955059,2.3676954,1.231601,0.095506633,0.73455973,0.55704498,0.14876106,-0.046505167,-0.25952286,0.077755158,-0.72106121,-0.56129794,-0.68555826,-0.86307301,-0.91632743,-1.0583392,-1.3246114,-1.4843746,-1.8039012,-1.9636645,-2.2299366,-2.5317116,-2.6027175,-2.5317116,-2.5672146,-2.4962087,-2.0701733,-1.6973923,-1.2891084,-0.93407891,-0.43703761,-0.099759592,-0.099759592,0.36177876,0.52154203,0.64580235,0.27302138,0.50379055,0.30852433,0.43278466,0.36177876,0.37953023,0.29077286,0.5392935,0.30852433,0.62805088,0.57479645,0.6102994,0.57479645,0.25526991,0.6102994,0.34402728,0.57479645,0.41503318,0.21976696,0.27302138,0.55704498,0.30852433,0.25526991,0.29077286,0.27302138,0.50379055,0.18426401,0.30852433,0.23751843,0.060003683,0.16651253,0.20201548,-0.064256642,0.21976696,0.18426401,0.20201548,0.095506633,-0.17076549,0.50379055,0.18426401,0.18426401,0.11325811,0.32627581,0.25526991,0.25526991,0.5392935,0.30852433,0.59254793,0.57479645,0.34402728,0.45053613,0.39728171,0.48603908,0.32627581,0.29077286,0.48603908,0.73455973:-1
1.3084559,2.5326755,2.5672471,1.1317266,-0.042169112,0.55679287,1.1341733,0.90654975,1.0640724,0.48358225,-0.33310204,-0.30649192,-0.64862953,-0.79981042,-0.81463101,-0.88200523,-1.002864,-1.2456578,-1.2165421,-1.2608334,-1.6924437,-1.6718997,-1.8980276,-2.1698596,-2.1852311,-2.4829402,-2.4297767,-2.4755274,-2.2562715,-1.9250092,-1.5828682,-1.112299,-0.62868402,-0.19758705,0.074202562,0.24453867,0.51297591,0.70515466,0.55388315,0.5666342,0.76992444,0.50183663,0.42562598,0.68719628,0.50331669,0.56406933,0.60573608,0.57315027,0.61750989,0.5857523,0.53046861,0.55388283,0.69972902,0.50941901,0.43474328,0.5085047,0.45174653,0.4113844,0.32602884,0.43877057,0.34449028,0.22102244,0.18235969,0.29640352,0.19574463,0.082229881,0.25161629,0.061732386,0.11608909,0.044929444,0.22205897,0.47938609,0.48613213,0.53600098,0.35084294,0.2633702,0.050237219,-0.024588945,-0.040239751,-0.081721791,0.017324661,-0.18496493,0.020526854,-0.041323205,0.050318386,0.044882988,-0.13149635,-0.033367784,0.097154351,0.080608674,0.4181689,1.4756806,2.175542,0.82515804,-0.54097616,-0.091631666:1
0.55686579,0.81828421,0.96784416,1.3404921,1.9317436,2.3661759,2.3375529,1.8998198,1.3690636,0.89970477,0.36114369,-0.17698351,-0.34962957,-0.18012552,-0.1373533,-0.3138134,-0.39519556,-0.34465947,-0.31354598,-0.27889901,-0.27884146,-0.43379412,-0.59497077,-0.62117654,-0.6793944,-0.81701902,-0.86013889,-0.84316095,-0.89559815,-0.92122324,-0.88928992,-0.9648305,-1.1142478,-1.1620867,-1.1577271,-1.2233045,-1.3407032,-1.4862591,-1.6275197,-1.6469463,-1.5591661,-1.5406761,-1.6107753,-1.6279842,-1.6003671,-1.6350744,-1.6498041,-1.47202,-1.1759175,-1.0049538,-0.9702992,-0.88095065,-0.73201572,-0.63995015,-0.52509206,-0.28096973,-0.062383655,-0.021949972,-0.019032333,0.10383147,0.24379633,0.23786778,0.1565006,0.19093237,0.35307145,0.50156327,0.5441835,0.48843187,0.44293224,0.54723574,0.71845521,0.70815968,0.57932866,0.62876366,0.79178011,0.76625982,0.61005728,0.60152951,0.75465614,0.90416095,1.0213569,1.1079595,1.0623296,0.89330866,0.79984596,0.83840082,0.81934987,0.70344962,0.7430917,1.0056726,1.1647486,1.0658567,1.0470411,1.2694538,1.2243422,0.56942382:-1
0.73543754,1.8699754,2.2378345,1.3957275,0.21107322,-1.4823914,-1.0472139,0.15702017,-0.22123268,0.019546913,0.053034731,-0.16331404,-0.36689641,-0.95736738,-1.103912,-1.340855,-1.0370343,-1.2842738,-1.3641318,-1.2791882,-1.4002281,-1.4080326,-1.4692785,-1.6918667,-1.6782148,-1.4673317,-1.8244895,-1.9068038,-1.9298943,-1.7127263,-1.8947244,-1.9375769,-1.6380168,-1.7444979,-1.4329895,-1.2871992,-1.2158426,-0.68493209,-0.37072444,-0.23453134,-0.086409319,0.27393778,0.38104229,0.6539539,0.51985868,0.67703155,0.89186799,0.76912619,0.69865802,0.77491053,0.84246016,0.70444584,0.72742393,0.59631786,0.64563288,0.86459168,0.66524626,0.62393512,0.47120656,0.82290509,0.87045218,0.52840362,0.70167141,0.76079688,0.66404873,0.65784907,0.6582625,0.75222882,0.67945989,0.4966542,0.70567358,0.49551026,0.88176751,0.95524748,1.1016102,1.225435,0.85128993,1.0111744,0.66293574,0.54521456,0.77143072,0.37383113,0.36460138,0.37565211,0.40420964,0.45484573,0.24159055,0.34370038,0.33325365,0.34025632,0.45008457,0.20859543,0.29181353,0.48405224,0.44091647,0.29539937:1
0.41500979,0.67367738,1.9191069,3.2162676,2.8894929,2.6509826,1.2160414,-0.22193749,0.31057568,0.41078598,-0.041293451,-0.2297146,0.10139349,-0.10164656,-0.77507146,-0.36890014,-0.59624103,-0.95912436,-0.8567013,-0.99241809,-1.0888853,-1.0417139,-1.1047771,-1.2595511,-1.3323476,-1.4335868,-1.5878223,-1.6363281,-1.5809843,-1.8849704,-1.8502112,-1.5605024,-2.1586919,-1.8949871,-1.5886635,-1.7734619,-1.4500595,-1.262174,-0.6652126,-0.17822508,0.036122577,0.41654386,0.548315,0.66836473,0.77296784,0.87175677,1.0227698,1.0639148,0.87277644,0.67065337,1.0432044,0.84760635,0.49511649,0.76566684,0.55918838,0.6747978,0.59264024,0.49202133,0.70914366,0.62153356,0.49030768,0.54991974,0.65918223,0.4954751,0.54939406,0.40261956,0.20818362,0.55779193,0.26727987,0.27607969,0.31585484,0.10803062,0.1624707,0.23201055,0.61703523,0.68554618,0.54223095,0.59528904,0.26795275,0.20668617,0.027907715,-0.175753,0.19438146,-0.097093177,-0.32245049,-0.0021939396,0.05254325,-0.096647804,-0.32224132,-0.19478725,-0.20156981,-0.2467759,-0.17661876,-0.41986688,-0.25287784,-0.027529814:1
0.43707074,0.18274102,-0.38857572,-1.0763129,-1.247922,-0.73082583,-0.17795163,-0.1124692,-0.23692637,-0.10154323,0.066372326,-0.14923713,-0.57392493,-0.7120064,-0.54022507,-0.41591443,-0.48967529,-0.61413303,-0.72557428,-0.86629299,-0.99517312,-1.0197488,-0.99517312,-1.0380113,-1.1636724,-1.2910559,-1.3995714,-1.5005207,-1.6017705,-1.7099414,-1.8376695,-1.9208202,-1.8713694,-1.7291684,-1.6523203,-1.6688235,-1.6354704,-1.4814734,-1.3321717,-1.259456,-1.1468225,-0.91981039,-0.7424242,-0.75550708,-0.80982392,-0.6267914,-0.20322652,0.18067076,0.31912124,0.33351818,0.43707074,0.62131362,0.68981965,0.62938654,0.6561198,0.88433353,1.1110678,1.1367263,1.0436681,1.0240922,1.0436681,0.95551695,0.79091922,0.75110276,0.89201878,1.0496927,1.0605181,0.96637615,0.90886871,0.93143944,0.94256857,0.88622598,0.841469,0.89907418,1.0099683,1.0532713,1.0099683,0.97005977,0.99311835,1.0461243,1.0605181,0.98671204,0.841469,0.73180897,0.75721936,0.85410098,0.85831893,0.76343678,0.75721936,0.92377713,1.0942179,1.1039632,1.0268182,1.0052978,1.0099683,0.9373903:-1
1.2259204,1.8508505,2.8294223,3.263266,2.1600331,1.3472488,0.6058005,-0.75581516,-0.8421453,-0.020085156,-0.25751114,-0.45800598,-0.20190807,-0.32052377,-0.33016424,-0.28678445,-0.38412916,-0.45739365,-0.79393108,-0.97711277,-0.64542274,-0.75732619,-1.0511368,-0.97099145,-1.2059984,-1.3835055,-1.2444735,-1.3142344,-1.4773477,-1.6714611,-1.7352912,-1.610633,-1.7341661,-1.9516243,-1.7901028,-1.6197654,-1.6608119,-1.5337532,-1.3233466,-1.2214091,-1.046124,-0.68745478,-0.37534271,-0.295424,-0.14324557,0.12981266,0.28452149,0.364611,0.40489234,0.40548486,0.40420162,0.35692385,0.36216982,0.44092194,0.37749129,0.34421921,0.38923281,0.1811664,0.12140753,0.20907595,0.073102099,0.12791697,0.20966993,0.10841687,0.096871528,0.253693,0.62839466,0.77861289,0.707466,0.76560167,0.69542167,0.73705912,1.0000557,1.112517,1.1496046,1.2669278,1.4226271,1.3073774,1.0300946,0.89760681,0.62940603,0.46698548,0.56096792,0.46951187,0.43776261,0.53859312,0.38359117,0.19577834,0.17058344,0.10325461,0.13442427,0.20905684,0.060733267,-0.11545964,-0.11310455,-0.023894207:1
0.58127681,0.87618758,1.0427672,1.7961197,2.5413991,2.2466526,1.5003869,1.0315208,0.38267199,-0.19756134,-0.16993849,0.01144398,-0.014047002,-0.076610835,-0.060981187,0.091619691,0.22472284,-0.01356082,-0.47678065,-0.65884966,-0.67497174,-0.83289751,-0.85054084,-0.73707682,-0.80863656,-0.87081929,-0.89387103,-1.0535721,-1.1644873,-1.1868895,-1.171606,-1.1302897,-1.2804719,-1.4578255,-1.4537981,-1.5607523,-1.7141015,-1.7409582,-1.8769725,-1.9752459,-1.8498089,-1.8544701,-1.9398877,-1.6467192,-1.2572351,-1.2498011,-1.2151296,-0.92686749,-0.7684571,-0.54259414,-0.20504068,-0.1419683,0.032076295,0.38084395,0.44776824,0.53223706,0.6235315,0.51215621,0.68879071,0.94772035,0.8274124,0.72960427,0.71119979,0.57064342,0.59894443,0.76494881,0.71934306,0.5633234,0.51730475,0.49819486,0.50454372,0.59124855,0.56237854,0.44703778,0.45239829,0.4407001,0.44913373,0.65793626,0.77128378,0.6883202,0.76057639,0.95106694,0.95167507,0.86996202,0.96020984,1.0703106,1.0027704,0.90786883,0.91645678,0.92397483,0.76735709,0.65622342,0.76235704,0.50137321,-0.33333635,-0.524546:1
2.6890171,2.7087035,2.0083814,2.2357998,1.5169816,0.02991649,-0.56134614,-0.79370191,-0.97937117,-1.2881617,-1.178131,-1.3899892,-1.3843161,-1.4799193,-1.6174653,-1.6067999,-1.7073068,-1.8333817,-1.7511665,-1.8837535,-1.9133903,-1.9986311,-1.8438057,-1.9308357,-1.7339859,-1.5787199,-1.3686669,-1.0669859,-0.68688217,-0.38254923,0.0058375575,0.28644788,0.56434769,0.76388319,0.92430946,1.1767835,1.0195918,1.0565467,0.97452859,0.97208583,0.79756973,0.80532536,0.78101338,0.79397353,0.64513762,0.66608905,0.63825042,0.60022936,0.51806721,0.64637147,0.51211797,0.47815973,0.34186576,0.40103811,0.40939273,0.30471192,0.2577703,0.38755869,0.25075475,0.26046103,0.11719242,0.1300502,0.30662929,0.09310346,0.093169052,0.069559367,0.21729395,0.064019283,0.19102973,0.080114911,0.12376522,0.16413121,0.2455166,0.59856244,0.78595212,0.63289168,0.601114,0.39655387,0.18487064,0.2394387,0.048780372,0.014701305,0.056774287,-0.159521,-0.022906271,-0.13740048,-0.13660983,-0.072175939,-0.082737685,-0.1384679,-0.12039571,-0.089411494,-0.24314052,-0.11970985,0.12404237,0.27346274:-1
0.19767692,0.45541658,0.97310983,1.9359564,2.259463,1.7413407,1.1582961,0.41824112,-0.071605093,-0.24124953,-0.24347772,-0.2639019,-0.62165563,-0.41871614,-0.18850206,-0.6231424,-0.93578951,-1.1178232,-1.2450346,-1.3277681,-1.3543206,-1.2618599,-1.2808817,-1.3678759,-1.5093921,-1.7489948,-1.691137,-1.5754371,-1.8345013,-1.8479682,-1.7746864,-2.0595725,-2.179838,-2.021338,-1.7997254,-1.5894695,-1.4506705,-1.2929073,-1.0361691,-0.72906394,-0.41531947,-0.20284251,3.0511646E-4,0.21511179,0.2955633,0.40503821,0.45540189,0.54207991,0.73676461,0.67149855,0.63718316,0.77934611,0.67812924,0.55736698,0.63462258,0.57043994,0.46618602,0.48409927,0.46811174,0.43414845,0.43444022,0.46884501,0.43787545,0.46474394,0.52942319,0.50502137,0.59580496,0.60665388,0.57833233,0.65745667,0.66066382,0.80420603,0.95017385,0.86632106,1.0014973,1.2667761,1.261269,1.2621858,1.1996334,0.94305876,0.83352393,0.6915735,0.41830842,0.42601702,0.57805773,0.58022963,0.48245231,0.32556942,0.24799135,0.18412739,0.050357907,0.24198843,0.33145057,-0.1200061,0.042422635,0.34329344:-1
0.17950028,1.0384092,1.9464212,2.7051409,1.6707064,-0.10116654,-1.5788757,-0.75090575,0.17531007,0.064900903,0.44313164,0.034638965,0.0095425646,-0.53952365,-0.7703735,-0.86459765,-1.2169037,-1.1220705,-1.2970508,-1.0562452,-1.2684458,-1.4927307,-1.4998569,-1.6429739,-1.5111231,-1.8409323,-1.5926416,-1.7653278,-2.0782307,-1.8019612,-2.0299619,-2.0198087,-1.9855857,-1.7244608,-1.6564068,-1.5422498,-1.11003,-0.71823834,-0.3009326,-0.23294287,0.30359266,0.46398306,0.49706412,0.86968963,0.93148206,0.77660642,0.95722736,0.84270652,0.59997909,0.83157962,0.48951411,0.3744976,0.72580573,0.56427401,0.66095832,0.52405056,0.46671876,0.61706199,0.68490133,0.46143356,0.50701044,0.54280183,0.53118055,0.73012784,0.77407468,0.55115241,0.41732696,0.58127611,0.49454658,0.49244215,0.48735228,0.46125489,0.64845969,0.99879183,0.96269761,1.0421928,0.75878503,0.61377296,0.73969574,0.41964707,0.58649517,0.34465915,0.20750257,0.52698019,0.27258373,0.34840968,0.32432338,0.33048863,0.11195293,0.44894807,0.56713171,0.13675737,0.44476796,0.15104997,0.19337751,0.45170853:1
0.073124179,0.77605406,2.181336,3.4403251,2.1684748,0.49731547,-0.92428396,-1.4992268,-0.67932845,-0.54989193,-0.78725674,-0.86524789,-0.67281251,-0.43837158,-0.75957456,-1.2470789,-0.76753457,-0.90354932,-1.19472,-1.121947,-0.98355763,-1.2439151,-1.4228455,-1.2470051,-1.5611456,-1.4887447,-1.2420938,-1.5224499,-1.9511948,-1.881457,-1.7514624,-1.8197548,-1.5629875,-1.4381696,-1.3597793,-0.81603422,-0.61959996,-0.48986109,-0.15566953,0.11285306,0.59185826,0.71814721,0.65506268,0.75182204,1.0983434,1.2792478,1.0563155,0.99464566,1.1167,0.89990447,0.75355753,0.93003195,0.9151704,0.77815786,0.75508833,0.76912022,0.79651893,0.83954318,0.76156696,0.62995935,0.94179343,0.5148406,0.57168814,0.84011187,0.5736698,0.71731607,0.81150426,0.63731832,0.22063763,0.68522624,0.52607755,0.44106115,0.32928138,0.60522125,0.99376719,0.83343942,0.74053978,0.61812138,0.62578752,0.46864555,0.059755354,0.096981647,0.19685754,-0.0021268498,-0.094384183,-0.2534871,-0.058934993,-0.13063785,-0.34723477,-0.1779331,-0.060331578,-0.34763359,-0.44744306,-0.06668896,-0.17844792,-0.25605159:1
