/*
 * Decompiled with CFR 0.152.
 */
package PETER_Monitor.vital_monitor;

import Language.LoadFXMLWithResourceBundle;
import PETER_Communications.com_protocol.VitalData;
import PETER_Monitor.vital_ecg.ECGData;
import PETER_Monitor.vital_ecg.ECGLineChart;
import PETER_Monitor.vital_ecg.ECGPoint;
import PETER_Monitor.vital_monitor.DefibrilatorHandle;
import PETER_Monitor.vital_monitor.NIBPHandler;
import PETER_Monitor.vital_monitor.settings_monitor.Settings;
import PETER_Monitor.vital_monitor.settings_monitor.SettingsValues;
import PETER_Monitor.vital_monitor.settings_monitor.ValuesAboutStateOfAplication;
import PETER_Monitor.vital_values.ChangingValuesAnimation;
import PETER_Monitor.vital_values.NIBPVitalFunction;
import PETER_Monitor.vital_values.SimpleVitalFunction;
import PETER_Monitor.vital_values.TempVitalFunction;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.chart.Chart;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ProgressBar;
import javafx.scene.image.Image;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundImage;
import javafx.scene.layout.BackgroundPosition;
import javafx.scene.layout.BackgroundRepeat;
import javafx.scene.layout.BackgroundSize;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.RowConstraints;
import javafx.scene.text.Font;
import javafx.stage.Stage;
import javafx.util.Duration;

public class Controller
implements Initializable {
    @FXML
    Button aed;
    @FXML
    Button shock;
    @FXML
    Button changeMode;
    @FXML
    Button closeNIBP;
    @FXML
    Button start;
    @FXML
    Button closeDefibrilator;
    @FXML
    Button lowImpedanceButton;
    @FXML
    Button mediumImpedanceButton;
    @FXML
    Button highImpedanceButton;
    @FXML
    Button NIBPButton;
    @FXML
    ProgressBar reload;
    @FXML
    ProgressBar NIBPprogress;
    @FXML
    ProgressBar analysaProgress;
    @FXML
    ProgressBar poweringOnProgress;
    @FXML
    Label powerinOnLabel;
    @FXML
    Button energy50;
    @FXML
    Button energy100;
    @FXML
    Button energy150;
    @FXML
    Button energy200;
    @FXML
    Label NIBPmodeLabel;
    @FXML
    Label NIBPmodeValueLabel;
    @FXML
    Label NIBPpressureLabel;
    @FXML
    Label NIBPpressure2Label;
    @FXML
    Label power;
    @FXML
    Label timeTotalLabel;
    @FXML
    Label timeLastLabel;
    @FXML
    Label numberOfShocksLabel;
    @FXML
    Label typeOfDefibrilator;
    @FXML
    Label NIBPtime;
    @FXML
    GridPane defibrilator;
    @FXML
    GridPane firstGraph;
    @FXML
    GridPane secondGraph;
    @FXML
    GridPane thirdGraph;
    @FXML
    GridPane fourthGraph;
    @FXML
    GridPane fifthGraph;
    @FXML
    GridPane valuesFromRemoter;
    @FXML
    GridPane powerOn;
    @FXML
    GridPane controlPaneGridPane;
    @FXML
    GridPane NIBPGridPane;
    @FXML
    GridPane NIBPOverview;
    @FXML
    GridPane AEDfunction;
    @FXML
    GridPane manualSetting;
    @FXML
    Label infoDefibrilatorLabel;
    @FXML
    Button metronomButton;
    @FXML
    Label metronomLabel;
    @FXML
    MenuItem pauseAplication;
    @FXML
    MenuItem resumeAplication;
    @FXML
    MenuItem shutDownMonitor;
    @FXML
    MenuItem boundariesMenu;
    @FXML
    MenuItem aboutMenu;
    @FXML
    MenuItem settingsMenu;
    @FXML
    CheckMenuItem graph1;
    @FXML
    CheckMenuItem graph2;
    @FXML
    CheckMenuItem graph3;
    @FXML
    Button soundDefibrilator;
    @FXML
    Button soundNIBP;
    @FXML
    Button overViewButton;
    @FXML
    Button powerOnButton;
    @FXML
    Button manualButton;
    @FXML
    CheckBox connectEcgElectrods;
    @FXML
    CheckBox connectTherapyElectrods;
    private ECGData ecgData;
    private ECGLineChart ecgGraph;
    private VitalData vitalData;
    private NIBPHandler NIBPhandler;
    private DefibrilatorHandle defibrilatorHandle;
    private boolean isMetronomOn = false;
    private ArrayList<SimpleVitalFunction> vitalFunctions;
    private int hearthRateIndex;
    private int SpO2Index;
    private int PPIndex;
    private int NIBPIndex;
    private int CO2Index;
    private int TempIndex;
    private ChangingValuesAnimation changingValuesAnimation;
    private ArrayList newValues;
    private Settings settings;
    private Timeline poweringOnAnimation;
    private boolean ecgSound;

    public void initialize(URL location, ResourceBundle resources) {
        this.defibrilatorHandle = new DefibrilatorHandle(this.defibrilator, this.typeOfDefibrilator, this.power, this.numberOfShocksLabel, this.timeLastLabel, this.timeTotalLabel, this.reload, this.shock, this.infoDefibrilatorLabel, this.analysaProgress, this.closeDefibrilator);
        this.NIBPhandler = new NIBPHandler(this.NIBPprogress, this.NIBPmodeLabel, this.NIBPmodeValueLabel, this.NIBPpressureLabel, this.NIBPpressure2Label, this.changeMode, this.start, this.NIBPGridPane, this.NIBPtime, this.NIBPOverview, this.closeNIBP);
        this.setVisibilityAllComponents(false);
        ((ColumnConstraints)this.powerOn.getColumnConstraints().get(2)).prefWidthProperty().bind((ObservableValue)this.controlPaneGridPane.widthProperty().multiply(1));
        ((ColumnConstraints)this.powerOn.getColumnConstraints().get(2)).minWidthProperty().bind((ObservableValue)this.controlPaneGridPane.widthProperty().multiply(1));
        ((ColumnConstraints)this.powerOn.getColumnConstraints().get(2)).maxWidthProperty().bind((ObservableValue)this.controlPaneGridPane.widthProperty().multiply(1));
        this.defibrilatorHandle.setImpedanceFromRemoter(1, this.lowImpedanceButton, this.mediumImpedanceButton, this.highImpedanceButton);
        this.defibrilatorHandle.setActivePowerButton(this.energy200, this.energy50, this.energy100, this.energy150, this.energy200);
        this.reload.minWidthProperty().bind((ObservableValue)((GridPane)this.reload.getParent()).heightProperty().subtract(100));
        this.analysaProgress.minWidthProperty().bind((ObservableValue)((GridPane)this.analysaProgress.getParent()).widthProperty().subtract(70));
        this.setElectrodsCheckboxes();
        this.changingValuesAnimation = new ChangingValuesAnimation();
        this.setSoundButtonDefibrilator();
        this.setSoundNIBPButton();
        this.ecgSound = true;
        this.setVisibilityAllComponents(false);
        this.settings = new Settings(this.soundDefibrilator, this.soundNIBP);
        this.setupVitalFunctionsPanels();
    }

    public ECGData getECGData() {
        return this.ecgData;
    }

    public void addFirstGraph(String nameOfGraph, ECGLineChart graph) {
        this.ecgGraph = graph;
        this.ecgGraph.setPadding(new Insets(0.0, 0.0, 20.0, 0.0));
        this.firstGraph.add((Node)this.createPanelWithButton(new Label(nameOfGraph), new Button()), 0, 0);
        this.firstGraph.add((Node)this.ecgGraph, 1, 0);
    }

    private GridPane createPanelWithButton(Label name, Button button) {
        GridPane gridPane = new GridPane();
        name.setFont(Font.font((String)"System", (double)20.0));
        name.setPadding(new Insets(3.0, 0.0, 0.0, 0.0));
        ColumnConstraints columnConstraints = new ColumnConstraints();
        columnConstraints.setMinWidth(79.0);
        RowConstraints rowConstraints1 = new RowConstraints(50.0);
        rowConstraints1.setValignment(VPos.TOP);
        RowConstraints rowConstraints2 = new RowConstraints();
        rowConstraints2.minHeightProperty().bind((ObservableValue)this.firstGraph.heightProperty().subtract(50));
        gridPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{columnConstraints});
        gridPane.getRowConstraints().addAll((Object[])new RowConstraints[]{rowConstraints1, rowConstraints2});
        gridPane.add((Node)name, 0, 0);
        gridPane.add((Node)button, 0, 1);
        gridPane.minHeightProperty().bind((ObservableValue)this.firstGraph.heightProperty());
        ((ColumnConstraints)gridPane.getColumnConstraints().get(0)).setHalignment(HPos.CENTER);
        button.setMinWidth(50.0);
        button.setMinHeight(40.0);
        GridPane.setMargin((Node)button, (Insets)new Insets(0.0, 0.0, 35.0, 12.0));
        GridPane.setMargin((Node)name, (Insets)new Insets(0.0, 0.0, 0.0, 10.0));
        button.setStyle("-fx-cursor: hand;");
        this.setBackgroundImageOnSoundButton(button, false);
        button.setOnAction(event -> {
            this.setBackgroundImageOnSoundButton(button, this.ecgSound);
            this.ecgSound = !this.ecgSound;
            this.ecgData.setBeep(this.ecgSound);
        });
        return gridPane;
    }

    private void setBackgroundImageOnSoundButton(Button button, boolean isActive) {
        String imagePath = isActive ? "images/disabledSound.jpg" : "images/activeSound.jpg";
        BackgroundImage backgroundImage = new BackgroundImage(new Image(this.getClass().getResource(imagePath).toExternalForm()), BackgroundRepeat.NO_REPEAT, BackgroundRepeat.NO_REPEAT, BackgroundPosition.CENTER, BackgroundSize.DEFAULT);
        Background background = new Background(new BackgroundImage[]{backgroundImage});
        button.setBackground(background);
    }

    private void createNormalGraphPane(GridPane graphGrid, String nameOfGraph, Chart graph) {
        graph.setPadding(new Insets(0.0, 0.0, 20.0, 0.0));
        Label name = new Label(nameOfGraph);
        name.setFont(Font.font((String)"System", (double)20.0));
        name.setPadding(new Insets(3.0, 0.0, 0.0, 0.0));
        ((ColumnConstraints)graphGrid.getColumnConstraints().get(0)).setHalignment(HPos.CENTER);
        ((RowConstraints)graphGrid.getRowConstraints().get(0)).setValignment(VPos.TOP);
        graphGrid.add((Node)name, 0, 0);
        graphGrid.add((Node)graph, 1, 0);
        GridPane.setMargin((Node)name, (Insets)new Insets(0.0, 0.0, 0.0, 10.0));
    }

    public void removeGraph(int number) {
        switch (number) {
            case 1: {
                this.firstGraph.getChildren().clear();
                break;
            }
            case 2: {
                this.secondGraph.getChildren().clear();
                break;
            }
            case 3: {
                this.thirdGraph.getChildren().clear();
                break;
            }
            case 4: {
                this.fourthGraph.getChildren().clear();
                break;
            }
            case 5: {
                this.fifthGraph.getChildren().clear();
            }
        }
    }

    @FXML
    public void exitApplication() {
        Platform.exit();
    }

    @FXML
    public void fullscreen() {
        Stage stage = (Stage)this.valuesFromRemoter.getScene().getWindow();
        stage.setFullScreen(true);
    }

    @FXML
    public void settings() {
        this.settings.showSettings(0);
    }

    @FXML
    public void setBoundaries() {
        this.settings.showSettings(1);
    }

    @FXML
    public void getAbout() {
        this.settings.showSettings(3);
    }

    @FXML
    public void hideGraph(ActionEvent e) {
        String id = ((CheckMenuItem)e.getSource()).getId();
        boolean visibility = ((CheckMenuItem)e.getSource()).isSelected();
        switch (id) {
            case "graph1": {
                this.firstGraph.setVisible(!visibility);
                break;
            }
            case "graph2": {
                this.secondGraph.setVisible(!visibility);
                break;
            }
            case "graph3": {
                this.thirdGraph.setVisible(!visibility);
            }
        }
    }

    @FXML
    public void pauseAplication() {
        this.changingValuesAnimation.pauseAnimation();
        this.defibrilatorHandle.pauseAnimations();
        this.NIBPhandler.pauseAnimation();
        this.pauseAplication.setDisable(true);
        this.resumeAplication.setDisable(false);
    }

    @FXML
    public void resumeAplication() {
        this.changingValuesAnimation.resumeAnimation();
        this.defibrilatorHandle.resumeAnimation();
        this.NIBPhandler.resumeAnimation();
        this.pauseAplication.setDisable(false);
        this.resumeAplication.setDisable(true);
    }

    @FXML
    public void shutDownMonitor() {
        this.setVisibilityAllComponents(false);
        this.firstGraph.getParent().setStyle("-fx-background-color: black;");
        this.changingValuesAnimation.stopAnimation();
        this.ecgData.clear();
        this.ecgData = null;
        this.removeGraph(1);
        this.removeGraph(2);
        this.removeGraph(3);
        this.vitalFunctions.forEach(simpleVitalFunction -> simpleVitalFunction.clear());
        this.vitalFunctions.clear();
        this.vitalFunctions = null;
        this.vitalData = null;
        ValuesAboutStateOfAplication.clear();
    }

    public void defibStart(ActionEvent e) {
        Button b = (Button)e.getSource();
        if (b.getText().equals(LoadFXMLWithResourceBundle.getLangResource().getString("monitor.userPanel.aed")) && this.powerOn.isVisible()) {
            this.startPoweringOnAnimation(0.4, true);
            return;
        }
        if (this.powerOn.isVisible()) {
            return;
        }
        if (this.NIBPGridPane.isVisible() && !this.NIBPhandler.isNIBPRunning()) {
            this.hidePressure();
        }
        this.defibrilatorHandle.defibStart(b.getText(), this.manualSetting, this.AEDfunction);
    }

    public void setPowerValue(ActionEvent e) {
        this.defibrilatorHandle.setActivePowerButton((Button)e.getSource(), this.energy50, this.energy100, this.energy150, this.energy200);
    }

    public void changeElectrods() {
        this.defibrilatorHandle.changeElectrods();
    }

    public void runAnalyza() {
        if (this.vitalData != null && this.defibrilator.isVisible()) {
            this.defibrilatorHandle.runAnalyza(this.vitalData.getSuccessOfAnalyse());
        }
    }

    public void reloadDefibrilator() {
        if (this.manualSetting.isVisible()) {
            this.defibrilatorHandle.reloadDefibrilator(true);
        }
    }

    @FXML
    public void setMetronom() {
        if (this.isMetronomOn) {
            this.isMetronomOn = false;
            this.metronomButton.setStyle("");
            this.metronomLabel.setText(LoadFXMLWithResourceBundle.getLangResource().getString("monitor.metronom.off"));
        } else {
            this.isMetronomOn = true;
            this.metronomButton.setStyle("-fx-background-color:white; -fx-text-fill:black;");
            this.metronomLabel.setText(LoadFXMLWithResourceBundle.getLangResource().getString("monitor.metronom.on"));
        }
    }

    public void setSoundButtonDefibrilator() {
        this.soundDefibrilator.setOnAction(event -> {
            if (this.defibrilatorHandle.isActiveSound()) {
                this.defibrilatorHandle.setActiveSounds(false);
                this.soundDefibrilator.setStyle("-fx-background-color:white; -fx-text-fill:black;");
                this.soundDefibrilator.setText(LoadFXMLWithResourceBundle.getLangResource().getString("monitor.global.sound"));
            } else {
                this.defibrilatorHandle.setActiveSounds(true);
                this.soundDefibrilator.setStyle("");
                this.soundDefibrilator.setText(LoadFXMLWithResourceBundle.getLangResource().getString("monitor.defibrilator.mute"));
            }
        });
        if (SettingsValues.DEFIBRILATORSound) {
            this.soundDefibrilator.fire();
        }
    }

    public void setElectrodsCheckboxes() {
        this.connectTherapyElectrods.setDisable(true);
        this.connectEcgElectrods.selectedProperty().addListener((observable, oldValue, newValue) -> {
            this.connectTherapyElectrods.setDisable(!this.connectEcgElectrods.isSelected());
            this.connectTherapyElectrods.setSelected(false);
        });
        this.connectEcgElectrods.setOnAction(event -> this.defibrilatorHandle.setElectrods(this.connectEcgElectrods.isSelected(), this.connectTherapyElectrods.isSelected()));
        this.connectTherapyElectrods.setOnAction(event -> this.defibrilatorHandle.setElectrods(this.connectEcgElectrods.isSelected(), this.connectTherapyElectrods.isSelected()));
    }

    public void startShock() {
        this.defibrilatorHandle.startShock();
        if (this.vitalData != null && this.vitalData.getResurectionEcg() != null) {
            this.ecgData.sendCurve(Controller.setEcgData(this.vitalData.getResurectionEcg()));
            this.vitalFunctions.get(this.hearthRateIndex).setActualValue(80.0);
            this.vitalFunctions.get(this.PPIndex).setActualValue(35.0);
            this.vitalFunctions.get(this.CO2Index).setActualValue(58.0);
            this.vitalFunctions.get(this.SpO2Index).setActualValue(32.0);
            this.newValues.set(this.hearthRateIndex, 80.0);
            this.newValues.set(this.PPIndex, 72.0);
            this.newValues.set(this.CO2Index, 42.0);
            this.newValues.set(this.SpO2Index, 85.0);
        }
    }

    public void hideDefibrilator() {
        ValuesAboutStateOfAplication.isDefibrilatorManualOn = false;
        ValuesAboutStateOfAplication.isDefibrilatorAEDOn = false;
        this.defibrilatorHandle.hideDefibrilator();
    }

    public void showPressure() {
        ValuesAboutStateOfAplication.isNIBPON = true;
        this.NIBPhandler.showPressure();
    }

    public void hidePressure() {
        ValuesAboutStateOfAplication.isNIBPON = false;
        this.NIBPhandler.hidePressure();
    }

    public void runPressure() {
        if (this.vitalData != null) {
            this.NIBPhandler.runPressure(this.vitalData.getSysPressure(), this.vitalData.getDiaPressure());
        }
    }

    public void setNIBPmode() {
        this.NIBPhandler.setMode();
    }

    public void showOverview() {
        if (this.NIBPOverview.isVisible()) {
            this.NIBPOverview.setVisible(false);
            this.overViewButton.setStyle("");
        } else {
            this.NIBPOverview.setVisible(true);
            this.NIBPhandler.showOverview();
            this.overViewButton.setStyle("-fx-background-color:white; -fx-text-fill:black;");
        }
    }

    public void setSoundNIBPButton() {
        this.soundNIBP.setOnAction(event -> {
            if (this.NIBPhandler.getVolumeActive()) {
                this.NIBPhandler.setVolume(0);
                this.soundNIBP.setText(LoadFXMLWithResourceBundle.getLangResource().getString("monitor.global.sound"));
                this.soundNIBP.setStyle("-fx-background-color:white; -fx-text-fill:black;");
            } else {
                this.NIBPhandler.setVolume(5);
                this.soundNIBP.setText(LoadFXMLWithResourceBundle.getLangResource().getString("monitor.nibp.mute"));
                this.soundNIBP.setStyle("");
            }
        });
        if (SettingsValues.NIBPSound) {
            this.soundNIBP.fire();
        }
    }

    private void startPoweringOnAnimation(double time, boolean isDefibrilator) {
        this.poweringOnProgress.setVisible(true);
        this.powerinOnLabel.setVisible(true);
        if (ValuesAboutStateOfAplication.isMonitorTurnON) {
            this.setVisibilityAllComponents(true);
            return;
        }
        if (this.poweringOnAnimation == null) {
            this.poweringOnProgress.setProgress(ValuesAboutStateOfAplication.valuesLoadingMonitor);
            this.poweringOnAnimation = new Timeline(new KeyFrame[]{new KeyFrame(Duration.seconds((double)time), e -> this.poweringOnAnimation(isDefibrilator), new KeyValue[0])});
            this.poweringOnAnimation.setCycleCount(-1);
            this.poweringOnAnimation.playFromStart();
        }
    }

    private void poweringOnAnimation(boolean isDefibrilator) {
        this.poweringOnProgress.setProgress(this.poweringOnProgress.getProgress() + 0.05);
        ValuesAboutStateOfAplication.valuesLoadingMonitor = this.poweringOnProgress.getProgress();
        if (this.poweringOnProgress.getProgress() >= 1.0) {
            this.poweringOnAnimation.stop();
            this.poweringOnAnimation = null;
            this.poweringOnProgress.setVisible(false);
            this.powerinOnLabel.setVisible(false);
            this.poweringOnProgress.setProgress(0.0);
            this.setVisibilityAllComponents(true);
            ValuesAboutStateOfAplication.isMonitorTurnON = true;
            if (isDefibrilator) {
                this.defibrilatorHandle.defibStart(LoadFXMLWithResourceBundle.getLangResource().getString("monitor.userPanel.aed"), this.manualSetting, this.AEDfunction);
            }
        }
    }

    public void showAppComponents() {
        this.startPoweringOnAnimation(0.6, false);
    }

    private void setVisibilityAllComponents(boolean visibility) {
        if (visibility) {
            this.setECGData();
            this.firstGraph.getParent().setStyle("-fx-background-color:whitesmoke");
            this.setupVitalFunctionsPanels();
            this.setBindingFromVitalFunctionsToGraph();
        }
        this.firstGraph.setVisible(visibility);
        this.secondGraph.setVisible(visibility);
        this.thirdGraph.setVisible(visibility);
        this.fourthGraph.setVisible(visibility);
        this.fifthGraph.setVisible(visibility);
        this.valuesFromRemoter.setVisible(visibility);
        this.NIBPGridPane.setVisible(false);
        this.defibrilator.setVisible(false);
        this.pauseAplication.setDisable(!visibility);
        this.resumeAplication.setDisable(true);
        this.shutDownMonitor.setDisable(!visibility);
        this.graph1.setDisable(!visibility);
        this.graph2.setDisable(!visibility);
        this.powerOn.setVisible(!visibility);
        this.NIBPButton.setVisible(visibility);
    }

    private void setupVitalFunctionsPanels() {
        if (this.vitalFunctions == null) {
            this.vitalFunctions = new ArrayList();
            this.vitalFunctions.add(new SimpleVitalFunction("HR", "l/min", SettingsValues.HRmin, SettingsValues.HRmax, SettingsValues.getColorToVitalFunctionByIndex(0), 1, 300));
            this.hearthRateIndex = this.vitalFunctions.size() - 1;
            this.vitalFunctions.add(new SimpleVitalFunction("SPO2", "%", SettingsValues.SPO2min, SettingsValues.SPO2max, SettingsValues.getColorToVitalFunctionByIndex(1), 1, 100));
            this.SpO2Index = this.vitalFunctions.size() - 1;
            this.vitalFunctions.add(new SimpleVitalFunction("PP", "l/min", SettingsValues.PPmin, SettingsValues.PPmax, SettingsValues.getColorToVitalFunctionByIndex(2), 1, 300));
            this.PPIndex = this.vitalFunctions.size() - 1;
            this.vitalFunctions.add(new NIBPVitalFunction("NIBP", "mmHg", SettingsValues.getColorToVitalFunctionByIndex(3)));
            this.NIBPIndex = this.vitalFunctions.size() - 1;
            this.vitalFunctions.add(new SimpleVitalFunction("ETCO2", "mmHg", SettingsValues.ETCO2min, SettingsValues.ETCO2max, SettingsValues.getColorToVitalFunctionByIndex(4), 1, 60));
            this.CO2Index = this.vitalFunctions.size() - 1;
            this.vitalFunctions.add(new TempVitalFunction("TEMP", "\u00b0C", SettingsValues.TEMPmin, SettingsValues.TEMPmax, SettingsValues.getColorToVitalFunctionByIndex(5), 15, 45));
            this.TempIndex = this.vitalFunctions.size() - 1;
            for (int i = 0; i < this.vitalFunctions.size(); ++i) {
                this.valuesFromRemoter.add((Node)this.vitalFunctions.get(i).getPanel(), i, 0);
            }
            this.NIBPhandler.setNibpVitalFunction((NIBPVitalFunction)this.vitalFunctions.get(this.NIBPIndex));
            this.settings.setVitalFunctions(this.vitalFunctions);
            ValuesAboutStateOfAplication.vitalFunctions = this.vitalFunctions;
        }
    }

    private void setBindingFromVitalFunctionsToGraph() {
        this.vitalFunctions.get(this.hearthRateIndex).getActualValueProperty().addListener((observable, oldValue, newValue) -> {
            if (!this.vitalFunctions.get(this.hearthRateIndex).getChangeComplete()) {
                this.ecgData.setHR(newValue.intValue());
            }
        });
        this.vitalFunctions.get(this.CO2Index).getActualValueProperty().addListener((observable, oldValue, newValue) -> {
            if (!this.vitalFunctions.get(this.CO2Index).getChangeComplete()) {
                this.ecgData.getGraphCO2().setCO2(newValue.intValue());
            }
        });
    }

    public void setData(VitalData vd) {
        if (this.ecgData == null) {
            return;
        }
        Timeline load = new Timeline(new KeyFrame[]{new KeyFrame(Duration.seconds((double)0.1), event -> {
            if (vd.isFibrilation()) {
                this.ecgData.setHR(vd.getHeartRate());
                this.vitalFunctions.get(this.hearthRateIndex).setActualValue(vd.getHeartRate());
                this.ecgData.sendCurve(Controller.setEcgData(vd.getEcg()));
            } else {
                this.handleECGCurveData(vd.getAsystolia(), vd.getEcg());
                this.handleDataForGraphAfterReceive(vd.getHeartRate(), vd.getCO2());
            }
            this.defibrilatorHandle.setImpedanceFromRemoter(vd.getImpedance(), this.lowImpedanceButton, this.mediumImpedanceButton, this.highImpedanceButton);
            this.setElectrodes(vd);
            this.vitalData = vd;
            this.changingValuesAnimation.changeValues(this.vitalFunctions, this.createListWithNewValuesFromVitalData(this.vitalData));
            ValuesAboutStateOfAplication.changingValuesAnimation = this.changingValuesAnimation;
            ValuesAboutStateOfAplication.actualVitalData = this.vitalData;
        }, new KeyValue[0])});
        load.setCycleCount(1);
        load.play();
    }

    private void setElectrodes(VitalData vd) {
        if (!vd.getElectrodesWasChange()) {
            return;
        }
        if (this.connectEcgElectrods.isSelected() != vd.getConnectECG() || this.connectTherapyElectrods.isSelected() != vd.getConnectTerapy()) {
            this.connectEcgElectrods.setSelected(vd.getConnectECG());
            this.connectTherapyElectrods.setSelected(vd.getConnectTerapy());
            this.defibrilatorHandle.setElectrods(vd.getConnectECG(), vd.getConnectTerapy());
        }
    }

    private void handleECGCurveData(boolean asystolia, List<float[][]> ecg) {
        if (!asystolia && ecg == null) {
            return;
        }
        if (this.vitalData != null) {
            if (asystolia && !this.vitalData.getAsystolia()) {
                this.ecgData.plotAsystolie();
                this.ecgData.setHR(1);
                return;
            }
            if (!asystolia && !ecg.equals(this.vitalData.getEcg())) {
                this.ecgData.sendCurve(Controller.setEcgData(ecg));
            }
        } else if (asystolia) {
            this.ecgData.setHR(1);
            this.ecgData.plotAsystolie();
        } else {
            this.ecgData.sendCurve(Controller.setEcgData(ecg));
        }
    }

    private void handleDataForGraphAfterReceive(int hearthRate, int ETCO2) {
        int minimumBorderForShutdown = 0;
        if (hearthRate < minimumBorderForShutdown) {
            this.ecgData.setHR(1);
            this.ecgData.notConnected();
        }
    }

    public static ObservableList<ObservableList<ECGPoint>> setEcgData(List<float[][]> data) {
        if (data == null) {
            return null;
        }
        ObservableList ecg = FXCollections.observableArrayList();
        for (float[][] curves : data) {
            ObservableList points = FXCollections.observableArrayList();
            for (float[] item : curves) {
                points.add((Object)new ECGPoint(item[0], item[1], item[2]));
            }
            ecg.add((Object)points);
        }
        return ecg;
    }

    private void setECGData() {
        if (this.ecgData == null) {
            this.ecgData = new ECGData();
            this.addFirstGraph("ECG1", this.ecgData.getGraphECG1());
            this.createNormalGraphPane(this.secondGraph, "CO2", (Chart)this.ecgData.getGraphCO2());
        }
    }

    private ArrayList createListWithNewValuesFromVitalData(VitalData vd) {
        if (this.newValues == null) {
            this.newValues = new ArrayList();
        }
        this.newValues.add(this.hearthRateIndex, Double.valueOf(vd.getHeartRate()));
        this.newValues.add(this.SpO2Index, Double.valueOf(vd.getSpO2()));
        this.newValues.add(this.PPIndex, Double.valueOf(vd.getPP()));
        this.newValues.add(this.NIBPIndex, 0.0);
        this.newValues.add(this.CO2Index, Double.valueOf(vd.getCO2()));
        this.newValues.add(this.TempIndex, Double.parseDouble(vd.getTemperature()));
        return this.newValues;
    }

    public void clear() {
        this.defibrilatorHandle.clear();
        this.NIBPhandler.clear();
        this.changingValuesAnimation.stopAnimation();
    }
}

