/*
 * Decompiled with CFR 0.152.
 */
package PETER_Communications.com_protocol;

import PETER_Communications.com_protocol.VitalData;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;

public class Server
extends Thread {
    private ServerSocket serverSocket = null;
    private Socket clientSocket = null;
    private int port = 55555;
    private boolean serverExit = false;
    private DatagramSocket dataSocket;
    private Boolean freePort = false;

    public Server() {
        this.start();
    }

    @Override
    public void run() {
        try {
            this.findFreePort();
            String clientIp = this.waitForClient();
            if (clientIp == null) {
                return;
            }
            this.clientSocket = this.serverSocket.accept();
        }
        catch (IOException ex) {
            System.exit(1);
        }
    }

    private void findFreePort() {
        while (!this.freePort.booleanValue()) {
            try {
                this.serverSocket = new ServerSocket(this.port);
                this.freePort = true;
            }
            catch (IOException e) {
                ++this.port;
                if (this.port <= 55560) continue;
                System.exit(1);
            }
        }
    }

    public Boolean sendData(VitalData data) {
        try {
            if (this.clientSocket == null) {
                return false;
            }
            ObjectOutputStream outputStream = new ObjectOutputStream(this.clientSocket.getOutputStream());
            outputStream.writeObject(data);
            if (data != null) {
                return true;
            }
            return false;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public void exitServer() {
        try {
            if (this.clientSocket == null) {
                this.serverSocket.close();
                this.dataSocket.close();
            } else {
                this.sendData(null);
                this.serverSocket.close();
                this.clientSocket.close();
                this.dataSocket.close();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private String waitForClient() {
        try {
            this.dataSocket = new DatagramSocket(this.port, InetAddress.getByName("0.0.0.0"));
            this.dataSocket.setBroadcast(true);
            byte[] recievedData = new byte[1024];
            DatagramPacket receivePacket = new DatagramPacket(recievedData, recievedData.length);
            this.dataSocket.receive(receivePacket);
            String recieveMessage = new String(receivePacket.getData()).trim();
            if ("CONNECTION_VERIFICATION".equals(recieveMessage)) {
                byte[] sendData = "CONNECTION_VERIFICATION".getBytes();
                DatagramPacket sendPacket = new DatagramPacket(sendData, sendData.length, receivePacket.getAddress(), receivePacket.getPort());
                this.dataSocket.send(sendPacket);
                return receivePacket.getAddress().getHostAddress();
            }
        }
        catch (SocketException ex) {
            return null;
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    static {
        System.setProperty("log4j.configurationFile", "PETER_Communications/com_protocol/client_configuration.xml");
    }
}

