/*
 * Decompiled with CFR 0.152.
 */
package PETER_Monitor.vital_parser;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.chart.XYChart;

public class ECGParser {
    private ECGParser() {
    }

    public static void removeColumnECG(String sourceName, String destName, int clm) {
        BufferedReader bfr = null;
        BufferedWriter bfw = null;
        String line = "";
        try {
            bfr = new BufferedReader(new FileReader(sourceName));
            bfw = new BufferedWriter(new FileWriter(destName));
            bfw.write(bfr.readLine() + "\n");
            bfw.write(bfr.readLine() + "\n");
            while ((line = bfr.readLine()) != null) {
                String[] split = line.split(",");
                int length = split.length;
                bfw.write(split[0]);
                for (int i = 1; i < length; ++i) {
                    if (i == clm) continue;
                    bfw.write("," + split[i]);
                }
                bfw.write("\n");
            }
            bfr.close();
            bfw.close();
        }
        catch (IOException ex) {
            System.err.println("The file " + sourceName + " cannot be loaded!");
        }
    }

    public static void transformData(String sourceName, String destName, float x1, float x2) {
        BufferedReader bfr = null;
        BufferedWriter bfw = null;
        String line = "";
        try {
            bfr = new BufferedReader(new FileReader(sourceName));
            bfw = new BufferedWriter(new FileWriter(destName));
            bfw.write(bfr.readLine() + "\n");
            bfw.write(bfr.readLine());
            while ((line = bfr.readLine()) != null) {
                String[] split = line.split(",");
                int length = split.length;
                float x = Float.valueOf(split[0]).floatValue();
                if (!(x >= x1) || !(x <= x2)) continue;
                bfw.write("\n" + (x - x1));
                for (int i = 1; i < length; ++i) {
                    bfw.write("," + split[i]);
                }
            }
            bfr.close();
            bfw.close();
        }
        catch (IOException ex) {
            System.err.println("The file " + sourceName + " cannot be loaded!");
        }
    }

    public static void rewriteData(String sourceName, String destName, float valX) {
        BufferedReader bfr = null;
        BufferedWriter bfw = null;
        int row = 1;
        String line = "";
        try {
            bfr = new BufferedReader(new FileReader(sourceName));
            bfw = new BufferedWriter(new FileWriter(destName));
            bfw.write(bfr.readLine() + "\n");
            bfw.write(bfr.readLine() + "\n");
            row = 2;
            while ((line = bfr.readLine()) != null) {
                ++row;
                String[] split = line.split(",");
                int length = split.length;
                bfw.write(split[0]);
                bfw.write("," + valX + "");
                for (int i = 2; i < length; ++i) {
                    bfw.write("," + split[i]);
                }
                bfw.write("\n");
            }
            bfr.close();
            bfw.close();
        }
        catch (IOException ex) {
            System.err.println("The file " + sourceName + " cannot be loaded!");
        }
    }

    public static void plusXSampleValue(String sourceName, String destName, float valX, int from) {
        BufferedReader bfr = null;
        BufferedWriter bfw = null;
        int row = 1;
        String line = "";
        try {
            bfr = new BufferedReader(new FileReader(sourceName));
            bfw = new BufferedWriter(new FileWriter(destName));
            bfw.write(bfr.readLine() + "\n");
            bfw.write(bfr.readLine() + "\n");
            row = 2;
            while ((line = bfr.readLine()) != null) {
                String[] split = line.split(",");
                int length = split.length;
                if (++row > from) {
                    float inc = Float.valueOf(split[0]).floatValue() + valX;
                    bfw.write(inc + "");
                } else {
                    bfw.write(split[0]);
                }
                for (int i = 1; i < length; ++i) {
                    bfw.write("," + split[i]);
                }
                bfw.write("\n");
            }
            bfr.close();
            bfw.close();
        }
        catch (IOException ex) {
            System.err.println("The file " + sourceName + " cannot be loaded!");
        }
    }

    public static ObservableList<XYChart.Data<Float, Float>> setData(String sourceName) {
        System.out.println("    starting set XY data from - " + sourceName + ".");
        ObservableList data = FXCollections.observableArrayList();
        BufferedReader bfr = null;
        String line = "";
        float x_0 = 0.0f;
        try {
            bfr = new BufferedReader(new FileReader(sourceName));
            String[] info = bfr.readLine().split(",");
            bfr.readLine();
            line = bfr.readLine();
            x_0 = Float.valueOf(line.split(",")[0]).floatValue();
            data.add((Object)new XYChart.Data((Object)Float.valueOf(line.split(",")[0]), (Object)Float.valueOf(line.split(",")[1])));
            while ((line = bfr.readLine()) != null) {
                data.add((Object)new XYChart.Data((Object)Float.valueOf(line.split(",")[0]), (Object)Float.valueOf(line.split(",")[1])));
            }
            bfr.close();
        }
        catch (IOException ex) {
            System.err.println("The file " + sourceName + " cannot be loaded!");
        }
        System.out.println("    data was succesfully create.");
        return data;
    }
}

