/*
 * Decompiled with CFR 0.152.
 */
package PETER_Monitor.vital_ecg;

import PETER_Monitor.vital_ecg.ECGConst;
import PETER_Monitor.vital_ecg.ECGData;
import PETER_Monitor.vital_ecg.ECGPoint;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public class ECGCalculation {
    private ObservableList<ECGPoint> data;
    private ObservableList<ObservableList<ECGPoint>> dataCurve;
    private Runnable calculation;
    private ScheduledFuture<?> calculationTask;
    private int pos;
    private int max_pos;
    private double HF;
    private double wait;
    private boolean plotCurve = true;
    private boolean plottingData1;
    private int markerInList;
    private float valueX;
    private boolean recalculate;
    private boolean beep;
    private final ScheduledExecutorService executor;
    private final ECGData ecg;

    public ECGCalculation(ScheduledExecutorService scheduledExecutorService, ECGData eCGData) {
        this.ecg = eCGData;
        this.executor = scheduledExecutorService;
        this.initValues();
        this.recalculateValues();
        this.setCalculating();
        eCGData.setWait(this.wait);
    }

    private void initValues() {
        this.HF = 60.0;
        this.pos = 0;
        this.max_pos = 0;
        this.markerInList = 0;
        this.recalculate = false;
        this.plottingData1 = true;
        this.plotCurve = false;
        this.ecg.notConnected();
        this.notConnected();
    }

    public void notConnected() {
        this.plotCurve = false;
    }

    private void setCalculating() {
        this.calculation = () -> {
            if (this.ecg.getCountPoints() < 200) {
                if (this.valueX < 5.0f) {
                    if (this.pos >= this.markerInList && this.recalculate) {
                        this.recalculate = false;
                        this.recalculateValues();
                        this.ecg.changeWait(this.wait);
                        this.pos = 0;
                    }
                    if (this.pos >= this.max_pos || this.pos == 0) {
                        this.pos = 0;
                        this.valueX += ((ECGPoint)this.data.get(this.pos)).getXValue();
                    } else {
                        this.valueX += ((ECGPoint)this.data.get(this.pos)).getXValue() - ((ECGPoint)this.data.get(this.pos - 1)).getXValue();
                        this.beep = ((ECGPoint)this.data.get(this.pos)).getPlay();
                    }
                    this.ecg.sendData(new ECGPoint(this.valueX, ((ECGPoint)this.data.get(this.pos)).getECG1YValue(), ((ECGPoint)this.data.get(this.pos)).getECG2YValue(), this.plottingData1, this.beep));
                    this.ecg.incPoint();
                    ++this.pos;
                } else {
                    this.plottingData1 = !this.plottingData1;
                    this.valueX = 0.0f;
                }
            }
        };
    }

    private double getTotalLengthPause() {
        double d = this.HF / 12.0;
        double d2 = 0.0;
        if (this.dataCurve != null) {
            for (ObservableList observableList : this.dataCurve) {
                double d3 = 5.0 - d * (double)((ECGPoint)observableList.get(observableList.size() - 1)).getXValue();
                d2 += d3 / d;
            }
        }
        return d2;
    }

    private void recalculateValues() {
        double d = this.getTotalLengthPause();
        double d2 = 0.0;
        if (this.plotCurve) {
            this.data = FXCollections.observableArrayList();
            double d3 = this.HF / 12.0;
            double d4 = d3 % (double)((int)d3);
            double d5 = d3 >= 1.0 ? d4 * d : 0.0;
            float f = 0.0f;
            this.max_pos = ((ObservableList)this.dataCurve.get(0)).size() - 1;
            d2 = this.getValueXPause();
            for (ObservableList observableList : this.dataCurve) {
                double d6 = 5.0 - d3 * (double)((ECGPoint)observableList.get(observableList.size() - 1)).getXValue();
                d6 /= d3;
                for (ECGPoint eCGPoint : observableList) {
                    if (eCGPoint.getXValue() < 0.0f) {
                        this.data.add((Object)new ECGPoint(-eCGPoint.getXValue() + f, eCGPoint.getECG1YValue(), eCGPoint.getECG2YValue(), true));
                        continue;
                    }
                    this.data.add((Object)new ECGPoint(eCGPoint.getXValue() + f, eCGPoint.getECG1YValue(), eCGPoint.getECG2YValue()));
                }
                this.setPauseToList(d6, d2);
                f = ((ECGPoint)this.data.get(this.max_pos)).getXValue();
            }
            this.wait = d > 0.0 ? ((double)((ECGPoint)this.data.get(this.max_pos)).getXValue() + Math.abs(d) + d5) / ((double)this.data.size() + d / d2 + d5 / d2) * 1.0E9 : ((double)((ECGPoint)this.data.get(this.max_pos)).getXValue() + d) / (double)this.data.size() * 1.0E9;
        } else {
            this.data = ECGConst.LINE;
            this.max_pos = this.data.size() - 1;
            this.wait = (double)(5.0f / (5.0f / ((ECGPoint)this.data.get(0)).getXValue())) * 1.0E9;
            this.markerInList = 0;
            d2 = ((ECGPoint)this.data.get(0)).getXValue();
        }
    }

    public void setHR(int n) {
        System.out.println("Set new HearthRate value: " + n);
        this.HF = n;
        this.recalculate = true;
    }

    public void setPlotData(boolean bl) {
        this.plotCurve = bl;
    }

    public void setECGData(ObservableList<ObservableList<ECGPoint>> observableList) {
        System.out.println("Settings new ECG DATA!");
        this.dataCurve = observableList;
        System.out.println("    nova krivka predana");
        this.plotCurve = true;
        this.recalculate = true;
    }

    private float getValueXPause() {
        int n;
        float f = 0.0f;
        int n2 = ((ObservableList)this.dataCurve.get(0)).size();
        for (n = 1; n < n2; ++n) {
            f += ((ECGPoint)((ObservableList)this.dataCurve.get(0)).get(n)).getXValue() - ((ECGPoint)((ObservableList)this.dataCurve.get(0)).get(n - 1)).getXValue();
        }
        return f /= (float)n;
    }

    private void setPauseToList(double d, double d2) {
        float f = (float)d2;
        this.max_pos = this.data.size() - 1;
        float f2 = ((ECGPoint)this.data.get(this.max_pos)).getXValue();
        float f3 = ((ECGPoint)this.data.get(0)).getECG1YValue();
        float f4 = ((ECGPoint)this.data.get(0)).getECG2YValue();
        this.markerInList = this.max_pos;
        float f5 = f2 + f;
        while ((double)f5 <= d + (double)f2) {
            this.data.add((Object)new ECGPoint(f5, f3, f4));
            f5 += f;
        }
        this.max_pos = this.data.size() - 1;
    }

    public void clear() {
        this.executor.shutdownNow();
    }

    public ScheduledFuture<?> getCalculation() {
        return this.calculationTask;
    }

    public void setNewCalculation() {
        this.calculationTask = this.executor.scheduleAtFixedRate(this.calculation, 0L, (long)this.wait, TimeUnit.NANOSECONDS);
    }
}

