/*
 * Decompiled with CFR 0.152.
 */
package PETER_Monitor.vital_monitor;

import Language.LoadFXMLWithResourceBundle;
import PETER_Communications.com_protocol.Client;
import PETER_Communications.com_protocol.VitalData;
import PETER_Monitor.vital_monitor.Controller;
import PETER_Monitor.vital_monitor.settings_monitor.LoadSettings;
import javafx.application.Application;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Stage;

public class Main
extends Application {
    private static Client client;
    public static Stage primaryStage;

    public void start(Stage stage) throws Exception {
        LoadSettings.loadSettings(0);
        FXMLLoader fXMLLoader = LoadFXMLWithResourceBundle.loadFXML(((Object)((Object)this)).getClass().getResource("Monitor.fxml"));
        if (fXMLLoader == null) {
            System.out.println("Couldnt load fxml or resource bundle!");
            return;
        }
        Parent parent = (Parent)fXMLLoader.load();
        stage.setTitle("PETER-MONITOR");
        stage.setScene(new Scene(parent, 1080.0, 720.0));
        stage.getScene().getStylesheets().add((Object)((Object)((Object)this)).getClass().getResource("monitorCSS.css").toExternalForm());
        stage.setMinHeight(720.0);
        stage.setMinWidth(1000.0);
        stage.show();
        Controller controller = (Controller)fXMLLoader.getController();
        client = new Client();
        client.start();
        Main.recivingData(controller);
        stage.setOnCloseRequest(windowEvent -> {
            client.closeClient();
            if (controller.getECGData() != null) {
                controller.getECGData().clear();
                controller.clear();
            }
        });
        primaryStage = stage;
    }

    public static void recivingData(final Controller controller) {
        Thread thread = new Thread(new Runnable(){
            VitalData recieveData;

            @Override
            public void run() {
                while (!client.isClientClosed()) {
                    if (client.isServerClosed()) {
                        Main.client = new Client();
                        client.start();
                    }
                    this.recieveData = client.waitForData();
                    if (this.recieveData == null) continue;
                    controller.setData(this.recieveData);
                }
            }
        });
        thread.start();
    }

    public static void main(String[] stringArray) {
        Main.launch((String[])stringArray);
    }

    public static Client getClient() {
        return client;
    }
}

