/*
 * Decompiled with CFR 0.152.
 */
package PETER_Monitor.vital_monitor;

import Language.LoadFXMLWithResourceBundle;
import PETER_Monitor.vital_values.NIBPVitalFunction;
import java.time.LocalTime;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.layout.GridPane;
import javafx.scene.media.AudioClip;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.util.Duration;

public class NIBPHandler {
    private ProgressBar NIBPprogress;
    private Timeline pressureTL;
    private Label mode;
    private Label valueOfMode;
    private Label pressure;
    private Label pressure2;
    private Label NIBPtime;
    private Button start;
    private Button changeMode;
    private Button closeNIBP;
    private GridPane NIBPGridPane;
    private GridPane NIBPOverview;
    private int activeMode;
    private int sysPressure;
    private int diaPressure;
    private int actualMeasurement;
    private int runCount;
    private final String[][] mods;
    private String[][] measurement;
    private boolean NIBPmax;
    private AudioClip clip;
    private double maxValue;
    private NIBPVitalFunction nibpVitalFunction;
    private boolean isSoundActive;
    private int volume;

    public NIBPHandler(ProgressBar progressBar, Label label, Label label2, Label label3, Label label4, Button button, Button button2, GridPane gridPane, Label label5, GridPane gridPane2, Button button3) {
        this.NIBPprogress = progressBar;
        this.mode = label;
        this.valueOfMode = label2;
        this.pressure = label3;
        this.pressure2 = label4;
        this.start = button;
        this.changeMode = button2;
        this.NIBPGridPane = gridPane;
        this.NIBPtime = label5;
        this.NIBPOverview = gridPane2;
        this.closeNIBP = button3;
        this.activeMode = 0;
        this.actualMeasurement = 0;
        this.measurement = new String[5][3];
        this.mods = new String[3][2];
        this.setMeasurement();
        this.setMods();
        this.NIBPmax = false;
        this.clip = new AudioClip(this.getClass().getResource("/PETER_Monitor/vital_monitor/sounds_monitor/nibp_sound.wav").toExternalForm());
        this.isSoundActive = false;
        this.volume = 5;
    }

    public void setNibpVitalFunction(NIBPVitalFunction nIBPVitalFunction) {
        this.nibpVitalFunction = nIBPVitalFunction;
    }

    public void runPressure(int n, int n2) {
        if (this.pressureTL != null) {
            return;
        }
        this.maxValue = Double.parseDouble(this.mods[this.activeMode][1]) / 300.0;
        this.runCount = 0;
        this.pressureTL = new Timeline(new KeyFrame[]{new KeyFrame(Duration.seconds((double)0.7), actionEvent -> this.setNIBPprogress(), new KeyValue[0])});
        this.pressureTL.setCycleCount(-1);
        this.pressureTL.playFromStart();
        this.setNewPressureLabels();
        this.clip.setVolume((double)this.volume);
        this.clip.play();
        this.closeNIBP.setDisable(true);
        this.sysPressure = n;
        this.diaPressure = n2;
        this.changeMode.setDisable(true);
        this.start.setDisable(true);
        this.NIBPOverview.setVisible(false);
    }

    public boolean isNIBPRunning() {
        return this.pressureTL != null;
    }

    public void setMode() {
        Platform.runLater(() -> {
            ++this.activeMode;
            this.activeMode %= 3;
            this.mode.setText(this.mods[this.activeMode][0]);
            this.valueOfMode.setText(this.mods[this.activeMode][1]);
        });
    }

    public void showOverview() {
        this.NIBPOverview.getChildren().clear();
        for (int i = 0; i < 5; ++i) {
            int n = !this.measurement[i][1].equals(LoadFXMLWithResourceBundle.getLangResource().getString("monitor.nibp.value.small")) ? 32 : 24;
            this.addLabelWithNIBP(n, i, 0);
            this.addLabelWithNIBP(n, i, 1);
            this.addLabelWithNIBP(n, i, 2);
        }
    }

    public void showPressure() {
        this.NIBPGridPane.setVisible(true);
    }

    public void hidePressure() {
        Platform.runLater(() -> {
            if (this.pressureTL != null) {
                this.pressureTL.pause();
                this.NIBPprogress.setProgress(0.0);
                this.changeMode.setDisable(false);
                this.start.setDisable(false);
            }
        });
        this.NIBPGridPane.setVisible(false);
    }

    private void setMeasurement() {
        for (int i = 0; i < 5; ++i) {
            this.measurement[i][0] = LoadFXMLWithResourceBundle.getLangResource().getString("monitor.nibp.value.big");
            this.measurement[i][1] = LoadFXMLWithResourceBundle.getLangResource().getString("monitor.nibp.value.small");
            this.measurement[i][2] = "--:--";
        }
    }

    private void setMods() {
        this.mods[0][0] = LoadFXMLWithResourceBundle.getLangResource().getString("monitor.nibp.mode.adult");
        this.mods[0][1] = "180";
        this.mods[1][0] = LoadFXMLWithResourceBundle.getLangResource().getString("monitor.nibp.mode.child");
        this.mods[1][1] = "120";
        this.mods[2][0] = LoadFXMLWithResourceBundle.getLangResource().getString("monitor.nibp.mode.neonat");
        this.mods[2][1] = "90";
    }

    private void setNIBPLabel() {
        int n = this.sysPressure;
        int n2 = this.diaPressure;
        String string = "" + n + "/" + n2;
        this.pressure.setText(string);
        this.nibpVitalFunction.setDiaAndSysPressure(n2, n);
        int n3 = (2 * n2 + n) / 3;
        String string2 = "(" + n3 + ")";
        this.pressure2.setText(string2);
        this.nibpVitalFunction.setMapPressure(n3);
        String string3 = this.getTime();
        this.NIBPtime.setText(LoadFXMLWithResourceBundle.getLangResource().getString("monitor.nibp.value.last") + string3);
        this.measurement[this.actualMeasurement][0] = string;
        this.measurement[this.actualMeasurement][1] = string2;
        this.measurement[this.actualMeasurement][2] = string3;
        ++this.actualMeasurement;
        this.actualMeasurement %= 5;
    }

    private void waitingInMeassure(int n) {
        if (n % 2 == 0) {
            this.NIBPprogress.setProgress(this.NIBPprogress.getProgress() + 0.02);
        } else {
            this.NIBPprogress.setProgress(this.NIBPprogress.getProgress() - 0.03);
        }
    }

    private String getTime() {
        String string = "";
        int n = LocalTime.now().getHour();
        string = n < 10 ? string + "0" + n + ":" : string + "" + n + ":";
        int n2 = LocalTime.now().getMinute();
        string = n2 < 10 ? string + "0" + n2 : string + "" + n2;
        return string;
    }

    private void setNewPressureLabels() {
        this.pressure.setText(LoadFXMLWithResourceBundle.getLangResource().getString("monitor.nibp.value.big"));
        this.pressure2.setText(LoadFXMLWithResourceBundle.getLangResource().getString("monitor.nibp.value.small"));
    }

    private void setNIBPprogress() {
        if (!this.NIBPmax) {
            this.NIBPprogress.setProgress(this.NIBPprogress.getProgress() + 0.07);
            if (this.maxValue <= this.NIBPprogress.getProgress()) {
                this.NIBPmax = true;
            }
        } else {
            this.decreasingNIBP();
        }
    }

    private void decreasingNIBP() {
        double d = this.NIBPprogress.getProgress();
        if (d < this.maxValue - 0.1 && this.clip.isPlaying()) {
            this.waitingInMeassure(this.runCount++);
            return;
        }
        if ((d -= 0.08) <= 0.0) {
            this.endOfNIBPMeasurrement();
        } else {
            this.NIBPprogress.setProgress(d);
        }
    }

    private void endOfNIBPMeasurrement() {
        this.NIBPmax = false;
        this.pressureTL.stop();
        this.pressureTL = null;
        this.setNIBPLabel();
        this.NIBPprogress.setProgress(0.0);
        this.changeMode.setDisable(false);
        this.start.setDisable(false);
        this.closeNIBP.setDisable(false);
        this.stopPlayingClip();
        if (this.NIBPOverview.isVisible()) {
            this.showOverview();
        }
    }

    private void addLabelWithNIBP(int n, int n2, int n3) {
        Label label = new Label(this.measurement[n2][n3]);
        label.setTextFill((Paint)Color.WHITE);
        label.setFont(new Font((double)n));
        this.NIBPOverview.add((Node)label, n3, n2);
    }

    public void pauseAnimation() {
        if (this.pressureTL != null) {
            this.pressureTL.pause();
        }
    }

    public void resumeAnimation() {
        if (this.pressureTL != null) {
            this.pressureTL.play();
        }
    }

    public void stopPlayingClip() {
        if (this.clip.isPlaying()) {
            this.clip.stop();
        }
    }

    public void setVolume(int n) {
        if (n == 0) {
            this.stopPlayingClip();
        }
        this.volume = n;
    }

    public boolean getVolumeActive() {
        return this.volume > 0;
    }

    public void clear() {
        if (this.pressureTL != null) {
            this.pressureTL.stop();
        }
        this.pressureTL = null;
        this.stopPlayingClip();
    }
}

