/*
 * Decompiled with CFR 0.152.
 */
package PETER_Monitor.vital_monitor;

import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.scene.media.AudioClip;
import javafx.util.Duration;

public class PlaySounds {
    private static final String PATH_TO_SOUNDS = "/PETER_Monitor/vital_monitor/sounds_monitor/";
    public static final String DO_KPR = "do_kpr.wav";
    public static final String CONNECT_ELECTRODS_TERAPY = "connect_electrods_for_terapy.wav";
    public static final String DONT_GIVE_SHOCK = "dont_give_shock.wav";
    public static final String DONT_TOUCH_PACIENT = "dont_touch_pacient.wav";
    public static final String START_ANALYSE_EKG = "start_analyse_ekg.wav";
    public static final String SHOCK_READY = "shock_ready.wav";
    public static final String SHOCK_GIVEN = "shock_given.wav";
    public static final String NIBP_SOUND = "nibp_sound.wav";
    public static final String GIVE_SHOCK = "give_shock.wav";
    public static final String FREE_ELECTRODS_TERAPY = "free_electrods_for_terapy.wav";
    public static final String FREE_EKG_ELECTROD = "free_ekg_electrod.wav";
    private AudioClip clip;
    private AudioClip shockReady1;
    private AudioClip shockReady2;
    private int volume;
    private Timeline shockReadyAnimation;

    public PlaySounds(int n) {
        this.volume = n;
    }

    public void playSound(String string) {
        String string2 = PATH_TO_SOUNDS + string;
        this.stopSound();
        try {
            this.clip = new AudioClip(this.getClass().getResource(string2).toExternalForm());
            this.clip.play((double)this.volume);
        }
        catch (Exception exception) {
            System.out.println("Sound doesnt exist:" + string);
            exception.printStackTrace();
        }
    }

    public void setVolume(int n) {
        this.volume = n;
        this.stopSound();
    }

    public void stopSound() {
        if (this.clip != null) {
            this.clip.stop();
            this.clip = null;
        }
        this.stopShockReadyAnimation();
    }

    public void startShockReadyAnimation() {
        if (this.shockReadyAnimation == null) {
            this.shockReadyAnimation = new Timeline(new KeyFrame[]{new KeyFrame(Duration.seconds((double)1.4), actionEvent -> this.playShockReady(), new KeyValue[0])});
            this.shockReadyAnimation.setCycleCount(-1);
            this.shockReadyAnimation.play();
        }
    }

    private void playShockReady() {
        try {
            String string = "/PETER_Monitor/vital_monitor/sounds_monitor/shock_ready.wav";
            if (this.shockReady1 == null || !this.shockReady1.isPlaying()) {
                this.shockReady1 = new AudioClip(this.getClass().getResource(string).toExternalForm());
                this.shockReady1.play((double)this.volume);
                return;
            }
            if (this.shockReady2 == null || this.shockReady1.isPlaying()) {
                this.shockReady2 = new AudioClip(this.getClass().getResource(string).toExternalForm());
                this.shockReady2.play((double)this.volume);
                return;
            }
        }
        catch (Exception exception) {
            System.out.println("Sound doesnt exist");
            exception.printStackTrace();
        }
    }

    public void stopShockReadyAnimation() {
        if (this.shockReadyAnimation != null) {
            if (this.shockReady1 != null) {
                this.shockReady1.stop();
            }
            if (this.shockReady2 != null) {
                this.shockReady2.stop();
            }
            this.shockReadyAnimation.stop();
            this.shockReadyAnimation = null;
        }
    }
}

