/*
 * Decompiled with CFR 0.152.
 */
package PETER_Remoter.remoter_GUI;

import Language.LoadFXMLWithResourceBundle;
import PETER_Communications.com_protocol.Server;
import PETER_Communications.com_protocol.ServerConnectionException;
import PETER_Remoter.remoter_GUI.Controller;
import javafx.application.Application;
import javafx.concurrent.Task;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Stage;

public class Main
extends Application {
    private static Server server;

    public void start(Stage stage) throws Exception {
        FXMLLoader fXMLLoader = LoadFXMLWithResourceBundle.loadFXML(((Object)((Object)this)).getClass().getResource("remote.fxml"));
        if (fXMLLoader == null) {
            System.out.println("Couldnt load fxml or resource bundle!");
            return;
        }
        Parent parent = (Parent)fXMLLoader.load();
        Controller controller = (Controller)fXMLLoader.getController();
        stage.setTitle("PETER-VYSILAC");
        stage.setScene(new Scene(parent, 800.0, 640.0));
        stage.getScene().getStylesheets().add((Object)"PETER_Remoter/remoter_GUI/remoterCSS.css");
        stage.setMinHeight(640.0);
        stage.setMinWidth(800.0);
        stage.show();
        server = new Server();
        Main.testingConnectionWithReconnect(controller);
        stage.setOnCloseRequest(windowEvent -> server.closeServer());
    }

    public static void testingConnectionWithReconnect(final Controller controller) {
        Task<Void> task = new Task<Void>(){

            public Void call() throws Exception {
                if (!server.isConnectionOpen()) {
                    server.connectToClient();
                }
                boolean bl = false;
                while (!server.isClosedServer()) {
                    try {
                        bl = server.testConnection(bl);
                        controller.setStatusOfConnection(bl);
                    }
                    catch (ServerConnectionException serverConnectionException) {
                        controller.setStatusOfConnection(false);
                        return null;
                    }
                }
                return null;
            }
        };
        Thread thread = new Thread((Runnable)task);
        thread.setDaemon(true);
        thread.start();
    }

    public static void main(String[] stringArray) {
        server = new Server();
        Main.launch((String[])stringArray);
    }

    public static Server getServer() {
        return server;
    }

    public static void startServerAgain() {
        server = new Server();
    }
}

