package data;

import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

/**
 * @author Patrik Patera
 */
public class VitalData implements Serializable {

    private Boolean successOfAnalyse, successOfDefibrillation, connectECG, connectTherapy, changeOnlyDefibrillator;
    private int impedance, time, ecg, resuscitationEcg;

    protected String name;
    public transient IntegerProperty heartRate, spo2, pp, sysPressure, diaPressure, respirationRate, co2;
    protected transient DoubleProperty temperature;

    public VitalData() {
        this(-1, -1, -1, -1, -1, -1,
                -1, -1, -1, -1, false, false,
                -1, false, false, -1);
    }

    public VitalData(int heartRate, int spO2, int pp, int sysPressure, int diaPressure, int respirationRate, double temperature,
                     int co2, int ecg, int time, boolean successOfAnalyse, boolean successOfDefibrillation,
                     int impedance, boolean connectECG, boolean connectTherapy, int resuscitationEcg) {

        this.name = "Socket";
        this.heartRate = new SimpleIntegerProperty(heartRate);
        this.spo2 = new SimpleIntegerProperty(spO2);
        this.pp = new SimpleIntegerProperty(pp);
        this.sysPressure = new SimpleIntegerProperty(sysPressure);
        this.diaPressure = new SimpleIntegerProperty(diaPressure);
        this.respirationRate = new SimpleIntegerProperty(respirationRate);
        this.temperature = new SimpleDoubleProperty(temperature);
        this.co2 = new SimpleIntegerProperty(co2);
        this.ecg = ecg;
        this.time = time;
        this.successOfAnalyse = successOfAnalyse;
        this.successOfDefibrillation = successOfDefibrillation;
        this.impedance = impedance;
        this.connectECG = connectECG;
        this.connectTherapy = connectTherapy;
        this.resuscitationEcg = resuscitationEcg;
        this.changeOnlyDefibrillator = false;
    }

    public void setVitalData(VitalData data) {
        this.heartRate.set(data.getHeartRate());
        this.spo2.set(data.getSpo2());
        this.pp.set(data.getPp());
        this.sysPressure.set(data.getSysPressure());
        this.diaPressure.set(data.getDiaPressure());
        this.respirationRate.set(data.getRespirationRate());
        this.temperature.set(data.getTemperature());
        this.co2.set(data.getCo2());
        this.ecg = data.getEcg();
        this.time = data.getTime();
        this.successOfAnalyse = data.getSuccessOfAnalyse();
        this.successOfDefibrillation = data.getSuccessOfDefibrilation();
        this.impedance = data.getImpedance();
        this.connectECG = data.getConnectECG();
        this.connectTherapy = data.getConnectTerapy();
        this.resuscitationEcg = data.getResuscitationEcg();
        this.changeOnlyDefibrillator = data.isChangeOnlyDefibrillator();
    }

    public boolean isChangeOnlyDefibrillator() {
        return changeOnlyDefibrillator;
    }

    public void setChangeOnlyDefibrillator(boolean changeOnlyDefibrillator) {
        this.changeOnlyDefibrillator = changeOnlyDefibrillator;
    }

    public boolean isSuccessOfAnalyse() {
        return successOfAnalyse;
    }

    public boolean getSuccessOfDefibrillation() {
        return successOfDefibrillation;
    }

    public boolean isConnectECG() {
        return connectECG;
    }

    public boolean getConnectTherapy() {
        return connectTherapy;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getHeartRate() {
        return heartRate.get();
    }

    public IntegerProperty heartRateProperty() {
        return heartRate;
    }

    public void setHeartRate(int heartRate) {
        this.heartRate.set(heartRate);
    }

    public int getSpo2() {
        return spo2.get();
    }

    public IntegerProperty spo2Property() {
        return spo2;
    }

    public void setSpo2(int spo2) {
        this.spo2.set(spo2);
    }

    public int getPp() {
        return pp.get();
    }

    public IntegerProperty ppProperty() {
        return pp;
    }

    public void setPp(int pp) {
        this.pp.set(pp);
    }

    public int getSysPressure() {
        return sysPressure.get();
    }

    public IntegerProperty sysPressureProperty() {
        return sysPressure;
    }

    public void setSysPressure(int sysPressure) {
        this.sysPressure.set(sysPressure);
    }

    public int getDiaPressure() {
        return diaPressure.get();
    }

    public IntegerProperty diaPressureProperty() {
        return diaPressure;
    }

    public void setDiaPressure(int diaPressure) {
        this.diaPressure.set(diaPressure);
    }

    public int getRespirationRate() {
        return respirationRate.get();
    }

    public IntegerProperty respirationRateProperty() {
        return respirationRate;
    }

    public void setRespirationRate(int respirationRate) {
        this.respirationRate.set(respirationRate);
    }

    public int getCo2() {
        return co2.get();
    }

    public IntegerProperty co2Property() {
        return co2;
    }

    public void setCo2(int co2) {
        this.co2.set(co2);
    }

    public double getTemperature() {
        return temperature.get();
    }

    public DoubleProperty temperatureProperty() {
        return temperature;
    }

    public void setTemperature(double temperature) {
        this.temperature.set(temperature);
    }

    public void setSuccessOfAnalyse(Boolean successOfAnalyse) {
        this.successOfAnalyse = successOfAnalyse;
    }

    public void setSuccessOfDefibrillation(Boolean successOfDefibrillation) {
        this.successOfDefibrillation = successOfDefibrillation;
    }

    public void setConnectECG(Boolean connectECG) {
        this.connectECG = connectECG;
    }

    public void setConnectTherapy(Boolean connectTherapy) {
        this.connectTherapy = connectTherapy;
    }


    public void setImpedance(int impedance) {
        this.impedance = impedance;
    }

    public void setTime(int time) {
        this.time = time;
    }

    public void setResuscitationEcg(int resuscitationEcg) {
        this.resuscitationEcg = resuscitationEcg;
    }

    public void setEcg(int ecg) {
        this.ecg = ecg;
    }

    /**
     * cas pro odeslani
     *
     * @return cas
     */
    public int getTime() {
        return time;
    }

    /**
     * list s daty pro vykresleni krivek
     *
     * @return list s daty
     */
    public int getEcg() {
        return ecg;
    }

    public int getResuscitationEcg() {
        return resuscitationEcg;
    }

    /**
     * Impedance
     *
     * @return hodnota impedance
     */
    public int getImpedance() {
        return impedance;
    }

    /**
     * Uspesna analyza
     *
     * @return true pokud byla analyza uspesna
     */
    public boolean getSuccessOfAnalyse() {
        return successOfAnalyse;
    }

    /**
     * Uspesna defibrilace
     *
     * @return true pokud byla defibrilace uspesna
     */
    public boolean getSuccessOfDefibrilation() {
        return successOfDefibrillation;
    }

    /**
     * Pripojeni ecg
     *
     * @return true pokud je ecg pripojene
     */
    public boolean getConnectECG() {
        return connectECG;
    }

    /**
     * Pripojena terapie
     *
     * @return true pokud je pripojena te
     */
    public boolean getConnectTerapy() {
        return connectTherapy;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();

        s.writeInt(heartRate.get());
        s.writeInt(spo2.get());
        s.writeInt(pp.get());
        s.writeInt(sysPressure.get());
        s.writeInt(diaPressure.get());
        s.writeInt(respirationRate.get());
        s.writeInt(co2.get());
        s.writeDouble(temperature.get());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();

        heartRate = new SimpleIntegerProperty(in.readInt());
        spo2 = new SimpleIntegerProperty(in.readInt());
        pp = new SimpleIntegerProperty(in.readInt());
        sysPressure = new SimpleIntegerProperty(in.readInt());
        diaPressure = new SimpleIntegerProperty(in.readInt());
        respirationRate = new SimpleIntegerProperty(in.readInt());
        co2 = new SimpleIntegerProperty(in.readInt());
        temperature = new SimpleDoubleProperty(in.readDouble());
    }


   /* @Override
    public String toString() {
        return heartRate + co2 + " " + diaPressure + " " + pp + " "
                + respirationRate + " " + spo2 + " " + sysPressure + " " + temperature;
    }*/
}
