package gui_components;

import java.util.ResourceBundle;

import language.KeysForLanguage;
import language.LoadFXMLWithResourceBundle;

public class GuiUtils {
	private static final ResourceBundle langResource =  LoadFXMLWithResourceBundle.getLangResource();
	private static final int MIN_PORT_VALUE = 49152;
	private static final int MAX_PORT_VALUE = 65535;
	
	public static boolean checkPort(String portStr) {
		boolean result = true;
		if(portStr == null || portStr.isEmpty()) {
			result = false;
		}
		try	{
		    int port =Integer.parseInt(portStr); 
		    if(port < MIN_PORT_VALUE || port > MAX_PORT_VALUE) {
		    	result = false;
		    }
		} catch (NumberFormatException e){
			result = false;
		}
		if(!result) {
			Alerts.warningAlert(langResource.getString(KeysForLanguage.COMMON_ALERT_CONF_ERROR), langResource.getString(KeysForLanguage.COMMON_ALERT_EMPTY_PORT), langResource.getString(KeysForLanguage.COMMON_ALERT_EMPTY_PORT_SET)+MIN_PORT_VALUE+"-"+MAX_PORT_VALUE);
		}
		return result;
	}
	
	public static boolean checkMonitorName(String monintorName) {
		boolean result = true;
		if(monintorName == null || monintorName.isEmpty()) {
			result = false;
		}
		
		if(!result) {
			Alerts.warningAlert(langResource.getString(KeysForLanguage.COMMON_ALERT_CONF_ERROR), langResource.getString(KeysForLanguage.COMMON_ALERT_EMPTY_MONITOR_), langResource.getString(KeysForLanguage.COMMON_ALERT_EMPTY_MONITOR_SET));
		}
		return result;
	}
	
	public static boolean checkIpAddress(String ipAddress) {
		boolean result = true;
		if(ipAddress == null || ipAddress.isEmpty()) {
			result = false;
		}
		
		if(!result) {
			Alerts.warningAlert(langResource.getString(KeysForLanguage.COMMON_ALERT_CONF_ERROR), langResource.getString(KeysForLanguage.COMMON_ALERT_EMPTY_IP), langResource.getString(KeysForLanguage.COMMON_ALERT_EMPTY_IP_SET));
		}
		return result;
	}
	
	
}
