package gui_components;

import java.util.ResourceBundle;

import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.geometry.Orientation;
import javafx.scene.control.*;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.RowConstraints;
import javafx.scene.layout.VBox;
import language.KeysForLanguage;
import language.LoadFXMLWithResourceBundle;

/**
 * Created by BobrZlosyn on 7. 7. 2016.
 */
public class Settings {
	private final ResourceBundle langResource =  LoadFXMLWithResourceBundle.getLangResource();
    private GridPane pane, activeContent;
    private ListView<IPaneSetting> menuList;
    private Button applyButton;

    public void initPanels(ObservableList list) {
        menuList = new ListView<>(list);
    }

    public void showSettings() {
        ButtonType apply = new ButtonType(langResource.getString(KeysForLanguage.COMMON_SETTING_SAVE), ButtonType.APPLY.getButtonData());
        ButtonType ok = new ButtonType(langResource.getString(KeysForLanguage.COMMON_SETTING_OK), ButtonType.OK.getButtonData());
        ButtonType cancel = new ButtonType(langResource.getString(KeysForLanguage.COMMON_SETTING_CANCEL), ButtonType.CANCEL.getButtonData());

        Alert options = new Alert(Alert.AlertType.CONFIRMATION);
        options.getButtonTypes().set(0, ok);
        options.getButtonTypes().set(1, apply);
        options.getButtonTypes().add(2, cancel);
        options.setTitle(langResource.getString(KeysForLanguage.COMMON_SETTING_SETTING));
        options.setHeaderText(" ");

        DialogPane dialogPane = options.getDialogPane();
        dialogPane.getStylesheets().add(getClass().getResource("./settingsCSS.css").toExternalForm());

        applyButton = (Button) options.getDialogPane().lookupButton(apply);
        applyButton.addEventFilter(ActionEvent.ACTION, event -> {
            menuList.getSelectionModel().getSelectedItem().saveChanges();
            event.consume();
        });

        options.setGraphic(createSettingPanel());
        menuList.getSelectionModel().select(0);

        Button okButton = (Button) options.getDialogPane().lookupButton(ok);
        okButton.addEventFilter(ActionEvent.ACTION, event -> {
            if (!applyButton.isDisable()) {
                menuList.getSelectionModel().getSelectedItem().saveChanges();
            }
        });

        options.showAndWait();
    }

    private GridPane createSettingPanel() {
        pane = new GridPane();
        ColumnConstraints menu = new ColumnConstraints(100, 100, 100);
        ColumnConstraints content = new ColumnConstraints(400, 450, 450);
        pane.getColumnConstraints().addAll(menu, content);
        RowConstraints row = new RowConstraints(300, 300, 300);
        Separator separator = new Separator(Orientation.VERTICAL);

        pane.getRowConstraints().addAll(row);
        pane.add(createMenuPanel(), 0, 0);
        pane.add(separator, 1, 0);
        return pane;
    }

    private VBox createMenuPanel() {
        VBox menu = new VBox();
      //  menuList = new ListView<>(FXCollections.observableArrayList(boundariesPanel, generalPanel, soundPanel));
        menuList.setMinHeight(100);
        menuList.setMaxHeight(100);
        menuList.getStyleClass().add("settings");

        menuList.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> {
            if (oldValue != null && oldValue.equals(newValue)) {
                return;
            }

            pane.getChildren().remove(activeContent);
            activeContent = newValue.getContent();
            pane.add(activeContent, 1, 0);
        });

        Label label = new Label(langResource.getString(KeysForLanguage.COMMON_SETTING_SETTING));
        menu.getChildren().addAll(label, menuList);
        return menu;
    }
}
