package vital_ecg;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;

import static java.util.concurrent.TimeUnit.NANOSECONDS;

import javafx.application.Platform;

/**
 * @author Patrik Patera
 * @version 1.00
 */
public class ECGAnimation {

    /**
     * Vlakno urcene pro animaci.
     */
    private Runnable animation;

    /**
     * Planovac pro animaci.
     */
    private ScheduledFuture<?> animateTask;

    /**
     * ECGData
     */
    private final ECGData ecg;

    /**
     * Planovac vlakna.
     */
    private final ScheduledExecutorService executor;

    /**
     * Cekaci doba.
     */
    private double wait;

    /**
     * Pipnuti
     */
    private boolean beepSound;

    /**
     * Provadeni animace.
     */
    private boolean hasAnimation;

    /**
     * Konstruktor pro vytvoreni tridy k animaci krivek.
     *
     * @param executor manager vlaken.
     * @param ecg      prostredni ECGData.
     */
    public ECGAnimation(ScheduledExecutorService executor, ECGData ecg) {
        this.ecg = ecg;
        this.executor = executor;
        this.beepSound = true;
        this.hasAnimation = true;

        setAnimation();
    }

    /**
     * Vlakno, ktere se zabyva vykreslovanim bodu do grafu z urciteho listu.
     */
    private void setAnimation() {
        animation = () -> {
            if (!hasAnimation)  return;
            Platform.runLater(() -> {
                if (!ecg.isListEmpty()) {
                    ECGPoint value = ecg.removePoint();

                    ecg.getGraphECG1().addData(value.getPlotting(), value.getXValue(), value.getECG1YValue());
//                    ecg.getGraphECG2().addData(value.getPlotting(), value.getXValue(), value.getECG2YValue());

                    ecg.decPoint();

                    if (beepSound) {
                        value.beep();
                    }
                }
            });
        };
    }

    /**
     * Vrati referenci na vlakno animace.
     *
     * @return vlakno animace.
     */
    public ScheduledFuture<?> getAnimation() {
        return animateTask;
    }

    /**
     * Zapnuti/vypnuti pipnuti pri animaci.
     *
     * @param beep zda-li ma byt zaply zvuk.
     */
    public void setBeep(boolean beep) {
        this.beepSound = beep;
    }

    /**
     * Nastavi nove vlakno s novou cekaci dobou.
     *
     * @param time nove nastaveni vykreslovani.
     */
    public void setNewAnimation(double time) {
        wait = time;
        animateTask = executor.scheduleAtFixedRate(animation, 0, (long) wait, NANOSECONDS);
    }

    /**
     * Nastaveni provadeni animace - vykreslovani.
     *
     * @param flag priznak pro animaci.
     */
    public void hasAnimation(boolean flag) {
        hasAnimation = flag;
    }
}
