package vital_ecg;

import data.ECGConst;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.chart.Axis;
import javafx.scene.chart.LineChart;
import javafx.scene.chart.XYChart;

/**
 * Trida slouzi pro vykreslovani danych krivek s ruznou tepovou frekvenci.
 *
 * @author Patrik Patera
 * @version 1.00
 */
public class ECGLineChart extends LineChart<Float, Float> {

    /**
     * Vykreslovaci data.
     */
    private final ObservableList<XYChart.Data<Float, Float>> plotData;

    /**
     * Vykreslovaci data.
     */
    private final ObservableList<XYChart.Data<Float, Float>> plotData2;

    /**
     * Vykreslovaci krivka 1.
     */
    private final XYChart.Series<Float, Float> series;

    /**
     * Vzkreslovaci krivka 2.
     */
    private final XYChart.Series<Float, Float> series2;

    /**
     * Konstruktor vytvori instanci, ktera dedi od LineChart.
     *
     * @param axis x-ova souradnicova osa.
     * @param axis1 y-ova souradnicova osa.
     */
    public ECGLineChart(Axis<Float> axis, Axis<Float> axis1) {
        super(axis, axis1);

        this.plotData = FXCollections.observableArrayList();
        this.plotData2 = FXCollections.observableArrayList();

        this.series = new XYChart.Series<>(this.plotData);
        this.series2 = new XYChart.Series<>(this.plotData2);

        this.getData().addAll(series, series2);
        this.setAnimated(false);
    }

    /**
     * Pridani bodu pro vykresleni.
     *
     * @param plottingData1 kam se ma bod pridat.
     * @param valueX hodnota x-ove souradnice.
     * @param valueY hodnota y-ove souradnice.
     */
    public void addData(boolean plottingData1, float valueX, float valueY) {
        if (plottingData1) {
            plotData.add(new XYChart.Data<>(valueX, valueY));
            removePoint(valueX, plotData2);
        } else {
            plotData2.add(new XYChart.Data<>(valueX, valueY));
            removePoint(valueX, plotData);
        }
    }

    /**
     * Odstranovani bodu ze seznamu vykreslovani.
     *
     * @param list z jakeho listu odebirat.
     */
    private void removePoint(float valX, ObservableList<XYChart.Data<Float, Float>> list) {
        while (list.size() > 0 && Math.abs(valX - list.get(0).getXValue()) < ECGConst.REMOVE_LENGTH) {
            list.remove(0);
        }
    }

    /**
     * Nastaveni typu krivky - teckova nebo plna.
     *
     * @param dotted jestli se ma vykreslovat teckovana cara.
     */
    public void setTypeCurve(boolean dotted) {
        String line = dotted ? "3.0 3.0" : "NULL";

        series.nodeProperty().get().setStyle("-fx-stroke-dash-array: " + line + ";");
        series2.nodeProperty().get().setStyle("-fx-stroke-dash-array: " + line + ";");
    }

}
