package vital_ecg;

import data.ECGConst;

/**
 * Prepravka zajistujici hodnoty bodu pro krivky.
 *
 * @author Patrik Patera
 * @version 1.00
 */
public class ECGPoint {

    /**
     * Hodnota X-ove souradnice grafu.
     */
    private float XValue;

    /**
     * Hodnota Y-ove souradnice pro ECG1 graf.
     */
    private final float ECG1YValue;

    /**
     * Hodnota Y-ove souradnice pro ECG2 graf.
     */
    private final float ECG2YValue;

    /**
     * Priznak, jestli se ma vykreslovat do data1 - true nebo data2 - false.
     */
    private final boolean plottingData1;

    /**
     * Priznak, jestli se ma prehrat pipnuti.
     */
    private final boolean play;

    /**
     * Konstruktor vytvori bod s X hodnotou a Y hodnotama, kam se vykreslovat a
     * jestli se ma prehrat pipnuti.
     *
     * @param XValue X-ova souradnice.
     * @param ECG1YValue Y-ova souradnice pro ECG1.
     * @param ECG2YValue Y-ova souradnice pro ECG2.
     * @param plottingData1 priznak, kam se vykreslovat.
     * @param play priznak pro pipnuti.
     */
    public ECGPoint(float XValue, float ECG1YValue, float ECG2YValue, boolean plottingData1,
            boolean play) {

        this.XValue = XValue;
        this.ECG1YValue = ECG1YValue;
        this.ECG2YValue = ECG2YValue;
        this.plottingData1 = plottingData1;
        this.play = play;

    }

    /**
     * Konstruktor vytvori bod s X hodnotou a Y hodnotama, kam se vykreslovat a
     * jestli se ma prehrat pipnuti.
     *
     * @param XValue X-ova souradnice.
     * @param ECG1YValue Y-ova souradnice pro ECG1.
     * @param ECG2YValue Y-ova souradnice pro ECG2.
     * @param play priznak pro pipnuti.
     */
    public ECGPoint(float XValue, float ECG1YValue, float ECG2YValue, boolean play) {
        this(XValue, ECG1YValue, ECG2YValue, false, play);
    }

    /**
     * Konstruktor vytvori bod s X hodnotou a Y hodnotama, kam se vykreslovat a
     * jestli se ma prehrat pipnuti.
     *
     * @param XValue X-ova souradnice.
     * @param ECG1YValue Y-ova souradnice pro ECG1.
     * @param ECG2YValue Y-ova souradnice pro ECG2.
     */
    public ECGPoint(float XValue, float ECG1YValue, float ECG2YValue) {
        this(XValue, ECG1YValue, ECG2YValue, false, false);
    }

    public void beep() {
        if (play) {
            ECGConst.BEEP.play();
        }
    }

    /**
     * Jestli se ma prehrat zvuk.
     *
     * @return true - pipnuti, false - nepipnuti.
     */
    public boolean getPlay() {
        return this.play;
    }

    /**
     * Znaci, do jakych dat se bude vykreslovat.
     *
     * @return jestli vykreslovat do data1 - true nebo data2 - false.
     */
    public boolean getPlotting() {
        return this.plottingData1;
    }

    /**
     * X-ova hodnota souradnice bodu.
     *
     * @return X-hodnota souradnice bodu.
     */
    public float getXValue() {
        return this.XValue;
    }

    /**
     * Y-ova hodnota souradnice bodu pro ECG1.
     *
     * @return Y-ova hodnota souradnice bodu pro ECG1.
     */
    public float getECG1YValue() {
        return ECG1YValue;
    }

    /**
     * Y-ova hodnota souradnice bodu pro ECG2.
     *
     * @return Y-ova hodnota souradnice bodu pro ECG2.
     */
    public float getECG2YValue() {
        return ECG2YValue;
    }

}
