package vital_monitor;

import javafx.application.Application;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import language.LoadFXMLWithResourceBundle;

public class Main extends Application {

    public static Stage primaryStage;

    @Override
    public void start(Stage primaryStage) throws Exception {
        FXMLLoader fXMLLoader = LoadFXMLWithResourceBundle.loadFXML(getClass().getResource("Monitor.fxml"));

        if(fXMLLoader == null){
            System.out.println("Couldnt load fxml or resource bundle!");
            return;
        }

        Parent root = fXMLLoader.load();
        primaryStage.setTitle("PETER-MONITOR");
        primaryStage.setScene(new Scene(root, 1080, 720));
        primaryStage.getScene().getStylesheets().add(getClass().getResource("monitorCSS.css").toExternalForm());
        primaryStage.setMinHeight(720);
        primaryStage.setMinWidth(1000);
        primaryStage.show();

        Controller controller = fXMLLoader.getController();
        primaryStage.setOnCloseRequest((WindowEvent we) -> {
        	controller.closeMonitor();
        });

        this.primaryStage = primaryStage;
    }

    public static void main(String[] args) {
        launch(args);
    }

}
