package vital_monitor.settings;

import java.util.ResourceBundle;

import gui_components.IPaneSetting;
import javafx.geometry.Insets;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.RowConstraints;
import language.KeysForLanguage;
import language.LoadFXMLWithResourceBundle;


public class CreateSoundPanel implements IPaneSetting {

    private CheckBox defibrilatorSound, nibpSound, ecgSound;
    private Button defibrilatorMute, nibpMute, ecgS;
    private static final ResourceBundle langResource =  LoadFXMLWithResourceBundle.getLangResource();
    public CreateSoundPanel(Button defMute, Button nibpMute,Button ecgSound) {
        this.defibrilatorMute = defMute;
        this.nibpMute = nibpMute;
        this.ecgS = ecgSound;
    }

    public GridPane createSoundSettingsPanel(){
        GridPane pane = new GridPane();
        pane.setPadding(new Insets(15,0,0,25));
        ColumnConstraints name = new ColumnConstraints(200);
        ColumnConstraints setting = new ColumnConstraints(200);
        RowConstraints row1 = new RowConstraints();
        RowConstraints row2 = new RowConstraints();
        RowConstraints row3 = new RowConstraints();
        RowConstraints row4 = new RowConstraints();
        RowConstraints row5 = new RowConstraints();

        pane.getColumnConstraints().addAll(name, setting);
        pane.getRowConstraints().addAll(row1, row2, row3, row4, row5);


        Label defibrilatorL = new Label(langResource.getString(KeysForLanguage.MONITOR_SOUND_OFF_DEF));
        defibrilatorSound = new CheckBox();

        Label nibpL = new Label(langResource.getString(KeysForLanguage.MONITOR_SOUND_OFF_PRESURE));
        nibpSound = new CheckBox();

        Label ecgL = new Label(langResource.getString(KeysForLanguage.MONITOR_SOUND_OFF_ECG));
        ecgSound = new CheckBox();

        Label title = new Label(langResource.getString(KeysForLanguage.MONITOR_SOUND_SETTING));

        defibrilatorSound.setSelected(ValuesAboutStateOfApplication.DEFIBRILATORSound);
        nibpSound.setSelected(ValuesAboutStateOfApplication.NIBPSound);
        ecgSound.setSelected(ValuesAboutStateOfApplication.ECGSound);


        pane.add(title,0,0);
        pane.add(defibrilatorL,0,1);
        pane.add(nibpL,0,2);
        pane.add(ecgL,0,3);
        pane.add(defibrilatorSound,1,1);
        pane.add(nibpSound,1,2);
        pane.add(ecgSound,1,3);

        return  pane;
    }

    private void saveSoundChanges(){
        if(ValuesAboutStateOfApplication.DEFIBRILATORSound != defibrilatorSound.isSelected()){
            defibrilatorMute.fire();
            ValuesAboutStateOfApplication.DEFIBRILATORSound = defibrilatorSound.isSelected();
        }

        if(ValuesAboutStateOfApplication.NIBPSound != nibpSound.isSelected()){
            nibpMute.fire();
            ValuesAboutStateOfApplication.NIBPSound = nibpSound.isSelected();
        }

        if (ValuesAboutStateOfApplication.ECGSound != ecgSound.isSelected()) {
            ecgS.fire();
            ValuesAboutStateOfApplication.ECGSound = ecgSound.isSelected();
        }
    }

    @Override
    public String toString() {
        return langResource.getString(KeysForLanguage.MONITOR_SOUND_SOUNDS);
    }

    @Override
    public void saveChanges() {
        saveSoundChanges();
    }

    @Override
    public GridPane getContent() {
        return createSoundSettingsPanel();
    }
}
