package vital_parser;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.chart.XYChart;

/**
 * Trida slouzi k ziskani potrebnych ECG vln z navzorkovanych dat - a to hlavne
 * T, P vlny a QRS komplexu
 *
 * @author Patrik Patera
 * @version 1.00
 */
public class ECGParser {

    private ECGParser() {

    }

    public static void removeColumnECG(String sourceName, String destName, int clm) {

        BufferedReader bfr = null;
        BufferedWriter bfw = null;

        String line = "";

        try {
            bfr = new BufferedReader(new FileReader(sourceName));
            bfw = new BufferedWriter(new FileWriter(destName));

            bfw.write(bfr.readLine() + "\n");
            bfw.write(bfr.readLine() + "\n");

            while ((line = bfr.readLine()) != null) {
                String[] split = line.split(",");
                int length = split.length;
                bfw.write(split[0]);

                for (int i = 1; i < length; i++) {
                    if (i != clm) {
                        bfw.write("," + split[i]);
                    }
                }
                bfw.write("\n");

            }

            bfr.close();
            bfw.close();
        } catch (IOException ex) {
            System.err.println("The file " + sourceName + " cannot be loaded!");
        }
    }

    public static void transformData(String sourceName, String destName,
            float x1, float x2) {

        BufferedReader bfr = null;
        BufferedWriter bfw = null;

        String line = "";

        try {
            bfr = new BufferedReader(new FileReader(sourceName));
            bfw = new BufferedWriter(new FileWriter(destName));

            bfw.write(bfr.readLine() + "\n");
            bfw.write(bfr.readLine());

            while ((line = bfr.readLine()) != null) {
                String[] split = line.split(",");
                int length = split.length;
                float x = Float.valueOf(split[0]);

                if (x >= x1 && x <= x2) {
                    bfw.write("\n" + (x - x1));
                    for (int i = 1; i < length; i++) {
                        bfw.write("," + split[i]);
                    }
                }
            }

            bfr.close();
            bfw.close();
        } catch (IOException ex) {
            System.err.println("The file " + sourceName + " cannot be loaded!");
        }
    }

    /**
     * 
     *
     * @param sourceName nazev vstupnich vzorku.
     * @param destName cilovy nazev vzorku.
     * @param valX inkrementacni hodnota.
     */
    public static void rewriteData(String sourceName, String destName, float valX) {
        BufferedReader bfr = null;
        BufferedWriter bfw = null;
        int row = 1;

        String line = "";

        try {
            bfr = new BufferedReader(new FileReader(sourceName));
            bfw = new BufferedWriter(new FileWriter(destName));

            bfw.write(bfr.readLine() + "\n");
            bfw.write(bfr.readLine() + "\n");
            row = 2;

            while ((line = bfr.readLine()) != null) {
                row++;
                String[] split = line.split(",");
                int length = split.length;
                bfw.write(split[0]);
                bfw.write("," + valX + "");

                for (int i = 2; i < length; i++) {
                    bfw.write("," + split[i]);
                }

                bfw.write("\n");
            }

            bfr.close();
            bfw.close();
        } catch (IOException ex) {
            System.err.println("The file " + sourceName + " cannot be loaded!");
        }
    }

    /**
     * Pridat od x-ove hodnoty from pro vsechny ostatni hodnotu valX.
     *
     * @param sourceName nazev vstupnich vzorku.
     * @param destName cilovy nazev vzorku.
     * @param valX inkrementacni hodnota.
     * @param from od jake x-ove hodnoty inkrementovat.
     */
    public static void plusXSampleValue(String sourceName, String destName, float valX, int from) {
        BufferedReader bfr = null;
        BufferedWriter bfw = null;
        int row = 1;

        String line = "";

        try {
            bfr = new BufferedReader(new FileReader(sourceName));
            bfw = new BufferedWriter(new FileWriter(destName));

            bfw.write(bfr.readLine() + "\n");
            bfw.write(bfr.readLine() + "\n");
            row = 2;

            while ((line = bfr.readLine()) != null) {
                row++;
                String[] split = line.split(",");
                int length = split.length;
                //bfw.write(split[0]);

                if (row > from) {
                    float inc = Float.valueOf(split[0]) + valX;
                    bfw.write(inc + "");
                } else {
                    bfw.write(split[0]);
                }

                for (int i = 1; i < length; i++) {
                    bfw.write("," + split[i]);
                }

                bfw.write("\n");
            }

            bfr.close();
            bfw.close();
        } catch (IOException ex) {
            System.err.println("The file " + sourceName + " cannot be loaded!");
        }
    }

    /**
     * Vytvoreni bodove rady pro graf.
     *
     * @param sourceName nazev zdrojoveho souboru.
     * @return bodova rada.
     */
    public static ObservableList<XYChart.Data<Float, Float>> setData(String sourceName) {
        System.out.println("    starting set XY data from - " + sourceName + ".");
        ObservableList<XYChart.Data<Float, Float>> data = FXCollections.observableArrayList();

        BufferedReader bfr = null;
        String line = "";
        float x_0 = 0;

        try {
            bfr = new BufferedReader(new FileReader(sourceName));

            /* infomace o prvni radce - nazvy jednotlivych grafu */
            String[] info = bfr.readLine().split(",");

            bfr.readLine();

            line = bfr.readLine();

            /* zjisteni nejmensi hodnoty x-ove souradnice, aby dany komplex 
             zacinal od 0
             */
            x_0 = Float.valueOf(line.split(",")[0]);

            data.add(new XYChart.Data(Float.valueOf(line.split(",")[0]),
                    Float.valueOf(line.split(",")[1])));

            while ((line = bfr.readLine()) != null) {
                data.add(new XYChart.Data(Float.valueOf(line.split(",")[0]),
                        Float.valueOf(line.split(",")[1])));
            }

            bfr.close();
        } catch (IOException ex) {
            System.err.println("The file " + sourceName + " cannot be loaded!");
        }

        System.out.println("    data was succesfully create.");

        return data;
    }

}
