package remoter_GUI;

import javafx.application.Application;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import language.LoadFXMLWithResourceBundle;

public class Main extends Application {


    @Override
    public void init() throws Exception {
        super.init();
    }

    @Override
    public void start(Stage primaryStage) throws Exception {
        FXMLLoader fXMLLoader = LoadFXMLWithResourceBundle.loadFXML(getClass().getResource("remote.fxml"));
        if (fXMLLoader == null) {
            System.out.println("Couldnt load fxml or resource bundle!");
            return;
        }

        Parent root = fXMLLoader.load();
        Controller remoterController = fXMLLoader.getController();
        primaryStage.setTitle("PETER-VYSILAC");
        primaryStage.setScene(new Scene(root, 800, 640));
        primaryStage.getScene().getStylesheets().add("remoter_GUI/remoterCSS.css");
        primaryStage.setMinHeight(640);
        primaryStage.setMinWidth(800);
        primaryStage.show();
        primaryStage.setOnCloseRequest((WindowEvent we) -> {
        	remoterController.closeRemoter();
        	//TODO Uzavirani serveru
            //server.closeServer();
        });

    }


    public static void main(String[] args) {
        // vytvoreni a spusteni serveru
        launch(args);
    }

}
