/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package PETER_Communications.com_protocol;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.Proxy;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.easymock.EasyMock;
import static org.easymock.EasyMock.createMock;
import org.junit.After;
import org.junit.AfterClass;
import static org.junit.Assert.assertEquals;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

/**
 *
 * @author user
 */
public class ClientTest {

    // TODO add test methods here.
    // The methods must be annotated with annotation @Test. For example:
    //
    // @Test
    // public void hello() {}
    private Socket socket;
    private static ServerSocket serverSocket;

    @BeforeClass
    public static void setUpClass() throws Exception {
        serverSocket = new ServerSocket(55555);
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testReadData() {
        ObjectOutputStream oos = null;
        Client client = new Client();
        VitalData vitalData = createMock(VitalData.class);
        EasyMock.replay(vitalData);
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(baos);
            oos.writeObject(vitalData);
            oos.flush();
            oos.close();
            InputStream is = new ByteArrayInputStream(baos.toByteArray());

            assertEquals(vitalData.toString(), client.readData(is).toString());

        } catch (IOException ex) {
            Logger.getLogger(ClientTest.class.getName()).log(Level.SEVERE, null, ex);
        } finally {
            try {
                oos.close();
            } catch (IOException ex) {
                Logger.getLogger(ClientTest.class.getName()).log(Level.SEVERE, null, ex);
            }
        }

    }

    @Test
    public void testRecieveData1() throws IOException {
        Client client = new Client() {
            @Override
            public VitalData readData(InputStream is) {
                return null;
            }
        };
        client.recieveData("0.0.0.0");
        assertEquals(true, client.isCloseServer());
    }

    @Test
    public void testRecieveData2() throws IOException {
        Client client = new Client() {
            @Override
            public boolean clientConnection(String ip) {
                setClientSocket(new Socket(Proxy.NO_PROXY));
                return true;
            }
        };
        client.recieveData("0.0.0.0");
        assertEquals(true, client.isCloseClient());
    }

    @Test
    public void testClientConnection1() throws IOException {
        Client client = new Client();
        assertEquals(true, client.clientConnection("0.0.0.0"));
    }

    @Test
    public void testClientConnection2() throws IOException {
        Client client = new Client();
        assertEquals(false, client.clientConnection("NegativeTest"));
    }

    @Test(expected = SocketTimeoutException.class)
    public void testSendSocketToBroadcasts1() throws SocketException, IOException {

        Client client = new Client();
        byte[] recvBuf = new byte[15000];
        DatagramPacket receivePacket = new DatagramPacket(recvBuf, recvBuf.length);
        DatagramSocket socket = client.sendSocketToBroadcasts();
        socket.setSoTimeout(1000);
        socket.receive(receivePacket);
    }

    @Test
    public void testSendSocketToBroadcasts2() throws SocketException, IOException {
        Client client = new Client();
        byte[] recvBuf = new byte[15000];
        Thread th = new Thread() {
            public void run() {
                try {
                    DatagramSocket dataSocket = new DatagramSocket(55556, InetAddress.getByName("0.0.0.0"));
                    dataSocket.setBroadcast(true);
                    byte[] recievedData = new byte[1024];
                    DatagramPacket receivePacket = new DatagramPacket(recievedData, recievedData.length);
                    dataSocket.receive(receivePacket);
                        byte[] sendData = "DISCOVER_FUIFSERVER_RESPONSE".getBytes();
                        DatagramPacket sendPacket = new DatagramPacket(sendData, sendData.length, receivePacket.getAddress(), receivePacket.getPort());
                        dataSocket.send(sendPacket);
                } catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        };
        th.start();
        DatagramPacket receivePacket = new DatagramPacket(recvBuf, recvBuf.length);
        DatagramSocket socket = client.sendSocketToBroadcasts();
        socket.setSoTimeout(2000);
        socket.receive(receivePacket);
    }

    /**
     * Test of run method, of class Client.
     */
    @Test
    public void testRun1() {
        System.out.println("run");
        Client client = new Client(){
            @Override
            public String getServerIp(DatagramSocket socket){
                return null;
            } 
            @Override
            public DatagramSocket sendSocketToBroadcasts(){
                return null;
            } 
            @Override
            public void recieveData(String ip){
                setCloseServer(true);
            }
        };
    }

    @Test
    public void testRun2() {
        System.out.println("run");
        Client client = new Client(){
            @Override
            public String getServerIp(DatagramSocket socket){
                setCloseClient(true);
                return null;
            } 
            @Override
            public DatagramSocket sendSocketToBroadcasts(){
                return null;
            } 
            @Override
            public void recieveData(String ip){
            }
        };
    }


    /**
     * Test of getServerIp method, of class Client.
     */
    @Test
    public void testGetServerIp1() {
        try {
            byte[] recvBuf = new byte[15000];
            DatagramSocket socket=new DatagramSocket(55555);
            socket.send(new DatagramPacket(recvBuf, recvBuf.length,InetAddress.getLocalHost(),55555));
            Client client= new Client();
            String result=client.getServerIp(socket);
            assertEquals(InetAddress.getLocalHost().getHostAddress(), result);
        } catch (SocketException ex) {
            Logger.getLogger(ClientTest.class.getName()).log(Level.SEVERE, null, ex);
        } catch (IOException ex) {
            Logger.getLogger(ClientTest.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
    @Test
    public void testGetServerIp2() {
        try {
            byte[] recvBuf = new byte[15000];
            DatagramSocket socket=new DatagramSocket(55557);
            Client client= new Client();
            String result=client.getServerIp(socket);
            assertEquals(null, result);
        } catch (SocketException ex) {
            Logger.getLogger(ClientTest.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    /**
     * Test of closeClient method, of class Client.
     */
    @Test
    public void testCloseClient() {
        Client client = new Client();
        client.setCloseClient(false);
        client.setClientSocket(new Socket());
        client.closeClient();
        assertEquals(true, client.isCloseClient());
        assertEquals(true, client.getClientSocket().isClosed());
    }

   
}
